/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class ConfigDataCache {
    private static final Set<Item> tamingItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> tamingTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> standardFoodItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> standardFoodTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> stealableItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> stealableTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> retrievableItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> retrievableItemTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> buffFoodItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> buffFoodTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> lureItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> lureItemTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> bedAvoidanceFoodItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> bedAvoidanceFoodTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> pouchUnlockItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> pouchUnlockTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> repeatableFoodItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> repeatableFoodTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> pouchAllowedItems = new HashSet<Item>();
    private static final Set<Item> autoHealFoodItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> autoHealFoodTags = new HashSet<TagKey<Item>>();
    private static final Set<TagKey<Item>> pouchAllowedTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> pouchDisallowedItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> pouchDisallowedTags = new HashSet<TagKey<Item>>();
    private static final Set<Item> resurrectionTributeItems = new HashSet<Item>();
    private static final Set<TagKey<Item>> resurrectionTributeTags = new HashSet<TagKey<Item>>();
    private static final Set<Block> celebrationOreBlocks = new HashSet<Block>();
    private static final Set<TagKey<Block>> celebrationOreTags = new HashSet<TagKey<Block>>();
    private static final Set<Block> sulkingOreBlocks = new HashSet<Block>();
    private static final Set<TagKey<Block>> sulkingOreTags = new HashSet<TagKey<Block>>();
    private static final Set<ResourceLocation> blueBiomeIds = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> blueBiomeTags = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> blueExclusionBiomeIds = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> blueExclusionBiomeTags = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> lavenderBiomeIds = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> lavenderBiomeTags = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> lavenderExclusionBiomeIds = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> lavenderExclusionBiomeTags = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> whiteBiomeIds = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> whiteBiomeTags = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> whiteExclusionBiomeIds = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> whiteExclusionBiomeTags = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> grayBiomeIds = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> grayBiomeTags = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> grayExclusionBiomeIds = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> grayExclusionBiomeTags = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> blackBiomeIds = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> blackBiomeTags = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> blackExclusionBiomeIds = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> blackExclusionBiomeTags = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> creamBiomeIds = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> creamBiomeTags = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> creamExclusionBiomeIds = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> creamExclusionBiomeTags = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> chocolateBiomeIds = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> chocolateBiomeTags = new HashSet<TagKey<Biome>>();
    private static final Set<ResourceLocation> chocolateExclusionBiomeIds = new HashSet<ResourceLocation>();
    private static final Set<TagKey<Biome>> chocolateExclusionBiomeTags = new HashSet<TagKey<Biome>>();
    private static final List<Item> flattenedDefaultCheekLoot = new ArrayList<Item>();
    private static final List<Item> flattenedExtraCheekLoot = new ArrayList<Item>();
    private static final List<Item> flattenedCaveCheekLoot = new ArrayList<Item>();

    public static void parseConfig() {
        ConfigDataCache.clearAllItemSets();
        ConfigDataCache.clearAllBlockSets();
        ConfigDataCache.clearAllBiomeSets();
        ConfigDataCache.parseItemList(Configs.AHP.tamingFoods, tamingItems, tamingTags, "tamingFoods");
        ConfigDataCache.parseItemList(Configs.AHP.standardFoods, standardFoodItems, standardFoodTags, "standardFoods");
        ConfigDataCache.parseItemList(Configs.AHP.stealableItems, stealableItems, stealableTags, "stealableItems");
        ConfigDataCache.parseItemList(Configs.AHP.retrievableItems, retrievableItems, retrievableItemTags, "retrievableItems");
        ConfigDataCache.parseItemList(Configs.AHP.buffFoods, buffFoodItems, buffFoodTags, "buffFoods");
        ConfigDataCache.parseItemList(Configs.AHP.lureItems, lureItems, lureItemTags, "lureItems");
        ConfigDataCache.parseItemList(Configs.AHP.bedAvoidanceFoods, bedAvoidanceFoodItems, bedAvoidanceFoodTags, "bedAvoidanceFoods");
        ConfigDataCache.parseItemList(Configs.AHP.pouchUnlockFoods, pouchUnlockItems, pouchUnlockTags, "pouchUnlockFoods");
        ConfigDataCache.parseItemList(Configs.AHP.repeatableFoods, repeatableFoodItems, repeatableFoodTags, "repeatableFoods");
        ConfigDataCache.parseItemList(Configs.AHP.pouchAllowedItems, pouchAllowedItems, pouchAllowedTags, "pouchAllowedItems");
        ConfigDataCache.parseItemList(Configs.AHP.pouchDisallowedItems, pouchDisallowedItems, pouchDisallowedTags, "pouchDisallowedItems");
        ConfigDataCache.parseItemList(Configs.AHP.pouchDisallowedTags, pouchDisallowedItems, pouchDisallowedTags, "pouchDisallowedTags");
        ConfigDataCache.parseItemList(Configs.AHP.autoHealFoods, autoHealFoodItems, autoHealFoodTags, "autoHealFoods");
        ConfigDataCache.parseItemList(Configs.AHP.resurrectionTributes, resurrectionTributeItems, resurrectionTributeTags, "resurrectionTributes");
        ConfigDataCache.parseLootGenerationList(Configs.AHP_WORLDGEN.defaultCheekLootList, flattenedDefaultCheekLoot, "defaultCheekLootList");
        ConfigDataCache.parseLootGenerationList(Configs.AHP_WORLDGEN.extraCheekLootList, flattenedExtraCheekLoot, "extraCheekLootList");
        ConfigDataCache.parseLootGenerationList(Configs.AHP_WORLDGEN.caveCheekLootList, flattenedCaveCheekLoot, "caveCheekLootList");
        ConfigDataCache.parseBlockList(Configs.AHP.celebrationOres, celebrationOreBlocks, celebrationOreTags, "celebrationOres");
        ConfigDataCache.parseBlockList(Configs.AHP.sulkingOres, sulkingOreBlocks, sulkingOreTags, "sulkingOres");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.blueBiomes, blueBiomeIds, "blueBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.blueTags, blueBiomeTags, "blueTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.blueExclusionBiomes, blueExclusionBiomeIds, "blueExclusionBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.blueExclusionTags, blueExclusionBiomeTags, "blueExclusionTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.lavenderBiomes, lavenderBiomeIds, "lavenderBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.lavenderTags, lavenderBiomeTags, "lavenderTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.lavenderExclusionBiomes, lavenderExclusionBiomeIds, "lavenderExclusionBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.lavenderExclusionTags, lavenderExclusionBiomeTags, "lavenderExclusionTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.whiteBiomes, whiteBiomeIds, "whiteBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.whiteTags, whiteBiomeTags, "whiteTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.whiteExclusionBiomes, whiteExclusionBiomeIds, "whiteExclusionBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.whiteExclusionTags, whiteExclusionBiomeTags, "whiteExclusionTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.grayBiomes, grayBiomeIds, "grayBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.grayTags, grayBiomeTags, "grayTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.grayExclusionBiomes, grayExclusionBiomeIds, "grayExclusionBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.grayExclusionTags, grayExclusionBiomeTags, "grayExclusionTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.blackBiomes, blackBiomeIds, "blackBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.blackTags, blackBiomeTags, "blackTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.blackExclusionBiomes, blackExclusionBiomeIds, "blackExclusionBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.blackExclusionTags, blackExclusionBiomeTags, "blackExclusionTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.creamBiomes, creamBiomeIds, "creamBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.creamTags, creamBiomeTags, "creamTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.creamExclusionBiomes, creamExclusionBiomeIds, "creamExclusionBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.creamExclusionTags, creamExclusionBiomeTags, "creamExclusionTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.chocolateBiomes, chocolateBiomeIds, "chocolateBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.chocolateTags, chocolateBiomeTags, "chocolateTags");
        ConfigDataCache.parseBiomeIdList(Configs.AHP_WORLDGEN.chocolateExclusionBiomes, chocolateExclusionBiomeIds, "chocolateExclusionBiomes");
        ConfigDataCache.parseBiomeTagList(Configs.AHP_WORLDGEN.chocolateExclusionTags, chocolateExclusionBiomeTags, "chocolateExclusionTags");
        AdorableHamsterPets.LOGGER.info("Parsed all item and biome tag overrides from config.");
    }

    public static boolean isTamingFood(ItemStack stack) {
        return ConfigDataCache.matchesItem(stack, tamingItems, tamingTags);
    }

    public static boolean isStandardFood(ItemStack stack) {
        return ConfigDataCache.matchesItem(stack, standardFoodItems, standardFoodTags);
    }

    public static boolean isStealableItem(ItemStack stack) {
        return ConfigDataCache.matchesItem(stack, stealableItems, stealableTags);
    }

    public static boolean isRetrievableItem(ItemStack stack) {
        return ConfigDataCache.matchesItem(stack, retrievableItems, retrievableItemTags);
    }

    public static boolean isBuffFood(ItemStack stack) {
        return ConfigDataCache.matchesItem(stack, buffFoodItems, buffFoodTags);
    }

    public static boolean isLureItem(ItemStack stack) {
        return ConfigDataCache.matchesItem(stack, lureItems, lureItemTags);
    }

    public static boolean isBedAvoidanceFood(ItemStack stack) {
        return ConfigDataCache.matchesItem(stack, bedAvoidanceFoodItems, bedAvoidanceFoodTags);
    }

    public static boolean isPouchUnlockFood(ItemStack stack) {
        return ConfigDataCache.matchesItem(stack, pouchUnlockItems, pouchUnlockTags);
    }

    public static boolean isRepeatableFood(ItemStack stack) {
        return ConfigDataCache.matchesItem(stack, repeatableFoodItems, repeatableFoodTags);
    }

    public static boolean isAutoHealFood(ItemStack stack) {
        return ConfigDataCache.matchesItem(stack, autoHealFoodItems, autoHealFoodTags);
    }

    public static boolean isPouchAllowed(ItemStack stack) {
        return ConfigDataCache.matchesItem(stack, pouchAllowedItems, pouchAllowedTags);
    }

    public static boolean isPouchDisallowed(ItemStack stack) {
        return ConfigDataCache.matchesItem(stack, pouchDisallowedItems, pouchDisallowedTags);
    }

    public static boolean isResurrectionTribute(ItemStack stack) {
        return ConfigDataCache.matchesItem(stack, resurrectionTributeItems, resurrectionTributeTags);
    }

    public static Item getRandomDefaultLootItem(RandomSource random) {
        if (flattenedDefaultCheekLoot.isEmpty()) {
            return Items.f_41852_;
        }
        return flattenedDefaultCheekLoot.get(random.m_188503_(flattenedDefaultCheekLoot.size()));
    }

    public static Item getRandomCustomLootItem(RandomSource random) {
        if (flattenedExtraCheekLoot.isEmpty()) {
            return Items.f_41852_;
        }
        return flattenedExtraCheekLoot.get(random.m_188503_(flattenedExtraCheekLoot.size()));
    }

    public static Item getRandomCaveLootItem(RandomSource random) {
        if (flattenedCaveCheekLoot.isEmpty()) {
            return Items.f_41852_;
        }
        return flattenedCaveCheekLoot.get(random.m_188503_(flattenedCaveCheekLoot.size()));
    }

    public static boolean isCelebrationOre(BlockState state) {
        return ConfigDataCache.matchesBlock(state, celebrationOreBlocks, celebrationOreTags);
    }

    public static boolean isSulkingOre(BlockState state) {
        return ConfigDataCache.matchesBlock(state, sulkingOreBlocks, sulkingOreTags);
    }

    public static boolean isBlueBiome(Holder<Biome> biomeEntry) {
        return ConfigDataCache.matchesBiome(biomeEntry, blueBiomeIds, blueBiomeTags, blueExclusionBiomeIds, blueExclusionBiomeTags);
    }

    public static boolean isLavenderBiome(Holder<Biome> biomeEntry) {
        return ConfigDataCache.matchesBiome(biomeEntry, lavenderBiomeIds, lavenderBiomeTags, lavenderExclusionBiomeIds, lavenderExclusionBiomeTags);
    }

    public static boolean isWhiteBiome(Holder<Biome> biomeEntry) {
        return ConfigDataCache.matchesBiome(biomeEntry, whiteBiomeIds, whiteBiomeTags, whiteExclusionBiomeIds, whiteExclusionBiomeTags);
    }

    public static boolean isGrayBiome(Holder<Biome> biomeEntry) {
        return ConfigDataCache.matchesBiome(biomeEntry, grayBiomeIds, grayBiomeTags, grayExclusionBiomeIds, grayExclusionBiomeTags);
    }

    public static boolean isBlackBiome(Holder<Biome> biomeEntry) {
        return ConfigDataCache.matchesBiome(biomeEntry, blackBiomeIds, blackBiomeTags, blackExclusionBiomeIds, blackExclusionBiomeTags);
    }

    public static boolean isCreamBiome(Holder<Biome> biomeEntry) {
        return ConfigDataCache.matchesBiome(biomeEntry, creamBiomeIds, creamBiomeTags, creamExclusionBiomeIds, creamExclusionBiomeTags);
    }

    public static boolean isChocolateBiome(Holder<Biome> biomeEntry) {
        return ConfigDataCache.matchesBiome(biomeEntry, chocolateBiomeIds, chocolateBiomeTags, chocolateExclusionBiomeIds, chocolateExclusionBiomeTags);
    }

    private static void parseItemList(List<String> configList, Set<Item> itemSet, Set<TagKey<Item>> tagSet, String listName) {
        for (String entry : configList) {
            if (entry.startsWith("#")) {
                try {
                    ResourceLocation tagId = new ResourceLocation(entry.substring(1));
                    tagSet.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)tagId));
                }
                catch (Exception e) {
                    AdorableHamsterPets.LOGGER.warn("[ItemTagManager] Invalid item tag identifier in '{}' config list: '{}'", (Object)listName, (Object)entry);
                }
                continue;
            }
            try {
                ResourceLocation itemId = new ResourceLocation(entry);
                BuiltInRegistries.f_257033_.m_6612_(itemId).ifPresent(itemSet::add);
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[ItemTagManager] Invalid item identifier in '{}' config list: '{}'", (Object)listName, (Object)entry);
            }
        }
    }

    private static void parseLootGenerationList(List<String> configList, List<Item> targetList, String listName) {
        for (String entry : configList) {
            if (entry.startsWith("#")) {
                try {
                    ResourceLocation tagId = new ResourceLocation(entry.substring(1));
                    TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagId);
                    BuiltInRegistries.f_257033_.m_203431_(tagKey).ifPresent(entries -> {
                        for (Holder itemEntry : entries) {
                            targetList.add((Item)itemEntry.m_203334_());
                        }
                    });
                }
                catch (Exception e) {
                    AdorableHamsterPets.LOGGER.warn("[LootConfig] Invalid item tag in '{}': '{}'", (Object)listName, (Object)entry);
                }
                continue;
            }
            try {
                ResourceLocation itemId = new ResourceLocation(entry);
                BuiltInRegistries.f_257033_.m_6612_(itemId).ifPresent(targetList::add);
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[LootConfig] Invalid item ID in '{}': '{}'", (Object)listName, (Object)entry);
            }
        }
    }

    private static void parseBlockList(List<String> configList, Set<Block> blockSet, Set<TagKey<Block>> tagSet, String listName) {
        for (String entry : configList) {
            if (entry.startsWith("#")) {
                try {
                    ResourceLocation tagId = new ResourceLocation(entry.substring(1));
                    tagSet.add((TagKey<Block>)TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tagId));
                }
                catch (Exception e) {
                    AdorableHamsterPets.LOGGER.warn("[BlockTagManager] Invalid block tag identifier in '{}' config list: '{}'", (Object)listName, (Object)entry);
                }
                continue;
            }
            try {
                ResourceLocation blockId = new ResourceLocation(entry);
                BuiltInRegistries.f_256975_.m_6612_(blockId).ifPresent(blockSet::add);
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[BlockTagManager] Invalid block identifier in '{}' config list: '{}'", (Object)listName, (Object)entry);
            }
        }
    }

    private static void parseBiomeIdList(List<String> configList, Set<ResourceLocation> idSet, String listName) {
        for (String entry : configList) {
            try {
                idSet.add(new ResourceLocation(entry));
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[BiomeTagManager] Invalid biome identifier in '{}' config list: '{}'", (Object)listName, (Object)entry);
            }
        }
    }

    private static void parseBiomeTagList(List<String> configList, Set<TagKey<Biome>> tagSet, String listName) {
        for (String entry : configList) {
            String tagName = entry.startsWith("#") ? entry.substring(1) : entry;
            try {
                tagSet.add((TagKey<Biome>)TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation(tagName)));
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.warn("[BiomeTagManager] Invalid biome tag in '{}' config list: '{}'", (Object)listName, (Object)entry);
            }
        }
    }

    private static boolean matchesItem(ItemStack stack, Set<Item> itemSet, Set<TagKey<Item>> tagSet) {
        if (stack.m_41619_()) {
            return false;
        }
        if (itemSet.contains(stack.m_41720_())) {
            return true;
        }
        for (TagKey<Item> tag : tagSet) {
            if (!stack.m_204117_(tag)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesBlock(BlockState state, Set<Block> blockSet, Set<TagKey<Block>> tagSet) {
        if (state == null) {
            return false;
        }
        if (blockSet.contains(state.m_60734_())) {
            return true;
        }
        for (TagKey<Block> tag : tagSet) {
            if (!state.m_204336_(tag)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchesBiome(Holder<Biome> biomeEntry, Set<ResourceLocation> ids, Set<TagKey<Biome>> tags, Set<ResourceLocation> exclusionIds, Set<TagKey<Biome>> exclusionTags) {
        ResourceLocation biomeId = biomeEntry.m_203543_().map(ResourceKey::m_135782_).orElse(null);
        if (biomeId == null) {
            return false;
        }
        if (exclusionIds.contains(biomeId)) {
            return false;
        }
        for (TagKey<Biome> tag : exclusionTags) {
            if (!biomeEntry.m_203656_(tag)) continue;
            return false;
        }
        if (ids.contains(biomeId)) {
            return true;
        }
        for (TagKey<Biome> tag : tags) {
            if (!biomeEntry.m_203656_(tag)) continue;
            return true;
        }
        return false;
    }

    private static void clearAllItemSets() {
        tamingItems.clear();
        tamingTags.clear();
        standardFoodItems.clear();
        standardFoodTags.clear();
        stealableItems.clear();
        stealableTags.clear();
        retrievableItems.clear();
        retrievableItemTags.clear();
        buffFoodItems.clear();
        buffFoodTags.clear();
        lureItems.clear();
        lureItemTags.clear();
        bedAvoidanceFoodItems.clear();
        bedAvoidanceFoodTags.clear();
        pouchUnlockItems.clear();
        pouchUnlockTags.clear();
        repeatableFoodItems.clear();
        repeatableFoodTags.clear();
        autoHealFoodItems.clear();
        autoHealFoodTags.clear();
        pouchAllowedItems.clear();
        pouchAllowedTags.clear();
        pouchDisallowedItems.clear();
        pouchDisallowedTags.clear();
        resurrectionTributeItems.clear();
        resurrectionTributeTags.clear();
        flattenedDefaultCheekLoot.clear();
        flattenedExtraCheekLoot.clear();
        flattenedCaveCheekLoot.clear();
    }

    private static void clearAllBlockSets() {
        celebrationOreBlocks.clear();
        celebrationOreTags.clear();
        sulkingOreBlocks.clear();
        sulkingOreTags.clear();
    }

    private static void clearAllBiomeSets() {
        blueBiomeIds.clear();
        blueBiomeTags.clear();
        blueExclusionBiomeIds.clear();
        blueExclusionBiomeTags.clear();
        lavenderBiomeIds.clear();
        lavenderBiomeTags.clear();
        lavenderExclusionBiomeIds.clear();
        lavenderExclusionBiomeTags.clear();
        whiteBiomeIds.clear();
        whiteBiomeTags.clear();
        whiteExclusionBiomeIds.clear();
        whiteExclusionBiomeTags.clear();
        grayBiomeIds.clear();
        grayBiomeTags.clear();
        grayExclusionBiomeIds.clear();
        grayExclusionBiomeTags.clear();
        blackBiomeIds.clear();
        blackBiomeTags.clear();
        blackExclusionBiomeIds.clear();
        blackExclusionBiomeTags.clear();
        creamBiomeIds.clear();
        creamBiomeTags.clear();
        creamExclusionBiomeIds.clear();
        creamExclusionBiomeTags.clear();
        chocolateBiomeIds.clear();
        chocolateBiomeTags.clear();
        chocolateExclusionBiomeIds.clear();
        chocolateExclusionBiomeTags.clear();
    }

    public static Component getFirstItemNameFromList(List<String> configList) {
        if (configList.isEmpty()) {
            return Component.m_237115_((String)"block.minecraft.air");
        }
        String firstEntry = configList.get(0);
        if (firstEntry.startsWith("#")) {
            return Component.m_237113_((String)firstEntry);
        }
        try {
            ResourceLocation itemId = new ResourceLocation(firstEntry);
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
            if (item == Items.f_41852_ && !firstEntry.equals("minecraft:air")) {
                return Component.m_237113_((String)firstEntry);
            }
            return item.m_41466_();
        }
        catch (Exception e) {
            return Component.m_237113_((String)firstEntry);
        }
    }
}

