/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.custom.HamsterArmorItem;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class HamsterPlayWithItemGoal
extends Goal {
    private static final int LUNGE_DURATION_TICKS = 5;
    private final HamsterEntity hamster;
    private final Level world;
    @Nullable
    private ItemEntity targetItem;
    @Nullable
    private Player owner;
    @Nullable
    private Vec3 pounceStartPos;
    @Nullable
    private Vec3 repositionTarget;
    private int bounceSoundDelayTicks;
    private int playAnimSettleTicks;
    private int repositionAttempts;
    private int lungeTicks;
    private int itemInterestTimer;
    private boolean isFriendlyDelivery = false;
    private State currentState = State.SCANNING;

    public HamsterPlayWithItemGoal(HamsterEntity hamster) {
        this.hamster = hamster;
        this.world = hamster.m_9236_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        HamsterArmorItem armorItem;
        Item item3;
        AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] Evaluating canStart...", (Object)this.hamster.m_19879_());
        if (this.hamster.isHoldingInterestItem()) {
            if (this.hamster.m_21827_()) {
                return false;
            }
            if (!(this.hamster.m_269323_() instanceof Player)) {
                return false;
            }
            this.owner = (Player)this.hamster.m_269323_();
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] canStart SUCCEEDED: Resuming existing interaction.", (Object)this.hamster.m_19879_());
            return true;
        }
        if (!Configs.AHP.enableItemCarrying) {
            return false;
        }
        if (this.hamster.isHoldingInterestItem() || this.hamster.m_21827_()) {
            return false;
        }
        long currentTime = this.world.m_46467_();
        if (this.hamster.interestCooldownEndTick > currentTime) {
            return false;
        }
        LivingEntity livingEntity = this.hamster.m_269323_();
        if (!(livingEntity instanceof Player)) {
            return false;
        }
        Player playerOwner = (Player)livingEntity;
        this.owner = playerOwner;
        List nearbyItems = this.world.m_6443_(ItemEntity.class, this.hamster.m_20191_().m_82400_(10.0), itemEntity -> (ConfigDataCache.isStealableItem(itemEntity.m_32055_()) || ConfigDataCache.isRetrievableItem(itemEntity.m_32055_())) && itemEntity.m_20096_());
        Optional<ItemEntity> closestItem = nearbyItems.stream().filter(item -> this.hamster.m_21573_().m_6570_((Entity)item, 0) != null).min((item1, item2) -> Float.compare(item1.m_20270_((Entity)this.hamster), item2.m_20270_((Entity)this.hamster)));
        if (closestItem.isEmpty()) {
            return false;
        }
        this.targetItem = closestItem.get();
        ItemStack stack = this.targetItem.m_32055_();
        boolean isRetrievable = ConfigDataCache.isRetrievableItem(stack);
        boolean isStealable = ConfigDataCache.isStealableItem(stack);
        boolean hasDiamondArmor = false;
        ItemStack armor = this.hamster.getArmorStack();
        if (!armor.m_41619_() && (item3 = armor.m_41720_()) instanceof HamsterArmorItem && (armorItem = (HamsterArmorItem)item3).getMaterial() == HamsterArmorItem.HamsterArmorMaterial.DIAMOND) {
            hasDiamondArmor = true;
        }
        if (isRetrievable || isStealable && hasDiamondArmor) {
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] canStart SUCCEEDED (Guaranteed). Target: {}.", (Object)this.hamster.m_19879_(), (Object)stack.m_41720_());
            return true;
        }
        if (isStealable) {
            float chance;
            float randomVal = this.hamster.m_217043_().m_188501_();
            if (randomVal > (chance = ((Float)Configs.AHP.itemThieveryChance.get()).floatValue())) {
                return false;
            }
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] canStart SUCCEEDED (Thievery Roll Passed). Target: {}.", (Object)this.hamster.m_19879_(), (Object)stack.m_41720_());
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.hamster.m_21827_()) {
            return false;
        }
        if (this.owner == null || !this.owner.m_6084_()) {
            return false;
        }
        if (this.itemInterestTimer <= 0) {
            return false;
        }
        if (this.currentState == State.FLEEING || this.currentState == State.RETURNING || this.currentState == State.PLAYING_WITH_ITEM) {
            if (!this.hamster.isHoldingInterestItem()) {
                AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] shouldContinue check failed: Player retrieved item.", (Object)this.hamster.m_19879_());
                return false;
            }
        } else if (!(this.currentState != State.MOVING_TO_ITEM && this.currentState != State.POUNCING || this.targetItem != null && this.targetItem.m_6084_())) {
            return false;
        }
        return true;
    }

    public void m_8056_() {
        ItemStack interestStack;
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
        if (this.hamster.isHoldingInterestItem()) {
            interestStack = this.hamster.getInterestItemStack();
        } else if (this.targetItem != null) {
            interestStack = this.targetItem.m_32055_();
        } else {
            this.m_8041_();
            return;
        }
        this.determineMode(interestStack);
        if (this.hamster.isHoldingInterestItem()) {
            this.itemInterestTimer = this.hamster.getItemInterestTimer();
            this.targetItem = null;
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] Resuming interaction. Mode: Friendly={}", (Object)this.hamster.m_19879_(), (Object)this.isFriendlyDelivery);
            this.currentState = this.isFriendlyDelivery ? State.RETURNING : (this.hamster.m_20270_((Entity)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue() ? State.FLEEING : State.PLAYING_WITH_ITEM);
        } else {
            this.currentState = State.MOVING_TO_ITEM;
            this.hamster.m_21573_().m_5624_((Entity)this.targetItem, 1.5);
            this.itemInterestTimer = this.hamster.m_217043_().m_216332_((Integer)Configs.AHP.minStealDurationSeconds.get() * 20, (Integer)Configs.AHP.maxStealDurationSeconds.get() * 20);
            this.hamster.setItemInterestTimer(this.itemInterestTimer);
            this.repositionTarget = null;
            this.repositionAttempts = 0;
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] Goal started fresh. State: MOVING_TO_ITEM. Duration: {} ticks. Friendly: {}", new Object[]{this.hamster.m_19879_(), this.itemInterestTimer, this.isFriendlyDelivery});
        }
    }

    public void m_8041_() {
        ItemStack itemHeldInMouthStack;
        AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] Goal stopped. Final state was: {}.", (Object)this.hamster.m_19879_(), (Object)this.currentState);
        this.hamster.interestCooldownEndTick = this.world.m_46467_() + (long)((Integer)Configs.AHP.stealCooldownTicks.get()).intValue();
        if (this.hamster.isHoldingInterestItem() && this.itemInterestTimer <= 0 && !(itemHeldInMouthStack = this.hamster.getInterestItemStack()).m_41619_()) {
            this.world.m_7967_((Entity)new ItemEntity(this.world, this.hamster.m_20185_(), this.hamster.m_20186_(), this.hamster.m_20189_(), itemHeldInMouthStack.m_41777_()));
            this.hamster.m_5496_(ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_HURT_SOUNDS, this.hamster.m_217043_()), 1.0f, 1.0f);
            SoundEvent pounceSound = ModSounds.getDynamicItemSound(itemHeldInMouthStack);
            float volume = pounceSound == SoundEvents.f_11912_ ? 0.35f : 1.0f;
            this.world.m_5594_(null, this.hamster.m_20183_(), pounceSound, SoundSource.NEUTRAL, volume, 1.7f);
        }
        this.hamster.setInterestItemStack(ItemStack.f_41583_);
        this.hamster.setItemInterestTimer(0);
        this.hamster.setTauntingWithItem(false);
        this.hamster.setPresentingItem(false);
        this.hamster.setHoldingInterestItem(false);
        this.hamster.m_21573_().m_26573_();
        this.targetItem = null;
        this.owner = null;
        this.currentState = State.SCANNING;
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
    }

    public void m_8037_() {
        if (this.itemInterestTimer > 0) {
            --this.itemInterestTimer;
            this.hamster.setItemInterestTimer(this.itemInterestTimer);
        }
        if (this.owner == null) {
            return;
        }
        if (this.bounceSoundDelayTicks > 0) {
            --this.bounceSoundDelayTicks;
            if (this.bounceSoundDelayTicks == 0) {
                this.hamster.m_5496_((SoundEvent)ModSounds.HAMSTER_BOUNCE.get(), 0.6f, this.hamster.m_6100_() * 1.2f);
            }
        }
        switch (this.currentState) {
            case MOVING_TO_ITEM: {
                if (this.targetItem == null) {
                    return;
                }
                this.hamster.m_21563_().m_24960_((Entity)this.targetItem, 25.0f, 25.0f);
                if (this.hamster.m_21573_().m_26571_()) {
                    this.currentState = State.REPOSITIONING;
                    return;
                }
                if (!((double)this.hamster.m_20270_((Entity)this.targetItem) < 1.5)) break;
                this.currentState = State.POUNCING;
                this.lungeTicks = 5;
                this.pounceStartPos = this.hamster.m_20182_();
                this.hamster.m_21573_().m_26573_();
                this.hamster.triggerAnimOnServer("mainController", "anim_hamster_pounce_on_item");
                this.bounceSoundDelayTicks = 5;
                SoundEvent celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.hamster.m_217043_());
                if (celebrationSound == null) break;
                this.hamster.m_5496_(celebrationSound, 0.7f, this.hamster.m_6100_());
                break;
            }
            case REPOSITIONING: {
                if (this.targetItem == null) {
                    return;
                }
                if (this.repositionAttempts >= 3) {
                    this.itemInterestTimer = 0;
                    return;
                }
                if (this.repositionTarget == null) {
                    ++this.repositionAttempts;
                    this.repositionTarget = LandRandomPos.m_148492_((PathfinderMob)this.hamster, (int)2, (int)3, (Vec3)Vec3.m_82512_((Vec3i)this.targetItem.m_20183_()));
                    if (this.repositionTarget != null) {
                        this.hamster.m_21573_().m_26519_(this.repositionTarget.f_82479_, this.repositionTarget.f_82480_, this.repositionTarget.f_82481_, 1.55);
                    } else {
                        this.itemInterestTimer = 0;
                        return;
                    }
                }
                if (!this.hamster.m_21573_().m_26571_()) break;
                this.repositionTarget = null;
                this.currentState = State.MOVING_TO_ITEM;
                this.hamster.m_21573_().m_5624_((Entity)this.targetItem, 1.5);
                break;
            }
            case POUNCING: {
                if (this.targetItem == null) {
                    return;
                }
                --this.lungeTicks;
                if (this.pounceStartPos != null && this.lungeTicks >= 0) {
                    double progress = (double)(5 - this.lungeTicks) / 5.0;
                    double easedProgress = progress * progress;
                    double newX = this.pounceStartPos.f_82479_ + easedProgress * (this.targetItem.m_20185_() - this.pounceStartPos.f_82479_);
                    double newZ = this.pounceStartPos.f_82481_ + easedProgress * (this.targetItem.m_20189_() - this.pounceStartPos.f_82481_);
                    this.hamster.m_6034_(newX, this.hamster.m_20186_(), newZ);
                }
                if (this.lungeTicks >= 0) break;
                ItemStack stackToSteal = this.targetItem.m_32055_().m_41777_();
                if (stackToSteal.m_41619_()) {
                    this.itemInterestTimer = 0;
                    return;
                }
                this.hamster.setInterestItemStack(stackToSteal);
                this.targetItem.m_146870_();
                this.hamster.setHoldingInterestItem(true);
                SoundEvent pounceSound = ModSounds.getDynamicItemSound(stackToSteal);
                float volume = pounceSound == SoundEvents.f_11912_ ? 0.35f : 1.0f;
                this.world.m_5594_(null, this.hamster.m_20183_(), pounceSound, SoundSource.NEUTRAL, volume, 1.7f);
                if (!this.world.f_46443_) {
                    ParticleEffectsUtil.spawnParticles(this.world, new Vec3(this.hamster.m_20185_(), this.hamster.m_20186_() + 0.5, this.hamster.m_20189_()), ParticleTypes.f_123810_, 5, new Vec3(0.1, 0.1, 0.1), 0.05);
                    ParticleEffectsUtil.spawnParticles(this.world, new Vec3(this.hamster.m_20185_(), this.hamster.m_20186_() + 0.5, this.hamster.m_20189_()), new ItemParticleOption(ParticleTypes.f_123752_, stackToSteal), 18, new Vec3(0.2, 0.2, 0.2), 0.1);
                }
                if (this.isFriendlyDelivery) {
                    this.currentState = State.RETURNING;
                    break;
                }
                this.currentState = State.FLEEING;
                break;
            }
            case FLEEING: {
                this.hamster.setTauntingWithItem(false);
                if (this.hamster.m_20270_((Entity)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue()) {
                    Vec3 fleePos = LandRandomPos.m_148521_((PathfinderMob)this.hamster, (int)((Integer)Configs.AHP.maxFleeDistance.get()), (int)7, (Vec3)this.owner.m_20182_());
                    if (fleePos == null) break;
                    this.hamster.m_21573_().m_26519_(fleePos.f_82479_, fleePos.f_82480_, fleePos.f_82481_, 1.5);
                    break;
                }
                this.currentState = State.PLAYING_WITH_ITEM;
                this.hamster.m_21573_().m_26573_();
                break;
            }
            case RETURNING: {
                this.hamster.setPresentingItem(false);
                this.hamster.m_21573_().m_5624_((Entity)this.owner, 1.5);
                double distToOwner = this.hamster.m_20270_((Entity)this.owner);
                if (!(distToOwner <= 2.5)) break;
                this.currentState = State.PLAYING_WITH_ITEM;
                this.hamster.m_21573_().m_26573_();
                break;
            }
            case PLAYING_WITH_ITEM: {
                this.hamster.m_21563_().m_24960_((Entity)this.owner, 25.0f, 25.0f);
                if (!this.hamster.isTauntingWithItem() && !this.hamster.isPresentingItem() && this.playAnimSettleTicks == 0) {
                    this.playAnimSettleTicks = 5;
                }
                if (this.playAnimSettleTicks > 0) {
                    --this.playAnimSettleTicks;
                }
                if (this.hamster.m_21573_().m_26571_() && this.playAnimSettleTicks == 0) {
                    if (this.isFriendlyDelivery) {
                        this.hamster.setPresentingItem(true);
                    } else {
                        this.hamster.setTauntingWithItem(true);
                    }
                }
                if (this.isFriendlyDelivery) {
                    if (!((double)this.hamster.m_20270_((Entity)this.owner) > 5.0)) break;
                    this.currentState = State.RETURNING;
                    this.hamster.setPresentingItem(false);
                    this.playAnimSettleTicks = 0;
                    break;
                }
                if (!(this.hamster.m_20270_((Entity)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue())) break;
                this.currentState = State.FLEEING;
                this.hamster.setTauntingWithItem(false);
                this.playAnimSettleTicks = 0;
            }
        }
    }

    private void determineMode(ItemStack stack) {
        if (ConfigDataCache.isRetrievableItem(stack)) {
            this.isFriendlyDelivery = true;
            return;
        }
        if (ConfigDataCache.isStealableItem(stack)) {
            HamsterArmorItem armorItem;
            Item item;
            ItemStack armor = this.hamster.getArmorStack();
            this.isFriendlyDelivery = !armor.m_41619_() && (item = armor.m_41720_()) instanceof HamsterArmorItem && (armorItem = (HamsterArmorItem)item).getMaterial() == HamsterArmorItem.HamsterArmorMaterial.DIAMOND;
            return;
        }
        this.isFriendlyDelivery = false;
    }

    private static enum State {
        SCANNING,
        MOVING_TO_ITEM,
        REPOSITIONING,
        POUNCING,
        FLEEING,
        RETURNING,
        PLAYING_WITH_ITEM;

    }
}

