/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client;

import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class HamsterModel
extends GeoModel<HamsterEntity> {
    private static final float ADULT_SCALE = 0.8f;
    private static final float ADULT_HEAD_SCALE = 1.0f;
    private static final float BABY_SCALE = 0.5f;
    private static final float BABY_HEAD_SCALE = 1.2f;

    public ResourceLocation getModelResource(HamsterEntity animatable) {
        return ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"geo/hamster.geo.json");
    }

    public ResourceLocation getTextureResource(HamsterEntity animatable) {
        return ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"textures/entity/hamster/orange.png");
    }

    public ResourceLocation getAnimationResource(HamsterEntity animatable) {
        return ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"animations/anim_hamster.animation.json");
    }

    public void setCustomAnimations(HamsterEntity entity, long instanceId, AnimationState<HamsterEntity> animationState) {
        super.setCustomAnimations((GeoAnimatable)entity, instanceId, animationState);
        CoreGeoBone rootBone = this.getAnimationProcessor().getBone("root");
        CoreGeoBone headParentBone = this.getAnimationProcessor().getBone("head_parent");
        CoreGeoBone leftCheekDefBone = this.getAnimationProcessor().getBone("left_cheek_deflated");
        CoreGeoBone rightCheekDefBone = this.getAnimationProcessor().getBone("right_cheek_deflated");
        CoreGeoBone leftCheekInfBone = this.getAnimationProcessor().getBone("left_cheek_inflated");
        CoreGeoBone rightCheekInfBone = this.getAnimationProcessor().getBone("right_cheek_inflated");
        CoreGeoBone rightEarBone = this.getAnimationProcessor().getBone("right_ear");
        CoreGeoBone acornHatBone = this.getAnimationProcessor().getBone("acorn_hat");
        CoreGeoBone petalHeadBone = this.getAnimationProcessor().getBone("pink_petal_head");
        CoreGeoBone petalSideBone = this.getAnimationProcessor().getBone("pink_petal_side");
        CoreGeoBone petalBackBone = this.getAnimationProcessor().getBone("pink_petal_lower_back");
        if (leftCheekDefBone != null && leftCheekInfBone != null) {
            boolean leftFull = entity.isLeftCheekFull();
            leftCheekDefBone.setHidden(leftFull);
            leftCheekInfBone.setHidden(!leftFull);
        }
        if (rightCheekDefBone != null && rightCheekInfBone != null) {
            boolean rightFull = entity.isRightCheekFull();
            rightCheekDefBone.setHidden(rightFull);
            rightCheekInfBone.setHidden(!rightFull);
        }
        if (rightEarBone != null) {
            ItemStack armorStack;
            boolean shouldHideEar = false;
            boolean shouldShowHat = false;
            ItemStack blingStack = entity.getAccessoryStack();
            if (blingStack.m_150930_((Item)ModItems.ACORN_HAT.get())) {
                shouldHideEar = true;
                shouldShowHat = true;
            }
            if ((armorStack = entity.getArmorStack()).m_150930_((Item)ModItems.HAMSTER_ARMOR_ACORN.get()) && ((Boolean)Configs.AHP.renderAcornHat.get()).booleanValue()) {
                shouldHideEar = true;
                shouldShowHat = true;
            }
            rightEarBone.setHidden(shouldHideEar);
            if (acornHatBone != null) {
                acornHatBone.setHidden(!shouldShowHat);
            }
        }
        if (rootBone != null && headParentBone != null) {
            float baseScale = entity.m_6162_() ? 0.5f : 0.8f;
            float headScale = entity.m_6162_() ? 1.2f : 1.0f;
            rootBone.setScaleX(baseScale);
            rootBone.setScaleY(baseScale);
            rootBone.setScaleZ(baseScale);
            if (entity.isShoulderPet()) {
                rootBone.setScaleY(baseScale * entity.dynamicScaleY);
            }
            headParentBone.setScaleX(headScale);
            headParentBone.setScaleY(headScale);
            headParentBone.setScaleZ(headScale);
            if (entity.isThrown()) {
                Vec3 velocity = entity.m_20184_();
                double horizontalSpeed = Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
                float targetPitch = (float)Math.atan2(velocity.f_82480_, horizontalSpeed);
                rootBone.setRotX(targetPitch);
            } else if (entity.clientFallPitchProgress > 0.0f || entity.prevClientFallPitchProgress > 0.0f) {
                float partialTick = animationState.getPartialTick();
                float lerpedProgress = Mth.m_14179_((float)partialTick, (float)entity.prevClientFallPitchProgress, (float)entity.clientFallPitchProgress);
                float t = entity.clientFallPitchProgress;
                float interpolated = (1.0f - Mth.m_14089_((float)(lerpedProgress * (float)Math.PI))) * 0.5f;
                float targetPitch = -1.5707964f;
                rootBone.setRotX(targetPitch * interpolated);
                rootBone.setRotX(targetPitch * interpolated);
            } else {
                rootBone.setRotX(0.0f);
            }
        }
    }
}

