/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.dawson.adorablehamsterpets.AdorableHamsterPetsClient;
import net.dawson.adorablehamsterpets.client.sound.HamsterCleaningSoundInstance;
import net.dawson.adorablehamsterpets.entity.client.HamsterModel;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterAcornHatLayer;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterArmorLayer;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterOverlayLayer;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterPinkPetalOverlayLayer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.entity.custom.HamsterVariant;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.HamsterMouthItemOffsets;
import net.dawson.adorablehamsterpets.util.HamsterSeatOffsets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class HamsterRenderer
extends GeoEntityRenderer<HamsterEntity> {
    private final float adultShadowRadius;
    private static final Map<Integer, HamsterCleaningSoundInstance> activeCleaningSounds = new HashMap<Integer, HamsterCleaningSoundInstance>();
    public static final ThreadLocal<Boolean> IS_RENDERING_PASSENGER = ThreadLocal.withInitial(() -> false);
    private static final String SEAT_BONE = "body_child";

    public HamsterRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, (GeoModel)new HamsterModel());
        this.f_114477_ = this.adultShadowRadius = 0.2f;
        this.addRenderLayer(new HamsterOverlayLayer((GeoRenderer<HamsterEntity>)this));
        this.addRenderLayer(new HamsterArmorLayer((GeoRenderer<HamsterEntity>)this));
        this.addRenderLayer(new HamsterPinkPetalOverlayLayer((GeoRenderer<HamsterEntity>)this));
        this.addRenderLayer(new HamsterAcornHatLayer((GeoRenderer<HamsterEntity>)this));
    }

    public ResourceLocation getTextureLocation(HamsterEntity entity) {
        HamsterVariant variant = HamsterVariant.byId(entity.getVariant());
        String baseTextureName = variant.getBaseTextureName();
        return ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)("textures/entity/hamster/" + baseTextureName + ".png"));
    }

    public void preRender(PoseStack poseStack, HamsterEntity animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (Entity)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        model.getBone("left_foot").ifPresent(bone -> bone.setTrackingMatrices(true));
        model.getBone("nose").ifPresent(bone -> bone.setTrackingMatrices(true));
        model.getBone(SEAT_BONE).ifPresent(bone -> bone.setTrackingMatrices(true));
    }

    public void render(HamsterEntity entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        AnimatableManager manager;
        AnimatableInstanceCache cache;
        boolean isCleaning = entity.isCleaning();
        HamsterCleaningSoundInstance sound = activeCleaningSounds.get(entity.m_19879_());
        if (isCleaning && (sound == null || sound.m_7801_())) {
            sound = new HamsterCleaningSoundInstance(entity);
            activeCleaningSounds.put(entity.m_19879_(), sound);
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
        } else if (!isCleaning && sound != null) {
            sound.stop();
            activeCleaningSounds.remove(entity.m_19879_());
        }
        this.f_114477_ = entity.m_6162_() ? this.adultShadowRadius * 0.5f : this.adultShadowRadius;
        AdorableHamsterPetsClient.onHamsterRendered(entity.m_19879_());
        poseStack.m_85836_();
        float targetYOffset = 0.0f;
        BlockPos pos = entity.m_20183_();
        BlockState blockState = entity.m_9236_().m_8055_(pos);
        if (blockState.m_60713_(Blocks.f_50125_)) {
            targetYOffset = 0.125f;
        }
        entity.renderedSnowYOffset += (targetYOffset - entity.renderedSnowYOffset) * 0.15f;
        poseStack.m_85837_(0.0, (double)entity.renderedSnowYOffset, 0.0);
        if (!entity.isShoulderPet() && (cache = entity.getAnimatableInstanceCache()) != null && (manager = cache.getManagerForId((long)entity.m_19879_())) != null) {
            manager.updatedAt(0.0);
        }
        super.m_7392_((Entity)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.m_85849_();
    }

    public void renderFinal(PoseStack poseStack, HamsterEntity animatable, BakedGeoModel model, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderFinal(poseStack, (Entity)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (!animatable.m_20197_().isEmpty()) {
            model.getBone(SEAT_BONE).ifPresent(bone -> this.renderPassengersForBone(poseStack, animatable, (GeoBone)bone, bufferSource, packedLight, partialTick));
        }
        if (animatable.isHoldingInterestItem()) {
            model.getBone("nose").ifPresent(bone -> this.renderItemForBone(poseStack, animatable, (GeoBone)bone, bufferSource, packedLight, packedOverlay));
        }
        if (animatable.particleEffectId != null) {
            this.handleParticleKeyframes(animatable, model);
        }
        if (animatable.soundEffectId != null) {
            this.handleSoundKeyframes(animatable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderPassengersForBone(PoseStack matrices, HamsterEntity hamster, GeoBone bone, MultiBufferSource bufferSource, int packedLight, float partialTick) {
        Minecraft client = Minecraft.m_91087_();
        EntityRenderDispatcher dispatcher = client.m_91290_();
        Matrix4f modelBase = new Matrix4f((Matrix4fc)this.modelRenderTranslations);
        Matrix3f modelBaseNormal = new Matrix3f((Matrix4fc)modelBase).invert().transpose();
        dispatcher.m_114468_(false);
        try {
            for (Entity passenger : hamster.m_20197_()) {
                if (!(passenger instanceof LivingEntity)) continue;
                LivingEntity living = (LivingEntity)passenger;
                if (passenger == client.f_91074_ && client.f_91066_.m_92176_().m_90612_()) continue;
                matrices.m_85836_();
                try {
                    matrices.m_85850_().m_252922_().set((Matrix4fc)modelBase);
                    matrices.m_85850_().m_252943_().set((Matrix3fc)modelBaseNormal);
                    Matrix4f bonePose = new Matrix4f((Matrix4fc)bone.getModelSpaceMatrix());
                    Vector3f t = bonePose.getTranslation(new Vector3f());
                    Quaternionf r = bonePose.getUnnormalizedRotation(new Quaternionf());
                    Matrix4f boneTR = new Matrix4f().identity().translate((Vector3fc)t).rotate((Quaternionfc)r);
                    matrices.m_85850_().m_252922_().mul((Matrix4fc)boneTR);
                    matrices.m_85850_().m_252943_().set((Matrix3fc)new Matrix3f((Matrix4fc)matrices.m_85850_().m_252922_()).invert().transpose());
                    float mountScale = hamster.getScale();
                    if (mountScale != 1.0f) {
                        float inv = 1.0f / mountScale;
                        matrices.m_85841_(inv, inv, inv);
                    }
                    Vec3 seat = HamsterSeatOffsets.visualSeatOffset(living, hamster.getScale());
                    matrices.m_85837_(seat.f_82479_, seat.f_82480_, seat.f_82481_);
                    float passengerYaw = Mth.m_14189_((float)partialTick, (float)passenger.f_19859_, (float)passenger.m_146908_());
                    matrices.m_252781_(Axis.f_252436_.m_252977_(passengerYaw - 180.0f));
                    IS_RENDERING_PASSENGER.set(true);
                    try {
                        dispatcher.m_114384_(passenger, 0.0, 0.0, 0.0, passengerYaw, partialTick, matrices, bufferSource, packedLight);
                    }
                    finally {
                        IS_RENDERING_PASSENGER.set(false);
                    }
                }
                finally {
                    matrices.m_85849_();
                }
            }
        }
        finally {
            dispatcher.m_114468_(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderItemForBone(PoseStack matrices, HamsterEntity hamster, GeoBone bone, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack itemStack = hamster.getInterestItemStack();
        if (itemStack.m_41619_()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        Matrix4f modelBase = new Matrix4f((Matrix4fc)this.modelRenderTranslations);
        Matrix3f modelBaseNormal = new Matrix3f((Matrix4fc)modelBase).invert().transpose();
        matrices.m_85836_();
        try {
            matrices.m_85850_().m_252922_().set((Matrix4fc)modelBase);
            matrices.m_85850_().m_252943_().set((Matrix3fc)modelBaseNormal);
            Matrix4f bonePose = new Matrix4f((Matrix4fc)bone.getModelSpaceMatrix());
            matrices.m_85850_().m_252922_().mul((Matrix4fc)bonePose);
            matrices.m_85850_().m_252943_().set((Matrix3fc)new Matrix3f((Matrix4fc)matrices.m_85850_().m_252922_()).invert().transpose());
            HamsterMouthItemOffsets.applyMouthItemTransforms(matrices);
            itemRenderer.m_269128_(itemStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, packedLight, packedOverlay, matrices, bufferSource, hamster.m_9236_(), hamster.m_19879_());
        }
        finally {
            matrices.m_85849_();
        }
    }

    private void handleParticleKeyframes(HamsterEntity animatable, BakedGeoModel model) {
        RandomSource random = animatable.m_217043_();
        switch (animatable.particleEffectId) {
            case "attack_poof": {
                model.getBone("left_foot").ifPresent(bone -> {
                    Vector3d pos = bone.getWorldPosition();
                    for (int i = 0; i < 8; ++i) {
                        double d = random.m_188583_() * 0.1;
                        double e = random.m_188583_() * 0.2;
                        double f = random.m_188583_() * 0.1;
                        animatable.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, pos.x + d, pos.y + e, pos.z + f, random.m_188583_() * 0.05, random.m_188583_() * 0.05, random.m_188583_() * 0.05);
                    }
                });
                break;
            }
            case "seeking_dust": {
                model.getBone("nose").ifPresent(bone -> {
                    Vector3d pos = bone.getWorldPosition();
                    BlockPos blockBelow = BlockPos.m_274561_((double)pos.x, (double)(pos.y - 0.1), (double)pos.z).m_7495_();
                    BlockState state = animatable.m_9236_().m_8055_(blockBelow);
                    if (state.m_60795_()) {
                        state = Blocks.f_50493_.m_49966_();
                    }
                    for (int i = 0; i < 12; ++i) {
                        double d = random.m_188583_() * 0.2;
                        double e = random.m_188583_() * 0.03;
                        double f = random.m_188583_() * 0.2;
                        animatable.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123814_, state), pos.x + d, pos.y + e, pos.z + f, 0.0, 0.0, 0.0);
                    }
                });
            }
        }
        animatable.particleEffectId = null;
    }

    private void handleSoundKeyframes(HamsterEntity animatable) {
        Minecraft client = Minecraft.m_91087_();
        switch (animatable.soundEffectId) {
            case "hamster_step_sound": {
                BlockPos pos = animatable.m_20183_();
                BlockState blockState = animatable.m_9236_().m_8055_(pos.m_7495_());
                if (blockState.m_60795_()) {
                    blockState = animatable.m_9236_().m_8055_(pos.m_6625_(2));
                }
                if (blockState.m_60795_()) break;
                SoundType group = blockState.m_60827_();
                float volume = blockState.m_60713_(Blocks.f_49994_) ? 0.060000002f : 0.1f;
                client.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(group.m_56776_(), SoundSource.NEUTRAL, volume, group.m_56774_() * 1.5f, animatable.m_217043_(), animatable.m_20185_(), animatable.m_20186_(), animatable.m_20189_()));
                break;
            }
            case "hamster_beg_bounce": {
                SoundEvent bounceSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BOUNCE_SOUNDS, animatable.m_217043_());
                if (bounceSound == null) break;
                float basePitch = animatable.m_6100_();
                float randomPitchAddition = animatable.m_217043_().m_188501_() * 0.2f;
                float finalPitch = basePitch * 1.2f + randomPitchAddition;
                client.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance(bounceSound, SoundSource.NEUTRAL, 0.6f, finalPitch, animatable.m_217043_(), animatable.m_20185_(), animatable.m_20186_(), animatable.m_20189_()));
                break;
            }
            case "hamster_thump_sound": {
                float thumpPitch = 1.0f + animatable.m_217043_().m_188501_() * 0.4f;
                client.m_91106_().m_120367_((SoundInstance)new SimpleSoundInstance((SoundEvent)ModSounds.HAMSTER_THUMP.get(), SoundSource.NEUTRAL, 0.3f, thumpPitch, animatable.m_217043_(), animatable.m_20185_(), animatable.m_20186_(), animatable.m_20189_()));
            }
        }
        animatable.soundEffectId = null;
    }
}

