/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.EnumMap;
import java.util.Map;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.client.state.ClientShoulderHamsterData;
import net.dawson.adorablehamsterpets.component.HamsterShoulderData;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.client.feature.ShoulderAnimationState;
import net.dawson.adorablehamsterpets.entity.client.feature.ShoulderHamsterState;
import net.dawson.adorablehamsterpets.entity.client.renderer.ShoulderHamsterRenderer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class HamsterShoulderFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final float HAMSTER_SHOULDER_SCALE = 0.8f;
    private final Map<ShoulderLocation, HamsterEntity> dummyHamsters = new EnumMap<ShoulderLocation, HamsterEntity>(ShoulderLocation.class);
    private final Map<ShoulderLocation, ShoulderHamsterRenderer> hamsterRenderers = new EnumMap<ShoulderLocation, ShoulderHamsterRenderer>(ShoulderLocation.class);

    public HamsterShoulderFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> context) {
        super(context);
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        ClientShoulderHamsterData clientData;
        PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
        if (!this.hasShoulderDataSafe(playerAccessor)) {
            return;
        }
        if (this.dummyHamsters.isEmpty()) {
            this.initializeDummies(player.m_9236_());
        }
        if ((clientData = playerAccessor.adorablehamsterpets$getClientShoulderData()) == null) {
            return;
        }
        for (ShoulderLocation location : ShoulderLocation.values()) {
            CompoundTag shoulderNbt = playerAccessor.getShoulderHamster(location);
            if (shoulderNbt.m_128456_()) continue;
            HamsterShoulderData.fromNbt(shoulderNbt).ifPresent(shoulderData -> this.renderShoulderHamster(matrices, vertexConsumers, light, player, (HamsterShoulderData)shoulderData, tickDelta, clientData, location));
        }
    }

    private boolean hasShoulderDataSafe(PlayerEntityAccessor playerAccessor) {
        try {
            return playerAccessor.hasAnyShoulderHamster();
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private void applyShoulderData(HamsterEntity dummyHamster, HamsterShoulderData data, Player owner) {
        dummyHamster.setShoulderPet(true);
        dummyHamster.setVariant(data.variantId());
        dummyHamster.setLeftCheekFull((data.hamsterFlags() & 0x40) != 0);
        dummyHamster.setRightCheekFull((data.hamsterFlags() & 0x80) != 0);
        dummyHamster.m_20088_().m_135381_(HamsterEntity.PINK_PETAL_TYPE, (Object)data.pinkPetalType());
        dummyHamster.m_20088_().m_135381_(HamsterEntity.ANIMATION_PERSONALITY_ID, (Object)data.animationPersonalityId());
        dummyHamster.m_146762_(data.breedingAge());
        dummyHamster.getItems().clear();
        if (!data.inventoryNbt().m_128456_()) {
            ContainerHelper.m_18980_((CompoundTag)data.inventoryNbt(), dummyHamster.getItems());
            dummyHamster.updateEquipmentTrackers();
        }
        dummyHamster.m_21816_(owner.m_20148_());
        dummyHamster.setTamed(true, false);
    }

    private void renderShoulderHamster(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer player, HamsterShoulderData shoulderData, float tickDelta, ClientShoulderHamsterData clientData, ShoulderLocation location) {
        float renderScaleY;
        AnimatableManager manager;
        HamsterEntity dummyHamster = this.dummyHamsters.get((Object)location);
        ShoulderHamsterRenderer hamsterRenderer = this.hamsterRenderers.get((Object)location);
        if (dummyHamster == null || hamsterRenderer == null) {
            return;
        }
        this.updateDummyState(dummyHamster, shoulderData, clientData, location, (Player)player);
        AnimatableInstanceCache cache = dummyHamster.getAnimatableInstanceCache();
        if (cache != null && (manager = cache.getManagerForId((long)dummyHamster.m_19879_())) != null) {
            manager.updatedAt(0.0);
        }
        float renderOffsetY = clientData.getRenderOffsetY(location, tickDelta);
        dummyHamster.dynamicScaleY = renderScaleY = clientData.getRenderScaleY(location, tickDelta);
        matrices.m_85836_();
        ItemStack chestStack = player.m_150109_().m_36052_(2);
        boolean isWearingChestplate = !chestStack.m_41619_() && !chestStack.m_150930_(Items.f_42741_);
        boolean isSlim = "slim".equals(player.m_108564_());
        switch (location) {
            case RIGHT_SHOULDER: {
                float yOffset;
                float xOffset;
                ((PlayerModel)this.m_117386_()).f_102811_.m_104299_(matrices);
                if (isWearingChestplate) {
                    xOffset = -0.18f;
                    yOffset = -0.18f;
                } else {
                    xOffset = isSlim ? -0.08f : -0.12f;
                    yOffset = -0.12f;
                }
                matrices.m_252880_(xOffset, yOffset, -0.016f);
                matrices.m_252781_(Axis.f_252436_.m_252977_(15.0f));
                break;
            }
            case LEFT_SHOULDER: {
                float yOffset;
                float xOffset;
                ((PlayerModel)this.m_117386_()).f_102812_.m_104299_(matrices);
                if (isWearingChestplate) {
                    xOffset = 0.18f;
                    yOffset = -0.18f;
                } else {
                    xOffset = isSlim ? 0.08f : 0.12f;
                    yOffset = -0.12f;
                }
                matrices.m_252880_(xOffset, yOffset, -0.016f);
                matrices.m_252781_(Axis.f_252436_.m_252977_(-15.0f));
                break;
            }
            case HEAD: {
                ((PlayerModel)this.m_117386_()).f_102808_.m_104299_(matrices);
                matrices.m_252880_(0.0f, -0.5f, -0.05f);
            }
        }
        matrices.m_252880_(0.0f, -renderOffsetY, 0.0f);
        matrices.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        matrices.m_85841_(0.8f, 0.8f, 0.8f);
        float renderYaw = 180.0f - player.m_213816_();
        hamsterRenderer.render(dummyHamster, renderYaw, tickDelta, matrices, vertexConsumers, light);
        matrices.m_85849_();
    }

    private double getAnchorBoneWorldY(PoseStack matrices, ModelPart anchorBone) {
        PoseStack tempMatrices = new PoseStack();
        tempMatrices.m_252931_(matrices.m_85850_().m_252922_());
        anchorBone.m_104299_(tempMatrices);
        Matrix4f finalMatrix = tempMatrices.m_85850_().m_252922_();
        return finalMatrix.m31();
    }

    private void updateDummyState(HamsterEntity dummyHamster, HamsterShoulderData nbtData, ClientShoulderHamsterData clientData, ShoulderLocation location, Player owner) {
        this.applyShoulderData(dummyHamster, nbtData, owner);
        dummyHamster.f_19797_ = clientData.getAnimationAge(location);
        ShoulderHamsterState state = clientData.getHamsterState(location);
        if (state != null) {
            ShoulderAnimationState currentState = state.getCurrentState();
            dummyHamster.m_20088_().m_135381_(HamsterEntity.SHOULDER_ANIMATION_STATE, (Object)currentState.ordinal());
            dummyHamster.setSitting(currentState == ShoulderAnimationState.SITTING, true);
        }
        dummyHamster.shoulderLocation = location;
    }

    private void initializeDummies(Level world) {
        if (world == null) {
            return;
        }
        Minecraft client = Minecraft.m_91087_();
        EntityRendererProvider.Context context = new EntityRendererProvider.Context(client.m_91290_(), client.m_91291_(), client.m_91289_(), client.m_91290_().m_234586_(), client.m_91098_(), client.m_167973_(), client.f_91062_);
        for (ShoulderLocation location : ShoulderLocation.values()) {
            HamsterEntity dummy = new HamsterEntity((EntityType<? extends TamableAnimal>)((EntityType)ModEntities.HAMSTER.get()), world);
            dummy.m_20242_(true);
            dummy.m_20225_(true);
            this.dummyHamsters.put(location, dummy);
            this.hamsterRenderers.put(location, new ShoulderHamsterRenderer(context));
        }
    }
}

