/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.custom;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.component.HamsterShoulderData;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.MountPriority;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.AI.HamsterFleeGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterFollowOwnerGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterGoToBedAndSleepGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterLookAroundGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterLookAtEntityGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterMateGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterMeleeAttackGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterPlayWithItemGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSitGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSleepGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSniffForOreGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterTemptGoal;
import net.dawson.adorablehamsterpets.entity.AI.HamsterWanderAroundFarGoal;
import net.dawson.adorablehamsterpets.entity.AI.navigation.HamsterNavigation;
import net.dawson.adorablehamsterpets.entity.ImplementedInventory;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.client.feature.ShoulderAnimationState;
import net.dawson.adorablehamsterpets.entity.control.HamsterBodyControl;
import net.dawson.adorablehamsterpets.entity.custom.HamsterTreeSearcherEntity;
import net.dawson.adorablehamsterpets.entity.custom.HamsterVariant;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.item.custom.HamsterArmorItem;
import net.dawson.adorablehamsterpets.item.custom.HamsterBedItem;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.screen.HamsterScreenHandlerFactory;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.tag.ModBiomeTags;
import net.dawson.adorablehamsterpets.util.HamsterAnimationScheduler;
import net.dawson.adorablehamsterpets.util.HamsterPlacementUtil;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.dawson.adorablehamsterpets.util.HamsterSeatOffsets;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.dawson.adorablehamsterpets.util.TreeHeistUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HamsterEntity
extends TamableAnimal
implements GeoEntity,
ImplementedInventory {
    private static final double WALK_TO_RUN_THRESHOLD_SQUARED = 0.002;
    private static final double RUN_TO_SPRINT_THRESHOLD_SQUARED = 0.008;
    public static final float FAST_YAW_CHANGE = 25.0f;
    public static final float FAST_PITCH_CHANGE = 25.0f;
    private static final int INVENTORY_SIZE = 8;
    private static final int CHEEK_POUCH_SIZE = 6;
    public static final int ACCESSORY_SLOT_INDEX = 6;
    public static final int ARMOR_SLOT_INDEX = 7;
    private static final int REFUSE_FOOD_TIMER_TICKS = 40;
    private static final int CUSTOM_LOVE_TICKS = 600;
    private static final double THROWN_GRAVITY = -0.05;
    private static final double HAMSTER_ATTACK_BOX_EXPANSION = 0.7;
    private static final UUID ARMOR_SPEED_BOOST_UUID = UUID.fromString("74ba7508-3010-449e-97c7-573531b7987e");
    private static final UUID ARMOR_KNOCKBACK_RESISTANCE_UUID = UUID.fromString("a8470a74-d2ca-4c8d-806d-6215d290680d");
    private static final int NORMAL_FALL_PITCH_DURATION = 15;
    private static final int PITCH_RESET_DURATION = 3;
    private static final int RIDER_JUMP_COOLDOWN_TICKS = 8;
    private static final double RIDER_JUMP_VELOCITY = 0.6;
    public static final int CELEBRATION_PARTICLE_DURATION_TICKS = 600;
    private static final float DEFAULT_FOOTSTEP_VOLUME = 0.1f;
    private static final float GRAVEL_VOLUME_MODIFIER = 0.6f;
    private static final List<HamsterVariant> ORANGE_VARIANTS = List.of(HamsterVariant.ORANGE, HamsterVariant.ORANGE_OVERLAY1, HamsterVariant.ORANGE_OVERLAY2, HamsterVariant.ORANGE_OVERLAY3, HamsterVariant.ORANGE_OVERLAY4, HamsterVariant.ORANGE_OVERLAY5, HamsterVariant.ORANGE_OVERLAY6, HamsterVariant.ORANGE_OVERLAY7, HamsterVariant.ORANGE_OVERLAY8);
    private static final List<HamsterVariant> BLUE_VARIANTS = List.of(HamsterVariant.BLUE, HamsterVariant.BLUE_OVERLAY1, HamsterVariant.BLUE_OVERLAY2, HamsterVariant.BLUE_OVERLAY3, HamsterVariant.BLUE_OVERLAY4, HamsterVariant.BLUE_OVERLAY5, HamsterVariant.BLUE_OVERLAY6, HamsterVariant.BLUE_OVERLAY7, HamsterVariant.BLUE_OVERLAY8);
    private static final List<HamsterVariant> CHOCOLATE_VARIANTS = List.of(HamsterVariant.CHOCOLATE, HamsterVariant.CHOCOLATE_OVERLAY1, HamsterVariant.CHOCOLATE_OVERLAY2, HamsterVariant.CHOCOLATE_OVERLAY3, HamsterVariant.CHOCOLATE_OVERLAY4, HamsterVariant.CHOCOLATE_OVERLAY5, HamsterVariant.CHOCOLATE_OVERLAY6, HamsterVariant.CHOCOLATE_OVERLAY7, HamsterVariant.CHOCOLATE_OVERLAY8);
    private static final List<HamsterVariant> CREAM_VARIANTS = List.of(HamsterVariant.CREAM, HamsterVariant.CREAM_OVERLAY1, HamsterVariant.CREAM_OVERLAY2, HamsterVariant.CREAM_OVERLAY3, HamsterVariant.CREAM_OVERLAY4, HamsterVariant.CREAM_OVERLAY5, HamsterVariant.CREAM_OVERLAY6, HamsterVariant.CREAM_OVERLAY7, HamsterVariant.CREAM_OVERLAY8);
    private static final List<HamsterVariant> DARK_GRAY_VARIANTS = List.of(HamsterVariant.DARK_GRAY, HamsterVariant.DARK_GRAY_OVERLAY1, HamsterVariant.DARK_GRAY_OVERLAY2, HamsterVariant.DARK_GRAY_OVERLAY3, HamsterVariant.DARK_GRAY_OVERLAY4, HamsterVariant.DARK_GRAY_OVERLAY5, HamsterVariant.DARK_GRAY_OVERLAY6, HamsterVariant.DARK_GRAY_OVERLAY7, HamsterVariant.DARK_GRAY_OVERLAY8);
    private static final List<HamsterVariant> LAVENDER_VARIANTS = List.of(HamsterVariant.LAVENDER, HamsterVariant.LAVENDER_OVERLAY1, HamsterVariant.LAVENDER_OVERLAY2, HamsterVariant.LAVENDER_OVERLAY3, HamsterVariant.LAVENDER_OVERLAY4, HamsterVariant.LAVENDER_OVERLAY5, HamsterVariant.LAVENDER_OVERLAY6, HamsterVariant.LAVENDER_OVERLAY7, HamsterVariant.LAVENDER_OVERLAY8);
    private static final List<HamsterVariant> LIGHT_GRAY_VARIANTS = List.of(HamsterVariant.LIGHT_GRAY, HamsterVariant.LIGHT_GRAY_OVERLAY1, HamsterVariant.LIGHT_GRAY_OVERLAY2, HamsterVariant.LIGHT_GRAY_OVERLAY3, HamsterVariant.LIGHT_GRAY_OVERLAY4, HamsterVariant.LIGHT_GRAY_OVERLAY5, HamsterVariant.LIGHT_GRAY_OVERLAY6, HamsterVariant.LIGHT_GRAY_OVERLAY7, HamsterVariant.LIGHT_GRAY_OVERLAY8);
    public static final int SLEEPING_FLAG = 1;
    public static final int SITTING_FLAG = 2;
    public static final int BEGGING_FLAG = 4;
    public static final int IN_LOVE_FLAG = 8;
    public static final int REFUSING_FOOD_FLAG = 16;
    public static final int THROWN_FLAG = 32;
    public static final int LEFT_CHEEK_FULL_FLAG = 64;
    public static final int RIGHT_CHEEK_FULL_FLAG = 128;
    public static final int KNOCKED_OUT_FLAG = 256;
    public static final int CHEEK_POUCH_UNLOCKED_FLAG = 512;
    public static final int CONSIDERING_AUTO_EAT_FLAG = 1024;
    public static final int SULKING_FLAG = 2048;
    public static final int CELEBRATING_DIAMOND_FLAG = 4096;
    public static final int CLEANING_FLAG = 8192;
    public static final int HOLDING_INTEREST_ITEM_FLAG = 16384;
    public static final int TAUNTING_WITH_ITEM_FLAG = 32768;
    public static final int PRESENTING_ITEM_FLAG = 0x100000;
    public static final int CELEBRATING_RETRIEVAL_FLAG = 65536;
    public static final int IS_SHOULDER_PET_FLAG = 131072;
    public static final int IS_WANDER_MODE_ACTIVE_FLAG = 262144;
    public static final int ON_THE_WAY_TO_BED_FLAG = 524288;
    public static final int STUCK_SEARCHING_FOR_BED_FLAG = 0x200000;
    public static final int RESCUE_SLEEPING_FLAG = 0x400000;
    private static final EntityDataAccessor<Integer> HAMSTER_FLAGS = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> ANIMATION_PERSONALITY_ID = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> PINK_PETAL_TYPE = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DOZING_PHASE = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<String> CURRENT_DEEP_SLEEP_ANIM_ID = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<String> ACTIVE_CUSTOM_GOAL_NAME_DEBUG = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Integer> ITEM_INTEREST_TIMER = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<ItemStack> INTEREST_ITEM_STACK = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final EntityDataAccessor<Long> GREEN_BEAN_BUFF_DURATION = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    public static final EntityDataAccessor<Integer> CURRENT_LOOK_UP_ANIM_ID = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> SHOULDER_ANIMATION_STATE = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<ItemStack> TRACKED_ACCESSORY_STACK = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> TRACKED_ARMOR_STACK = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<Boolean> FALL_IMMUNITY_ACTIVE = SynchedEntityData.m_135353_(HamsterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final RawAnimation CRASH_ANIM = RawAnimation.begin().thenPlay("anim_hamster_crash");
    private static final RawAnimation KNOCKED_OUT_ANIM = RawAnimation.begin().thenPlay("anim_hamster_ko");
    private static final RawAnimation WAKE_UP_FROM_KO_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup_from_ko");
    private static final RawAnimation FLYING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_flying");
    private static final RawAnimation STANDING_HEADSHAKE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_standing_headshake");
    private static final RawAnimation SITTING_HEADSHAKE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_headshake");
    private static final RawAnimation MOVING_HEADSHAKE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_moving_headshake");
    private static final RawAnimation SLEEP_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose1");
    private static final RawAnimation SLEEP_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose2");
    private static final RawAnimation SLEEP_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sleep_pose3");
    private static final RawAnimation SIT_SETTLE_SLEEP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep1");
    private static final RawAnimation SIT_SETTLE_SLEEP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep2");
    private static final RawAnimation SIT_SETTLE_SLEEP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit_settle_sleep3");
    private static final RawAnimation STAND_SETTLE_SLEEP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep1");
    private static final RawAnimation STAND_SETTLE_SLEEP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep2");
    private static final RawAnimation STAND_SETTLE_SLEEP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_stand_settle_sleep3");
    private static final RawAnimation SIT1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit1");
    private static final RawAnimation SIT2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit2");
    private static final RawAnimation SIT3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sit3");
    private static final RawAnimation STANDUP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_standup1");
    private static final RawAnimation STANDUP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_standup2");
    private static final RawAnimation STANDUP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_standup3");
    private static final RawAnimation WAKE_UP_1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup1");
    private static final RawAnimation WAKE_UP_2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup2");
    private static final RawAnimation WAKE_UP_3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wakeup3");
    private static final RawAnimation SITTING_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose1");
    private static final RawAnimation SITTING_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose2");
    private static final RawAnimation SITTING_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sitting_pose3");
    private static final RawAnimation DRIFTING_OFF_POSE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose1");
    private static final RawAnimation DRIFTING_OFF_POSE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose2");
    private static final RawAnimation DRIFTING_OFF_POSE3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_drifting_off_pose3");
    private static final RawAnimation CLEANING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_cleaning");
    private static final RawAnimation RUNNING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_running");
    private static final RawAnimation WALKING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_walking");
    private static final RawAnimation SPRINTING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sprinting");
    private static final RawAnimation BEGGING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_begging");
    private static final RawAnimation IDLE1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle1");
    private static final RawAnimation IDLE2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle2");
    private static final RawAnimation IDLE_LOOKING_UP1_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up1");
    private static final RawAnimation IDLE_LOOKING_UP2_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up2");
    private static final RawAnimation IDLE_LOOKING_UP3_ANIM = RawAnimation.begin().thenPlay("anim_hamster_idle_looking_up3");
    private static final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("anim_hamster_attack");
    private static final RawAnimation SULK_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sulk");
    private static final RawAnimation SULKING_ANIM = RawAnimation.begin().thenPlay("anim_hamster_sulking");
    private static final RawAnimation SEEKING_ORE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_seeking_ore");
    private static final RawAnimation WANTS_TO_SEEK_ORE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_wants_to_seek_ore");
    private static final RawAnimation POUNCE_ON_ITEM_ANIM = RawAnimation.begin().thenPlay("anim_hamster_pounce_on_item");
    private static final RawAnimation TAUNT_WITH_ITEM_ANIM = RawAnimation.begin().thenPlay("anim_hamster_taunt_with_item");
    private static final RawAnimation PRESENTING_ITEM_ANIM = RawAnimation.begin().thenPlay("anim_hamster_presenting_item");
    private static final RawAnimation CELEBRATE_CHASE_ANIM = RawAnimation.begin().thenPlay("anim_hamster_celebrate_chase");
    private static final RawAnimation LAYING_DOWN_HEAD_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_head");
    private static final RawAnimation LAYING_DOWN_RIGHT_SHOULDER_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_right_shoulder");
    private static final RawAnimation LAYING_DOWN_LEFT_SHOULDER_ANIM = RawAnimation.begin().thenPlay("anim_hamster_shoulder_laying_down_left_shoulder");
    @Unique
    public int interactionCooldown = 0;
    @Unique
    public int throwTicks = 0;
    @Unique
    public int wakingUpTicks = 0;
    @Unique
    private int ejectionCheckCooldown = 20;
    @Unique
    private int preAutoEatDelayTicks = 0;
    @Unique
    private int quiescentSitDurationTimer = 0;
    @Unique
    private int driftingOffTimer = 0;
    @Unique
    private int settleSleepAnimationCooldown = 0;
    @Unique
    private String activeCustomGoalDebugName = "None";
    @Unique
    public boolean isPrimedToSeekDiamonds = false;
    @Unique
    public long foundOreCooldownEndTick = 0L;
    @Unique
    public BlockPos currentOreTarget = null;
    @Unique
    private int celebrationParticleTicks = 0;
    @Unique
    private int diamondCelebrationSoundTicks = 0;
    @Unique
    private int sulkOrchestraHitDelayTicks = 0;
    @Unique
    private int sulkFailParticleTicks = 0;
    @Unique
    private int sulkEntityEffectTicks = 0;
    @Unique
    private int sulkShockedSoundDelayTicks = 0;
    @Unique
    private int diamondSparkleSoundDelayTicks = 0;
    @Unique
    public transient String particleEffectId = null;
    @Unique
    public transient String soundEffectId = null;
    @Unique
    public long interestCooldownEndTick = 0L;
    @Unique
    private int celebrationRetrievalTicks = 0;
    @Unique
    private boolean zoomiesIsClockwise = false;
    @Unique
    private double lastZoomiesAngle = 0.0;
    @Unique
    private int zoomiesRadiusModifier = 0;
    @Unique
    public transient float renderedSnowYOffset = 0.0f;
    @Unique
    public transient ShoulderLocation shoulderLocation = ShoulderLocation.RIGHT_SHOULDER;
    @Unique
    public int suffocationGracePeriod = 0;
    @Unique
    public transient float dynamicScaleY = 1.0f;
    @Unique
    private Optional<GlobalPos> linkedBedPos = Optional.empty();
    @Unique
    private int goToBedCooldown = 0;
    @Unique
    private int lureToBedTimer = 0;
    @Unique
    public int goToBedDelayTicks = 0;
    @Unique
    private int wakeUpFromBedDelay = 0;
    @Unique
    public int bedLeafParticleTicks = 0;
    @Unique
    private boolean bypassNextSleepDelay = false;
    @Unique
    private int napInBedDurationTimer = 0;
    @Unique
    private int thumpSoundDelayTicks = 0;
    @Unique
    private float thumpSoundVolume = 0.2f;
    @Unique
    public int pathingFailures = 0;
    @Unique
    @Nullable
    public BlockPos lastFailedTarget = null;
    @Unique
    private boolean hasPlayedIncomingSound = false;
    @Unique
    private boolean isLoadingNbt = false;
    @Unique
    private boolean isSilentInventoryUpdate = false;
    private boolean armorAbsorbedDamage = false;
    private boolean performDeferredArmorUpdate = false;
    @Unique
    public float clientFallPitchProgress = 0.0f;
    @Unique
    public float prevClientFallPitchProgress = 0.0f;
    @Unique
    private int riderJumpCooldown = 0;
    @Unique
    private boolean riderJumpHeld = false;
    @Unique
    private boolean riderJumpQueued = false;
    @Unique
    private boolean riderSprintHeld = false;
    @Unique
    private int localSpawnImmunityTicks = 60;
    private final NonNullList<ItemStack> items = ImplementedInventory.create(8);
    private ItemStack lastArmorStack = ItemStack.f_41583_;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final HamsterAnimationScheduler animScheduler = new HamsterAnimationScheduler();
    private int refuseTimer = 0;
    private ItemStack lastFoodItem = ItemStack.f_41583_;
    public int customLoveTimer;
    private int tamingCooldown = 0;
    public long throwCooldownEndTick = 0L;
    private long greenBeanBuffEndTick = 0L;
    private boolean isAutoEating = false;
    private int autoEatProgressTicks = 0;
    private int autoEatCooldownTicks = 0;
    public int cleaningTimer = 0;
    private int cleaningCooldownTimer = 0;

    public EntityGetter m_9236_() {
        return this.m_9236_();
    }

    private static HamsterVariant determineVariantForBiome(Holder<Biome> biomeEntry, RandomSource random) {
        String biomeName = biomeEntry.m_203543_().map(k -> k.m_135782_().toString()).orElse("unknown");
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] determineVariantForBiome called for biome: {}", (Object)biomeName);
        HamsterVariant result = HamsterEntity.canSpawnBlue(biomeEntry) ? (random.m_188503_(10) < 7 ? HamsterEntity.getRandomVariant(BLUE_VARIANTS, random) : HamsterVariant.WHITE) : (HamsterEntity.canSpawnLavender(biomeEntry) ? HamsterEntity.getRandomVariant(LAVENDER_VARIANTS, random) : (HamsterEntity.canSpawnWhite(biomeEntry) ? HamsterVariant.WHITE : (HamsterEntity.canSpawnGray(biomeEntry) ? (random.m_188499_() ? HamsterEntity.getRandomVariant(LIGHT_GRAY_VARIANTS, random) : HamsterEntity.getRandomVariant(DARK_GRAY_VARIANTS, random)) : (HamsterEntity.canSpawnBlack(biomeEntry) ? HamsterVariant.BLACK : (HamsterEntity.canSpawnCream(biomeEntry) ? HamsterEntity.getRandomVariant(CREAM_VARIANTS, random) : (HamsterEntity.canSpawnChocolate(biomeEntry) ? HamsterEntity.getRandomVariant(CHOCOLATE_VARIANTS, random) : HamsterEntity.getRandomVariant(ORANGE_VARIANTS, random)))))));
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] Determined variant for {} is {}", (Object)biomeName, (Object)result.name());
        return result;
    }

    private static boolean canSpawnBlue(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isBlueBiome(biomeEntry);
    }

    private static boolean canSpawnLavender(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isLavenderBiome(biomeEntry);
    }

    private static boolean canSpawnWhite(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isWhiteBiome(biomeEntry);
    }

    private static boolean canSpawnGray(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isGrayBiome(biomeEntry);
    }

    private static boolean canSpawnBlack(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isBlackBiome(biomeEntry);
    }

    private static boolean canSpawnCream(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isCreamBiome(biomeEntry);
    }

    private static boolean canSpawnChocolate(Holder<Biome> biomeEntry) {
        return ConfigDataCache.isChocolateBiome(biomeEntry);
    }

    private static HamsterVariant getRandomVariant(List<HamsterVariant> variantPool, RandomSource random) {
        if (variantPool == null || variantPool.isEmpty()) {
            return HamsterVariant.ORANGE;
        }
        return variantPool.get(random.m_188503_(variantPool.size()));
    }

    public static AttributeSupplier.Builder createHamsterAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)Configs.AHP.wildMaxHealth.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, ((Double)Configs.AHP.meleeDamage.get()).doubleValue()).m_22268_(Attributes.f_22277_, 40.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    @Nullable
    public static HamsterEntity createFromNbt(ServerLevel world, Player player, CompoundTag nbt) {
        Optional<HamsterShoulderData> dataOpt = HamsterShoulderData.fromNbt(nbt);
        if (dataOpt.isEmpty()) {
            AdorableHamsterPets.LOGGER.error("Failed to deserialize HamsterShoulderData from NBT: {}", (Object)nbt);
            return null;
        }
        HamsterShoulderData data = dataOpt.get();
        AdorableHamsterPets.LOGGER.debug("[HamsterEntity] createFromNbt called for player {} with data: {}", (Object)player.m_7755_().getString(), (Object)data);
        HamsterEntity hamster = (HamsterEntity)((EntityType)ModEntities.HAMSTER.get()).m_20615_((Level)world);
        if (hamster != null) {
            hamster.m_20084_(data.entityUuid());
            hamster.setVariant(data.variantId());
            hamster.m_21153_(data.health());
            hamster.m_21816_(player.m_20148_());
            hamster.setTamed(true, true);
            hamster.m_146762_(data.breedingAge());
            hamster.throwCooldownEndTick = data.throwCooldownEndTick();
            hamster.autoEatCooldownTicks = data.autoEatCooldownTicks();
            hamster.m_20088_().m_135381_(PINK_PETAL_TYPE, (Object)data.pinkPetalType());
            hamster.m_20088_().m_135381_(ANIMATION_PERSONALITY_ID, (Object)data.animationPersonalityId());
            hamster.m_20088_().m_135381_(HAMSTER_FLAGS, (Object)data.hamsterFlags());
            hamster.setHamsterFlag(2, false);
            data.customName().ifPresent(name -> {
                if (!name.isEmpty()) {
                    hamster.m_6593_((Component)Component.m_237113_((String)name));
                }
            });
            if (!data.inventoryNbt().m_128456_()) {
                ContainerHelper.m_18980_((CompoundTag)data.inventoryNbt(), hamster.items);
                hamster.updateCheekTrackers();
                hamster.updateEquipmentTrackers();
            }
            HamsterShoulderData.GreenBeanBuffData buffData = data.greenBeanBuffData();
            hamster.greenBeanBuffEndTick = buffData.greenBeanBuffEndTick();
            hamster.m_20088_().m_135381_(GREEN_BEAN_BUFF_DURATION, (Object)buffData.greenBeanBuffDuration());
            ListTag effectsList = buffData.activeEffectsNbt();
            for (int i = 0; i < effectsList.size(); ++i) {
                CompoundTag effectNbt = effectsList.m_128728_(i);
                MobEffectInstance effectInstance = MobEffectInstance.m_19560_((CompoundTag)effectNbt);
                if (effectInstance == null) continue;
                hamster.m_7292_(effectInstance);
            }
            HamsterShoulderData.SeekingBehaviorData seekingData = data.seekingBehaviorData();
            hamster.isPrimedToSeekDiamonds = seekingData.isPrimedToSeekDiamonds();
            hamster.foundOreCooldownEndTick = seekingData.foundOreCooldownEndTick();
            hamster.currentOreTarget = seekingData.currentOreTarget().orElse(null);
            HamsterShoulderData.WanderModeData wanderData = data.wanderModeData();
            hamster.linkedBedPos = wanderData.linkedBedPos();
            hamster.bypassNextSleepDelay = wanderData.bypassNextSleepDelay();
            hamster.isAutoEating = false;
            hamster.autoEatProgressTicks = 0;
            hamster.setHamsterFlag(8192, false);
            hamster.setDozingPhase(DozingPhase.NONE);
        }
        return hamster;
    }

    public static void spawnFromNbt(ServerLevel world, Player player, CompoundTag nbt, boolean wasDiamondAlertActive, @Nullable HamsterEntity preconfiguredHamster) {
        HamsterEntity hamster;
        HamsterEntity hamsterEntity = hamster = preconfiguredHamster != null ? preconfiguredHamster : HamsterEntity.createFromNbt(world, player, nbt);
        if (hamster == null) {
            return;
        }
        hamster.suffocationGracePeriod = 200;
        if (wasDiamondAlertActive && Configs.AHP.enableIndependentDiamondSeeking) {
            hamster.isPrimedToSeekDiamonds = true;
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity {}] Primed for diamond seeking upon dismount.", (Object)hamster.m_19879_());
        }
        if (hamster.isThrown()) {
            world.m_7967_((Entity)hamster);
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity] Spawned THROWN Hamster ID {} from NBT data near Player {}.", (Object)hamster.m_19879_(), (Object)player.m_7755_().getString());
        } else {
            BlockPos ultimateFallbackPos = player.m_20183_();
            HitResult hitResult = player.m_19907_(4.5, 0.0f, false);
            BlockPos initialSearchPos = hitResult.m_6662_() == HitResult.Type.BLOCK ? ((BlockHitResult)hitResult).m_82425_() : ultimateFallbackPos;
            Optional<BlockPos> safePosOpt = HamsterPlacementUtil.findSafeSpawnPosition(initialSearchPos, (Level)world, 5, hamster);
            safePosOpt.ifPresentOrElse(safePos -> {
                hamster.m_7678_((double)safePos.m_123341_() + 0.5, safePos.m_123342_(), (double)safePos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                AdorableHamsterPets.LOGGER.debug("[HamsterDismount] Found safe spawn at {} for player {}.", safePos, (Object)player.m_7755_().getString());
            }, () -> {
                AdorableHamsterPets.LOGGER.warn("[HamsterDismount] Could not find a safe spawn position for player {}. Spawning at player's feet as a fallback.", (Object)player.m_7755_().getString());
                hamster.m_7678_((double)ultimateFallbackPos.m_123341_() + 0.5, ultimateFallbackPos.m_123342_(), (double)ultimateFallbackPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
            });
            world.m_47205_((Entity)hamster);
            AdorableHamsterPets.LOGGER.debug("[HamsterEntity] Spawned Hamster ID {} from NBT data near Player {}.", (Object)hamster.m_19879_(), (Object)player.m_7755_().getString());
        }
    }

    public static void tryThrowFromShoulder(ServerPlayer player) {
        PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
        AhpConfig config = AdorableHamsterPets.CONFIG;
        if (!config.enableHamsterThrowing) {
            player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.throwing_disabled"), true);
            return;
        }
        if (!playerAccessor.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.warn("[HamsterThrow] Player {} tried to throw, but has no shoulder hamster.", (Object)player.m_7755_().getString());
            return;
        }
        playerAccessor.adorablehamsterpets$dismountShoulderHamster(true);
    }

    public HamsterEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 3;
        this.m_21441_(BlockPathTypes.WATER, 16.0f);
        this.m_21441_(BlockPathTypes.LAVA, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variantId) {
        this.f_19804_.m_135381_(VARIANT, (Object)variantId);
    }

    public boolean m_5803_() {
        return this.getHamsterFlag(1);
    }

    public void setSleeping(boolean sleeping) {
        this.setHamsterFlag(1, sleeping);
    }

    public boolean m_21827_() {
        return this.getHamsterFlag(2) || this.getHamsterFlag(1) || this.getHamsterFlag(256) || this.getHamsterFlag(2048);
    }

    public boolean isCleaning() {
        return this.getHamsterFlag(8192);
    }

    public boolean isBegging() {
        return this.getHamsterFlag(4);
    }

    public void setBegging(boolean value) {
        this.setHamsterFlag(4, value);
    }

    public boolean m_27593_() {
        return this.getHamsterFlag(8);
    }

    public void setInLove(boolean value) {
        this.setHamsterFlag(8, value);
    }

    public boolean isRefusingFood() {
        return this.getHamsterFlag(16);
    }

    public void setRefusingFood(boolean value) {
        this.setHamsterFlag(16, value);
    }

    public boolean isThrown() {
        return this.getHamsterFlag(32);
    }

    public void setThrown(boolean thrown) {
        this.setHamsterFlag(32, thrown);
        if (thrown) {
            this.hasPlayedIncomingSound = false;
        }
    }

    public boolean isLeftCheekFull() {
        return this.getHamsterFlag(64);
    }

    public void setLeftCheekFull(boolean full) {
        this.setHamsterFlag(64, full);
    }

    public boolean isRightCheekFull() {
        return this.getHamsterFlag(128);
    }

    public void setRightCheekFull(boolean full) {
        this.setHamsterFlag(128, full);
    }

    public boolean isKnockedOut() {
        return this.getHamsterFlag(256);
    }

    public void setKnockedOut(boolean knocked_out) {
        this.setHamsterFlag(256, knocked_out);
    }

    public String getCurrentDeepSleepAnimationIdFromTracker() {
        return (String)this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID);
    }

    public boolean isAutoEating() {
        return this.isAutoEating;
    }

    public boolean isConsideringAutoEat() {
        return this.getHamsterFlag(1024);
    }

    public DozingPhase getDozingPhase() {
        return DozingPhase.values()[(Integer)this.f_19804_.m_135370_(DOZING_PHASE)];
    }

    public void setDozingPhase(DozingPhase phase) {
        this.f_19804_.m_135381_(DOZING_PHASE, (Object)phase.ordinal());
    }

    public void setActiveCustomGoalDebugName(String name) {
        this.f_19804_.m_135381_(ACTIVE_CUSTOM_GOAL_NAME_DEBUG, (Object)name);
    }

    public String getActiveCustomGoalDebugName() {
        String goalName = (String)this.f_19804_.m_135370_(ACTIVE_CUSTOM_GOAL_NAME_DEBUG);
        return goalName;
    }

    public boolean isSulking() {
        return this.getHamsterFlag(2048);
    }

    public boolean isCelebratingDiamond() {
        return this.getHamsterFlag(4096);
    }

    public void setCelebratingDiamond(boolean celebrating) {
        this.setHamsterFlag(4096, celebrating);
        if (celebrating) {
            this.setBegging(false);
            if (!this.m_9236_().m_5776_()) {
                this.celebrationParticleTicks = 600;
                this.diamondSparkleSoundDelayTicks = 10;
            }
        } else {
            this.celebrationParticleTicks = 0;
            this.diamondSparkleSoundDelayTicks = 0;
            this.diamondCelebrationSoundTicks = 0;
        }
    }

    public void setSulking(boolean sulking) {
        this.setHamsterFlag(2048, sulking);
        if (sulking) {
            if (!this.m_9236_().m_5776_()) {
                this.sulkOrchestraHitDelayTicks = 10;
                this.sulkShockedSoundDelayTicks = 44;
                this.sulkFailParticleTicks = 600;
                this.sulkEntityEffectTicks = 600;
            }
        } else {
            this.sulkOrchestraHitDelayTicks = 0;
            this.sulkFailParticleTicks = 0;
            this.sulkEntityEffectTicks = 0;
        }
    }

    public boolean isHoldingInterestItem() {
        return this.getHamsterFlag(16384);
    }

    public void setHoldingInterestItem(boolean holding) {
        this.setHamsterFlag(16384, holding);
    }

    public int getItemInterestTimer() {
        return (Integer)this.f_19804_.m_135370_(ITEM_INTEREST_TIMER);
    }

    public void setItemInterestTimer(int ticks) {
        this.f_19804_.m_135381_(ITEM_INTEREST_TIMER, (Object)ticks);
    }

    public boolean isTauntingWithItem() {
        return this.getHamsterFlag(32768);
    }

    public void setTauntingWithItem(boolean taunting) {
        this.setHamsterFlag(32768, taunting);
    }

    public boolean isPresentingItem() {
        return this.getHamsterFlag(0x100000);
    }

    public void setPresentingItem(boolean presenting) {
        this.setHamsterFlag(0x100000, presenting);
    }

    public ItemStack getInterestItemStack() {
        return (ItemStack)this.f_19804_.m_135370_(INTEREST_ITEM_STACK);
    }

    public void setInterestItemStack(ItemStack stack) {
        this.f_19804_.m_135381_(INTEREST_ITEM_STACK, (Object)stack);
    }

    public boolean isCelebratingRetrieval() {
        return this.getHamsterFlag(65536);
    }

    public void setCelebratingRetrieval(boolean celebrating) {
        this.setHamsterFlag(65536, celebrating);
    }

    public boolean hasGreenBeanBuff() {
        return (Long)this.m_20088_().m_135370_(GREEN_BEAN_BUFF_DURATION) > this.m_9236_().m_46467_();
    }

    public boolean getZoomiesIsClockwise() {
        return this.zoomiesIsClockwise;
    }

    public double getLastZoomiesAngle() {
        return this.lastZoomiesAngle;
    }

    public void setLastZoomiesAngle(double angle) {
        this.lastZoomiesAngle = angle;
    }

    public int getZoomiesRadiusModifier() {
        return this.zoomiesRadiusModifier;
    }

    public boolean isShoulderPet() {
        return this.getHamsterFlag(131072);
    }

    public void setShoulderPet(boolean isShoulderPet) {
        this.setHamsterFlag(131072, isShoulderPet);
    }

    public boolean isWanderModeActive() {
        return this.getHamsterFlag(262144);
    }

    public void setWanderModeActive(boolean active) {
        this.setHamsterFlag(262144, active);
    }

    public Optional<GlobalPos> getLinkedBedPos() {
        return this.linkedBedPos;
    }

    public void setLinkedBedPos(Optional<GlobalPos> pos) {
        this.linkedBedPos = pos;
    }

    public int getGoToBedCooldown() {
        return this.goToBedCooldown;
    }

    public boolean isStuckSearchingForBed() {
        return this.getHamsterFlag(0x200000);
    }

    public void setStuckSearchingForBed(boolean stuck) {
        this.setHamsterFlag(0x200000, stuck);
    }

    public boolean isRescueSleeping() {
        return this.getHamsterFlag(0x400000);
    }

    public void setRescueSleeping(boolean rescueSleeping) {
        this.setHamsterFlag(0x400000, rescueSleeping);
    }

    public void setFallFlyImmunityTicks(int ticks) {
        if (ticks <= 0) {
            this.f_19804_.m_135381_(FALL_IMMUNITY_ACTIVE, (Object)false);
            this.localSpawnImmunityTicks = 0;
        } else {
            this.f_19804_.m_135381_(FALL_IMMUNITY_ACTIVE, (Object)true);
            this.localSpawnImmunityTicks = ticks;
        }
    }

    public void wakeUpFromBed(boolean isManualWakeUp) {
        if (!this.m_5803_()) {
            return;
        }
        this.triggerWakeUpFromSleepAnimation(isManualWakeUp);
        this.setSleeping(false);
        this.setRescueSleeping(false);
        this.m_21837_(false);
        if (isManualWakeUp) {
            this.goToBedCooldown = (Integer)Configs.AHP.bedWakeUpCooldown.get();
            this.setBypassNextSleepDelay(true);
        }
        this.getLinkedBedPos().ifPresent(globalPos -> {
            if (this.m_9236_().m_46472_() == globalPos.m_122640_()) {
                BlockEntity be;
                BlockPos bedPos = globalPos.m_122646_();
                BlockState bedState = this.m_9236_().m_8055_(bedPos);
                ParticleEffectsUtil.spawnParticles(this.m_9236_(), Vec3.m_82539_((Vec3i)bedPos).m_82520_(0.0, 0.3, 0.0), ModParticles.getForVariant((WoodVariant)((Object)((Object)bedState.m_61143_(HamsterBedBlock.WOOD_VARIANT)))), 50, new Vec3(0.2, 0.5, 0.2), 0.0);
                SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, this.f_19796_);
                if (rustleSound != null) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), rustleSound, SoundSource.NEUTRAL, 0.2f, 1.8f);
                }
                if (bedState.m_60713_((Block)ModBlocks.HAMSTER_BED.get()) && ((Boolean)bedState.m_61143_((Property)HamsterBedBlock.OCCUPIED)).booleanValue()) {
                    this.m_9236_().m_7731_(bedPos, (BlockState)bedState.m_61124_((Property)HamsterBedBlock.OCCUPIED, (Comparable)Boolean.valueOf(false)), 3);
                }
                if ((be = this.m_9236_().m_7702_(bedPos)) instanceof GeoBlockEntity) {
                    GeoBlockEntity geoBlockEntity = (GeoBlockEntity)be;
                    geoBlockEntity.triggerAnim("hamster_bed_controller", "anim_bed_becoming_unoccupied");
                }
                for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)bedPos.m_7918_(-1, 0, -1), (BlockPos)bedPos.m_7918_(1, 0, 1))) {
                    if (checkPos.equals((Object)bedPos) || !HamsterPlacementUtil.isSafeSpawnLocation(checkPos, this.m_9236_(), this)) continue;
                    this.m_21573_().m_26519_((double)checkPos.m_123341_() + 0.5, (double)checkPos.m_123342_(), (double)checkPos.m_123343_() + 0.5, 1.2);
                    return;
                }
            }
        });
    }

    public int getGoToBedDelayTicks() {
        return this.goToBedDelayTicks;
    }

    public void setGoToBedDelayTicks(int ticks) {
        this.goToBedDelayTicks = ticks;
    }

    public int getLureToBedTimer() {
        return this.lureToBedTimer;
    }

    public void setLureToBedTimer(int ticks) {
        this.lureToBedTimer = ticks;
    }

    public void lureToBed() {
        this.lureToBedTimer = 20;
    }

    public boolean isOnTheWayToBed() {
        return this.getHamsterFlag(524288);
    }

    public void setOnTheWayToBed(boolean onTheWay) {
        this.setHamsterFlag(524288, onTheWay);
    }

    public boolean shouldBypassNextSleepDelay() {
        return this.bypassNextSleepDelay;
    }

    public void setBypassNextSleepDelay(boolean bypass) {
        this.bypassNextSleepDelay = bypass;
    }

    public void startNapTimer() {
        if (((Boolean)Configs.AHP.circadianChaos.get()).booleanValue()) {
            int min = (Integer)Configs.AHP.minNapInBedIntervalSeconds.get() * 20;
            int max = (Integer)Configs.AHP.maxNapInBedIntervalSeconds.get() * 20;
            this.napInBedDurationTimer = this.f_19796_.m_216332_(min, max);
        }
    }

    public void triggerSettleEffects(float swishVolume, int thumpDelay, float thumpVolume) {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.HAMSTER_SWISH.get(), SoundSource.NEUTRAL, swishVolume, 1.0f + this.f_19796_.m_188501_() * 0.5f);
        }
        this.thumpSoundDelayTicks = thumpDelay;
        this.thumpSoundVolume = thumpVolume;
    }

    public void triggerWakeUpFromSleepAnimation(boolean isManualWakeUp) {
        SoundEvent affectionSound;
        String currentSleepAnim;
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.triggerAnimOnServer("mainController", switch (currentSleepAnim = (String)this.m_20088_().m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID)) {
            case "anim_hamster_sleep_pose2" -> "wakeup2";
            case "anim_hamster_sleep_pose3" -> "wakeup3";
            default -> "wakeup1";
        });
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.HAMSTER_SWISH.get(), SoundSource.NEUTRAL, 0.1f, 1.0f + this.f_19796_.m_188501_() * 0.5f);
        if (isManualWakeUp && (affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.f_19796_)) != null) {
            this.m_9236_().m_5594_(null, this.m_20183_(), affectionSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public boolean isPathThroughUnlinkedBed(@Nullable Path path) {
        if (path == null) {
            return false;
        }
        BlockPos linkedBed = this.getLinkedBedPos().map(GlobalPos::m_122646_).orElse(null);
        for (int i = 0; i < path.m_77398_(); ++i) {
            Node node = path.m_77375_(i);
            BlockPos pos = node.m_77288_();
            if (!this.isUnlinkedBed(pos, linkedBed) && !this.isUnlinkedBed(pos.m_7495_(), linkedBed)) continue;
            AdorableHamsterPets.LOGGER.trace("[AHP Nav Debug] Path intersects unlinked bed at {}, linkedBed={} for hamster {}", new Object[]{pos, linkedBed, this.m_20148_()});
            return true;
        }
        return false;
    }

    public boolean isUnlinkedBed(BlockPos pos, BlockPos linkedBed) {
        if (this.m_9236_().m_8055_(pos).m_60734_() instanceof HamsterBedBlock) {
            return linkedBed == null || !pos.equals((Object)linkedBed);
        }
        return false;
    }

    public void updateNavigation() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        boolean useCustomNav = Configs.AHP.avoidUnlinkedBeds;
        boolean isCurrentlyCustom = this.f_21344_ instanceof HamsterNavigation;
        if (useCustomNav && !isCurrentlyCustom) {
            this.f_21344_ = this.m_6037_(this.m_9236_());
        } else if (!useCustomNav && isCurrentlyCustom) {
            this.f_21344_ = this.m_6037_(this.m_9236_());
        }
    }

    public boolean tryShoulderMount(Player player, ItemStack stack) {
        PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
        ShoulderLocation availableSlot = null;
        MountPriority priority = (MountPriority)((Object)Configs.AHP.mountPriority.get());
        if (priority == MountPriority.HEAD_FIRST) {
            if (playerAccessor.getShoulderHamster(ShoulderLocation.HEAD).m_128456_()) {
                availableSlot = ShoulderLocation.HEAD;
            } else if (playerAccessor.getShoulderHamster(ShoulderLocation.RIGHT_SHOULDER).m_128456_()) {
                availableSlot = ShoulderLocation.RIGHT_SHOULDER;
            } else if (playerAccessor.getShoulderHamster(ShoulderLocation.LEFT_SHOULDER).m_128456_()) {
                availableSlot = ShoulderLocation.LEFT_SHOULDER;
            }
        } else if (playerAccessor.getShoulderHamster(ShoulderLocation.RIGHT_SHOULDER).m_128456_()) {
            availableSlot = ShoulderLocation.RIGHT_SHOULDER;
        } else if (playerAccessor.getShoulderHamster(ShoulderLocation.LEFT_SHOULDER).m_128456_()) {
            availableSlot = ShoulderLocation.LEFT_SHOULDER;
        } else if (playerAccessor.getShoulderHamster(ShoulderLocation.HEAD).m_128456_()) {
            availableSlot = ShoulderLocation.HEAD;
        }
        if (availableSlot != null) {
            this.setWanderModeActive(false);
            HamsterShoulderData data = this.saveToShoulderData();
            playerAccessor.setShoulderHamster(availableSlot, data.toNbt());
            playerAccessor.adorablehamsterpets$getMountOrderQueue().addLast(availableSlot);
            BlockPos hamsterPosForMountSound = this.m_20183_();
            this.m_146870_();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModCriteria.HAMSTER_ON_SHOULDER.trigger(serverPlayer);
            }
            player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.shoulder_mount_success"), true);
            SoundEvent mountSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SHOULDER_MOUNT_SOUNDS, this.f_19796_);
            if (mountSound != null) {
                this.m_9236_().m_5594_(null, player.m_20183_(), mountSound, SoundSource.PLAYERS, 1.0f, this.m_6100_());
            }
            if (ConfigDataCache.isLureItem(stack)) {
                SoundEvent mountLureSound = ModSounds.getDynamicItemSound(stack);
                this.m_9236_().m_5594_(null, hamsterPosForMountSound, mountLureSound, SoundSource.PLAYERS, 1.0f, 1.0f);
                ParticleEffectsUtil.spawnParticles(this.m_9236_(), Vec3.m_82512_((Vec3i)hamsterPosForMountSound), new ItemParticleOption(ParticleTypes.f_123752_, stack.m_41777_()), 8, new Vec3(0.25, 0.25, 0.25), 0.05);
                if (!player.m_150110_().f_35937_ && Configs.AHP.consumeLureItem) {
                    stack.m_41774_(1);
                }
            }
            return true;
        }
        player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.shoulder_occupied"), true);
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268612_)) {
            this.suffocationGracePeriod = 40;
            return false;
        }
        this.armorAbsorbedDamage = false;
        boolean result = super.m_6469_(source, amount);
        if (this.armorAbsorbedDamage) {
            return true;
        }
        return result;
    }

    protected void m_6475_(DamageSource source, float amount) {
        ItemStack realArmorStack;
        if (!this.m_9236_().f_46443_ && !source.m_269533_(DamageTypeTags.f_268490_) && !(realArmorStack = (ItemStack)this.items.get(7)).m_41619_() && realArmorStack.m_41720_() instanceof HamsterArmorItem && this.shouldArmorAbsorb(source, realArmorStack)) {
            this.armorAbsorbedDamage = true;
            ItemStack particleStack = realArmorStack.m_41777_();
            int armorDamage = (int)Math.ceil(amount);
            realArmorStack.m_41622_(armorDamage, (LivingEntity)this, e -> e.m_21166_(EquipmentSlot.CHEST));
            if (realArmorStack.m_41619_()) {
                this.m_5496_(SoundEvents.f_12347_, 0.5f, 1.2f);
                ParticleEffectsUtil.spawnParticles(this.m_9236_(), new Vec3(this.m_20185_(), this.m_20227_(0.5), this.m_20189_()), new ItemParticleOption(ParticleTypes.f_123752_, particleStack), 15, new Vec3(0.2, 0.2, 0.2), 0.1);
                this.performDeferredArmorUpdate = true;
            } else {
                this.m_5496_(SoundEvents.f_12346_, 0.5f, 1.2f);
                ParticleEffectsUtil.spawnParticles(this.m_9236_(), new Vec3(this.m_20185_(), this.m_20227_(0.5), this.m_20189_()), new ItemParticleOption(ParticleTypes.f_123752_, particleStack), 5, new Vec3(0.2, 0.2, 0.2), 0.05);
            }
            return;
        }
        super.m_6475_(source, amount);
    }

    public boolean m_21515_() {
        return super.m_21515_() && !this.isThrown();
    }

    public boolean m_6094_() {
        if (this.isThrown() || this.m_5803_() && this.getLinkedBedPos().isPresent()) {
            return false;
        }
        return super.m_6094_();
    }

    @Override
    public void m_6836_(int slot, ItemStack stack) {
        ItemStack oldStack = ((ItemStack)this.items.get(slot)).m_41777_();
        this.getItems().set(slot, (Object)stack);
        if (!(this.m_9236_().f_46443_ || slot != 6 && slot != 7)) {
            this.updateEquipmentTrackers();
        }
        if (!(this.m_9236_().f_46443_ || this.isLoadingNbt || this.isSilentInventoryUpdate)) {
            this.handleSlotUpdateSounds(slot, oldStack, stack);
        }
        this.m_6596_();
    }

    @Override
    public ItemStack m_8016_(int slot) {
        ItemStack oldStack = this.m_8020_(slot).m_41777_();
        ItemStack result = ImplementedInventory.super.m_8016_(slot);
        ItemStack newStack = this.m_8020_(slot);
        if (!(this.m_9236_().f_46443_ || this.isLoadingNbt || this.isSilentInventoryUpdate)) {
            this.handleSlotUpdateSounds(slot, oldStack, newStack);
        }
        return result;
    }

    @Override
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack oldStack = this.m_8020_(slot).m_41777_();
        ItemStack result = ImplementedInventory.super.m_7407_(slot, amount);
        ItemStack newStack = this.m_8020_(slot);
        if (!(this.m_9236_().f_46443_ || this.isLoadingNbt || this.isSilentInventoryUpdate)) {
            this.handleSlotUpdateSounds(slot, oldStack, newStack);
        }
        return result;
    }

    public boolean shouldRenderFlying() {
        if (this.m_21827_()) {
            return false;
        }
        if (this.isThrown()) {
            return true;
        }
        if (((Boolean)this.f_19804_.m_135370_(FALL_IMMUNITY_ACTIVE)).booleanValue() && this.localSpawnImmunityTicks > 0) {
            return false;
        }
        return !this.m_20096_() && this.m_20184_().f_82480_ < -0.01;
    }

    public void putPlayerOnBack(Player player) {
        if (!this.m_20363_((Entity)player)) {
            player.m_20329_((Entity)this);
            this.setSitting(false, false);
            if (this.m_21830_((LivingEntity)player)) {
                this.setWanderModeActive(false);
            }
        }
    }

    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity passenger;
        Entity firstPassenger;
        if (this.m_21824_() && (firstPassenger = this.m_146895_()) instanceof LivingEntity && this.m_21830_(passenger = (LivingEntity)firstPassenger)) {
            return passenger;
        }
        return null;
    }

    public void m_7023_(Vec3 movementInput) {
        if (this.m_6084_()) {
            LivingEntity passenger = this.m_6688_();
            if (this.m_21824_() && passenger instanceof Player) {
                Player player = (Player)passenger;
                this.m_146922_(player.m_146908_());
                this.f_19859_ = this.m_146908_();
                this.m_146926_(player.m_146909_() * 0.5f);
                this.m_19915_(this.m_146908_(), this.m_146909_());
                this.f_20885_ = this.f_20883_ = this.m_146908_();
                float forwardSpeed = player.f_20902_;
                float sidewaysSpeed = player.f_20900_;
                if (forwardSpeed <= 0.0f) {
                    forwardSpeed *= 0.25f;
                }
                AhpConfig config = AdorableHamsterPets.CONFIG;
                boolean hasMovement = (double)Math.abs(forwardSpeed) > 1.0E-5 || (double)Math.abs(sidewaysSpeed) > 1.0E-5;
                boolean isSprinting = this.riderSprintHeld && hasMovement;
                this.m_6858_(isSprinting);
                double speedMultiplier = isSprinting ? (Double)config.ridingSprintSpeedMultiplier.get() : (Double)config.ridingBaseSpeedMultiplier.get();
                float attributeSpeed = (float)this.m_21133_(Attributes.f_22279_);
                float finalSpeed = (float)((double)attributeSpeed * speedMultiplier);
                if (this.m_21023_(MobEffects.f_19596_)) {
                    finalSpeed += 0.1f;
                }
                this.m_7910_(finalSpeed);
                if (this.riderJumpCooldown > 0) {
                    --this.riderJumpCooldown;
                } else if (this.riderJumpQueued) {
                    this.riderJumpQueued = false;
                    this.tryRiderJump();
                }
                if (this.m_6109_()) {
                    super.m_7023_(new Vec3((double)sidewaysSpeed, 0.0, (double)forwardSpeed));
                } else if (player instanceof LocalPlayer) {
                    super.m_7023_(new Vec3((double)sidewaysSpeed, 0.0, (double)forwardSpeed));
                }
                return;
            }
        }
        super.m_7023_(movementInput);
    }

    public void setRiderInput(boolean jump, boolean sprint) {
        if (jump && !this.riderJumpHeld) {
            this.riderJumpQueued = true;
            if (!this.m_9236_().m_5776_()) {
                AdorableHamsterPets.LOGGER.info("[AHP JUMP][SERVER] hamsterId={} queuedJump=true", (Object)this.m_19879_());
            }
        }
        this.riderJumpHeld = jump;
        this.riderSprintHeld = sprint;
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        if (slot == EquipmentSlot.FEET) {
            return (ItemStack)this.items.get(7);
        }
        return super.m_6844_(slot);
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.FEET) {
            this.m_6836_(7, stack);
            return;
        }
        super.m_8061_(slot, stack);
    }

    public Iterable<ItemStack> m_6168_() {
        return List.of((ItemStack)this.items.get(7));
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    @Override
    public void m_6596_() {
        if (!this.m_9236_().m_5776_()) {
            this.updateCheekTrackers();
            this.updateAccessoryState();
        }
    }

    public ItemStack getArmorStack() {
        return (ItemStack)this.f_19804_.m_135370_(TRACKED_ARMOR_STACK);
    }

    public ItemStack getAccessoryStack() {
        return (ItemStack)this.f_19804_.m_135370_(TRACKED_ACCESSORY_STACK);
    }

    public void setArmorStack(ItemStack stack) {
        this.m_6836_(7, stack);
    }

    public Component m_5446_() {
        if (this.m_8077_()) {
            return super.m_5446_();
        }
        if (Configs.AHP.useHampterName) {
            return Component.m_237115_((String)"entity.adorablehamsterpets.hampter");
        }
        return super.m_5446_();
    }

    @Override
    public boolean m_7013_(int slot, ItemStack stack) {
        if (slot < 6) {
            return !this.isItemDisallowed(stack);
        }
        if (slot == 6) {
            return stack.m_150930_((Item)ModItems.ACORN_HAT.get()) || stack.m_150930_(Items.f_271209_);
        }
        if (slot == 7) {
            return stack.m_41720_() instanceof HamsterArmorItem;
        }
        return false;
    }

    public void updateCheekTrackers() {
        LivingEntity livingEntity;
        boolean leftFull = false;
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            leftFull = true;
            break;
        }
        boolean rightFull = false;
        for (int i = 3; i < 6; ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            rightFull = true;
            break;
        }
        if (this.isLeftCheekFull() != leftFull) {
            this.setLeftCheekFull(leftFull);
        }
        if (this.isRightCheekFull() != rightFull) {
            this.setRightCheekFull(rightFull);
        }
        if (!this.m_9236_().m_5776_() && (livingEntity = this.m_269323_()) instanceof ServerPlayer) {
            ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
            boolean allSlotsFilled = true;
            for (int i = 0; i < 6; ++i) {
                if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
                allSlotsFilled = false;
                break;
            }
            if (allSlotsFilled) {
                ModCriteria.HAMSTER_POUCH_FILLED.trigger(serverPlayerOwner, this);
            }
        }
    }

    public void updateEquipmentTrackers() {
        if (this.m_9236_().m_5776_() && !this.isShoulderPet()) {
            return;
        }
        ItemStack accessory = (ItemStack)this.items.get(6);
        ItemStack armor = (ItemStack)this.items.get(7);
        this.f_19804_.m_135381_(TRACKED_ACCESSORY_STACK, (Object)accessory);
        this.f_19804_.m_135381_(TRACKED_ARMOR_STACK, (Object)armor);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128405_("HamsterVariant", this.getVariant());
        if (this.m_21824_()) {
            nbt.m_128379_("Sitting", this.getHamsterFlag(2));
        }
        nbt.m_128379_("KnockedOut", this.getHamsterFlag(256));
        nbt.m_128379_("CheekPouchUnlocked", this.getHamsterFlag(512));
        if (this.m_21824_()) {
            nbt.m_128379_("IsSleeping", this.getHamsterFlag(1));
        } else {
            nbt.m_128379_("IsSleeping", false);
        }
        nbt.m_128356_("ThrowCooldownEnd", this.throwCooldownEndTick);
        nbt.m_128356_("GreenBeanBuffDuration", ((Long)this.m_20088_().m_135370_(GREEN_BEAN_BUFF_DURATION)).longValue());
        nbt.m_128405_("AutoEatCooldown", this.autoEatCooldownTicks);
        nbt.m_128405_("EjectionCheckCooldown", this.ejectionCheckCooldown);
        nbt.m_128405_("PinkPetalType", ((Integer)this.f_19804_.m_135370_(PINK_PETAL_TYPE)).intValue());
        nbt.m_128405_("AnimationPersonalityId", ((Integer)this.f_19804_.m_135370_(ANIMATION_PERSONALITY_ID)).intValue());
        nbt.m_128405_("DozingPhase", this.getDozingPhase().ordinal());
        nbt.m_128359_("CurrentDeepSleepAnimId", (String)this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID));
        nbt.m_128405_("QuiescentSitTimer", this.quiescentSitDurationTimer);
        nbt.m_128405_("DriftingOffTimer", this.driftingOffTimer);
        nbt.m_128405_("SettleSleepCooldown", this.settleSleepAnimationCooldown);
        CompoundTag inventoryWrapperNbt = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)inventoryWrapperNbt, this.items);
        nbt.m_128365_("Inventory", (Tag)inventoryWrapperNbt);
        nbt.m_128379_("IsPrimedToSeekDiamonds", this.isPrimedToSeekDiamonds);
        nbt.m_128356_("FoundOreCooldownEndTick", this.foundOreCooldownEndTick);
        if (this.currentOreTarget != null) {
            nbt.m_128405_("OreTargetX", this.currentOreTarget.m_123341_());
            nbt.m_128405_("OreTargetY", this.currentOreTarget.m_123342_());
            nbt.m_128405_("OreTargetZ", this.currentOreTarget.m_123343_());
        }
        nbt.m_128379_("IsSulking", this.getHamsterFlag(2048));
        nbt.m_128379_("IsCelebratingDiamond", this.getHamsterFlag(4096));
        if (this.isHoldingInterestItem()) {
            nbt.m_128379_("isHoldingInterestItem", true);
            nbt.m_128405_("ItemInterestTimer", this.getItemInterestTimer());
            if (!this.getInterestItemStack().m_41619_()) {
                nbt.m_128365_("InterestItemStack", (Tag)this.getInterestItemStack().m_41739_(new CompoundTag()));
            }
        }
        nbt.m_128379_("IsWanderModeActive", this.isWanderModeActive());
        this.linkedBedPos.ifPresent(globalPos -> {
            DataResult result = GlobalPos.f_122633_.encodeStart((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)this.m_9236_().m_9598_()), globalPos);
            result.result().ifPresent(tag -> nbt.m_128365_("LinkedBedPos", tag));
        });
        nbt.m_128379_("BypassNextSleepDelay", this.bypassNextSleepDelay);
        nbt.m_128379_("StuckSearchingForBed", this.isStuckSearchingForBed());
        nbt.m_128379_("IsRescueSleeping", this.isRescueSleeping());
        nbt.m_128379_("HasPlayedIncomingSound", this.hasPlayedIncomingSound);
    }

    public void m_7378_(CompoundTag nbt) {
        this.isLoadingNbt = true;
        super.m_7378_(nbt);
        this.setVariant(nbt.m_128451_("HamsterVariant"));
        boolean wasSittingNbt = this.m_21824_() && nbt.m_128471_("Sitting");
        this.setSitting(wasSittingNbt, true);
        this.setHamsterFlag(256, nbt.m_128471_("KnockedOut"));
        this.setHamsterFlag(512, nbt.m_128471_("CheekPouchUnlocked"));
        this.setHamsterFlag(2048, nbt.m_128471_("IsSulking"));
        this.setHamsterFlag(4096, nbt.m_128471_("IsCelebratingDiamond"));
        boolean loadedSleeping = nbt.m_128471_("IsSleeping");
        if (!this.m_21824_()) {
            loadedSleeping = false;
        }
        this.setHamsterFlag(1, loadedSleeping);
        this.throwCooldownEndTick = nbt.m_128454_("ThrowCooldownEnd");
        this.m_20088_().m_135381_(GREEN_BEAN_BUFF_DURATION, (Object)nbt.m_128454_("GreenBeanBuffDuration"));
        this.autoEatCooldownTicks = nbt.m_128451_("AutoEatCooldown");
        this.ejectionCheckCooldown = nbt.m_128425_("EjectionCheckCooldown", 3) ? nbt.m_128451_("EjectionCheckCooldown") : 20;
        this.f_19804_.m_135381_(PINK_PETAL_TYPE, (Object)nbt.m_128451_("PinkPetalType"));
        if (!nbt.m_128425_("AnimationPersonalityId", 3)) {
            int personalityId = this.f_19796_.m_216332_(1, 3);
            this.f_19804_.m_135381_(ANIMATION_PERSONALITY_ID, (Object)personalityId);
            AdorableHamsterPets.LOGGER.debug("[NBT READ] Hamster ID {}: NBT had no personality, assigned new ID {}", (Object)this.m_19879_(), (Object)personalityId);
        } else {
            this.f_19804_.m_135381_(ANIMATION_PERSONALITY_ID, (Object)nbt.m_128451_("AnimationPersonalityId"));
        }
        if (nbt.m_128425_("DozingPhase", 3)) {
            int phaseOrdinal = nbt.m_128451_("DozingPhase");
            if (phaseOrdinal >= 0 && phaseOrdinal < DozingPhase.values().length) {
                DozingPhase phase = DozingPhase.values()[phaseOrdinal];
                this.setDozingPhase(phase);
                if (phase == DozingPhase.DEEP_SLEEP) {
                    this.setHamsterFlag(1, true);
                }
            } else {
                this.setDozingPhase(DozingPhase.NONE);
            }
        } else {
            this.setDozingPhase(DozingPhase.NONE);
        }
        this.f_19804_.m_135381_(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)nbt.m_128461_("CurrentDeepSleepAnimId"));
        this.quiescentSitDurationTimer = nbt.m_128451_("QuiescentSitTimer");
        this.driftingOffTimer = nbt.m_128451_("DriftingOffTimer");
        this.settleSleepAnimationCooldown = nbt.m_128451_("SettleSleepCooldown");
        this.items.clear();
        if (nbt.m_128425_("Inventory", 10)) {
            ContainerHelper.m_18980_((CompoundTag)nbt.m_128469_("Inventory"), this.items);
        }
        if (!this.hasInventoryData(nbt) && !this.m_21824_()) {
            this.generateWildLoot();
        }
        this.updateCheekTrackers();
        this.updateEquipmentTrackers();
        this.isPrimedToSeekDiamonds = nbt.m_128471_("IsPrimedToSeekDiamonds");
        this.foundOreCooldownEndTick = nbt.m_128454_("FoundOreCooldownEndTick");
        this.currentOreTarget = nbt.m_128441_("OreTargetX") && nbt.m_128441_("OreTargetY") && nbt.m_128441_("OreTargetZ") ? new BlockPos(nbt.m_128451_("OreTargetX"), nbt.m_128451_("OreTargetY"), nbt.m_128451_("OreTargetZ")) : null;
        this.setHoldingInterestItem(nbt.m_128471_("isHoldingInterestItem"));
        if (this.isHoldingInterestItem()) {
            this.setItemInterestTimer(nbt.m_128451_("ItemInterestTimer"));
            if (nbt.m_128425_("InterestItemStack", 10)) {
                this.setInterestItemStack(ItemStack.m_41712_((CompoundTag)nbt.m_128469_("InterestItemStack")));
            }
        } else {
            this.setItemInterestTimer(0);
            this.setInterestItemStack(ItemStack.f_41583_);
        }
        this.setWanderModeActive(nbt.m_128471_("IsWanderModeActive"));
        this.linkedBedPos = nbt.m_128441_("LinkedBedPos") ? GlobalPos.f_122633_.parse((DynamicOps)RegistryOps.m_255058_((DynamicOps)NbtOps.f_128958_, (HolderLookup.Provider)this.m_9236_().m_9598_()), (Object)nbt.m_128423_("LinkedBedPos")).result() : Optional.empty();
        this.bypassNextSleepDelay = nbt.m_128471_("BypassNextSleepDelay");
        this.setStuckSearchingForBed(nbt.m_128471_("StuckSearchingForBed"));
        this.setRescueSleeping(nbt.m_128471_("IsRescueSleeping"));
        if (this.isRescueSleeping()) {
            this.setHamsterFlag(1, true);
        }
        this.hasPlayedIncomingSound = nbt.m_128471_("HasPlayedIncomingSound");
        this.isLoadingNbt = false;
    }

    public HamsterShoulderData saveToShoulderData() {
        this.updateCheekTrackers();
        CompoundTag inventoryNbt = new CompoundTag();
        ContainerHelper.m_18973_((CompoundTag)inventoryNbt, this.items);
        ListTag effectsList = new ListTag();
        for (MobEffectInstance effectInstance : this.m_21220_()) {
            effectsList.add((Object)effectInstance.m_19555_(new CompoundTag()));
        }
        Optional<String> nameOptional = Optional.ofNullable(this.m_7770_()).map(Component::getString);
        HamsterShoulderData.SeekingBehaviorData seekingData = new HamsterShoulderData.SeekingBehaviorData(this.isPrimedToSeekDiamonds, this.foundOreCooldownEndTick, Optional.ofNullable(this.currentOreTarget));
        HamsterShoulderData.GreenBeanBuffData buffData = new HamsterShoulderData.GreenBeanBuffData(this.greenBeanBuffEndTick, (Long)this.m_20088_().m_135370_(GREEN_BEAN_BUFF_DURATION), effectsList);
        HamsterShoulderData.WanderModeData wanderData = new HamsterShoulderData.WanderModeData(this.linkedBedPos, this.bypassNextSleepDelay);
        return new HamsterShoulderData(this.m_20148_(), this.getVariant(), this.m_21223_(), inventoryNbt, this.m_146764_(), this.throwCooldownEndTick, buffData, this.autoEatCooldownTicks, nameOptional, (Integer)this.f_19804_.m_135370_(PINK_PETAL_TYPE), (Integer)this.f_19804_.m_135370_(ANIMATION_PERSONALITY_ID), seekingData, wanderData, (Integer)this.f_19804_.m_135370_(HAMSTER_FLAGS));
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public void m_19884_(double cursorX, double cursorY) {
        if (this.m_5803_()) {
            return;
        }
        super.m_19884_(cursorX, cursorY);
    }

    public void m_21839_(boolean sitting) {
        this.setSitting(sitting, true);
    }

    public void setSitting(boolean sitting, boolean suppressSound) {
        boolean wasSitting = this.m_21827_();
        if (sitting && !wasSitting) {
            int personalityId = (Integer)this.f_19804_.m_135370_(ANIMATION_PERSONALITY_ID);
            String animToTrigger = switch (personalityId) {
                case 2 -> "sit2";
                case 3 -> "sit3";
                default -> "sit1";
            };
            this.triggerAnimOnServer("mainController", animToTrigger);
            this.triggerSettleEffects(0.12f, 7, 0.2f);
        } else if (!sitting && wasSitting) {
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.HAMSTER_SWISH.get(), SoundSource.NEUTRAL, 0.1f, 1.0f + this.f_19796_.m_188501_() * 0.5f);
            }
            int personalityId = (Integer)this.f_19804_.m_135370_(ANIMATION_PERSONALITY_ID);
            String animToTrigger = switch (personalityId) {
                case 2 -> "standup2";
                case 3 -> "standup3";
                default -> "standup1";
            };
            this.triggerAnimOnServer("mainController", animToTrigger);
        }
        if (!sitting && this.m_21824_() && this.getDozingPhase() != DozingPhase.NONE) {
            this.resetSleepSequence("Player commanded hamster to stand up.");
        }
        this.setHamsterFlag(2, sitting);
        this.m_21837_(sitting);
        if (sitting) {
            this.cleaningTimer = 0;
        } else {
            this.quiescentSitDurationTimer = 0;
            this.cleaningTimer = 0;
            if (this.getHamsterFlag(8192)) {
                this.setHamsterFlag(8192, false);
            }
        }
    }

    public boolean m_217066_(LivingEntity entity) {
        AABB hamsterBox = this.m_20191_();
        AABB attackBox = hamsterBox.m_82377_(0.7, 0.0, 0.7);
        boolean intersects = attackBox.m_82381_(entity.m_20191_());
        return intersects;
    }

    public boolean m_7757_(LivingEntity target, LivingEntity owner) {
        TraceableEntity ownableFallback;
        Entity fallbackOwnerEntity;
        UUID ownerUuid = owner.m_20148_();
        AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Hamster: {}, Target: {}, Owner: {}", new Object[]{this.m_7755_().getString(), target.m_7755_().getString(), owner.m_7755_().getString()});
        if (target == this || target == owner) {
            return false;
        }
        if (target instanceof Player && target.m_20148_().equals(ownerUuid)) {
            return false;
        }
        if (target instanceof Creeper || target instanceof ArmorStand) {
            return false;
        }
        if (target instanceof TamableAnimal) {
            TamableAnimal tameablePet = (TamableAnimal)target;
            UUID petOwnerUuid = tameablePet.m_21805_();
            if (petOwnerUuid != null && petOwnerUuid.equals(ownerUuid)) {
                AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is a TameableEntity owned by the same player. Preventing attack.");
                return false;
            }
        } else if (target instanceof AbstractHorse) {
            AbstractHorse horsePet = (AbstractHorse)target;
            LivingEntity horseOwnerEntity = horsePet.m_269323_();
            if (horseOwnerEntity != null && horseOwnerEntity.m_20148_().equals(ownerUuid)) {
                AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is an AbstractHorseEntity owned by the same player. Preventing attack.");
                return false;
            }
        } else if (target instanceof TraceableEntity && (fallbackOwnerEntity = (ownableFallback = (TraceableEntity)target).m_19749_()) != null && fallbackOwnerEntity.m_20148_().equals(ownerUuid)) {
            AdorableHamsterPets.LOGGER.trace("[canAttackWithOwner] Target is an Ownable (fallback) owned by the same player. Preventing attack.");
            return false;
        }
        return true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (this.m_20363_((Entity)player)) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        Level world = this.m_9236_();
        AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Interaction start. Player: {}, Hand: {}, Item: {}", new Object[]{this.m_19879_(), world.m_46467_(), player.m_7755_().getString(), hand, stack.m_41720_()});
        if (this.interactionCooldown > 0) {
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Interaction cooldown active ({} ticks left). Passing.", new Object[]{this.m_19879_(), world.m_46467_(), this.interactionCooldown});
            return InteractionResult.PASS;
        }
        if (player.m_6144_() && stack.m_150930_((Item)ModItems.HAMSTER_GUIDE_BOOK.get())) {
            if (!world.f_46443_) {
                boolean newSetting;
                AhpConfig currentConfig = AdorableHamsterPets.CONFIG;
                boolean currentSetting = currentConfig.enableJadeHamsterDebugInfo;
                currentConfig.enableJadeHamsterDebugInfo = newSetting = !currentSetting;
                currentConfig.save();
                MutableComponent message = Component.m_237115_((String)(newSetting ? "message.adorablehamsterpets.debug_overlay_enabled" : "message.adorablehamsterpets.debug_overlay_disabled")).m_130940_(newSetting ? ChatFormatting.WHITE : ChatFormatting.RED);
                player.m_5661_((Component)message, true);
                AdorableHamsterPets.LOGGER.info("Player {} toggled Jade Hamster Debug Info via Guide Book to: {} for hamster {}", new Object[]{player.m_7755_().getString(), newSetting, this.m_19879_()});
            }
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player) && stack.m_41720_() instanceof HamsterBedItem) {
            if (!world.f_46443_) {
                UUID linkedUuid = null;
                if (stack.m_41782_() && stack.m_41783_().m_128441_("LinkedHamsterUuid")) {
                    linkedUuid = stack.m_41783_().m_128342_("LinkedHamsterUuid");
                }
                Object nameToSet = this.m_8077_() ? this.m_7755_() : this.m_5446_().m_6881_().m_130946_(" " + this.m_19879_());
                String nameJson = Component.Serializer.m_130703_((Component)nameToSet);
                if (linkedUuid == null) {
                    ItemStack newStack = stack.m_41777_();
                    CompoundTag nbt = newStack.m_41784_();
                    nbt.m_128362_("LinkedHamsterUuid", this.m_20148_());
                    nbt.m_128359_("LinkedHamsterName", nameJson);
                    nbt.m_128359_("WanderDistance", ((WanderDistance)((Object)Configs.AHP.defaultWanderDistance.get())).m_7912_());
                    player.m_21008_(hand, newStack);
                    world.m_5594_(null, this.m_20183_(), SoundEvents.f_244240_, SoundSource.PLAYERS, 1.0f, 1.2f);
                    ParticleEffectsUtil.spawnParticles(world, new Vec3(this.m_20185_(), this.m_20227_(0.5), this.m_20189_()), ParticleTypes.f_123748_, 10, new Vec3(0.5, 0.5, 0.5), 0.0);
                    player.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.bed_linked", (Object[])new Object[]{this.m_7755_()}), true);
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        ModCriteria.HAMSTER_BED_LINKED.trigger(serverPlayer);
                    }
                } else if (linkedUuid.equals(this.m_20148_())) {
                    WanderDistance currentDistance = (WanderDistance)((Object)Configs.AHP.defaultWanderDistance.get());
                    CompoundTag stackNbt = stack.m_41784_();
                    if (stackNbt.m_128441_("WanderDistance")) {
                        try {
                            currentDistance = WanderDistance.valueOf(stackNbt.m_128461_("WanderDistance"));
                        }
                        catch (IllegalArgumentException serverPlayer) {
                            // empty catch block
                        }
                    }
                    WanderDistance[] values = WanderDistance.values();
                    WanderDistance nextDistance = values[(currentDistance.ordinal() + 1) % values.length];
                    stackNbt.m_128359_("WanderDistance", nextDistance.m_7912_());
                    player.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.wander_distance_set", (Object[])new Object[]{this.m_7755_(), nextDistance.m_7912_()}), true);
                    world.m_5594_(null, this.m_20183_(), (SoundEvent)SoundEvents.f_12490_.m_203334_(), SoundSource.PLAYERS, 0.5f, 1.0f);
                } else {
                    ItemStack newStack = stack.m_41777_();
                    CompoundTag nbt = newStack.m_41784_();
                    nbt.m_128362_("LinkedHamsterUuid", this.m_20148_());
                    nbt.m_128359_("LinkedHamsterName", nameJson);
                    nbt.m_128359_("WanderDistance", ((WanderDistance)((Object)Configs.AHP.defaultWanderDistance.get())).m_7912_());
                    player.m_21008_(hand, newStack);
                    world.m_5594_(null, this.m_20183_(), SoundEvents.f_244240_, SoundSource.PLAYERS, 1.0f, 1.2f);
                    ParticleEffectsUtil.spawnParticles(world, new Vec3(this.m_20185_(), this.m_20227_(0.5), this.m_20189_()), ParticleTypes.f_123748_, 10, new Vec3(0.5, 0.5, 0.5), 0.0);
                    player.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.bed_linked", (Object[])new Object[]{this.m_7755_()}), true);
                }
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (!this.m_21824_()) {
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Hamster not tamed. Checking for taming attempt.", (Object)this.m_19879_(), (Object)world.m_46467_());
            if (player.m_6144_() && ConfigDataCache.isTamingFood(stack)) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Taming attempt detected.", (Object)this.m_19879_(), (Object)world.m_46467_());
                if (!world.f_46443_) {
                    this.tryTame(player, stack);
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Not a taming attempt. Calling super.interactMob for untamed.", (Object)this.m_19879_(), (Object)world.m_46467_());
            return super.m_6071_(player, hand);
        }
        if (this.m_21830_((LivingEntity)player)) {
            boolean isPotentialFood;
            AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Player is owner. Processing owner interactions.", (Object)this.m_19879_(), (Object)world.m_46467_());
            boolean isSneaking = player.m_6144_();
            PlayerEntityAccessor playerAccessor = (PlayerEntityAccessor)player;
            if (!player.m_6144_() && stack.m_41720_() instanceof HamsterArmorItem) {
                if (!world.f_46443_) {
                    ItemStack currentArmor = this.getArmorStack();
                    ItemStack newArmor = stack.m_41620_(1);
                    this.setArmorStack(newArmor);
                    world.m_5594_(null, this.m_20183_(), SoundEvents.f_11675_, SoundSource.NEUTRAL, 0.6f, 1.2f);
                    if (!currentArmor.m_41619_() && !player.m_150109_().m_36054_(currentArmor)) {
                        player.m_36176_(currentArmor, false);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.f_46443_);
            }
            if (this.m_5803_()) {
                if (!world.m_5776_()) {
                    this.wakeUpFromBed(true);
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (this.getDozingPhase() != DozingPhase.NONE) {
                this.resetSleepSequence("Player interacted with hamster.");
            }
            if (this.isHoldingInterestItem() && this.m_21830_((LivingEntity)player)) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob-{}] Passed 'isHoldingInterestItem' check.", (Object)this.m_19879_());
                if (!world.f_46443_) {
                    ItemStack retrievedStack = this.getInterestItemStack().m_41777_();
                    player.m_150109_().m_150079_(this.getInterestItemStack().m_41777_());
                    this.setInterestItemStack(ItemStack.f_41583_);
                    this.setItemInterestTimer(0);
                    this.setHoldingInterestItem(false);
                    this.setCelebratingRetrieval(true);
                    this.celebrationRetrievalTicks = 30;
                    this.triggerAnimOnServer("mainController", "anim_hamster_celebrate_chase");
                    world.m_5594_(null, this.m_20183_(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.f_19796_), SoundSource.NEUTRAL, 1.0f, this.m_6100_());
                    if (!retrievedStack.m_41619_()) {
                        SoundEvent pounceSound = ModSounds.getDynamicItemSound(retrievedStack);
                        float volume = pounceSound == SoundEvents.f_11912_ ? 0.35f : 1.0f;
                        world.m_5594_(null, this.m_20183_(), pounceSound, SoundSource.NEUTRAL, volume, 1.7f);
                        ParticleEffectsUtil.spawnParticles(world, new Vec3(this.m_20185_(), this.m_20227_(0.5), this.m_20189_()), new ItemParticleOption(ParticleTypes.f_123752_, retrievedStack), 10, new Vec3(0.2, 0.2, 0.2), 0.05);
                    }
                    AdorableHamsterPets.LOGGER.trace("[InteractMob-{}] Item returned to player and goal stopped.", (Object)this.m_19879_());
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (this.isKnockedOut()) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Hamster is knocked out. Waking up.", (Object)this.m_19879_(), (Object)world.m_46467_());
                if (!world.m_5776_()) {
                    SoundEvent wakeUpSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_WAKE_UP_SOUNDS, this.f_19796_);
                    if (wakeUpSound != null) {
                        world.m_5594_(null, this.m_20183_(), wakeUpSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                    this.setKnockedOut(false);
                    this.setSitting(false, true);
                    this.triggerAnimOnServer("mainController", "wakeup_from_ko");
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (this.isCelebratingDiamond()) {
                if (!world.m_5776_()) {
                    this.setCelebratingDiamond(false);
                    this.setSitting(false, true);
                    SoundEvent affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.f_19796_);
                    if (affectionSound != null) {
                        world.m_5594_(null, this.m_20183_(), affectionSound, SoundSource.NEUTRAL, 1.0f, this.m_6100_());
                    } else {
                        world.m_5594_(null, this.m_20183_(), SoundEvents.f_12019_, SoundSource.NEUTRAL, 0.5f, 1.5f);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (this.isSulking()) {
                if (!world.m_5776_()) {
                    this.setSulking(false);
                    this.setSitting(false, true);
                    SoundEvent affectionSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_AFFECTION_SOUNDS, this.f_19796_);
                    if (affectionSound != null) {
                        world.m_5594_(null, this.m_20183_(), affectionSound, SoundSource.NEUTRAL, 1.0f, this.m_6100_());
                    } else {
                        world.m_5594_(null, this.m_20183_(), SoundEvents.f_11754_, SoundSource.NEUTRAL, 0.5f, 1.5f);
                    }
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (this.m_7013_(6, stack) && !player.m_6144_()) {
                if (!world.f_46443_) {
                    ItemStack currentAccessory = (ItemStack)this.items.get(6);
                    if (stack.m_150930_(Items.f_271209_) && currentAccessory.m_150930_(Items.f_271209_)) {
                        int currentPetalType = (Integer)this.f_19804_.m_135370_(PINK_PETAL_TYPE);
                        int nextPetalType = currentPetalType % 3 + 1;
                        this.f_19804_.m_135381_(PINK_PETAL_TYPE, (Object)nextPetalType);
                        world.m_5594_(null, this.m_20183_(), SoundEvents.f_271130_, SoundSource.PLAYERS, 0.7f, 1.0f + this.f_19796_.m_188501_() * 0.2f);
                        ParticleEffectsUtil.spawnParticles(world, new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.75, this.m_20189_()), ParticleTypes.f_175832_, 7, new Vec3((double)this.m_20205_() / 2.0, (double)this.m_20206_() / 2.0, (double)this.m_20205_() / 2.0), 0.0);
                        AdorableHamsterPets.LOGGER.trace("[InteractMob {}] Cycled pink petal to type {}.", (Object)this.m_19879_(), (Object)nextPetalType);
                    } else {
                        ItemStack toEquip = stack.m_41620_(1);
                        ItemStack toReturn = currentAccessory.m_41777_();
                        this.m_6836_(6, toEquip);
                        if (!toReturn.m_41619_()) {
                            this.m_19983_(toReturn);
                        }
                        world.m_5594_(null, this.m_20183_(), SoundEvents.f_11675_, SoundSource.PLAYERS, 1.0f, 1.0f);
                        ParticleEffectsUtil.spawnParticles(world, new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.75, this.m_20189_()), new ItemParticleOption(ParticleTypes.f_123752_, toEquip), 7, new Vec3((double)this.m_20205_() / 2.0, (double)this.m_20206_() / 2.0, (double)this.m_20205_() / 2.0), 0.0);
                        if (toEquip.m_150930_(Items.f_271209_) && player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            ModCriteria.APPLIED_PINK_PETAL.trigger(serverPlayer, this);
                        }
                    }
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            if (stack.m_150930_(Items.f_42574_) && !player.m_6144_()) {
                boolean actionTaken = false;
                ItemStack armorStack = this.getArmorStack();
                if (!armorStack.m_41619_() && armorStack.m_41720_() instanceof HamsterArmorItem) {
                    if (!world.f_46443_) {
                        this.m_19983_(armorStack);
                        this.isSilentInventoryUpdate = true;
                        this.setArmorStack(ItemStack.f_41583_);
                        this.isSilentInventoryUpdate = false;
                        this.m_5496_(SoundEvents.f_184216_, 0.8f, 1.5f);
                        if (!player.m_150110_().f_35937_) {
                            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
                        }
                    }
                    actionTaken = true;
                }
                ItemStack accessoryStack = (ItemStack)this.items.get(6);
                if (!actionTaken && !accessoryStack.m_41619_()) {
                    if (!world.f_46443_) {
                        ItemStack particleStack = accessoryStack.m_41777_();
                        this.m_19983_(accessoryStack);
                        this.isSilentInventoryUpdate = true;
                        this.m_6836_(6, ItemStack.f_41583_);
                        this.isSilentInventoryUpdate = false;
                        this.updateAccessoryState();
                        world.m_5594_(null, this.m_20183_(), SoundEvents.f_12344_, SoundSource.PLAYERS, 0.9f, 1.0f + this.f_19796_.m_188501_() * 0.1f);
                        ParticleEffectsUtil.spawnParticles(world, new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_()), new ItemParticleOption(ParticleTypes.f_123752_, particleStack), 5, new Vec3((double)this.m_20205_() / 2.0, (double)this.m_20206_() / 2.0, (double)this.m_20205_() / 2.0), 0.05);
                        if (!player.m_150110_().f_35937_) {
                            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND));
                        }
                    }
                    actionTaken = true;
                }
                if (actionTaken) {
                    return InteractionResult.m_19078_((boolean)world.f_46443_);
                }
            }
            boolean isUsingItem = ConfigDataCache.isLureItem(stack);
            if (ConfigDataCache.isLureItem(stack)) {
                if (!world.f_46443_) {
                    this.tryShoulderMount(player, stack);
                } else {
                    player.m_6674_(hand);
                }
                return InteractionResult.CONSUME;
            }
            if (!world.m_5776_() && isSneaking) {
                if (this.getHamsterFlag(512) || !AdorableHamsterPets.CONFIG.requireFoodMixToUnlockCheeks) {
                    MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)new HamsterScreenHandlerFactory(this));
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.cheek_pouch_locked").m_130940_(ChatFormatting.WHITE), true);
                }
                return InteractionResult.CONSUME;
            }
            boolean bl = isPotentialFood = ConfigDataCache.isStandardFood(stack) || ConfigDataCache.isBuffFood(stack) || ConfigDataCache.isPouchUnlockFood(stack);
            if (!world.m_5776_() && !isSneaking && isPotentialFood) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Owner not sneaking, holding potential food. Checking refusal.", (Object)this.m_19879_(), (Object)world.m_46467_());
                if (this.checkRepeatFoodRefusal(stack, player)) {
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Food refused. Consuming interaction.", (Object)this.m_19879_(), (Object)world.m_46467_());
                    return InteractionResult.CONSUME;
                }
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Attempting feeding via tryFeedingAsTamed.", (Object)this.m_19879_(), (Object)world.m_46467_());
                boolean feedingOccurred = this.tryFeedingAsTamed(player, stack);
                if (feedingOccurred) {
                    AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] tryFeedingAsTamed returned true. Setting last food, decrementing stack.", (Object)this.m_19879_(), (Object)world.m_46467_());
                    this.lastFoodItem = stack.m_41777_();
                    if (!player.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.CONSUME;
                }
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] tryFeedingAsTamed returned false. Passing to vanilla/sitting.", (Object)this.m_19879_(), (Object)world.m_46467_());
            }
            if (!(isSneaking || isPotentialFood || ConfigDataCache.isLureItem(stack) || stack.m_150930_(Items.f_271209_))) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Not sneaking or holding handled food/petals. Calling super.interactMob.", (Object)this.m_19879_(), (Object)world.m_46467_());
                InteractionResult vanillaResult = super.m_6071_(player, hand);
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] super.interactMob returned: {}", new Object[]{this.m_19879_(), world.m_46467_(), vanillaResult});
                if (vanillaResult.m_19077_()) {
                    return vanillaResult;
                }
            }
            if (!world.m_5776_() && !isSneaking) {
                AdorableHamsterPets.LOGGER.trace("[InteractMob {} Tick {}] Fallback: Toggling sitting state.", (Object)this.m_19879_(), (Object)world.m_46467_());
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.CONSUME_PARTIAL;
            }
            AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Reached end of owner logic. Returning client-side success/pass.", (Object)this.m_19879_(), (Object)world.m_46467_());
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        AdorableHamsterPets.LOGGER.debug("[InteractMob {} Tick {}] Player is not owner. Calling super.interactMob.", (Object)this.m_19879_(), (Object)world.m_46467_());
        return super.m_6071_(player, hand);
    }

    public void m_7105_(boolean tamed) {
        this.setTamed(tamed, true);
    }

    public void setTamed(boolean tamed, boolean updateAttributes) {
        super.m_7105_(tamed);
        if (updateAttributes) {
            if (tamed) {
                this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Configs.AHP.tamedMaxHealth.get()).doubleValue());
                this.m_21153_(this.m_21233_());
                this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Configs.AHP.meleeDamage.get()).doubleValue());
            } else {
                this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Configs.AHP.wildMaxHealth.get()).doubleValue());
                this.m_21051_(Attributes.f_22281_).m_22100_(((Double)Configs.AHP.meleeDamage.get()).doubleValue());
            }
        }
    }

    public boolean isInCustomLove() {
        return this.customLoveTimer > 0;
    }

    public void setCustomInLove(Player player) {
        this.customLoveTimer = 600;
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_7605_((Entity)this, (byte)18);
        }
    }

    public void m_6863_(boolean baby) {
        this.m_146762_(baby ? -24000 : 0);
    }

    public void m_21837_(boolean inSittingPose) {
        super.m_21837_(inSittingPose);
        if (this.getHamsterFlag(2) != inSittingPose) {
            this.setHamsterFlag(2, inSittingPose);
        }
        if (!inSittingPose) {
            if (this.m_5803_()) {
                this.setSleeping(false);
            }
            if (this.isKnockedOut()) {
                this.setKnockedOut(false);
            }
        }
    }

    public HamsterVariant getVariantEnum() {
        return HamsterVariant.byId(this.getVariant());
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob mate) {
        HamsterVariant babyFinalVariant;
        boolean motherHasOverlay;
        HamsterEntity baby = (HamsterEntity)((EntityType)ModEntities.HAMSTER.get()).m_20615_((Level)world);
        if (baby == null) {
            return null;
        }
        if (!(mate instanceof HamsterEntity)) {
            int randomVariantId = this.f_19796_.m_188503_(HamsterVariant.values().length);
            baby.setVariant(randomVariantId);
            baby.m_6863_(true);
            AdorableHamsterPets.LOGGER.warn("Hamster breeding attempted with non-hamster mate. Assigning random variant to baby.");
            return baby;
        }
        HamsterEntity mother = (HamsterEntity)mate;
        HamsterEntity father = this;
        HamsterVariant parentProvidingBaseColor = this.f_19796_.m_188499_() ? father.getVariantEnum() : mother.getVariantEnum();
        HamsterVariant babyBaseColorEnum = parentProvidingBaseColor.getBaseVariant();
        @Nullable String fatherOverlayName = father.getVariantEnum().getOverlayTextureName();
        @Nullable String motherOverlayName = mother.getVariantEnum().getOverlayTextureName();
        List<HamsterVariant> allVariantsForBabyBase = HamsterVariant.getVariantsForBase(babyBaseColorEnum);
        ArrayList<@Nullable String> eligibleOverlayNames = new ArrayList<String>();
        for (HamsterVariant variant : allVariantsForBabyBase) {
            boolean matchesMother;
            @Nullable String candidateOverlay = variant.getOverlayTextureName();
            boolean matchesFather = fatherOverlayName != null && fatherOverlayName.equals(candidateOverlay);
            boolean bl = matchesMother = motherOverlayName != null && motherOverlayName.equals(candidateOverlay);
            if (matchesFather || matchesMother) continue;
            eligibleOverlayNames.add(candidateOverlay);
        }
        ArrayList<@Nullable String> finalSelectableOverlayNames = new ArrayList<String>();
        boolean fatherHasOverlay = fatherOverlayName != null;
        boolean bl = motherHasOverlay = motherOverlayName != null;
        if (fatherHasOverlay && motherHasOverlay) {
            for (String overlayName : eligibleOverlayNames) {
                if (overlayName == null) continue;
                finalSelectableOverlayNames.add(overlayName);
            }
            if (finalSelectableOverlayNames.isEmpty() && babyBaseColorEnum != HamsterVariant.WHITE) {
                for (HamsterVariant variant : allVariantsForBabyBase) {
                    if (variant.getOverlayTextureName() == null) continue;
                    finalSelectableOverlayNames.add(variant.getOverlayTextureName());
                }
            }
        } else {
            finalSelectableOverlayNames.addAll(eligibleOverlayNames);
        }
        if (!finalSelectableOverlayNames.isEmpty()) {
            @Nullable String chosenOverlayName = (String)finalSelectableOverlayNames.get(this.f_19796_.m_188503_(finalSelectableOverlayNames.size()));
            babyFinalVariant = HamsterVariant.getVariantByBaseAndOverlay(babyBaseColorEnum, chosenOverlayName);
        } else {
            babyFinalVariant = babyBaseColorEnum;
        }
        baby.setVariant(babyFinalVariant.getId());
        UUID ownerUUID = father.m_21805_();
        if (ownerUUID != null) {
            baby.m_21816_(ownerUUID);
            baby.setTamed(true, true);
        }
        baby.m_6863_(true);
        return baby;
    }

    public boolean m_6898_(ItemStack stack) {
        return ConfigDataCache.isStandardFood(stack);
    }

    public void m_8119_() {
        Level world;
        ItemStack currentArmor;
        int chanceDenominator;
        if (!this.m_9236_().m_5776_()) {
            this.animScheduler.tick(this.m_9236_().m_46467_());
        }
        if (this.interactionCooldown > 0) {
            --this.interactionCooldown;
        }
        if (this.suffocationGracePeriod > 0) {
            --this.suffocationGracePeriod;
        }
        if (this.wakingUpTicks > 0) {
            --this.wakingUpTicks;
        }
        if (this.autoEatCooldownTicks > 0) {
            --this.autoEatCooldownTicks;
        }
        if (this.autoEatProgressTicks > 0) {
            --this.autoEatProgressTicks;
        }
        if (this.ejectionCheckCooldown > 0) {
            --this.ejectionCheckCooldown;
        }
        if (this.preAutoEatDelayTicks > 0) {
            --this.preAutoEatDelayTicks;
        }
        if (this.celebrationParticleTicks > 0) {
            --this.celebrationParticleTicks;
        }
        if (this.celebrationParticleTicks > 0) {
            --this.celebrationParticleTicks;
        }
        if (this.diamondCelebrationSoundTicks > 0) {
            --this.diamondCelebrationSoundTicks;
        }
        if (this.sulkOrchestraHitDelayTicks > 0) {
            --this.sulkOrchestraHitDelayTicks;
        }
        if (this.sulkFailParticleTicks > 0) {
            --this.sulkFailParticleTicks;
        }
        if (this.sulkEntityEffectTicks > 0) {
            --this.sulkEntityEffectTicks;
        }
        if (this.sulkShockedSoundDelayTicks > 0) {
            --this.sulkShockedSoundDelayTicks;
        }
        if (this.diamondSparkleSoundDelayTicks > 0) {
            --this.diamondSparkleSoundDelayTicks;
        }
        if (this.goToBedCooldown > 0) {
            --this.goToBedCooldown;
        }
        if (this.lureToBedTimer > 0) {
            --this.lureToBedTimer;
        }
        if (this.wakeUpFromBedDelay > 0) {
            --this.wakeUpFromBedDelay;
        }
        if (this.napInBedDurationTimer > 0) {
            --this.napInBedDurationTimer;
        }
        if (this.localSpawnImmunityTicks > 0) {
            --this.localSpawnImmunityTicks;
        }
        if (this.thumpSoundDelayTicks > 0) {
            --this.thumpSoundDelayTicks;
            if (this.thumpSoundDelayTicks == 0 && !this.m_9236_().m_5776_()) {
                this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.HAMSTER_THUMP.get(), SoundSource.NEUTRAL, this.thumpSoundVolume, 1.5f);
            }
        }
        if (this.bedLeafParticleTicks > 0) {
            if (!this.m_9236_().m_5776_()) {
                int particleCount = 0;
                if (this.bedLeafParticleTicks == 3) {
                    particleCount = 15;
                } else if (this.bedLeafParticleTicks == 2) {
                    particleCount = 10;
                } else if (this.bedLeafParticleTicks == 1) {
                    particleCount = 5;
                }
                if (particleCount > 0 && this.getLinkedBedPos().isPresent()) {
                    BlockPos bedPos = this.getLinkedBedPos().get().m_122646_();
                    BlockState bedState = this.m_9236_().m_8055_(bedPos);
                    ParticleEffectsUtil.spawnParticles(this.m_9236_(), Vec3.m_82539_((Vec3i)bedPos).m_82520_(0.0, 0.3, 0.0), ModParticles.getForVariant((WoodVariant)((Object)bedState.m_61143_(HamsterBedBlock.WOOD_VARIANT))), particleCount, new Vec3(0.2, 0.3, 0.2), 1.0);
                }
            }
            --this.bedLeafParticleTicks;
        }
        if (this.cleaningCooldownTimer > 0) {
            --this.cleaningCooldownTimer;
        }
        if (this.cleaningTimer > 0) {
            --this.cleaningTimer;
            if (this.cleaningTimer == 0) {
                if (!this.m_9236_().f_46443_) {
                    this.setHamsterFlag(8192, false);
                }
                this.cleaningCooldownTimer = 200;
            }
        }
        if (this.isKnockedOut() && this.getHamsterFlag(8192)) {
            this.setHamsterFlag(8192, false);
            this.cleaningTimer = 0;
        }
        DozingPhase currentPhase = this.getDozingPhase();
        if (!this.m_9236_().m_5776_() && this.m_21824_() && this.m_21827_() && !this.getHamsterFlag(8192) && this.cleaningCooldownTimer <= 0 && (currentPhase == DozingPhase.NONE || currentPhase == DozingPhase.QUIESCENT_SITTING) && (chanceDenominator = ((Integer)Configs.AHP.cleaningChanceDenominator.get()).intValue()) > 0 && this.f_19796_.m_188503_(chanceDenominator) == 0) {
            this.cleaningTimer = this.f_19796_.m_216332_(30, 60);
            this.setHamsterFlag(8192, true);
        }
        if (this.isCelebratingRetrieval()) {
            if (this.celebrationRetrievalTicks > 0) {
                if (this.m_269323_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_269323_(), 25.0f, 25.0f);
                }
                --this.celebrationRetrievalTicks;
            } else {
                this.setCelebratingRetrieval(false);
            }
        }
        if (this.isThrown()) {
            ++this.throwTicks;
            Vec3 currentPos = this.m_20182_();
            Vec3 currentVel = this.m_20184_();
            Vec3 nextPos = currentPos.m_82549_(currentVel);
            Level world2 = this.m_9236_();
            BlockHitResult blockHit = world2.m_45547_(new ClipContext(currentPos, nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            boolean stopped = false;
            if (blockHit.m_6662_() == HitResult.Type.BLOCK) {
                BlockHitResult blockHitResult = blockHit;
                BlockPos hitPos = blockHitResult.m_82425_();
                if (world2.m_8055_(hitPos).m_60713_(Blocks.f_50050_) && !world2.m_5776_()) {
                    TreeHeistUtil.TreeScanResult scanResult = TreeHeistUtil.scanForTree(world2, hitPos);
                    if (HamsterTreeSearcherEntity.isTreeBlocked(world2, scanResult.treeId())) {
                        LivingEntity livingEntity = this.m_269323_();
                        if (livingEntity instanceof Player) {
                            Player owner = (Player)livingEntity;
                            owner.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.tree_heist.occupied").m_130940_(ChatFormatting.RED), true);
                        }
                    } else {
                        this.triggerLeafPopEffects(hitPos, true);
                        HamsterTreeSearcherEntity searcher = (HamsterTreeSearcherEntity)((EntityType)ModEntities.HAMSTER_TREE_SEARCHER.get()).m_20615_(world2);
                        if (searcher != null) {
                            CompoundTag nbt = new CompoundTag();
                            this.m_20240_(nbt);
                            searcher.initializeSearch(hitPos, scanResult, nbt);
                            world2.m_7967_((Entity)searcher);
                            this.m_146870_();
                            return;
                        }
                    }
                }
                BlockPos adjacentPos = blockHitResult.m_82425_().m_121945_(blockHitResult.m_82434_());
                this.m_6034_((double)adjacentPos.m_123341_() + 0.5, adjacentPos.m_123342_(), (double)adjacentPos.m_123343_() + 0.5);
                this.m_20256_(currentVel.m_82542_(0.6, 0.0, 0.6));
                this.setThrown(false);
                this.broadcastImpactSound(SoundEvents.f_11916_, 1.2f);
                this.setKnockedOut(true);
                this.m_21837_(true);
                if (!world2.m_5776_()) {
                    this.triggerAnimOnServer("mainController", "crash");
                }
                stopped = true;
            } else {
                EntityHitResult entityHit = ProjectileUtil.m_37304_((Level)world2, (Entity)this, (Vec3)currentPos, (Vec3)nextPos, (AABB)this.m_20191_().m_82369_(currentVel).m_82400_(1.0), this::canHitEntity);
                if (entityHit != null && entityHit.m_82443_() != null) {
                    Entity hitEntity = entityHit.m_82443_();
                    BlockPos impactPos = hitEntity.m_20183_();
                    boolean playEffects = false;
                    if (hitEntity instanceof ArmorStand) {
                        playEffects = true;
                    } else if (hitEntity instanceof LivingEntity) {
                        boolean damaged;
                        Item item;
                        LivingEntity livingHit = (LivingEntity)hitEntity;
                        DamageSource damageSource = this.m_269291_().m_269333_((LivingEntity)this);
                        float damageAmount = ((Double)Configs.AHP.hamsterThrowDamage.get()).floatValue();
                        ItemStack armorStack = this.getArmorStack();
                        if (!armorStack.m_41619_() && (item = armorStack.m_41720_()) instanceof HamsterArmorItem) {
                            HamsterArmorItem armorItem = (HamsterArmorItem)item;
                            if (((Boolean)Configs.AHP.enableArmorPerks.get()).booleanValue() && armorItem.getMaterial() == HamsterArmorItem.HamsterArmorMaterial.NETHERITE) {
                                damageAmount += ((Double)Configs.AHP.netheriteArmorThrowDamageBonus.get()).floatValue();
                            }
                        }
                        if (damaged = livingHit.m_6469_(damageSource, damageAmount)) {
                            livingHit.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 20, 0, false, false, false));
                            double knockbackStrength = 0.5;
                            double dx = currentVel.f_82479_;
                            double dz = currentVel.f_82481_;
                            livingHit.m_147240_(knockbackStrength, -dx, -dz);
                            playEffects = true;
                        }
                    } else {
                        playEffects = true;
                    }
                    if (playEffects) {
                        this.broadcastImpactSound((SoundEvent)ModSounds.HAMSTER_IMPACT.get(), 1.0f);
                        ParticleEffectsUtil.spawnParticles(world2, new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 2.0, this.m_20189_()), ParticleTypes.f_123759_, 50, new Vec3(0.4, 0.4, 0.4), 0.1);
                    }
                    Optional<BlockPos> safePosOpt = HamsterPlacementUtil.findSafeSpawnPosition(impactPos, world2, 2, this);
                    safePosOpt.ifPresentOrElse(safePos -> this.m_6034_((double)safePos.m_123341_() + 0.5, safePos.m_123342_(), (double)safePos.m_123343_() + 0.5), () -> {
                        AdorableHamsterPets.LOGGER.warn("[HamsterThrow] Could not find safe landing spot after hitting entity. Using entity's position {} as fallback.", (Object)impactPos);
                        this.m_6034_((double)impactPos.m_123341_() + 0.5, impactPos.m_123342_(), (double)impactPos.m_123343_() + 0.5);
                    });
                    this.m_20256_(currentVel.m_82542_(0.1, 0.1, 0.1));
                    this.setThrown(false);
                    this.setKnockedOut(true);
                    this.m_21837_(true);
                    if (!world2.m_5776_()) {
                        this.triggerAnimOnServer("mainController", "crash");
                    }
                    stopped = true;
                }
            }
            if (this.isThrown() && !stopped) {
                if (!this.m_9236_().m_5776_() && !this.hasPlayedIncomingSound) {
                    this.simulateTrajectoryAndCheckSound();
                }
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.05, 0.0));
                }
                Vec3 currentVelocity = this.m_20184_();
                if (Double.isNaN(currentVelocity.f_82479_) || Double.isNaN(currentVelocity.f_82480_) || Double.isNaN(currentVelocity.f_82481_)) {
                    this.m_20256_(Vec3.f_82478_);
                    this.setThrown(false);
                    AdorableHamsterPets.LOGGER.warn("Hamster velocity became NaN, resetting and stopping throw.");
                } else {
                    int particleDelay;
                    this.m_6034_(this.m_20185_() + currentVelocity.f_82479_, this.m_20186_() + currentVelocity.f_82480_, this.m_20189_() + currentVelocity.f_82481_);
                    this.f_19812_ = true;
                    int n = particleDelay = this.hasGreenBeanBuff() ? 3 : 5;
                    if (!world2.m_5776_() && this.throwTicks > particleDelay) {
                        double offsetMultiplier = 1.5;
                        double spawnX = this.f_19854_ - currentVelocity.f_82479_ * offsetMultiplier;
                        double spawnY = this.f_19855_ + (double)this.m_20206_() / 2.0 - currentVelocity.f_82480_ * offsetMultiplier;
                        double spawnZ = this.f_19856_ - currentVelocity.f_82481_ * offsetMultiplier;
                        ParticleEffectsUtil.spawnParticles(world2, new Vec3(spawnX, spawnY, spawnZ), ParticleTypes.f_123796_, 1, new Vec3(0.1, 0.1, 0.1), 0.0);
                    }
                }
            } else if (this.throwTicks != 0) {
                this.throwTicks = 0;
            }
        }
        if (!this.m_9236_().m_5776_() && this.m_21824_() && !this.isKnockedOut()) {
            boolean canInitiateDrowsiness = this.checkConditionsForInitiatingDrowsiness();
            boolean canSustainSlumber = this.checkConditionsForSustainingSlumber();
            switch (currentPhase) {
                case NONE: {
                    int durationTicks;
                    if (!this.m_21827_() || !canInitiateDrowsiness || this.quiescentSitDurationTimer != 0) break;
                    this.setDozingPhase(DozingPhase.QUIESCENT_SITTING);
                    int minSeconds = (Integer)Configs.AHP.tamedQuiescentSitMinSeconds.get();
                    int maxSeconds = (Integer)Configs.AHP.tamedQuiescentSitMaxSeconds.get();
                    if (minSeconds > maxSeconds) {
                        AdorableHamsterPets.LOGGER.info("Config issue: tamedQuiescentSitMinSeconds ({}) > tamedQuiescentSitMaxSeconds ({}). Swapping.", (Object)minSeconds, (Object)maxSeconds);
                        int temp = minSeconds;
                        minSeconds = maxSeconds;
                        maxSeconds = temp;
                    }
                    if (maxSeconds < minSeconds) {
                        maxSeconds = minSeconds;
                    }
                    this.quiescentSitDurationTimer = durationTicks = this.f_19796_.m_216332_(minSeconds * 20, maxSeconds * 20 + 1);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering QUIESCENT_SITTING for {} ticks.", (Object)this.m_19879_(), (Object)durationTicks);
                    break;
                }
                case QUIESCENT_SITTING: {
                    if (!this.m_21827_() || !canInitiateDrowsiness) {
                        this.resetSleepSequence("Quiescent sitting interrupted: no longer sitting or conditions unfavorable.");
                        break;
                    }
                    if (this.quiescentSitDurationTimer > 0) {
                        --this.quiescentSitDurationTimer;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.DRIFTING_OFF);
                    this.driftingOffTimer = 1800;
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering DRIFTING_OFF for {} ticks.", (Object)this.m_19879_(), (Object)this.driftingOffTimer);
                    break;
                }
                case DRIFTING_OFF: {
                    String settleAnimId;
                    if (!canSustainSlumber) {
                        this.resetSleepSequence("Drifting off interrupted: conditions for slumber no longer met.");
                        break;
                    }
                    if (this.driftingOffTimer > 0) {
                        --this.driftingOffTimer;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.SETTLING_INTO_SLUMBER);
                    int choice = this.f_19796_.m_188503_(3);
                    String deepSleepAnimIdForTracker = switch (choice) {
                        case 0 -> {
                            settleAnimId = "anim_hamster_settle_sleep1";
                            yield "anim_hamster_sleep_pose1";
                        }
                        case 1 -> {
                            settleAnimId = "anim_hamster_settle_sleep2";
                            yield "anim_hamster_sleep_pose2";
                        }
                        default -> {
                            settleAnimId = "anim_hamster_settle_sleep3";
                            yield "anim_hamster_sleep_pose3";
                        }
                    };
                    this.f_19804_.m_135381_(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)deepSleepAnimIdForTracker);
                    this.triggerAnimOnServer("mainController", settleAnimId);
                    this.settleSleepAnimationCooldown = 20;
                    this.triggerSettleEffects(0.22f, 5, 0.24f);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering SETTLING_INTO_SLUMBER, triggering {}, target deep sleep anim ID: {}.", new Object[]{this.m_19879_(), settleAnimId, deepSleepAnimIdForTracker});
                    break;
                }
                case SETTLING_INTO_SLUMBER: {
                    if (!canSustainSlumber) {
                        this.resetSleepSequence("Settling into slumber interrupted: conditions for slumber no longer met.");
                        break;
                    }
                    if (this.settleSleepAnimationCooldown > 0) {
                        --this.settleSleepAnimationCooldown;
                        break;
                    }
                    this.setDozingPhase(DozingPhase.DEEP_SLEEP);
                    AdorableHamsterPets.LOGGER.debug("Hamster {} entering DEEP_SLEEP, playing {}.", (Object)this.m_19879_(), this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID));
                    break;
                }
                case DEEP_SLEEP: {
                    if (canSustainSlumber) break;
                    this.triggerWakeUpFromSleepAnimation(false);
                    this.resetSleepSequence("Deep sleep interrupted: conditions for slumber no longer met.");
                }
            }
        }
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && !ItemStack.m_41728_((ItemStack)(currentArmor = this.getArmorStack()), (ItemStack)this.lastArmorStack)) {
            this.updateArmorModifiers(currentArmor);
            this.lastArmorStack = currentArmor.m_41777_();
        }
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 20 == 0) {
            this.updateNavigation();
            this.updateArmorModifiers(this.getArmorStack());
        }
        if (!this.m_9236_().m_5776_() && this.isSulking() && !this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -1.0, 0.0));
            this.f_19812_ = true;
        }
        if (!(world = this.m_9236_()).m_5776_()) {
            if (this.performDeferredArmorUpdate) {
                this.setArmorStack(ItemStack.f_41583_);
                this.performDeferredArmorUpdate = false;
            }
            if (((Boolean)Configs.AHP.circadianChaos.get()).booleanValue() && this.m_5803_() && this.getLinkedBedPos().isPresent() && this.napInBedDurationTimer == 0 && !this.isRescueSleeping()) {
                this.wakeUpFromBed(false);
            }
            if (!((Boolean)Configs.AHP.circadianChaos.get()).booleanValue() && this.m_5803_() && this.getLinkedBedPos().isPresent() && !this.isRescueSleeping()) {
                boolean isSleepTime;
                boolean bl = isSleepTime = (Boolean)Configs.AHP.sleepDuringDay.get() != false ? world.m_46461_() : world.m_46462_();
                if (!isSleepTime) {
                    if (this.wakeUpFromBedDelay == 0 && this.goToBedCooldown == 0) {
                        this.wakeUpFromBedDelay = this.f_19796_.m_216332_(5, 60);
                    }
                } else {
                    this.wakeUpFromBedDelay = 0;
                }
            }
            if (this.wakeUpFromBedDelay == 1) {
                this.wakeUpFromBed(false);
            }
            HamsterPlacementUtil.trySuffocationRescue(this);
            if (this.ejectionCheckCooldown <= 0) {
                this.ejectionCheckCooldown = 100;
                boolean inventoryChanged = false;
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.m_41619_() || this.m_7013_(i, stack)) continue;
                    AdorableHamsterPets.LOGGER.warn("[HamsterTick {}] Ejecting invalid item {} from slot {}.", new Object[]{this.m_19879_(), stack.m_41720_(), i});
                    Containers.m_18992_((Level)world, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)stack.m_41777_());
                    this.items.set(i, (Object)ItemStack.f_41583_);
                    inventoryChanged = true;
                }
                if (inventoryChanged) {
                    this.m_6596_();
                }
            }
            if (this.m_21824_() && this.m_21223_() < this.m_21233_() && !this.isAutoEating() && !this.isConsideringAutoEat() && this.autoEatCooldownTicks == 0 && !this.isThrown() && !this.isKnockedOut()) {
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.m_41619_() || !ConfigDataCache.isAutoHealFood(stack)) continue;
                    this.setHamsterFlag(1024, true);
                    this.preAutoEatDelayTicks = 40;
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Eligible to auto-eat. Starting 2s pre-eat delay.", (Object)this.m_19879_());
                    break;
                }
            }
            if (this.isConsideringAutoEat() && this.preAutoEatDelayTicks == 0) {
                this.setHamsterFlag(1024, false);
                boolean foodStillAvailable = false;
                ItemStack foodToEat = ItemStack.f_41583_;
                int foodSlot = -1;
                for (int i = 0; i < this.items.size(); ++i) {
                    ItemStack stack = (ItemStack)this.items.get(i);
                    if (stack.m_41619_() || !ConfigDataCache.isAutoHealFood(stack)) continue;
                    foodStillAvailable = true;
                    foodToEat = stack;
                    foodSlot = i;
                    break;
                }
                if (foodStillAvailable) {
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Pre-eat delay finished. Starting auto-eat on {} from slot {}", new Object[]{this.m_19879_(), foodToEat.m_41720_(), foodSlot});
                    this.isAutoEating = true;
                    this.autoEatProgressTicks = 60;
                    this.m_5496_(SoundEvents.f_11912_, 0.7f, 1.3f);
                    ParticleEffectsUtil.spawnParticles(world, new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20206_() / 2.0, this.m_20189_()), new ItemParticleOption(ParticleTypes.f_123752_, foodToEat.m_41620_(1)), 5, new Vec3(0.1, 0.1, 0.1), 0.02);
                    if (foodToEat.m_41619_()) {
                        this.items.set(foodSlot, (Object)ItemStack.f_41583_);
                    }
                    this.updateCheekTrackers();
                } else {
                    AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Pre-eat delay finished, but food no longer available.", (Object)this.m_19879_());
                }
            }
            if (this.isAutoEating() && this.autoEatProgressTicks == 0) {
                this.m_5634_(((Float)Configs.AHP.hamsterFoodMixHealing.get()).floatValue());
                this.autoEatCooldownTicks = 60;
                this.isAutoEating = false;
                AdorableHamsterPets.LOGGER.trace("[HamsterTick {}] Auto-eat finished. Healed. Cooldown set to 60.", (Object)this.m_19879_());
                LivingEntity livingEntity = this.m_269323_();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
                    ModCriteria.HAMSTER_AUTO_FED.trigger(serverPlayerOwner, this);
                }
            }
            if (!this.m_9236_().m_5776_() && this.isCelebratingDiamond()) {
                SoundEvent sparkleSound;
                if (this.diamondSparkleSoundDelayTicks == 1 && (sparkleSound = ModSounds.getRandomSoundFrom(ModSounds.DIAMOND_SPARKLE_SOUNDS, this.f_19796_)) != null) {
                    if (this.currentOreTarget != null) {
                        this.m_9236_().m_5594_(null, this.currentOreTarget, sparkleSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        this.m_9236_().m_5594_(null, this.m_20183_(), sparkleSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
                    }
                }
                if (this.celebrationParticleTicks > 0) {
                    ParticleEffectsUtil.spawnParticlesWithOffset((Entity)this, ParticleTypes.f_123749_, 2, 0.12, 0.25, 0.12, 0.15, 1.8);
                    if (this.currentOreTarget != null && this.f_19796_.m_188503_(4) == 0) {
                        BlockPos particlePos = this.currentOreTarget.m_7494_();
                        ParticleEffectsUtil.spawnParticles(this.m_9236_(), Vec3.m_82512_((Vec3i)particlePos), ParticleTypes.f_123815_, 1, new Vec3(0.2, 0.35, 0.2), 0.003);
                    }
                }
                if (this.diamondCelebrationSoundTicks <= 0) {
                    SoundEvent celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BEG_SOUNDS, this.f_19796_);
                    if (celebrationSound != null) {
                        this.m_9236_().m_5594_(null, this.m_20183_(), celebrationSound, SoundSource.NEUTRAL, 0.8f, this.m_6100_());
                    }
                    this.diamondCelebrationSoundTicks = 30;
                }
            }
            if (this.isSulking()) {
                if (this.sulkOrchestraHitDelayTicks == 1) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.ALARM_ORCHESTRA_HIT.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                if (this.sulkShockedSoundDelayTicks == 1) {
                    this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.HAMSTER_SHOCKED.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                if (this.sulkFailParticleTicks > 0 && this.currentOreTarget != null && this.f_19796_.m_188503_(3) == 0) {
                    BlockPos particlePos = this.currentOreTarget.m_7494_();
                    ParticleEffectsUtil.spawnParticles(this.m_9236_(), Vec3.m_82512_((Vec3i)particlePos), ParticleTypes.f_123762_, 2, new Vec3(0.3, 0.3, 0.3), 0.005);
                }
                if (this.sulkEntityEffectTicks > 0 && this.f_19796_.m_188503_(5) == 0) {
                    ParticleOptions darkGrayEffect = ParticleEffectsUtil.createColoredEffect(0.3f, 0.3f, 0.3f);
                    ParticleEffectsUtil.spawnParticlesOnEntity((Entity)this, darkGrayEffect, 1, 0.6, 0.5, 0.005, 0.1);
                }
            }
        }
        if (world.f_46443_ && this.hasGreenBeanBuff() && this.f_19796_.m_188503_(2) == 0) {
            ParticleEffectsUtil.spawnMotionTrail((Entity)this, ParticleTypes.f_123796_, 3, 1.4, 0.025, 1.7, 0.17);
        }
        if (this.isTauntingWithItem() && this.f_19796_.m_188503_(7) == 0) {
            ParticleEffectsUtil.spawnParticlesOnEntity((Entity)this, ParticleTypes.f_123751_, 2, 1.2, 0.5, 0.5, 0.2);
        }
        if (world.f_46443_) {
            this.prevClientFallPitchProgress = this.clientFallPitchProgress;
            this.clientFallPitchProgress = this.shouldRenderFlying() && !this.isThrown() ? (this.clientFallPitchProgress += 0.06666667f) : (this.clientFallPitchProgress -= 0.33333334f);
            this.clientFallPitchProgress = Mth.m_14036_((float)this.clientFallPitchProgress, (float)0.0f, (float)1.0f);
        }
        if (this.isRefusingFood() && this.refuseTimer > 0 && --this.refuseTimer <= 0) {
            this.setRefusingFood(false);
        }
        if (this.tamingCooldown > 0) {
            --this.tamingCooldown;
        }
        if (this.customLoveTimer > 0) {
            --this.customLoveTimer;
        }
        if (this.customLoveTimer <= 0 && this.m_27593_()) {
            this.setInLove(false);
        }
    }

    public void m_6667_(DamageSource source) {
        boolean respawnSuccessful;
        if (!this.m_9236_().m_5776_() && ((Boolean)Configs.AHP.enableRespawnInBed.get()).booleanValue() && (respawnSuccessful = this.tryRespawnInBed())) {
            this.m_146870_();
            return;
        }
        Level world = this.m_9236_();
        if (!world.m_5776_()) {
            if (!this.m_21824_() && Configs.AHP.disableWildLootDrops) {
                this.items.clear();
            }
            for (ItemStack stack : this.items) {
                if (stack.m_41619_()) continue;
                Containers.m_18992_((Level)world, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)stack);
            }
            this.items.clear();
            this.updateCheekTrackers();
        }
        super.m_6667_(source);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "mainController", 3, event -> {
            DozingPhase currentDozingPhase = this.getDozingPhase();
            int personality = (Integer)this.f_19804_.m_135370_(ANIMATION_PERSONALITY_ID);
            if (this.isShoulderPet()) {
                ShoulderAnimationState shoulderState = ShoulderAnimationState.values()[(Integer)this.f_19804_.m_135370_(SHOULDER_ANIMATION_STATE)];
                return switch (shoulderState) {
                    case ShoulderAnimationState.SITTING -> {
                        if (this.getHamsterFlag(8192)) {
                            yield event.setAndContinue(CLEANING_ANIM);
                        }
                        RawAnimation v1 = switch (personality) {
                            case 2 -> SITTING_POSE2_ANIM;
                            case 3 -> SITTING_POSE3_ANIM;
                            default -> SITTING_POSE1_ANIM;
                        };
                        yield event.setAndContinue(v1);
                    }
                    case ShoulderAnimationState.LAYING_DOWN -> {
                        switch (this.shoulderLocation) {
                            case LEFT_SHOULDER: {
                                yield event.setAndContinue(LAYING_DOWN_LEFT_SHOULDER_ANIM);
                            }
                            case HEAD: {
                                yield event.setAndContinue(LAYING_DOWN_HEAD_ANIM);
                            }
                        }
                        yield event.setAndContinue(LAYING_DOWN_RIGHT_SHOULDER_ANIM);
                    }
                    default -> event.setAndContinue(personality % 2 == 0 ? IDLE2_ANIM : IDLE1_ANIM);
                };
            }
            if (this.isKnockedOut()) {
                return event.setAndContinue(KNOCKED_OUT_ANIM);
            }
            if (this.isSulking()) {
                return event.setAndContinue(SULKING_ANIM);
            }
            if (this.shouldRenderFlying()) {
                return event.setAndContinue(FLYING_ANIM);
            }
            if (this.isTauntingWithItem()) {
                return event.setAndContinue(TAUNT_WITH_ITEM_ANIM);
            }
            if (this.isPresentingItem()) {
                return event.setAndContinue(PRESENTING_ITEM_ANIM);
            }
            boolean isSeekingGoalActive = false;
            String activeGoalName = this.getActiveCustomGoalDebugName();
            if (activeGoalName.startsWith(HamsterSniffForOreGoal.class.getSimpleName())) {
                isSeekingGoalActive = true;
            }
            if (isSeekingGoalActive) {
                double horizontalSpeedSquared = this.m_20184_().m_165925_();
                if (horizontalSpeedSquared > 1.0E-6) {
                    return event.setAndContinue(SEEKING_ORE_ANIM);
                }
                return event.setAndContinue(WANTS_TO_SEEK_ORE_ANIM);
            }
            if (this.isCelebratingDiamond()) {
                return event.setAndContinue(BEGGING_ANIM);
            }
            if (this.m_21824_()) {
                switch (currentDozingPhase) {
                    case DRIFTING_OFF: {
                        return event.setAndContinue(switch (personality) {
                            case 2 -> DRIFTING_OFF_POSE2_ANIM;
                            case 3 -> DRIFTING_OFF_POSE3_ANIM;
                            default -> DRIFTING_OFF_POSE1_ANIM;
                        });
                    }
                    case SETTLING_INTO_SLUMBER: {
                        String targetDeepSleepId = (String)this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID);
                        if (!targetDeepSleepId.isEmpty()) {
                            RawAnimation targetDeepSleepAnim = switch (targetDeepSleepId) {
                                case "anim_hamster_sleep_pose1" -> SLEEP_POSE1_ANIM;
                                case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                                case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                                default -> SITTING_POSE1_ANIM;
                            };
                            return event.setAndContinue(targetDeepSleepAnim);
                        }
                        if (!this.m_21827_()) break;
                        return event.setAndContinue(switch (personality) {
                            case 2 -> SITTING_POSE2_ANIM;
                            case 3 -> SITTING_POSE3_ANIM;
                            default -> SITTING_POSE1_ANIM;
                        });
                    }
                    case DEEP_SLEEP: {
                        String deepSleepId;
                        RawAnimation deepSleepAnimToPlay = switch (deepSleepId = (String)this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID)) {
                            case "anim_hamster_sleep_pose1" -> SLEEP_POSE1_ANIM;
                            case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                            case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                            default -> {
                                switch (personality) {
                                    case 2: {
                                        yield SITTING_POSE2_ANIM;
                                    }
                                    case 3: {
                                        yield SITTING_POSE3_ANIM;
                                    }
                                }
                                yield SITTING_POSE1_ANIM;
                            }
                        };
                        return event.setAndContinue(deepSleepAnimToPlay);
                    }
                }
            }
            if (!this.m_21824_() && this.m_5803_()) {
                String deepSleepId;
                RawAnimation deepSleepAnimToPlay = switch (deepSleepId = (String)this.f_19804_.m_135370_(CURRENT_DEEP_SLEEP_ANIM_ID)) {
                    case "anim_hamster_sleep_pose2" -> SLEEP_POSE2_ANIM;
                    case "anim_hamster_sleep_pose3" -> SLEEP_POSE3_ANIM;
                    default -> SLEEP_POSE1_ANIM;
                };
                return event.setAndContinue(deepSleepAnimToPlay);
            }
            if (this.m_21827_() && !this.isKnockedOut()) {
                if (this.getHamsterFlag(8192)) {
                    return event.setAndContinue(CLEANING_ANIM);
                }
                return event.setAndContinue(switch (personality) {
                    case 2 -> SITTING_POSE2_ANIM;
                    case 3 -> SITTING_POSE3_ANIM;
                    default -> SITTING_POSE1_ANIM;
                });
            }
            double horizontalSpeedSquared = this.m_20184_().m_165925_();
            if (horizontalSpeedSquared > 1.0E-6) {
                if (horizontalSpeedSquared > 0.008) {
                    return event.setAndContinue(SPRINTING_ANIM);
                }
                if (horizontalSpeedSquared > 0.002) {
                    return event.setAndContinue(RUNNING_ANIM);
                }
                return event.setAndContinue(WALKING_ANIM);
            }
            if (this.isBegging()) {
                return event.setAndContinue(BEGGING_ANIM);
            }
            if (activeGoalName.equals(HamsterLookAtEntityGoal.class.getSimpleName())) {
                return switch ((Integer)this.f_19804_.m_135370_(CURRENT_LOOK_UP_ANIM_ID)) {
                    case 2 -> event.setAndContinue(IDLE_LOOKING_UP2_ANIM);
                    case 3 -> event.setAndContinue(IDLE_LOOKING_UP3_ANIM);
                    default -> event.setAndContinue(IDLE_LOOKING_UP1_ANIM);
                };
            }
            RawAnimation current = event.getController().getCurrentRawAnimation();
            if (current != null && (current.equals((Object)IDLE1_ANIM) || current.equals((Object)IDLE2_ANIM))) {
                return event.setAndContinue(current);
            }
            return event.setAndContinue(this.f_19796_.m_188499_() ? IDLE1_ANIM : IDLE2_ANIM);
        }).triggerableAnim("crash", CRASH_ANIM).triggerableAnim("wakeup_from_ko", WAKE_UP_FROM_KO_ANIM).triggerableAnim("standing_headshake", STANDING_HEADSHAKE_ANIM).triggerableAnim("sitting_headshake", SITTING_HEADSHAKE_ANIM).triggerableAnim("moving_headshake", MOVING_HEADSHAKE_ANIM).triggerableAnim("attack", ATTACK_ANIM).triggerableAnim("sit1", SIT1_ANIM).triggerableAnim("sit2", SIT2_ANIM).triggerableAnim("sit3", SIT3_ANIM).triggerableAnim("standup1", STANDUP1_ANIM).triggerableAnim("standup2", STANDUP2_ANIM).triggerableAnim("standup3", STANDUP3_ANIM).triggerableAnim("wakeup1", WAKE_UP_1_ANIM).triggerableAnim("wakeup2", WAKE_UP_2_ANIM).triggerableAnim("wakeup3", WAKE_UP_3_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep1", SIT_SETTLE_SLEEP1_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep2", SIT_SETTLE_SLEEP2_ANIM).triggerableAnim("anim_hamster_sit_settle_sleep3", SIT_SETTLE_SLEEP3_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep1", STAND_SETTLE_SLEEP1_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep2", STAND_SETTLE_SLEEP2_ANIM).triggerableAnim("anim_hamster_stand_settle_sleep3", STAND_SETTLE_SLEEP3_ANIM).triggerableAnim("anim_hamster_sulk", SULK_ANIM).triggerableAnim("anim_hamster_pounce_on_item", POUNCE_ON_ITEM_ANIM).triggerableAnim("anim_hamster_celebrate_chase", CELEBRATE_CHASE_ANIM).setParticleKeyframeHandler(event -> {
            this.particleEffectId = event.getKeyframeData().getEffect();
        }).setSoundKeyframeHandler(event -> {
            this.soundEffectId = event.getKeyframeData().getSound();
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void triggerAnimOnServer(String controllerName, String animName) {
        if (!this.m_9236_().m_5776_()) {
            this.triggerAnim(controllerName, animName);
            AdorableHamsterPets.LOGGER.trace("[HamsterEntity {}] Triggered server-side animation: Controller='{}', Anim='{}'", new Object[]{this.m_19879_(), controllerName, animName});
            this.animScheduler.scheduleAnimationStop(this.m_9236_().m_46467_(), controllerName, animName, this);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAMSTER_FLAGS, (Object)0);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(PINK_PETAL_TYPE, (Object)0);
        this.f_19804_.m_135372_(DOZING_PHASE, (Object)DozingPhase.NONE.ordinal());
        this.f_19804_.m_135372_(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)"");
        this.f_19804_.m_135372_(ACTIVE_CUSTOM_GOAL_NAME_DEBUG, (Object)"None");
        this.f_19804_.m_135372_(ANIMATION_PERSONALITY_ID, (Object)1);
        this.f_19804_.m_135372_(ITEM_INTEREST_TIMER, (Object)0);
        this.f_19804_.m_135372_(INTEREST_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(GREEN_BEAN_BUFF_DURATION, (Object)0L);
        this.f_19804_.m_135372_(CURRENT_LOOK_UP_ANIM_ID, (Object)1);
        this.f_19804_.m_135372_(SHOULDER_ANIMATION_STATE, (Object)ShoulderAnimationState.STANDING.ordinal());
        this.f_19804_.m_135372_(TRACKED_ACCESSORY_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(TRACKED_ARMOR_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(FALL_IMMUNITY_ACTIVE, (Object)true);
    }

    protected void m_8099_() {
        AdorableHamsterPets.LOGGER.trace("[AI Init {} Tick {}] Initializing goals. Current State: isSleeping={}, isSittingPose={}", new Object[]{this.m_19879_(), this.m_9236_().f_46443_ ? "ClientTick?" : Long.valueOf(this.m_9236_().m_46467_()), this.m_5803_(), this.m_21825_()});
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new HamsterSniffForOreGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new HamsterPlayWithItemGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new HamsterGoToBedAndSleepGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new HamsterMeleeAttackGoal(this, 1.5, true));
        this.f_21345_.m_25352_(3, (Goal)new HamsterMateGoal(this, 0.75));
        this.f_21345_.m_25352_(4, (Goal)new HamsterFollowOwnerGoal(this, 1.0, 4.0f, 16.0f));
        this.f_21345_.m_25352_(5, new HamsterFleeGoal<LivingEntity>(this, LivingEntity.class, 8.0f, 0.75, 1.5));
        this.f_21345_.m_25352_(6, (Goal)new HamsterTemptGoal(this, 1.0, false));
        this.f_21345_.m_25352_(7, (Goal)new HamsterSitGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new HamsterSleepGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new HamsterWanderAroundFarGoal(this, 0.75));
        this.f_21345_.m_25352_(10, (Goal)new HamsterLookAtEntityGoal((Mob)this, Player.class, 2.0f, 0.15f));
        this.f_21345_.m_25352_(11, (Goal)new HamsterLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        AdorableHamsterPets.LOGGER.trace("[AI Init {} Tick {}] Finished initializing goals.", (Object)this.m_19879_(), this.m_9236_().f_46443_ ? "ClientTick?" : Long.valueOf(this.m_9236_().m_46467_()));
    }

    protected PathNavigation m_6037_(Level world) {
        if (Configs.AHP.avoidUnlinkedBeds) {
            return new HamsterNavigation(this, world);
        }
        return new GroundPathNavigation((Mob)this, world);
    }

    public void m_6710_(@Nullable LivingEntity target) {
        if (target == null) {
            super.m_6710_(null);
            return;
        }
        if (this.m_21824_() && this.m_269323_() != null) {
            TraceableEntity ownableFallback;
            Entity fallbackOwnerEntity;
            LivingEntity owner = this.m_269323_();
            UUID ownerUuid = owner.m_20148_();
            boolean preventTargeting = false;
            if (target instanceof TamableAnimal) {
                TamableAnimal tameablePet = (TamableAnimal)target;
                UUID petOwnerUuid = tameablePet.m_21805_();
                if (petOwnerUuid != null && petOwnerUuid.equals(ownerUuid) && tameablePet != this) {
                    preventTargeting = true;
                }
            } else if (target instanceof AbstractHorse) {
                AbstractHorse horsePet = (AbstractHorse)target;
                LivingEntity horseOwnerEntity = horsePet.m_269323_();
                if (horseOwnerEntity != null && horseOwnerEntity.m_20148_().equals(ownerUuid)) {
                    preventTargeting = true;
                }
            } else if (target instanceof TraceableEntity && (fallbackOwnerEntity = (ownableFallback = (TraceableEntity)target).m_19749_()) != null && fallbackOwnerEntity.m_20148_().equals(ownerUuid) && ownableFallback != this) {
                preventTargeting = true;
            }
            if (preventTargeting) {
                super.m_6710_(null);
                return;
            }
        }
        super.m_6710_(target);
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction positionUpdater) {
        if (this.m_20363_(passenger)) {
            double d;
            float currentScale = this.getScale();
            double baseY = (double)this.m_20206_() * 0.85;
            if (passenger instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)passenger;
                d = HamsterSeatOffsets.physicsSeatAdjustY(living, currentScale);
            } else {
                d = 0.0;
            }
            double riderAdjustY = d;
            positionUpdater.m_20372_(passenger, this.m_20185_(), this.m_20186_() + baseY + riderAdjustY, this.m_20189_());
        }
    }

    public float getScale() {
        return this.m_20206_() / 0.5f;
    }

    public void startBedSleepEffects() {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.getLinkedBedPos().ifPresent(globalPos -> {
            if (this.m_9236_().m_46472_() == globalPos.m_122640_()) {
                BlockPos bedPos = globalPos.m_122646_();
                BlockState bedState = this.m_9236_().m_8055_(bedPos);
                ParticleEffectsUtil.spawnParticles(this.m_9236_(), Vec3.m_82539_((Vec3i)bedPos).m_82520_(0.0, 0.3, 0.0), ModParticles.getForVariant((WoodVariant)((Object)((Object)bedState.m_61143_(HamsterBedBlock.WOOD_VARIANT)))), 70, new Vec3(0.2, 0.5, 0.2), 1.0);
            }
        });
        this.bedLeafParticleTicks = 4;
        SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, this.f_19796_);
        if (rustleSound != null) {
            this.m_9236_().m_5594_(null, this.m_20183_(), rustleSound, SoundSource.NEUTRAL, 0.5f, 1.0f);
        }
        this.m_9236_().m_5594_(null, this.m_20183_(), (SoundEvent)ModSounds.HAMSTER_THUMP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        LivingEntity livingEntity = this.m_269323_();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayerOwner = (ServerPlayer)livingEntity;
            ModCriteria.HAMSTER_SLEPT_IN_BED.trigger(serverPlayerOwner);
        }
    }

    protected SoundEvent m_7515_() {
        if (this.isKnockedOut()) {
            return null;
        }
        if (this.isBegging() || this.isTauntingWithItem()) {
            return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BEG_SOUNDS, this.f_19796_);
        }
        boolean playSleepSounds = false;
        if (this.m_21824_()) {
            DozingPhase phase = this.getDozingPhase();
            if (phase == DozingPhase.DRIFTING_OFF || phase == DozingPhase.SETTLING_INTO_SLUMBER || phase == DozingPhase.DEEP_SLEEP) {
                playSleepSounds = true;
            }
        } else if (this.m_5803_()) {
            playSleepSounds = true;
        }
        if (playSleepSounds) {
            return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_SLEEP_SOUNDS, this.f_19796_);
        }
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_IDLE_SOUNDS, this.f_19796_);
    }

    public void m_8032_() {
        SoundEvent soundEvent = this.m_7515_();
        if (soundEvent != null && Arrays.asList(ModSounds.HAMSTER_BEG_SOUNDS).contains(soundEvent)) {
            this.m_5496_(soundEvent, 0.8f, this.m_6100_());
        } else {
            super.m_8032_();
        }
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_HURT_SOUNDS, this.f_19796_);
    }

    protected SoundEvent m_5592_() {
        return ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DEATH_SOUNDS, this.f_19796_);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        if (!HamsterRenderTracker.isBeingRendered(this.m_19879_())) {
            try {
                SoundType group = state.m_60827_();
                float volume = state.m_60713_(Blocks.f_49994_) ? 0.060000002f : 0.1f;
                this.m_5496_(group.m_56776_(), volume, group.m_56774_() * 1.5f);
            }
            catch (Exception ex) {
                AdorableHamsterPets.LOGGER.warn("Error playing fallback step sound", (Throwable)ex);
            }
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (entity instanceof ArmorStand) {
            return !entity.m_5833_();
        }
        if (!entity.m_5833_() && entity.m_6084_() && entity.m_6087_()) {
            LivingEntity owner = this.m_269323_();
            return entity != this && (owner == null || !owner.m_20365_(entity));
        }
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag nbt) {
        AdorableHamsterPets.LOGGER.debug("[AHP Spawn Debug] HamsterEntity.initialize called. SpawnReason: {}", (Object)spawnReason);
        if (!world.m_5776_()) {
            int personalityId = this.f_19796_.m_216332_(1, 3);
            this.f_19804_.m_135381_(ANIMATION_PERSONALITY_ID, (Object)personalityId);
            AdorableHamsterPets.LOGGER.trace("[INITIALIZE] Hamster ID {}: Assigned Personality ID {}", (Object)this.m_19879_(), (Object)personalityId);
        }
        if (spawnReason == MobSpawnType.NATURAL || spawnReason == MobSpawnType.SPAWN_EGG || spawnReason == MobSpawnType.CHUNK_GENERATION) {
            Holder biomeEntry = world.m_204166_(this.m_20183_());
            String biomeKeyStr = biomeEntry.m_203543_().map(key -> key.m_135782_().toString()).orElse("UNKNOWN");
            AdorableHamsterPets.LOGGER.trace("[HamsterInit] SpawnReason: {}, BiomeKey: {}", (Object)spawnReason, (Object)biomeKeyStr);
            HamsterVariant chosenVariant = HamsterEntity.determineVariantForBiome((Holder<Biome>)biomeEntry, this.f_19796_);
            this.setVariant(chosenVariant.getId());
            AdorableHamsterPets.LOGGER.trace("[HamsterInit] Assigned variant: {}", (Object)chosenVariant.name());
        } else {
            int randomVariantId = this.f_19796_.m_188503_(HamsterVariant.values().length);
            this.setVariant(randomVariantId);
            AdorableHamsterPets.LOGGER.trace("[HamsterInit] SpawnReason: {}, Assigned random variant: {}", (Object)spawnReason, (Object)HamsterVariant.byId(randomVariantId).name());
        }
        if (!this.m_21824_()) {
            this.m_21051_(Attributes.f_22276_).m_22100_(((Double)Configs.AHP.wildMaxHealth.get()).doubleValue());
            this.m_21153_(this.m_21233_());
        }
        this.generateWildLoot();
        return super.m_6518_(world, difficulty, spawnReason, entityData, nbt);
    }

    protected BodyRotationControl m_7560_() {
        return new HamsterBodyControl((Mob)this);
    }

    private boolean shouldArmorAbsorb(DamageSource source, ItemStack armorStack) {
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            return this.getFireProtectionLevel(armorStack) > 0;
        }
        return true;
    }

    private int getFireProtectionLevel(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44966_, (ItemStack)stack);
    }

    private boolean tryRespawnInBed() {
        HamsterEntity newHamster;
        HamsterBedBlockEntity bedEntity;
        if (this.getLinkedBedPos().isEmpty()) {
            return false;
        }
        GlobalPos globalBedPos = this.getLinkedBedPos().get();
        MinecraftServer server = this.m_20194_();
        if (server == null) {
            return false;
        }
        ServerLevel bedWorld = server.m_129880_(globalBedPos.m_122640_());
        if (bedWorld == null) {
            return false;
        }
        BlockPos bedPos = globalBedPos.m_122646_();
        BlockState bedState = bedWorld.m_8055_(bedPos);
        if (!(bedState.m_60734_() instanceof HamsterBedBlock)) {
            return false;
        }
        BlockEntity beCheck = bedWorld.m_7702_(bedPos);
        if (!(beCheck instanceof HamsterBedBlockEntity) || !(bedEntity = (HamsterBedBlockEntity)beCheck).isRespawnEnabled()) {
            return false;
        }
        boolean isBedFree = (Boolean)bedState.m_61143_((Property)HamsterBedBlock.OCCUPIED) == false;
        BlockPos finalSpawnPos = null;
        if (!isBedFree) {
            Optional<BlockPos> safePosOpt = HamsterPlacementUtil.findSafeSpawnPosition(bedPos, (Level)bedWorld, 2, this);
            if (safePosOpt.isEmpty()) {
                return false;
            }
            finalSpawnPos = safePosOpt.get();
        }
        if ((newHamster = (HamsterEntity)((EntityType)ModEntities.HAMSTER.get()).m_20615_((Level)bedWorld)) == null) {
            return false;
        }
        CompoundTag data = new CompoundTag();
        this.m_7380_(data);
        newHamster.m_7378_(data);
        newHamster.m_21816_(this.m_21805_());
        newHamster.setTamed(this.m_21824_(), false);
        newHamster.m_6593_(this.m_7770_());
        newHamster.setKnockedOut(false);
        newHamster.interactionCooldown = 0;
        if (isBedFree) {
            Vec3 bedCenter = Vec3.m_82512_((Vec3i)bedPos).m_82520_(0.0, 0.1, 0.0);
            newHamster.m_7678_(bedCenter.f_82479_, bedCenter.f_82480_, bedCenter.f_82481_, 0.0f, 0.0f);
            newHamster.m_21153_(Math.max(1.0f, newHamster.m_21233_() * 0.05f));
            newHamster.setDozingPhase(DozingPhase.DEEP_SLEEP);
            newHamster.setSleeping(true);
            newHamster.m_21837_(true);
            int personality = (Integer)newHamster.m_20088_().m_135370_(ANIMATION_PERSONALITY_ID);
            int poseIndex = personality >= 1 && personality <= 3 ? personality : 1;
            String sleepAnim = "anim_hamster_sleep_pose" + poseIndex;
            newHamster.m_20088_().m_135381_(CURRENT_DEEP_SLEEP_ANIM_ID, (Object)sleepAnim);
            bedWorld.m_7731_(bedPos, (BlockState)bedState.m_61124_((Property)HamsterBedBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)), 3);
            bedEntity.triggerAnim("hamster_bed_controller", "anim_bed_becoming_occupied");
        } else {
            newHamster.m_7678_((double)finalSpawnPos.m_123341_() + 0.5, finalSpawnPos.m_123342_(), (double)finalSpawnPos.m_123343_() + 0.5, this.m_146908_(), 0.0f);
            newHamster.m_21153_(newHamster.m_21233_());
            newHamster.m_21839_(false);
        }
        BlockEntity personality = bedWorld.m_7702_(bedPos);
        if (personality instanceof HamsterBedBlockEntity) {
            HamsterBedBlockEntity finalBedEntity = (HamsterBedBlockEntity)personality;
            Component name = newHamster.m_8077_() ? newHamster.m_7770_() : newHamster.m_5446_();
            finalBedEntity.setLinkedHamster(newHamster.m_20148_(), name, finalBedEntity.getWanderDistance());
            finalBedEntity.setRespawnEnabled(false);
        }
        bedWorld.m_7967_((Entity)newHamster);
        bedWorld.m_5594_(null, bedPos, SoundEvents.f_276532_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        ParticleEffectsUtil.spawnParticles((Level)bedWorld, Vec3.m_82512_((Vec3i)bedPos), ParticleTypes.f_123789_, 20, new Vec3(0.3, 0.3, 0.3), 0.1);
        LivingEntity livingEntity = this.m_269323_();
        if (livingEntity instanceof Player) {
            Player owner = (Player)livingEntity;
            owner.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.respawn.success").m_130940_(ChatFormatting.GOLD), true);
        }
        return true;
    }

    protected void m_20351_(Entity passenger) {
        LivingEntity controller = this.m_6688_();
        super.m_20351_(passenger);
        if (passenger == controller) {
            this.riderJumpCooldown = 0;
            this.riderJumpHeld = false;
            this.riderSprintHeld = false;
            this.riderJumpQueued = false;
            this.m_6858_(false);
        }
    }

    private void tryRiderJump() {
        Player p;
        if (!this.m_20096_()) {
            return;
        }
        if (this.m_20069_() || this.m_20077_()) {
            return;
        }
        this.m_6135_();
        Vec3 v = this.m_20184_();
        this.m_20334_(v.f_82479_, 0.6, v.f_82481_);
        this.f_19812_ = true;
        this.f_19789_ = 0.0f;
        LivingEntity livingEntity = this.m_6688_();
        Player rider = livingEntity instanceof Player ? (p = (Player)livingEntity) : null;
        float randomPitch = 1.2f + (this.f_19796_.m_188501_() * 0.4f - 0.2f);
        this.m_9236_().m_6263_(rider, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.HAMSTER_BOUNCE.get(), SoundSource.PLAYERS, 0.6f, randomPitch);
        this.riderJumpCooldown = 8;
    }

    private boolean hasInventoryData(CompoundTag nbt) {
        return nbt.m_128425_("Inventory", 10);
    }

    private void generateWildLoot() {
        if (this.m_21824_() || !((ItemStack)this.items.get(0)).m_41619_()) {
            return;
        }
        float globalChance = ((Float)Configs.AHP_WORLDGEN.globalCheekLootChance.get()).floatValue();
        if (this.f_19796_.m_188501_() > globalChance) {
            return;
        }
        boolean fillBothCheeks = this.f_19796_.m_188501_() < 0.4f;
        BiConsumer<Integer, Integer> fillCheek = (startSlot, mode) -> {
            ItemStack stack;
            Item item;
            int count = 1 + this.f_19796_.m_188503_(3);
            int specificSlot = startSlot + this.f_19796_.m_188503_(3);
            switch (mode) {
                case 1: {
                    Item item2 = ConfigDataCache.getRandomCustomLootItem(this.f_19796_);
                    break;
                }
                case 2: {
                    Item item2 = ConfigDataCache.getRandomCaveLootItem(this.f_19796_);
                    break;
                }
                default: {
                    Item item2 = item = ConfigDataCache.getRandomDefaultLootItem(this.f_19796_);
                }
            }
            if (item != Items.f_41852_ && !this.isItemDisallowed(stack = new ItemStack((ItemLike)item, count)) && ((ItemStack)this.items.get(specificSlot)).m_41619_()) {
                this.m_6836_(specificSlot, stack);
            }
        };
        boolean isCaveHamster = false;
        if (!this.m_9236_().m_5776_()) {
            boolean isDeepAndDark;
            Holder biomeEntry = this.m_9236_().m_204166_(this.m_20183_());
            boolean isCaveBiome = biomeEntry.m_203656_(ModBiomeTags.IS_CAVE);
            boolean bl = isDeepAndDark = this.m_20186_() < 50.0 && !this.m_9236_().m_45527_(this.m_20183_());
            if (isCaveBiome || isDeepAndDark) {
                isCaveHamster = true;
            }
        }
        if (isCaveHamster) {
            float caveChance = ((Float)Configs.AHP_WORLDGEN.caveCheekLootChance.get()).floatValue();
            if (this.f_19796_.m_188501_() < caveChance) {
                if (fillBothCheeks) {
                    fillCheek.accept(0, 2);
                    fillCheek.accept(3, 2);
                } else {
                    fillCheek.accept(this.f_19796_.m_188499_() ? 0 : 3, 2);
                }
                return;
            }
        }
        float defaultChance = ((Float)Configs.AHP_WORLDGEN.defaultCheekLootChance.get()).floatValue();
        if (this.f_19796_.m_188501_() < defaultChance) {
            if (fillBothCheeks) {
                fillCheek.accept(0, 0);
                fillCheek.accept(3, 0);
            } else {
                fillCheek.accept(this.f_19796_.m_188499_() ? 0 : 3, 0);
            }
        }
        float customChance = ((Float)Configs.AHP_WORLDGEN.extraCheekLootChance.get()).floatValue();
        if (!Configs.AHP_WORLDGEN.extraCheekLootList.isEmpty() && this.f_19796_.m_188501_() < customChance) {
            if (fillBothCheeks) {
                fillCheek.accept(0, 1);
                fillCheek.accept(3, 1);
            } else {
                fillCheek.accept(this.f_19796_.m_188499_() ? 0 : 3, 1);
            }
        }
    }

    public void triggerLeafPopEffects(BlockPos pos, boolean playBreakSound) {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_5594_(null, pos, SoundEvents.f_144073_, SoundSource.NEUTRAL, 0.7f, 1.2f);
            SoundEvent rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, this.f_19796_);
            if (rustleSound != null) {
                this.m_9236_().m_5594_(null, pos, rustleSound, SoundSource.NEUTRAL, 1.7f, 1.0f);
            }
            ParticleEffectsUtil.spawnParticles(this.m_9236_(), Vec3.m_82512_((Vec3i)pos), ModParticles.getForVariant(WoodVariant.BAMBOO), 50, new Vec3(0.4, 0.4, 0.4), 0.0);
            ParticleEffectsUtil.spawnParticles(this.m_9236_(), Vec3.m_82512_((Vec3i)pos), ParticleTypes.f_123759_, 50, new Vec3(0.5, 0.75, 0.5), 0.0);
        }
    }

    public void scheduleTreeHeistCelebration() {
        if (!this.m_9236_().m_5776_()) {
            this.animScheduler.scheduleTask(this.m_9236_().m_46467_() + 20L, "heist_celebration", () -> {
                SoundEvent sparkleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.f_19796_);
                if (sparkleSound != null) {
                    this.m_5496_(sparkleSound, 1.0f, 1.0f);
                }
            });
        }
    }

    public void updateAccessoryState() {
        ItemStack accessory = (ItemStack)this.items.get(6);
        if (accessory.m_150930_(Items.f_271209_)) {
            if ((Integer)this.f_19804_.m_135370_(PINK_PETAL_TYPE) == 0) {
                this.f_19804_.m_135381_(PINK_PETAL_TYPE, (Object)1);
            }
        } else if ((Integer)this.f_19804_.m_135370_(PINK_PETAL_TYPE) != 0) {
            this.f_19804_.m_135381_(PINK_PETAL_TYPE, (Object)0);
        }
    }

    private void handleSlotUpdateSounds(int slot, ItemStack oldStack, ItemStack newStack) {
        boolean isEmpty = newStack.m_41619_();
        boolean wasEmpty = oldStack.m_41619_();
        if (ItemStack.m_41728_((ItemStack)oldStack, (ItemStack)newStack)) {
            return;
        }
        if (slot == 7) {
            if (wasEmpty && !isEmpty) {
                this.m_5496_(SoundEvents.f_11675_, 0.6f, 1.2f);
            } else if (!wasEmpty && isEmpty) {
                this.m_5496_(SoundEvents.f_11675_, 0.4f, 0.8f);
            } else if (!wasEmpty && !isEmpty) {
                this.m_5496_(SoundEvents.f_11675_, 0.6f, 1.2f);
            }
        }
        if (slot == 6) {
            if (wasEmpty && !isEmpty) {
                this.m_5496_(SoundEvents.f_11675_, 0.6f, 1.2f);
            } else if (!wasEmpty && isEmpty) {
                this.m_5496_(SoundEvents.f_11675_, 0.4f, 0.8f);
            } else if (!wasEmpty && !isEmpty) {
                this.m_5496_(SoundEvents.f_11675_, 0.6f, 1.2f);
            }
        }
    }

    private void updateArmorModifiers(ItemStack armorStack) {
        Item item;
        AttributeInstance speedAttribute = this.m_21051_(Attributes.f_22279_);
        AttributeInstance knockbackAttribute = this.m_21051_(Attributes.f_22278_);
        boolean perksEnabled = (Boolean)Configs.AHP.enableArmorPerks.get();
        boolean shouldHaveSpeed = false;
        boolean shouldHaveKnockback = false;
        if (perksEnabled && !armorStack.m_41619_() && (item = armorStack.m_41720_()) instanceof HamsterArmorItem) {
            HamsterArmorItem armorItem = (HamsterArmorItem)item;
            HamsterArmorItem.HamsterArmorMaterial material = armorItem.getMaterial();
            if (material == HamsterArmorItem.HamsterArmorMaterial.GOLD) {
                shouldHaveSpeed = true;
            } else if (material == HamsterArmorItem.HamsterArmorMaterial.NETHERITE) {
                shouldHaveKnockback = true;
            }
        }
        if (speedAttribute != null) {
            boolean hasSpeed;
            boolean bl = hasSpeed = speedAttribute.m_22111_(ARMOR_SPEED_BOOST_UUID) != null;
            if (shouldHaveSpeed && !hasSpeed) {
                speedAttribute.m_22118_(new AttributeModifier(ARMOR_SPEED_BOOST_UUID, "Hamster Armor Speed", 0.2, AttributeModifier.Operation.MULTIPLY_BASE));
            } else if (!shouldHaveSpeed && hasSpeed) {
                speedAttribute.m_22120_(ARMOR_SPEED_BOOST_UUID);
            }
        }
        if (knockbackAttribute != null) {
            boolean hasKnockback;
            boolean bl = hasKnockback = knockbackAttribute.m_22111_(ARMOR_KNOCKBACK_RESISTANCE_UUID) != null;
            if (shouldHaveKnockback && !hasKnockback) {
                knockbackAttribute.m_22118_(new AttributeModifier(ARMOR_KNOCKBACK_RESISTANCE_UUID, "Hamster Armor KB Resist", 0.5, AttributeModifier.Operation.ADDITION));
            } else if (!shouldHaveKnockback && hasKnockback) {
                knockbackAttribute.m_22120_(ARMOR_KNOCKBACK_RESISTANCE_UUID);
            }
        }
    }

    private void broadcastImpactSound(SoundEvent sound, float pitch) {
        HamsterArmorItem armorItem;
        Item item;
        ItemStack armorStack;
        if (this.m_9236_().m_5776_()) {
            return;
        }
        double impactX = this.m_20185_();
        double impactY = this.m_20186_();
        double impactZ = this.m_20189_();
        SoundEvent armorSound = null;
        float armorPitch = 1.0f;
        if (this.items.size() > 7 && !(armorStack = (ItemStack)this.items.get(7)).m_41619_() && (item = armorStack.m_41720_()) instanceof HamsterArmorItem && (armorItem = (HamsterArmorItem)item).getMaterial() != HamsterArmorItem.HamsterArmorMaterial.ACORN) {
            armorSound = SoundEvents.f_11699_;
            armorPitch = 2.0f + this.f_19796_.m_188501_() * 0.5f;
        }
        for (ServerPlayer player : ((ServerLevel)this.m_9236_()).m_6907_()) {
            float volume;
            double distSq = player.m_20275_(impactX, impactY, impactZ);
            if (!(distSq <= 2500.0)) continue;
            double distance = Math.sqrt(distSq);
            if (distance <= 16.0) {
                volume = 1.0f - 0.82f * (float)(distance / 16.0);
            } else {
                float remainingProgress = (float)(distance - 16.0) / 34.0f;
                volume = 0.18f - 0.08f * remainingProgress;
            }
            volume = Mth.m_14036_((float)volume, (float)0.1f, (float)1.0f);
            ModPackets.CHANNEL.sendToPlayer(player, (Object)new ModPackets.PlayDistantSoundS2CPacket(sound.m_11660_(), volume, pitch));
            if (armorSound == null) continue;
            float armorVolume = Math.min(1.0f, volume * 0.5f);
            ModPackets.CHANNEL.sendToPlayer(player, (Object)new ModPackets.PlayDistantSoundS2CPacket(armorSound.m_11660_(), armorVolume, armorPitch));
        }
    }

    private void simulateTrajectoryAndCheckSound() {
        Vec3 simPos = this.m_20182_();
        Vec3 simVel = this.m_20184_();
        for (int i = 1; i <= 20; ++i) {
            if (!this.m_20068_()) {
                simVel = simVel.m_82520_(0.0, -0.05, 0.0);
            }
            Vec3 nextPos = simPos.m_82549_(simVel);
            BlockHitResult blockHit = this.m_9236_().m_45547_(new ClipContext(simPos, nextPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            EntityHitResult entityHit = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)simPos, (Vec3)nextPos, (AABB)this.m_20191_().m_82369_(simVel).m_82400_(1.0), this::canHitEntity);
            Vec3 impactPos = null;
            if (entityHit != null) {
                impactPos = entityHit.m_82450_();
            } else if (blockHit.m_6662_() != HitResult.Type.MISS) {
                impactPos = blockHit.m_82450_();
            }
            if (impactPos != null) {
                if (this.throwTicks + i >= 20) {
                    this.m_9236_().m_6263_(null, impactPos.f_82479_, impactPos.f_82480_, impactPos.f_82481_, (SoundEvent)ModSounds.HAMSTER_INCOMING.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    AdorableHamsterPets.LOGGER.debug("Played Incoming sound at target: {}", (Object)impactPos);
                }
                this.hasPlayedIncomingSound = true;
                return;
            }
            simPos = nextPos;
        }
    }

    private boolean getHamsterFlag(int flag) {
        return ((Integer)this.f_19804_.m_135370_(HAMSTER_FLAGS) & flag) != 0;
    }

    private void setHamsterFlag(int flag, boolean value) {
        int currentFlags = (Integer)this.f_19804_.m_135370_(HAMSTER_FLAGS);
        if (value) {
            this.f_19804_.m_135381_(HAMSTER_FLAGS, (Object)(currentFlags | flag));
        } else {
            this.f_19804_.m_135381_(HAMSTER_FLAGS, (Object)(currentFlags & ~flag));
        }
    }

    public boolean isItemDisallowed(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (ConfigDataCache.isPouchAllowed(stack)) {
            return false;
        }
        if (ConfigDataCache.isPouchDisallowed(stack)) {
            return true;
        }
        if (ConfigDataCache.isStandardFood(stack) || ConfigDataCache.isTamingFood(stack) || ConfigDataCache.isBuffFood(stack) || ConfigDataCache.isPouchUnlockFood(stack) || ConfigDataCache.isAutoHealFood(stack)) {
            return false;
        }
        if (stack.m_41614_()) {
            return false;
        }
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            return true;
        }
        return item instanceof SpawnEggItem;
    }

    private HolderLookup.Provider getRegistryLookup() {
        return this.m_9236_().m_9598_();
    }

    private boolean tryTame(Player player, ItemStack itemStack) {
        if (!player.m_150110_().f_35937_) {
            itemStack.m_41774_(1);
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        int denominator = Math.max(1, (Integer)config.tamingChanceDenominator.get());
        if (this.f_19796_.m_188503_(denominator) == 0) {
            this.m_21816_(player.m_20148_());
            this.setTamed(true, true);
            this.f_21344_.m_26573_();
            this.m_21839_(false);
            this.setSleeping(false);
            this.m_6710_(null);
            this.m_9236_().m_7605_((Entity)this, (byte)7);
            SoundEvent celebrateSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.f_19796_);
            this.m_9236_().m_5594_(null, this.m_20183_(), celebrateSound, SoundSource.NEUTRAL, 0.7f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10590_.m_68829_(serverPlayer, (Animal)this);
            }
            return true;
        }
        this.m_9236_().m_7605_((Entity)this, (byte)6);
        return false;
    }

    private boolean checkRepeatFoodRefusal(ItemStack currentStack, Player player) {
        if (ConfigDataCache.isRepeatableFood(currentStack)) {
            return false;
        }
        if (!this.lastFoodItem.m_41619_() && ItemStack.m_41656_((ItemStack)this.lastFoodItem, (ItemStack)currentStack)) {
            this.setRefusingFood(true);
            this.refuseTimer = 40;
            player.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.food_refusal"), true);
            if (!this.m_9236_().m_5776_()) {
                boolean isMoving;
                boolean bl = isMoving = this.m_20184_().m_165925_() > 1.0E-6;
                if (isMoving) {
                    this.triggerAnimOnServer("mainController", "moving_headshake");
                } else {
                    this.triggerAnimOnServer("mainController", "stationary_headshake");
                }
            }
            return true;
        }
        return false;
    }

    private boolean tryFeedingAsTamed(Player player, ItemStack stack) {
        boolean isFood = ConfigDataCache.isStandardFood(stack);
        boolean isBuffItem = ConfigDataCache.isBuffFood(stack);
        boolean isPouchUnlockFood = ConfigDataCache.isPouchUnlockFood(stack);
        boolean canHeal = this.m_21223_() < this.m_21233_();
        boolean readyToBreed = this.m_146764_() == 0 && !this.isInCustomLove();
        Level world = this.m_9236_();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        boolean actionTaken = false;
        AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Entering tryFeedingAsTamed. Item: {}, isFood={}, isBuff={}, canHeal={}, breedingAge={}, isInCustomLove={}, readyToBreed={}", new Object[]{this.m_19879_(), world.m_46467_(), stack.m_41720_(), isFood, isBuffItem, canHeal, this.m_146764_(), this.isInCustomLove(), readyToBreed});
        if (isPouchUnlockFood && !this.getHamsterFlag(512)) {
            this.setHamsterFlag(512, true);
            AdorableHamsterPets.LOGGER.debug("Hamster {} cheek pouch unlocked by {}.", (Object)this.m_19879_(), (Object)stack.m_41720_());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModCriteria.CHEEK_POUCH_UNLOCKED.trigger(serverPlayer, this);
            }
            world.m_5594_(null, this.m_20183_(), SoundEvents.f_12275_, SoundSource.NEUTRAL, 0.5f, 1.5f);
            ParticleEffectsUtil.spawnParticles(world, new Vec3(this.m_20185_(), this.m_20227_(0.2), this.m_20189_()), new ItemParticleOption(ParticleTypes.f_123752_, stack.m_41777_()), 25, new Vec3(0.25, 0.15, 0.25), 0.0);
            return true;
        }
        if (isBuffItem) {
            long currentTime = world.m_46467_();
            if (this.greenBeanBuffEndTick > currentTime) {
                long remainingTicks = this.greenBeanBuffEndTick - currentTime;
                long totalSecondsRemaining = remainingTicks / 20L;
                long minutes = totalSecondsRemaining / 60L;
                long seconds = totalSecondsRemaining % 60L;
                player.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.beans_cooldown", (Object[])new Object[]{minutes, seconds}).m_130940_(ChatFormatting.RED), true);
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Buff item used, but on cooldown ({} ticks remaining). Returning false.", new Object[]{this.m_19879_(), world.m_46467_(), remainingTicks});
                return false;
            }
            int duration = (Integer)config.greenBeanBuffDuration.get();
            int speedAmplifier = (Integer)config.greenBeanBuffAmplifierSpeed.get();
            int strengthAmplifier = (Integer)config.greenBeanBuffAmplifierStrength.get();
            int absorptionAmplifier = (Integer)config.greenBeanBuffAmplifierAbsorption.get();
            int regenAmplifier = (Integer)config.greenBeanBuffAmplifierRegen.get();
            this.zoomiesIsClockwise = this.f_19796_.m_188499_();
            this.lastZoomiesAngle = 0.0;
            this.m_7292_(new MobEffectInstance(MobEffects.f_19596_, duration, speedAmplifier));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, duration, strengthAmplifier));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, duration, absorptionAmplifier));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, duration, regenAmplifier));
            this.zoomiesIsClockwise = this.f_19796_.m_188499_();
            this.zoomiesRadiusModifier = this.f_19796_.m_216332_(-2, 4);
            double dx = this.m_20185_() - player.m_20185_();
            double dz = this.m_20189_() - player.m_20189_();
            this.lastZoomiesAngle = Math.atan2(dz, dx);
            SoundEvent buffSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.f_19796_);
            world.m_5594_(null, this.m_20183_(), buffSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            long buffDurationEnd = currentTime + (long)((Integer)config.greenBeanBuffDuration.get()).intValue();
            this.m_20088_().m_135381_(GREEN_BEAN_BUFF_DURATION, (Object)buffDurationEnd);
            this.greenBeanBuffEndTick = currentTime + (long)((Integer)config.steamedGreenBeansBuffCooldown.get()).intValue();
            actionTaken = true;
            AdorableHamsterPets.LOGGER.trace("[FeedAttempt {} Tick {}] Applied buffs. Duration ends at tick {}. Cooldown ends at tick {}.", new Object[]{this.m_19879_(), world.m_46467_(), buffDurationEnd, this.greenBeanBuffEndTick});
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModCriteria.FED_HAMSTER_STEAMED_BEANS.trigger(serverPlayer, this);
            }
        } else if (ConfigDataCache.isStandardFood(stack)) {
            if (canHeal) {
                this.m_5634_(((Float)config.standardFoodHealing.get()).floatValue());
                actionTaken = true;
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {}] Healed with standard food.", (Object)this.m_19879_());
            } else if (readyToBreed) {
                this.setSitting(false, true);
                this.setCustomInLove(player);
                this.setInLove(true);
                actionTaken = true;
                AdorableHamsterPets.LOGGER.debug("[FeedAttempt {}] Entered love mode with standard food.", (Object)this.m_19879_());
            }
        }
        if (!actionTaken) {
            AdorableHamsterPets.LOGGER.debug("[FeedAttempt {} Tick {}] Item {} was not a valid food for any action.", new Object[]{this.m_19879_(), world.m_46467_(), stack.m_41720_()});
        }
        return actionTaken;
    }

    @Unique
    private boolean checkConditionsForInitiatingDrowsiness() {
        if (!this.m_21827_()) {
            return false;
        }
        Level world = this.m_9236_();
        if (Configs.AHP.requireDaytimeForTamedSleep && !world.m_46461_()) {
            return false;
        }
        if (this.m_27593_()) {
            return false;
        }
        double threatRadius = ((Integer)Configs.AHP.tamedSleepThreatDetectionRadiusBlocks.get()).intValue();
        List nearbyHostiles = world.m_6443_(LivingEntity.class, this.m_20191_().m_82400_(threatRadius), entity -> entity instanceof Monster && entity.m_6084_() && !entity.m_5833_());
        return nearbyHostiles.isEmpty();
    }

    @Unique
    private boolean checkConditionsForSustainingSlumber() {
        return this.m_21827_() && this.checkConditionsForInitiatingDrowsiness();
    }

    @Unique
    private void resetSleepSequence(String reason) {
        AdorableHamsterPets.LOGGER.debug("Hamster {} resetting sleep sequence: {}. Current phase was: {}", new Object[]{this.m_19879_(), reason, this.getDozingPhase()});
        this.setDozingPhase(DozingPhase.NONE);
        this.quiescentSitDurationTimer = 0;
        this.driftingOffTimer = 0;
        this.settleSleepAnimationCooldown = 0;
    }

    public void m_142036_() {
        super.m_142036_();
        if (!this.m_9236_().m_5776_()) {
            HamsterRenderTracker.onEntityUnload(this.m_19879_());
        }
    }

    public static enum DozingPhase {
        NONE,
        QUIESCENT_SITTING,
        DRIFTING_OFF,
        SETTLING_INTO_SLUMBER,
        DEEP_SLEEP;

    }
}

