/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.dawson.adorablehamsterpets.util.TreeHeistUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class HamsterTreeSearcherEntity
extends Entity {
    private static final Map<GlobalPos, Integer> ACTIVE_HEISTS = new ConcurrentHashMap<GlobalPos, Integer>();
    private CompoundTag hamsterNbt = new CompoundTag();
    private final List<Long> validLeafPositions = new ArrayList<Long>();
    private int searchTimer;
    private int maxSearchDuration;
    private int validationTimer;
    private int rummageTimer;
    private float dropChanceMultiplier = 1.0f;
    private boolean isExhausted = false;
    private BlockPos treeAnchor = null;
    private boolean hasAcornHat = false;
    private int dropCooldown = 0;
    private boolean isRegistered = false;
    private static final int VALIDATION_INTERVAL = 20;
    private static final int BASE_DURATION_MIN = 180;
    private static final int BASE_DURATION_MAX = 280;
    private static final float HAT_DROP_CHANCE_MULTIPLIER = 2.0f;
    private static final float BASE_DROP_CHANCE = 0.03f;
    private static final float DURATION_MULTIPLIER = 2.0f;

    public HamsterTreeSearcherEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.f_19794_ = true;
        this.m_20242_(true);
        this.m_6842_(true);
    }

    protected void m_8097_() {
    }

    public static boolean isTreeBlocked(Level world, BlockPos anchor) {
        if (anchor == null || world.m_5776_()) {
            return false;
        }
        GlobalPos key = GlobalPos.m_122643_((ResourceKey)world.m_46472_(), (BlockPos)anchor);
        return ACTIVE_HEISTS.containsKey(key);
    }

    private void registerHeist() {
        if (this.m_9236_().m_5776_() || this.treeAnchor == null || this.isRegistered) {
            return;
        }
        GlobalPos key = GlobalPos.m_122643_((ResourceKey)this.m_9236_().m_46472_(), (BlockPos)this.treeAnchor);
        ACTIVE_HEISTS.put(key, this.m_19879_());
        this.isRegistered = true;
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Registry] Registered heist for Tree {} (Entity {}). Active Heists: {}", new Object[]{this.treeAnchor.m_123344_(), this.m_19879_(), ACTIVE_HEISTS.size()});
        }
    }

    private void unregisterHeist() {
        if (this.m_9236_().m_5776_() || this.treeAnchor == null || !this.isRegistered) {
            return;
        }
        GlobalPos key = GlobalPos.m_122643_((ResourceKey)this.m_9236_().m_46472_(), (BlockPos)this.treeAnchor);
        if (ACTIVE_HEISTS.remove(key, this.m_19879_())) {
            this.isRegistered = false;
            if (Configs.AHP.debugTreeDetection) {
                AdorableHamsterPets.LOGGER.info("[TreeHeist-Registry] Unregistered heist for Tree {} (Entity {}). Active Heists: {}", new Object[]{this.treeAnchor.m_123344_(), this.m_19879_(), ACTIVE_HEISTS.size()});
            }
        }
    }

    public BlockPos getTreeAnchor() {
        return this.treeAnchor;
    }

    public void initializeSearch(BlockPos startPos, TreeHeistUtil.TreeScanResult scanResult, CompoundTag originalHamsterNbt) {
        CompoundTag invNbt;
        this.hamsterNbt = originalHamsterNbt;
        this.m_6034_((double)startPos.m_123341_() + 0.5, (double)startPos.m_123342_() + 0.5, (double)startPos.m_123343_() + 0.5);
        this.validLeafPositions.clear();
        for (BlockPos pos : scanResult.validCanopyPositions()) {
            this.validLeafPositions.add(pos.m_121878_());
        }
        this.treeAnchor = scanResult.treeId();
        this.registerHeist();
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Init] Searcher Entity Initialized. Anchor: {}. Canopy: {}.", (Object)this.treeAnchor.m_123344_(), (Object)this.validLeafPositions.size());
        }
        if (this.validLeafPositions.isEmpty()) {
            if (Configs.AHP.debugTreeDetection) {
                AdorableHamsterPets.LOGGER.warn("[TreeHeist-Init] No valid leaves found. Aborting.");
            }
            this.popOut(false);
            return;
        }
        if (Configs.AHP.debugTreeDetection) {
            TreeHeistUtil.spawnDebugParticles(this.m_9236_(), scanResult);
            AdorableHamsterPets.LOGGER.info("[TreeHeist] Identified Tree ID: {} | Canopy Size: {}", (Object)this.treeAnchor, (Object)this.validLeafPositions.size());
        }
        if (this.hamsterNbt.m_128403_("Owner")) {
            UUID ownerUuid = this.hamsterNbt.m_128342_("Owner");
            Player player = this.m_9236_().m_46003_(ownerUuid);
            if (player instanceof PlayerEntityAccessor) {
                PlayerEntityAccessor accessor = (PlayerEntityAccessor)player;
                this.dropChanceMultiplier = accessor.ahp$getHeistProfitability(this.treeAnchor);
                accessor.ahp$registerTreeHeist(this.treeAnchor);
                if (this.dropChanceMultiplier <= 0.01f) {
                    this.isExhausted = true;
                }
                if (!this.isExhausted) {
                    TreeHeistUtil.sendHeistStartMessage(player, this.dropChanceMultiplier);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ModCriteria.TREE_HEIST_STARTED.trigger(serverPlayer);
                }
            }
        }
        int baseDuration = this.f_19796_.m_216332_(180, 280);
        this.hasAcornHat = false;
        if (this.hamsterNbt.m_128425_("Inventory", 10) && (invNbt = this.hamsterNbt.m_128469_("Inventory")).m_128425_("Items", 9)) {
            ListTag itemsList = invNbt.m_128437_("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                ItemStack stack;
                CompoundTag itemTag = itemsList.m_128728_(i);
                int slot = itemTag.m_128445_("Slot") & 0xFF;
                if (slot != 6 || !(stack = ItemStack.m_41712_((CompoundTag)itemTag)).m_150930_((Item)ModItems.ACORN_HAT.get())) continue;
                this.hasAcornHat = true;
                break;
            }
        }
        if (this.isExhausted) {
            baseDuration = Math.max(60, (int)((float)baseDuration * 0.1f));
        }
        this.searchTimer = baseDuration;
        this.maxSearchDuration = baseDuration;
        this.validationTimer = 20;
        if (Configs.AHP.debugTreeDetection) {
            float baseChance = ((Float)Configs.AHP.acornDropChance.get()).floatValue();
            float estimatedFinalChance = baseChance * this.dropChanceMultiplier;
            if (this.hasAcornHat) {
                estimatedFinalChance *= 2.0f;
            }
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Stats] Heist Initialized:\n  - Tree Anchor: {}\n  - Base Profitability (History): {}%\n  - Acorn Hat Equipped: {}\n  - Hat Multiplier: {}x\n  - FINAL Drop Chance per Rummage: {}% (Base: {}%)\n", new Object[]{this.treeAnchor.m_123344_(), String.format("%.1f", Float.valueOf(this.dropChanceMultiplier * 100.0f)), this.hasAcornHat, Float.valueOf(this.hasAcornHat ? 2.0f : 1.0f), String.format("%.2f", Float.valueOf(estimatedFinalChance * 100.0f)), String.format("%.2f", Float.valueOf(baseChance * 100.0f))});
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!this.isRegistered && this.treeAnchor != null) {
            this.registerHeist();
        }
        if (this.validLeafPositions.isEmpty()) {
            if (this.f_19797_ > 5) {
                this.m_146870_();
            }
            return;
        }
        if (this.dropCooldown > 0) {
            --this.dropCooldown;
        }
        if (Configs.AHP.debugTreeDetection) {
            TreeHeistUtil.spawnDebugParticles(this.m_9236_(), this.treeAnchor, this.validLeafPositions);
        }
        if (--this.validationTimer <= 0) {
            this.validationTimer = 20;
            if (!this.validateTreeIntegrity()) {
                this.popOut(false);
                return;
            }
        }
        if (--this.rummageTimer <= 0) {
            this.rummageTimer = this.f_19796_.m_216332_(3, 5);
            this.rummage();
        }
        if (--this.searchTimer <= 0) {
            this.popOut(true);
        }
    }

    public void m_142036_() {
        super.m_142036_();
        if (!this.m_9236_().m_5776_()) {
            this.unregisterHeist();
        }
    }

    private boolean validateTreeIntegrity() {
        int samples = Math.min(3, this.validLeafPositions.size());
        int failures = 0;
        for (int i = 0; i < samples; ++i) {
            long posLong = this.validLeafPositions.get(this.f_19796_.m_188503_(this.validLeafPositions.size()));
            BlockPos pos = BlockPos.m_122022_((long)posLong);
            if (this.m_9236_().m_8055_(pos).m_60713_(Blocks.f_50050_)) continue;
            ++failures;
        }
        return failures <= samples / 2;
    }

    private void rummage() {
        BlockPos currentPos = this.m_20183_();
        BlockPos targetPos = null;
        ArrayList<BlockPos> nearbyExposed = new ArrayList<BlockPos>();
        ArrayList<BlockPos> nearbyBuried = new ArrayList<BlockPos>();
        for (Long l : this.validLeafPositions) {
            BlockPos p = BlockPos.m_122022_((long)l);
            if (p.equals((Object)currentPos) || p.m_123333_((Vec3i)currentPos) > 2) continue;
            if (this.isLeafExposed(this.m_9236_(), p)) {
                nearbyExposed.add(p);
                continue;
            }
            nearbyBuried.add(p);
        }
        if (!nearbyExposed.isEmpty()) {
            targetPos = (BlockPos)nearbyExposed.get(this.f_19796_.m_188503_(nearbyExposed.size()));
        } else if (!nearbyBuried.isEmpty()) {
            targetPos = (BlockPos)nearbyBuried.get(this.f_19796_.m_188503_(nearbyBuried.size()));
        } else {
            ArrayList<BlockPos> allExposed = new ArrayList<BlockPos>();
            for (Long posLong : this.validLeafPositions) {
                BlockPos p = BlockPos.m_122022_((long)posLong);
                if (!this.isLeafExposed(this.m_9236_(), p)) continue;
                allExposed.add(p);
            }
            if (!allExposed.isEmpty()) {
                targetPos = (BlockPos)allExposed.get(this.f_19796_.m_188503_(allExposed.size()));
            } else {
                long l = this.validLeafPositions.get(this.f_19796_.m_188503_(this.validLeafPositions.size()));
                targetPos = BlockPos.m_122022_((long)l);
            }
        }
        this.m_6034_((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5);
        ParticleEffectsUtil.spawnParticles(this.m_9236_(), new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()), ModParticles.getForVariant(WoodVariant.BAMBOO), 50, new Vec3(0.4, 0.4, 0.4), 0.0);
        ParticleEffectsUtil.spawnParticles(this.m_9236_(), new Vec3(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5), ParticleTypes.f_123790_, 7, new Vec3(0.4, 0.4, 0.4), 0.1);
        float dropChance = ((Float)Configs.AHP.acornDropChance.get()).floatValue() * this.dropChanceMultiplier;
        if (this.hasAcornHat) {
            dropChance *= 2.0f;
        }
        if (this.f_19796_.m_188501_() < dropChance && this.dropCooldown <= 0) {
            BlockPos blockPos = TreeHeistUtil.findExitPosition(this.m_9236_(), targetPos);
            ItemStack acornStack = new ItemStack((ItemLike)ModItems.ACORN.get());
            ItemEntity acornEntity = new ItemEntity(this.m_9236_(), (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.7, (double)blockPos.m_123343_() + 0.5, acornStack);
            double velX = (this.f_19796_.m_188500_() - 0.5) * 0.7;
            double velY = 0.0;
            double velZ = (this.f_19796_.m_188500_() - 0.5) * 0.7;
            acornEntity.m_20334_(velX, velY, velZ);
            SoundEvent acornPopSound = ModSounds.getDynamicItemSound(acornStack);
            this.m_9236_().m_6263_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, acornPopSound, SoundSource.NEUTRAL, 0.5f, 1.8f);
            this.m_9236_().m_6263_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, (SoundEvent)ModSounds.HAMSTER_DING.get(), SoundSource.NEUTRAL, 0.7f, 1.0f + (this.f_19796_.m_188501_() - 0.5f) * 0.2f);
            this.m_9236_().m_7967_((Entity)acornEntity);
            this.dropCooldown = 20;
        }
    }

    private boolean isLeafExposed(Level world, BlockPos pos) {
        for (Direction dir : Direction.values()) {
            if (!world.m_46859_(pos.m_121945_(dir))) continue;
            return true;
        }
        return false;
    }

    private void popOut(boolean success) {
        if (this.m_9236_().f_46443_) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)this.m_9236_();
        this.unregisterHeist();
        BlockPos startPoint = this.m_20183_();
        BlockPos exitPos = TreeHeistUtil.findExitPosition(this.m_9236_(), startPoint);
        HamsterEntity newHamster = (HamsterEntity)((EntityType)ModEntities.HAMSTER.get()).m_20615_((Level)serverWorld);
        if (newHamster != null) {
            SoundEvent celebrateSound;
            newHamster.m_20258_(this.hamsterNbt);
            newHamster.setFallFlyImmunityTicks(0);
            newHamster.m_7678_((double)exitPos.m_123341_() + 0.5, (double)exitPos.m_123342_() + 0.1, (double)exitPos.m_123343_() + 0.5, this.f_19796_.m_188501_() * 360.0f, 0.0f);
            newHamster.m_20256_(Vec3.f_82478_);
            newHamster.setThrown(false);
            newHamster.setKnockedOut(false);
            newHamster.m_21839_(false);
            newHamster.f_19812_ = true;
            if (success && !this.isExhausted) {
                ItemStack prize = new ItemStack((ItemLike)ModItems.ACORN.get());
                newHamster.setInterestItemStack(prize);
                newHamster.setHoldingInterestItem(true);
                newHamster.setItemInterestTimer(1200);
                SoundEvent sparkleSound = ModSounds.getRandomSoundFrom(ModSounds.DIAMOND_SPARKLE_SOUNDS, this.f_19796_);
                if (sparkleSound != null) {
                    serverWorld.m_5594_(null, newHamster.m_20183_(), sparkleSound, SoundSource.NEUTRAL, 0.5f, 1.0f);
                }
                newHamster.scheduleTreeHeistCelebration();
            } else {
                UUID ownerUuid;
                Player owner;
                newHamster.setSulking(true);
                newHamster.triggerAnimOnServer("mainController", "anim_hamster_sulk");
                if (this.isExhausted && this.hamsterNbt.m_128403_("Owner") && (owner = serverWorld.m_46003_(ownerUuid = this.hamsterNbt.m_128342_("Owner"))) != null) {
                    owner.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.tree_heist_exhausted").m_130940_(ChatFormatting.RED), true);
                    if (owner instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)owner;
                        ModCriteria.TREE_HEIST_DEPLETION.trigger(serverPlayer);
                    }
                }
            }
            serverWorld.m_47205_((Entity)newHamster);
            newHamster.triggerLeafPopEffects(startPoint, true);
            if (success && !this.isExhausted && (celebrateSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.f_19796_)) != null) {
                serverWorld.m_5594_(null, newHamster.m_20183_(), celebrateSound, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        }
        this.m_146870_();
    }

    protected void m_7380_(CompoundTag nbt) {
        nbt.m_128365_("HamsterNBT", (Tag)this.hamsterNbt);
        nbt.m_128405_("SearchTimer", this.searchTimer);
        nbt.m_128405_("MaxSearchDuration", this.maxSearchDuration);
        nbt.m_128405_("RummageTimer", this.rummageTimer);
        if (this.treeAnchor != null) {
            nbt.m_128356_("TreeAnchor", this.treeAnchor.m_121878_());
        }
        nbt.m_128379_("IsExhausted", this.isExhausted);
        nbt.m_128350_("DropMultiplier", this.dropChanceMultiplier);
        nbt.m_128379_("HasAcornHat", this.hasAcornHat);
        nbt.m_128405_("DropCooldown", this.dropCooldown);
        ListTag posList = new ListTag();
        for (Long pos : this.validLeafPositions) {
            posList.add((Object)LongTag.m_128882_((long)pos));
        }
        nbt.m_128365_("ValidLeafPositions", (Tag)posList);
    }

    protected void m_7378_(CompoundTag nbt) {
        this.hamsterNbt = nbt.m_128469_("HamsterNBT");
        this.searchTimer = nbt.m_128451_("SearchTimer");
        this.maxSearchDuration = nbt.m_128451_("MaxSearchDuration");
        this.rummageTimer = nbt.m_128451_("RummageTimer");
        if (nbt.m_128441_("TreeAnchor")) {
            this.treeAnchor = BlockPos.m_122022_((long)nbt.m_128454_("TreeAnchor"));
        }
        this.isExhausted = nbt.m_128471_("IsExhausted");
        this.dropChanceMultiplier = nbt.m_128457_("DropMultiplier");
        this.hasAcornHat = nbt.m_128471_("HasAcornHat");
        this.dropCooldown = nbt.m_128451_("DropCooldown");
        this.validLeafPositions.clear();
        if (nbt.m_128425_("ValidLeafPositions", 9)) {
            ListTag list = nbt.m_128437_("ValidLeafPositions", 4);
            for (Tag element : list) {
                if (!(element instanceof LongTag)) continue;
                LongTag nbtLong = (LongTag)element;
                this.validLeafPositions.add(nbtLong.m_7046_());
            }
        }
        this.validationTimer = 20;
    }
}

