/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.integration.jade;

import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationProcessor;

public enum HamsterDebugComponentProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;

    private static final ResourceLocation UID;

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        if (!Configs.AHP.enableJadeHamsterDebugInfo) {
            return;
        }
        Entity entity = accessor.getEntity();
        if (!(entity instanceof HamsterEntity)) {
            return;
        }
        HamsterEntity hamster = (HamsterEntity)entity;
        tooltip.add((Component)Component.m_237113_((String)"--- Current Animation ---").m_130940_(ChatFormatting.GRAY));
        AnimationController controller = (AnimationController)hamster.getAnimatableInstanceCache().getManagerForId((long)hamster.m_19879_()).getAnimationControllers().get("mainController");
        if (controller != null) {
            AnimationProcessor.QueuedAnimation currentAnim = controller.getCurrentAnimation();
            if (currentAnim != null) {
                tooltip.add(this.fText("Current Anim: %s", Component.m_237113_((String)currentAnim.animation().name()).m_130940_(ChatFormatting.AQUA)));
            } else {
                tooltip.add(this.fText("Current Anim: %s", Component.m_237113_((String)"None").m_130940_(ChatFormatting.GRAY)));
            }
        }
        tooltip.add((Component)Component.m_237113_((String)"--- AI & Action States ---").m_130940_(ChatFormatting.GRAY));
        tooltip.add(this.fText("Sitting (Command): %s", hamster.m_21827_() ? Component.m_237113_((String)"true").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"false").m_130940_(ChatFormatting.RED)));
        tooltip.add(this.fText("Sitting (Vanilla Pose): %s", hamster.m_21825_() ? Component.m_237113_((String)"true").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"false").m_130940_(ChatFormatting.RED)));
        tooltip.add(this.fText("Sleeping (Wild/General): %s", hamster.m_5803_() ? Component.m_237113_((String)"true").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"false").m_130940_(ChatFormatting.RED)));
        tooltip.add(this.fText("Cleaning: %s", hamster.isCleaning() ? Component.m_237113_((String)"true").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"false").m_130940_(ChatFormatting.RED)));
        if (hamster.isKnockedOut()) {
            tooltip.add(this.fText("State: %s", Component.m_237113_((String)"Knocked Out").m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})));
        } else if (hamster.isThrown()) {
            tooltip.add(this.fText("State: %s", Component.m_237113_((String)"Thrown").m_130940_(ChatFormatting.AQUA)));
        } else if (hamster.isSulking()) {
            tooltip.add(this.fText("State: %s", Component.m_237113_((String)"Sulking").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD})));
        } else if (hamster.isCelebratingDiamond()) {
            tooltip.add(this.fText("State: %s", Component.m_237113_((String)"Celebrating Diamond").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD})));
        }
        tooltip.add(this.fText("Is Navigating: %s", !hamster.m_21573_().m_26571_() ? Component.m_237113_((String)"true").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"false").m_130940_(ChatFormatting.RED)));
        LivingEntity target = hamster.m_5448_();
        tooltip.add(this.fText("Has Target: %s", target != null ? Component.m_237113_((String)"true").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"false").m_130940_(ChatFormatting.RED)));
        if (target != null) {
            tooltip.add(this.fText("  Target: %s", Component.m_237113_((String)target.m_7755_().getString()).m_130940_(ChatFormatting.WHITE)));
        }
        String activeGoalName = hamster.getActiveCustomGoalDebugName();
        tooltip.add(this.fText("Current Custom Goal: %s", Component.m_237113_((String)activeGoalName).m_130940_(activeGoalName.equals("None") ? ChatFormatting.GRAY : ChatFormatting.AQUA)));
        tooltip.add((Component)Component.m_237113_((String)"--- Bed Link ---").m_130940_(ChatFormatting.GRAY));
        CompoundTag serverData = accessor.getServerData();
        boolean isWanderActive = serverData.m_128471_("IsWanderModeActive");
        boolean isOnTheWayToBed = serverData.m_128471_("IsOnTheWayToBed");
        int goToBedDelay = serverData.m_128451_("GoToBedDelay");
        tooltip.add(this.fText("Wander Mode: %s", isWanderActive ? Component.m_237113_((String)"ACTIVE").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"INACTIVE").m_130940_(ChatFormatting.RED)));
        if (isWanderActive) {
            if (isOnTheWayToBed) {
                if (goToBedDelay > 0) {
                    tooltip.add(this.fText("  Status: %s", Component.m_237113_((String)String.format("Waiting... (starts in %.1f s)", (double)goToBedDelay / 20.0)).m_130940_(ChatFormatting.YELLOW)));
                } else {
                    tooltip.add(this.fText("  Status: %s", Component.m_237113_((String)"Pathfinding to bed...").m_130940_(ChatFormatting.YELLOW)));
                }
            } else if (serverData.m_128441_("WanderDistance")) {
                String distanceStr = serverData.m_128461_("WanderDistance");
                tooltip.add(this.fText("  Wander Distance: %s", Component.m_237113_((String)distanceStr).m_130940_(ChatFormatting.AQUA)));
            }
        }
        if (hamster.m_21824_()) {
            tooltip.add((Component)Component.m_237113_((String)"--- Tamed Sleep Sequence ---").m_130940_(ChatFormatting.GRAY));
            HamsterEntity.DozingPhase phase = hamster.getDozingPhase();
            tooltip.add(this.fText("Dozing Phase: %s", Component.m_237113_((String)phase.name()).m_130940_(phase != HamsterEntity.DozingPhase.NONE ? ChatFormatting.AQUA : ChatFormatting.WHITE)));
            if (phase == HamsterEntity.DozingPhase.DEEP_SLEEP || phase == HamsterEntity.DozingPhase.SETTLING_INTO_SLUMBER) {
                tooltip.add(this.fText("  Deep Sleep Anim: %s", Component.m_237113_((String)hamster.getCurrentDeepSleepAnimationIdFromTracker()).m_130940_(ChatFormatting.AQUA)));
            }
        }
        tooltip.add((Component)Component.m_237113_((String)"--- Ore Seeking ---").m_130940_(ChatFormatting.GRAY));
        tooltip.add(this.fText("Primed to Seek: %s", hamster.isPrimedToSeekDiamonds ? Component.m_237113_((String)"true").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"false").m_130940_(ChatFormatting.RED)));
        if (hamster.currentOreTarget != null) {
            tooltip.add(this.fText("  Current Ore Target: %s", Component.m_237113_((String)hamster.currentOreTarget.toString()).m_130940_(ChatFormatting.AQUA)));
        } else {
            tooltip.add(this.fText("  Current Ore Target: %s", Component.m_237113_((String)"None").m_130940_(ChatFormatting.GRAY)));
        }
        long foundOreCooldown = hamster.foundOreCooldownEndTick - hamster.m_9236_().m_46467_();
        if (Configs.AHP.enableIndependentDiamondSeekCooldown && foundOreCooldown > 0L) {
            tooltip.add(this.fText("  Found Ore Cooldown: %s sec", Component.m_237113_((String)String.format("%.1f", (double)foundOreCooldown / 20.0)).m_130940_(ChatFormatting.YELLOW)));
        } else if (Configs.AHP.enableIndependentDiamondSeekCooldown) {
            tooltip.add(this.fText("  Found Ore Cooldown: %s", Component.m_237113_((String)"Ready").m_130940_(ChatFormatting.GREEN)));
        } else {
            tooltip.add(this.fText("  Found Ore Cooldown: %s", Component.m_237113_((String)"Disabled").m_130940_(ChatFormatting.GRAY)));
        }
        tooltip.add((Component)Component.m_237113_((String)"--- Item Stealing/Fetching ---").m_130940_(ChatFormatting.GRAY));
        boolean isHolding = hamster.isHoldingInterestItem();
        tooltip.add(this.fText("Is Interested in Item: %s", isHolding ? Component.m_237113_((String)"true").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"false").m_130940_(ChatFormatting.RED)));
        if (isHolding) {
            int remainingTicks = hamster.getItemInterestTimer();
            tooltip.add(this.fText("  Time Remaining: %s sec", Component.m_237113_((String)String.format("%.1f", (double)remainingTicks / 20.0)).m_130940_(ChatFormatting.YELLOW)));
            if (hamster.isTauntingWithItem()) {
                tooltip.add(this.fText("  Action: %s", Component.m_237113_((String)"Taunting").m_130940_(ChatFormatting.GOLD)));
            } else if (hamster.isPresentingItem()) {
                tooltip.add(this.fText("  Action: %s", Component.m_237113_((String)"Presenting").m_130940_(ChatFormatting.AQUA)));
            } else {
                tooltip.add(this.fText("  Action: %s", Component.m_237113_((String)"Moving/Fleeing").m_130940_(ChatFormatting.WHITE)));
            }
        }
        tooltip.add((Component)Component.m_237113_((String)"--- Love & Interaction ---").m_130940_(ChatFormatting.GRAY));
        tooltip.add(this.fText("Begging: %s", hamster.isBegging() ? Component.m_237113_((String)"true").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"false").m_130940_(ChatFormatting.RED)));
        tooltip.add(this.fText("Refusing Food: %s", hamster.isRefusingFood() ? Component.m_237113_((String)"true").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"false").m_130940_(ChatFormatting.RED)));
        boolean inLoveDataTracker = hamster.m_27593_();
        boolean inLoveCustomTimer = hamster.customLoveTimer > 0;
        tooltip.add(this.fText("In Love (Tracker): %s", inLoveDataTracker ? Component.m_237113_((String)"true").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"false").m_130940_(ChatFormatting.RED)));
        tooltip.add(this.fText("In Love (Timer): %s (%d ticks)", inLoveCustomTimer ? Component.m_237113_((String)"true").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"false").m_130940_(ChatFormatting.RED), hamster.customLoveTimer));
        tooltip.add((Component)Component.m_237113_((String)"--- General Info ---").m_130940_(ChatFormatting.GRAY));
        tooltip.add(this.fText("Tamed: %s", hamster.m_21824_() ? Component.m_237113_((String)"Yes").m_130940_(ChatFormatting.GREEN) : Component.m_237113_((String)"No").m_130940_(ChatFormatting.RED)));
        if (hamster.m_21824_() && hamster.m_269323_() != null) {
            tooltip.add(this.fText("  Owner: %s", Component.m_237113_((String)hamster.m_269323_().m_7755_().getString()).m_130940_(ChatFormatting.WHITE)));
        }
        tooltip.add(this.fText("Variant: %s (ID: %d)", Component.m_237113_((String)hamster.getVariantEnum().name()).m_130940_(ChatFormatting.AQUA), hamster.getVariant()));
        tooltip.add(this.fText("Age: %s", hamster.m_6162_() ? Component.m_237113_((String)"Baby").m_130940_(ChatFormatting.AQUA) : Component.m_237113_((String)"Adult").m_130940_(ChatFormatting.WHITE)));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void appendServerData(CompoundTag data, EntityAccessor accessor) {
        Entity entity = accessor.getEntity();
        if (entity instanceof HamsterEntity) {
            HamsterEntity hamster = (HamsterEntity)entity;
            data.m_128379_("IsWanderModeActive", hamster.isWanderModeActive());
            data.m_128379_("IsOnTheWayToBed", hamster.isOnTheWayToBed());
            data.m_128405_("GoToBedDelay", hamster.getGoToBedDelayTicks());
            if (hamster.isWanderModeActive()) {
                hamster.getLinkedBedPos().ifPresent(globalPos -> {
                    BlockEntity patt11972$temp;
                    ServerLevel serverWorld;
                    Level world = hamster.m_9236_();
                    if (world instanceof ServerLevel && (serverWorld = (ServerLevel)world).m_46472_() == globalPos.m_122640_() && (patt11972$temp = serverWorld.m_7702_(globalPos.m_122646_())) instanceof HamsterBedBlockEntity) {
                        HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)patt11972$temp;
                        data.m_128359_("WanderDistance", bedEntity.getWanderDistance().m_7912_());
                    }
                });
            }
        }
    }

    private Component fText(String format, Object ... args) {
        Component[] formattedArgs = new Component[args.length];
        for (int i = 0; i < args.length; ++i) {
            Component textComponent;
            Object object = args[i];
            formattedArgs[i] = object instanceof Component ? (textComponent = (Component)object) : Component.m_237113_((String)String.valueOf(args[i])).m_130940_(ChatFormatting.WHITE);
        }
        MutableComponent result = Component.m_237119_();
        String[] parts = format.split("%s", -1);
        for (int i = 0; i < parts.length; ++i) {
            result.m_7220_((Component)Component.m_237113_((String)parts[i]).m_130940_(ChatFormatting.GOLD));
            if (i >= formattedArgs.length) continue;
            result.m_7220_(formattedArgs[i]);
        }
        return result;
    }

    static {
        UID = ResourceLocation.m_214293_((String)"adorablehamsterpets", (String)"hamster_debug_info");
    }
}

