/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.mixin.server;

import com.mojang.authlib.GameProfile;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.ModBlocks;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.block.custom.SunflowerBlock;
import net.dawson.adorablehamsterpets.client.state.ClientShoulderHamsterData;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.DismountOrder;
import net.dawson.adorablehamsterpets.entity.AI.HamsterSniffForOreGoal;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.ShoulderLocation;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.entity.custom.HamsterTreeSearcherEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.item.custom.HamsterArmorItem;
import net.dawson.adorablehamsterpets.networking.ModPackets;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.dawson.adorablehamsterpets.util.TreeHeistUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements PlayerEntityAccessor {
    @Unique
    private static final int CHECK_INTERVAL_TICKS = 20;
    @Unique
    private static final int AHP_GUIDEBOOK_CHECK_INTERVAL_TICKS = 20;
    @Unique
    private static final long HEIST_MEMORY_DURATION = 24000L;
    @Unique
    private static final String AHP_NBT_GUIDEBOOK_HAS_KEY = "AHPHasGuideBook";
    @Unique
    private static final String AHP_NBT_GUIDEBOOK_INIT_KEY = "AHPGuideBookTrackingInit";
    @Unique
    private static final List<String> DISMOUNT_MESSAGE_KEYS = Arrays.asList("message.adorablehamsterpets.dismount.1", "message.adorablehamsterpets.dismount.2", "message.adorablehamsterpets.dismount.3", "message.adorablehamsterpets.dismount.4", "message.adorablehamsterpets.dismount.5", "message.adorablehamsterpets.dismount.6");
    @Unique
    private CompoundTag ahp$shoulderData = new CompoundTag();
    @Unique
    private transient ClientShoulderHamsterData adorablehamsterpets$clientShoulderData;
    @Unique
    private final transient ArrayDeque<ShoulderLocation> adorablehamsterpets$mountOrderQueue = new ArrayDeque();
    @Unique
    private int adorablehamsterpets$diamondCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$creeperCheckTimer = 0;
    @Unique
    private int adorablehamsterpets$diamondSoundCooldownTicks = 0;
    @Unique
    private int adorablehamsterpets$creeperSoundCooldownTicks = 0;
    @Unique
    private int ahp$guideBookCheckTimer = 0;
    @Unique
    private int ahp$sunflowerCheckTimer = 0;
    @Unique
    private String adorablehamsterpets$lastDismountMessageKey = "";
    @Unique
    private boolean adorablehamsterpets$isDiamondAlertConditionMet = false;
    @Unique
    private int adorablehamsterpets$lastGoldMessageIndex = -1;
    @Unique
    private boolean ahp$cachedHasGuideBook = false;
    @Unique
    private boolean ahp$guideBookTrackingInitialized = false;
    @Unique
    private final List<ScheduledTask> adorablehamsterpets$scheduledTasks = new ArrayList<ScheduledTask>();
    @Unique
    private final List<TreeHeistUtil.HeistRecord> ahp$heistHistory = new ArrayList<TreeHeistUtil.HeistRecord>();

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$onInit(Level world, BlockPos pos, float yaw, GameProfile gameProfile, CallbackInfo ci) {
        if (world.f_46443_) {
            this.adorablehamsterpets$clientShoulderData = new ClientShoulderHamsterData();
        }
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$writeNbt(CompoundTag nbt, CallbackInfo ci) {
        if (!this.ahp$shoulderData.m_128456_()) {
            nbt.m_128365_("ShoulderHamsters", (Tag)this.ahp$shoulderData);
        }
        if (!this.adorablehamsterpets$mountOrderQueue.isEmpty()) {
            ListTag mountOrderList = new ListTag();
            for (ShoulderLocation location : this.adorablehamsterpets$mountOrderQueue) {
                mountOrderList.add((Object)StringTag.m_129297_((String)location.name()));
            }
            nbt.m_128365_("MountOrderQueue", (Tag)mountOrderList);
        }
        if (this.adorablehamsterpets$lastGoldMessageIndex != -1) {
            nbt.m_128405_("LastGoldMessageIndex", this.adorablehamsterpets$lastGoldMessageIndex);
        }
        if (!this.ahp$heistHistory.isEmpty()) {
            ListTag historyList = new ListTag();
            long currentTime = this.m_9236_().m_46467_();
            for (TreeHeistUtil.HeistRecord record : this.ahp$heistHistory) {
                if (currentTime - record.timestamp() >= 24000L) continue;
                CompoundTag tag = new CompoundTag();
                tag.m_128356_("x", (long)record.pos().m_123341_());
                tag.m_128356_("y", (long)record.pos().m_123342_());
                tag.m_128356_("z", (long)record.pos().m_123343_());
                tag.m_128356_("t", record.timestamp());
                historyList.add((Object)tag);
            }
            if (!historyList.isEmpty()) {
                nbt.m_128365_("AHPHeistHistory", (Tag)historyList);
            }
        }
        nbt.m_128379_(AHP_NBT_GUIDEBOOK_HAS_KEY, this.ahp$cachedHasGuideBook);
        nbt.m_128379_(AHP_NBT_GUIDEBOOK_INIT_KEY, this.ahp$guideBookTrackingInitialized);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$readNbt(CompoundTag nbt, CallbackInfo ci) {
        if (nbt.m_128425_("ShoulderHamster", 10)) {
            CompoundTag oldHamsterNbt = nbt.m_128469_("ShoulderHamster");
            if (!oldHamsterNbt.m_128456_()) {
                CompoundTag newShoulderPetsNbt = new CompoundTag();
                newShoulderPetsNbt.m_128365_(ShoulderLocation.RIGHT_SHOULDER.name(), (Tag)oldHamsterNbt);
                this.ahp$shoulderData = newShoulderPetsNbt;
                this.adorablehamsterpets$mountOrderQueue.clear();
                this.adorablehamsterpets$mountOrderQueue.add(ShoulderLocation.RIGHT_SHOULDER);
                nbt.m_128473_("ShoulderHamster");
                AdorableHamsterPets.LOGGER.info("Migrated legacy shoulder hamster data for player {}.", (Object)this.m_5446_().getString());
            }
        } else if (nbt.m_128425_("ShoulderHamsters", 10)) {
            this.ahp$shoulderData = nbt.m_128469_("ShoulderHamsters");
        }
        this.adorablehamsterpets$mountOrderQueue.clear();
        if (nbt.m_128425_("MountOrderQueue", 9)) {
            ShoulderLocation[] mountOrderList = nbt.m_128437_("MountOrderQueue", 8);
            HashSet<ShoulderLocation> seenLocations = new HashSet<ShoulderLocation>();
            for (Tag tag : mountOrderList) {
                try {
                    ShoulderLocation location = ShoulderLocation.valueOf(tag.m_7916_());
                    if (seenLocations.contains((Object)location) || this.getShoulderHamster(location).m_128456_()) continue;
                    this.adorablehamsterpets$mountOrderQueue.add(location);
                    seenLocations.add(location);
                }
                catch (IllegalArgumentException e) {
                    AdorableHamsterPets.LOGGER.warn("Found invalid ShoulderLocation name in NBT: {}", (Object)tag.m_7916_());
                }
            }
        }
        if (this.adorablehamsterpets$mountOrderQueue.isEmpty() && this.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.info("Player {} has shoulder hamsters but empty mount queue. Rebuilding...", (Object)this.m_5446_().getString());
            for (ShoulderLocation shoulderLocation : ShoulderLocation.values()) {
                if (this.getShoulderHamster(shoulderLocation).m_128456_()) continue;
                this.adorablehamsterpets$mountOrderQueue.addLast(shoulderLocation);
            }
        }
        this.adorablehamsterpets$lastGoldMessageIndex = nbt.m_128425_("LastGoldMessageIndex", 3) ? nbt.m_128451_("LastGoldMessageIndex") : -1;
        this.ahp$heistHistory.clear();
        if (nbt.m_128425_("AHPHeistHistory", 9)) {
            ListTag historyList = nbt.m_128437_("AHPHeistHistory", 10);
            for (int i = 0; i < historyList.size(); ++i) {
                CompoundTag tag = historyList.m_128728_(i);
                BlockPos blockPos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
                long time = tag.m_128454_("t");
                this.ahp$heistHistory.add(new TreeHeistUtil.HeistRecord(blockPos, time));
            }
        }
        if (nbt.m_128425_(AHP_NBT_GUIDEBOOK_HAS_KEY, 1)) {
            this.ahp$cachedHasGuideBook = nbt.m_128471_(AHP_NBT_GUIDEBOOK_HAS_KEY);
        }
        if (nbt.m_128425_(AHP_NBT_GUIDEBOOK_INIT_KEY, 1)) {
            this.ahp$guideBookTrackingInitialized = nbt.m_128471_(AHP_NBT_GUIDEBOOK_INIT_KEY);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void adorablehamsterpets$onTick(CallbackInfo ci) {
        Player self = (Player)this;
        Level world = self.m_9236_();
        if (world.f_46443_) {
            return;
        }
        RandomSource random = world.m_213780_();
        AhpConfig config = AdorableHamsterPets.CONFIG;
        long currentTime = world.m_46467_();
        this.adorablehamsterpets$scheduledTasks.removeIf(task -> {
            if (currentTime >= task.executionTick()) {
                task.action().run();
                return true;
            }
            return false;
        });
        if (this.adorablehamsterpets$diamondSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$diamondSoundCooldownTicks;
        }
        if (this.adorablehamsterpets$creeperSoundCooldownTicks > 0) {
            --this.adorablehamsterpets$creeperSoundCooldownTicks;
        }
        this.tickGuideBookTracking();
        if (++this.ahp$sunflowerCheckTimer >= 20) {
            this.ahp$sunflowerCheckTimer = 0;
            if (Configs.AHP_WORLDGEN.enableGlowingSunflowers && !world.m_46461_()) {
                BlockPos playerPos = self.m_20183_();
                for (BlockPos pos : BlockPos.m_121940_((BlockPos)playerPos.m_7918_(-5, -3, -5), (BlockPos)playerPos.m_7918_(5, 3, 5))) {
                    BlockState state = world.m_8055_(pos);
                    if (!state.m_60713_((Block)ModBlocks.SUNFLOWER_BLOCK.get()) || !((Boolean)state.m_61143_((Property)SunflowerBlock.LIT)).booleanValue()) continue;
                    ModCriteria.WITNESS_GLOWING_SUNFLOWER.trigger((ServerPlayer)self);
                    break;
                }
            }
        }
        if (this.hasAnyShoulderHamster()) {
            if (config.enableShoulderDiamondDetection) {
                ++this.adorablehamsterpets$diamondCheckTimer;
                if (this.adorablehamsterpets$diamondCheckTimer >= 20) {
                    this.adorablehamsterpets$diamondCheckTimer = 0;
                    if (this.isCelebrationOreNearby(self, (Double)config.shoulderDiamondDetectionRadius.get())) {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = true;
                        if (this.adorablehamsterpets$diamondSoundCooldownTicks == 0) {
                            world.m_5594_(null, self.m_20183_(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_DIAMOND_SNIFF_SOUNDS, random), SoundSource.NEUTRAL, 2.5f, 1.0f);
                            self.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.diamond_nearby").m_130940_(ChatFormatting.AQUA), true);
                            this.adorablehamsterpets$diamondSoundCooldownTicks = random.m_216332_(140, 200);
                            ModCriteria.HAMSTER_DIAMOND_ALERT_TRIGGERED.trigger((ServerPlayer)self);
                        }
                    } else {
                        this.adorablehamsterpets$isDiamondAlertConditionMet = false;
                    }
                }
            }
            if (config.enableShoulderCreeperDetection) {
                ++this.adorablehamsterpets$creeperCheckTimer;
                if (this.adorablehamsterpets$creeperCheckTimer >= 20) {
                    this.adorablehamsterpets$creeperCheckTimer = 0;
                    if (this.creeperSeesPlayer(self, (Double)config.shoulderCreeperDetectionRadius.get()) && this.adorablehamsterpets$creeperSoundCooldownTicks == 0) {
                        world.m_5594_(null, self.m_20183_(), ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CREEPER_DETECT_SOUNDS, random), SoundSource.NEUTRAL, 1.0f, 1.0f);
                        self.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.creeper_detected").m_130940_(ChatFormatting.RED), true);
                        this.adorablehamsterpets$creeperSoundCooldownTicks = random.m_216332_(100, 160);
                        ModCriteria.HAMSTER_CREEPER_ALERT_TRIGGERED.trigger((ServerPlayer)self);
                    }
                }
            }
        }
    }

    @Inject(method={"remove(Lnet/minecraft/entity/Entity$RemovalReason;)V"}, at={@At(value="HEAD")})
    private void adorablehamsterpets$onRemove(Entity.RemovalReason reason, CallbackInfo ci) {
        if (!this.m_9236_().m_5776_()) {
            HamsterRenderTracker.onPlayerDisconnect(this.m_20148_());
        }
    }

    @Inject(method={"wakeUp(ZZ)V"}, at={@At(value="RETURN")})
    private void adorablehamsterpets$onWakeUp(boolean skipSleepTimer, boolean updateSleepingPlayers, CallbackInfo ci) {
        Player self = (Player)this;
        if (!self.m_9236_().f_46443_ && !skipSleepTimer) {
            ServerLevel serverWorld = (ServerLevel)self.m_9236_();
            UUID ownerUuid = self.m_20148_();
            ArrayList<HamsterEntity> stuckHamsters = new ArrayList<HamsterEntity>();
            for (Entity entity : serverWorld.m_143280_((EntityTypeTest)ModEntities.HAMSTER.get(), Entity::m_6084_)) {
                HamsterEntity hamster;
                if (!(entity instanceof HamsterEntity) || !(hamster = (HamsterEntity)entity).m_21824_() || !ownerUuid.equals(hamster.m_21805_()) || !hamster.isStuckSearchingForBed()) continue;
                stuckHamsters.add(hamster);
            }
            for (HamsterEntity hamster : stuckHamsters) {
                hamster.getLinkedBedPos().ifPresent(globalPos -> {
                    if (serverWorld.m_46472_() == globalPos.m_122640_()) {
                        BlockPos bedPos = globalPos.m_122646_();
                        BlockState bedState = serverWorld.m_8055_(bedPos);
                        if (bedState.m_60734_() instanceof HamsterBedBlock && !((Boolean)bedState.m_61143_((Property)HamsterBedBlock.OCCUPIED)).booleanValue()) {
                            Vec3 targetCenter = Vec3.m_82512_((Vec3i)bedPos).m_82520_(0.0, 0.1, 0.0);
                            hamster.m_7678_(targetCenter.f_82479_, targetCenter.f_82480_, targetCenter.f_82481_, 0.0f, 0.0f);
                            hamster.setDozingPhase(HamsterEntity.DozingPhase.DEEP_SLEEP);
                            hamster.setSleeping(true);
                            hamster.setRescueSleeping(true);
                            hamster.m_21837_(true);
                            serverWorld.m_7731_(bedPos, (BlockState)bedState.m_61124_((Property)HamsterBedBlock.OCCUPIED, (Comparable)Boolean.valueOf(true)), 3);
                            int personality = (Integer)hamster.m_20088_().m_135370_(HamsterEntity.ANIMATION_PERSONALITY_ID);
                            int poseIndex = personality >= 1 && personality <= 3 ? personality : 1;
                            hamster.m_20088_().m_135381_(HamsterEntity.CURRENT_DEEP_SLEEP_ANIM_ID, (Object)("anim_hamster_sleep_pose" + poseIndex));
                            hamster.startNapTimer();
                            hamster.setStuckSearchingForBed(false);
                            hamster.setWanderModeActive(true);
                            AdorableHamsterPets.LOGGER.info("Rescued stuck hamster {} to bed at {}", (Object)hamster.m_19879_(), (Object)bedPos);
                        } else {
                            hamster.setStuckSearchingForBed(false);
                        }
                    }
                });
            }
        }
    }

    @Override
    @Unique
    public boolean ahp$computeHasGuideBook(Player player) {
        Inventory inv = player.m_150109_();
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !stack.m_150930_((Item)ModItems.HAMSTER_GUIDE_BOOK.get())) continue;
            return true;
        }
        return false;
    }

    @Override
    @Unique
    public void ahp$initGuideBookTracking(boolean currentlyHasGuideBook) {
        this.ahp$cachedHasGuideBook = currentlyHasGuideBook;
        this.ahp$guideBookTrackingInitialized = true;
        this.ahp$guideBookCheckTimer = 0;
    }

    @Override
    @Unique
    public CompoundTag getShoulderHamster(ShoulderLocation location) {
        return this.ahp$shoulderData.m_128469_(location.name());
    }

    @Override
    @Unique
    public void setShoulderHamster(ShoulderLocation location, CompoundTag nbt) {
        if (nbt == null || nbt.m_128456_()) {
            this.ahp$shoulderData.m_128473_(location.name());
        } else {
            this.ahp$shoulderData.m_128365_(location.name(), (Tag)nbt);
        }
        if (!this.m_9236_().m_5776_()) {
            Object object;
            ModPackets.SyncShoulderDataS2CPacket packet = new ModPackets.SyncShoulderDataS2CPacket(this.m_19879_(), this.ahp$shoulderData);
            Player self = (Player)this;
            if (self instanceof ServerPlayer) {
                ServerPlayer serverSelf = (ServerPlayer)self;
                ModPackets.CHANNEL.sendToPlayer(serverSelf, (Object)packet);
            }
            if ((object = self.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)object;
                for (ServerPlayer otherPlayer : serverWorld.m_6907_()) {
                    if (otherPlayer == self || !(otherPlayer.m_20280_((Entity)self) < 6400.0)) continue;
                    ModPackets.CHANNEL.sendToPlayer(otherPlayer, (Object)packet);
                }
            }
        }
    }

    @Override
    @Unique
    public void adorablehamsterpets$setRawShoulderData(CompoundTag nbt) {
        this.ahp$shoulderData = nbt;
    }

    @Override
    @Unique
    public void adorablehamsterpets$syncShoulderData() {
        Player self;
        if (!this.m_9236_().m_5776_() && !this.ahp$shoulderData.m_128456_() && (self = (Player)this) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)self;
            ModPackets.SyncShoulderDataS2CPacket packet = new ModPackets.SyncShoulderDataS2CPacket(this.m_19879_(), this.ahp$shoulderData);
            ModPackets.CHANNEL.sendToPlayer(serverPlayer, (Object)packet);
        }
    }

    @Override
    @Unique
    public void adorablehamsterpets$dismountShoulderHamster(boolean isThrow) {
        BlockPos hitPos;
        ShoulderLocation locationToProcess;
        Player self = (Player)this;
        Level world = self.m_9236_();
        if (world.f_46443_) {
            return;
        }
        if (this.adorablehamsterpets$mountOrderQueue.isEmpty() && this.hasAnyShoulderHamster()) {
            AdorableHamsterPets.LOGGER.warn("[HamsterDismount] Player {} has shoulder hamsters but empty queue. Rebuilding...", (Object)self.m_7755_().getString());
            for (ShoulderLocation location : ShoulderLocation.values()) {
                if (this.getShoulderHamster(location).m_128456_()) continue;
                this.adorablehamsterpets$mountOrderQueue.addLast(location);
            }
        }
        if (this.adorablehamsterpets$mountOrderQueue.isEmpty()) {
            return;
        }
        AhpConfig config = AdorableHamsterPets.CONFIG;
        RandomSource random = world.m_213780_();
        ShoulderLocation shoulderLocation = locationToProcess = config.dismountOrder.get() == DismountOrder.LIFO ? this.adorablehamsterpets$mountOrderQueue.peekLast() : this.adorablehamsterpets$mountOrderQueue.peekFirst();
        if (locationToProcess == null) {
            return;
        }
        CompoundTag shoulderNbt = this.getShoulderHamster(locationToProcess);
        if (shoulderNbt.m_128456_()) {
            AdorableHamsterPets.LOGGER.warn("Dismount queue pointed to an empty slot ({}). Desync probable.", (Object)locationToProcess);
            if (config.dismountOrder.get() == DismountOrder.LIFO) {
                this.adorablehamsterpets$mountOrderQueue.pollLast();
            } else {
                this.adorablehamsterpets$mountOrderQueue.pollFirst();
            }
            return;
        }
        HamsterEntity hamster = HamsterEntity.createFromNbt((ServerLevel)world, self, shoulderNbt);
        if (hamster == null) {
            this.setShoulderHamster(locationToProcess, new CompoundTag());
            if (config.dismountOrder.get() == DismountOrder.LIFO) {
                this.adorablehamsterpets$mountOrderQueue.pollLast();
            } else {
                this.adorablehamsterpets$mountOrderQueue.pollFirst();
            }
            return;
        }
        HitResult hitResult = self.m_19907_(5.0, 0.0f, false);
        if (hitResult.m_6662_() == HitResult.Type.BLOCK && world.m_8055_(hitPos = ((BlockHitResult)hitResult).m_82425_()).m_60713_(Blocks.f_50050_)) {
            TreeHeistUtil.TreeScanResult scanResult = TreeHeistUtil.scanForTree(world, hitPos);
            if (HamsterTreeSearcherEntity.isTreeBlocked(world, scanResult.treeId())) {
                self.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.tree_heist.occupied").m_130940_(ChatFormatting.RED), true);
                return;
            }
            HamsterTreeSearcherEntity searcher = (HamsterTreeSearcherEntity)((EntityType)ModEntities.HAMSTER_TREE_SEARCHER.get()).m_20615_(world);
            if (searcher != null) {
                hamster.triggerLeafPopEffects(hitPos, false);
                CompoundTag fullNbt = new CompoundTag();
                hamster.m_20240_(fullNbt);
                searcher.initializeSearch(hitPos, scanResult, fullNbt);
                world.m_7967_((Entity)searcher);
                if (config.dismountOrder.get() == DismountOrder.LIFO) {
                    this.adorablehamsterpets$mountOrderQueue.pollLast();
                } else {
                    this.adorablehamsterpets$mountOrderQueue.pollFirst();
                }
                this.setShoulderHamster(locationToProcess, new CompoundTag());
                return;
            }
        }
        if (isThrow) {
            Item item;
            if (hamster.m_6162_()) {
                self.m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.baby_throw_refusal").m_130940_(ChatFormatting.RED), true);
                return;
            }
            long currentTime = world.m_46467_();
            if (hamster.throwCooldownEndTick > currentTime) {
                long remainingTicks = hamster.throwCooldownEndTick - currentTime;
                long totalSecondsRemaining = Math.max(1L, remainingTicks / 20L);
                self.m_5661_((Component)Component.m_237110_((String)"message.adorablehamsterpets.throw_cooldown", (Object[])new Object[]{totalSecondsRemaining}).m_130940_(ChatFormatting.RED), true);
                return;
            }
            hamster.m_7678_(self.m_20185_(), self.m_20188_() - 0.1, self.m_20189_(), self.m_146908_(), self.m_146909_());
            hamster.setThrown(true);
            hamster.interactionCooldown = 10;
            hamster.throwCooldownEndTick = currentTime + (long)((Integer)config.hamsterThrowCooldown.get()).intValue();
            boolean isBuffed = hamster.hasGreenBeanBuff();
            float throwSpeed = isBuffed ? ((Double)config.hamsterThrowVelocityBuffed.get()).floatValue() : ((Double)config.hamsterThrowVelocity.get()).floatValue();
            ItemStack armorStack = hamster.getArmorStack();
            if (!armorStack.m_41619_() && (item = armorStack.m_41720_()) instanceof HamsterArmorItem) {
                HamsterArmorItem armorItem = (HamsterArmorItem)item;
                if (((Boolean)config.enableArmorPerks.get()).booleanValue() && armorItem.getMaterial() == HamsterArmorItem.HamsterArmorMaterial.IRON) {
                    throwSpeed += ((Double)config.ironArmorThrowSpeedBoost.get()).floatValue();
                }
            }
            Vec3 lookVec = self.m_20252_(1.0f);
            Vec3 throwVec = new Vec3(lookVec.f_82479_, lookVec.f_82480_ + (double)0.1f, lookVec.f_82481_).m_82541_();
            hamster.m_20256_(throwVec.m_82490_((double)throwSpeed));
            hamster.f_19812_ = true;
        }
        if (config.dismountOrder.get() == DismountOrder.LIFO) {
            this.adorablehamsterpets$mountOrderQueue.pollLast();
        } else {
            this.adorablehamsterpets$mountOrderQueue.pollFirst();
        }
        this.setShoulderHamster(locationToProcess, new CompoundTag());
        HamsterEntity.spawnFromNbt((ServerLevel)world, self, shoulderNbt, this.adorablehamsterpets$isDiamondAlertConditionMet, hamster);
        this.adorablehamsterpets$isDiamondAlertConditionMet = false;
        if (isThrow) {
            world.m_6263_(null, self.m_20185_(), self.m_20186_(), self.m_20189_(), (SoundEvent)ModSounds.HAMSTER_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            this.adorablehamsterpets$scheduledTasks.add(new ScheduledTask(world.m_46467_() + 3L, () -> {
                SoundEvent celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_FLYING_SOUNDS, random);
                if (celebrationSound != null) {
                    world.m_6263_(null, self.m_20185_(), self.m_20186_(), self.m_20189_(), celebrationSound, SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }));
            ModCriteria.HAMSTER_THROWN.trigger((ServerPlayer)self);
        } else {
            world.m_5594_(null, self.m_20183_(), (SoundEvent)ModSounds.HAMSTER_DISMOUNT.get(), SoundSource.PLAYERS, 0.7f, 1.0f + random.m_188501_() * 0.2f);
            if (config.enableShoulderDismountMessages && !DISMOUNT_MESSAGE_KEYS.isEmpty()) {
                String chosenKey;
                if (DISMOUNT_MESSAGE_KEYS.size() == 1) {
                    chosenKey = DISMOUNT_MESSAGE_KEYS.get(0);
                } else {
                    ArrayList<String> availableKeys = new ArrayList<String>(DISMOUNT_MESSAGE_KEYS);
                    availableKeys.remove(this.adorablehamsterpets$lastDismountMessageKey);
                    chosenKey = availableKeys.isEmpty() ? this.adorablehamsterpets$lastDismountMessageKey : (String)availableKeys.get(random.m_188503_(availableKeys.size()));
                }
                self.m_5661_((Component)Component.m_237115_((String)chosenKey), true);
                this.adorablehamsterpets$lastDismountMessageKey = chosenKey;
            }
        }
    }

    @Override
    @Unique
    public boolean hasAnyShoulderHamster() {
        return !this.getShoulderHamster(ShoulderLocation.RIGHT_SHOULDER).m_128456_() || !this.getShoulderHamster(ShoulderLocation.LEFT_SHOULDER).m_128456_() || !this.getShoulderHamster(ShoulderLocation.HEAD).m_128456_();
    }

    @Override
    @Unique
    public int ahp_getLastGoldMessageIndex() {
        return this.adorablehamsterpets$lastGoldMessageIndex;
    }

    @Override
    @Unique
    public void ahp_setLastGoldMessageIndex(int index) {
        this.adorablehamsterpets$lastGoldMessageIndex = index;
    }

    @Override
    @Unique
    public ArrayDeque<ShoulderLocation> adorablehamsterpets$getMountOrderQueue() {
        return this.adorablehamsterpets$mountOrderQueue;
    }

    @Override
    @Unique
    public ClientShoulderHamsterData adorablehamsterpets$getClientShoulderData() {
        if (this.adorablehamsterpets$clientShoulderData == null && this.m_9236_().f_46443_) {
            this.adorablehamsterpets$clientShoulderData = new ClientShoulderHamsterData();
        }
        return this.adorablehamsterpets$clientShoulderData;
    }

    @Override
    @Unique
    public void ahp$registerTreeHeist(BlockPos treeId) {
        long time = this.m_9236_().m_46467_();
        this.ahp$heistHistory.add(new TreeHeistUtil.HeistRecord(treeId, time));
        this.ahp$heistHistory.removeIf(r -> time - r.timestamp() > 24000L);
    }

    @Override
    @Unique
    public float ahp$getHeistProfitability(BlockPos treeId) {
        long time = this.m_9236_().m_46467_();
        int initialSize = this.ahp$heistHistory.size();
        this.ahp$heistHistory.removeIf(r -> time - r.timestamp() > 24000L);
        int prunedSize = this.ahp$heistHistory.size();
        int matchCount = 0;
        ArrayList<Long> matchAges = new ArrayList<Long>();
        for (TreeHeistUtil.HeistRecord record : this.ahp$heistHistory) {
            if (!record.pos().equals((Object)treeId)) continue;
            ++matchCount;
            matchAges.add(time - record.timestamp());
        }
        float multiplier = matchCount == 0 ? 1.0f : (matchCount == 1 ? 0.6f : (matchCount == 2 ? 0.3f : 0.0f));
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Profitability] Calculating for Tree Anchor: {}\n  - Current World Time: {}\n  - Player History Size: {} (Pruned from {})\n  - Matches Found for this Tree: {}\n  - Match Ages (ticks ago): {} (Memory Limit: {})\n  - Calculated Multiplier: {}", new Object[]{treeId.m_123344_(), time, prunedSize, initialSize, matchCount, matchAges, 24000L, String.format("%.2f", Float.valueOf(multiplier))});
        }
        return multiplier;
    }

    @Override
    @Unique
    public void ahp$clearHeistHistory() {
        this.ahp$heistHistory.clear();
        AdorableHamsterPets.LOGGER.info("[TreeHeist] Cleared heist history for player {}.", (Object)this.m_7755_().getString());
        ((Player)this).m_5661_((Component)Component.m_237115_((String)"message.adorablehamsterpets.heist_history_reset").m_130940_(ChatFormatting.WHITE), true);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        if (!this.ahp$shoulderData.m_128456_()) {
            ModPackets.SyncShoulderDataS2CPacket packet = new ModPackets.SyncShoulderDataS2CPacket(this.m_19879_(), this.ahp$shoulderData);
            ModPackets.CHANNEL.sendToPlayer(player, (Object)packet);
        }
    }

    @Unique
    private void tickGuideBookTracking() {
        Player self = (Player)this;
        if (self.m_9236_().f_46443_) {
            return;
        }
        if (!(self instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)self;
        if (++this.ahp$guideBookCheckTimer < 20) {
            return;
        }
        this.ahp$guideBookCheckTimer = 0;
        if (!this.ahp$guideBookTrackingInitialized) {
            this.ahp$initGuideBookTracking(this.ahp$computeHasGuideBook((Player)player));
            return;
        }
        boolean hasNow = this.ahp$computeHasGuideBook((Player)player);
        if (hasNow && !this.ahp$cachedHasGuideBook) {
            ModPackets.CHANNEL.sendToPlayer(player, (Object)new ModPackets.PlayGuidebookEffectsS2CPacket(false));
        }
        this.ahp$cachedHasGuideBook = hasNow;
    }

    @Unique
    private boolean isCelebrationOreNearby(Player player, double radius) {
        Level world = player.m_9236_();
        BlockPos center = player.m_20183_();
        int intRadius = (int)Math.ceil(radius);
        ArrayList<BlockPos> exposedOres = new ArrayList<BlockPos>();
        ArrayList<BlockPos> buriedOres = new ArrayList<BlockPos>();
        for (BlockPos checkPos : BlockPos.m_121940_((BlockPos)center.m_7918_(-intRadius, -intRadius, -intRadius), (BlockPos)center.m_7918_(intRadius, intRadius, intRadius))) {
            BlockState state;
            if (!(checkPos.m_123331_((Vec3i)center) <= radius * radius) || !ConfigDataCache.isCelebrationOre(state = world.m_8055_(checkPos))) continue;
            if (HamsterSniffForOreGoal.isOreExposed(checkPos, world)) {
                exposedOres.add(checkPos.m_7949_());
                continue;
            }
            buriedOres.add(checkPos.m_7949_());
        }
        return !exposedOres.isEmpty() || !buriedOres.isEmpty();
    }

    @Unique
    private boolean creeperSeesPlayer(Player player, double radius) {
        AABB searchBox;
        Level world = player.m_9236_();
        List nearbyCreepers = world.m_6443_(Creeper.class, searchBox = new AABB(player.m_20182_().m_82492_(radius, radius, radius), player.m_20182_().m_82520_(radius, radius, radius)), creeper -> creeper.m_6084_() && creeper.m_5448_() == player && EntitySelector.f_20402_.test(creeper));
        return !nearbyCreepers.isEmpty();
    }

    @Unique
    private record ScheduledTask(long executionTick, Runnable action) {
    }
}

