/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.networking;

import dev.architectury.networking.NetworkChannel;
import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import java.util.function.Supplier;
import net.dawson.adorablehamsterpets.AdorableHamsterPetsClient;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.util.HamsterRenderTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ModPackets {
    public static final NetworkChannel CHANNEL = NetworkChannel.create((ResourceLocation)new ResourceLocation("adorablehamsterpets", "main"));

    public static void registerCommonPackets() {
        CHANNEL.register(ThrowHamsterC2SPacket.class, (packet, buf) -> {}, buf -> new ThrowHamsterC2SPacket(), (packet, context) -> ((NetworkManager.PacketContext)context.get()).queue(() -> ModPackets.lambda$registerCommonPackets$2((Supplier)context)));
        CHANNEL.register(DismountHamsterC2SPacket.class, (packet, buf) -> {}, buf -> new DismountHamsterC2SPacket(), (packet, context) -> ((NetworkManager.PacketContext)context.get()).queue(() -> ModPackets.lambda$registerCommonPackets$6((Supplier)context)));
        CHANNEL.register(UpdateRenderStateC2SPacket.class, (packet, buf) -> {
            buf.writeInt(packet.entityId());
            buf.writeBoolean(packet.isRendering());
        }, buf -> new UpdateRenderStateC2SPacket(buf.readInt(), buf.readBoolean()), (packet, context) -> ((NetworkManager.PacketContext)context.get()).queue(() -> ModPackets.lambda$registerCommonPackets$10(packet, (Supplier)context)));
        CHANNEL.register(RequestGuidebookC2SPacket.class, (packet, buf) -> {}, buf -> new RequestGuidebookC2SPacket(), (packet, context) -> ((NetworkManager.PacketContext)context.get()).queue(() -> ModPackets.lambda$registerCommonPackets$14((Supplier)context)));
        CHANNEL.register(RequestHamsterMountC2SPacket.class, (packet, buf) -> buf.writeInt(packet.entityId()), buf -> new RequestHamsterMountC2SPacket(buf.readInt()), (packet, context) -> ((NetworkManager.PacketContext)context.get()).queue(() -> ModPackets.lambda$registerCommonPackets$18((Supplier)context, packet)));
        CHANNEL.register(ResetHeistHistoryC2SPacket.class, (packet, buf) -> {}, buf -> new ResetHeistHistoryC2SPacket(), (packet, context) -> ((NetworkManager.PacketContext)context.get()).queue(() -> ModPackets.lambda$registerCommonPackets$22((Supplier)context)));
        CHANNEL.register(RequestHamsterRideC2SPacket.class, (packet, buf) -> buf.writeInt(packet.entityId()), buf -> new RequestHamsterRideC2SPacket(buf.readInt()), (packet, context) -> ((NetworkManager.PacketContext)context.get()).queue(() -> ModPackets.lambda$registerCommonPackets$26((Supplier)context, packet)));
        CHANNEL.register(HamsterInputC2SPacket.class, (packet, buf) -> {
            buf.writeBoolean(packet.jumpHeld());
            buf.writeBoolean(packet.sprintHeld());
        }, buf -> new HamsterInputC2SPacket(buf.readBoolean(), buf.readBoolean()), (packet, context) -> ((NetworkManager.PacketContext)context.get()).queue(() -> ModPackets.lambda$registerCommonPackets$30((Supplier)context, packet)));
        CHANNEL.register(SpawnBeddingParticlesS2CPacket.class, (packet, buf) -> {
            buf.m_130064_(packet.pos());
            buf.m_130068_((Enum)packet.direction());
            buf.m_130068_((Enum)packet.variant());
        }, buf -> new SpawnBeddingParticlesS2CPacket(buf.m_130135_(), (Direction)buf.m_130066_(Direction.class), (WoodVariant)buf.m_130066_(WoodVariant.class)), (packet, context) -> ((NetworkManager.PacketContext)context.get()).queue(() -> EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> AdorableHamsterPetsClient.handleSpawnBeddingParticles(packet))));
        CHANNEL.register(PlayGuidebookEffectsS2CPacket.class, (packet, buf) -> buf.writeBoolean(packet.closeScreen()), buf -> new PlayGuidebookEffectsS2CPacket(buf.readBoolean()), (packet, context) -> ((NetworkManager.PacketContext)context.get()).queue(() -> EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> AdorableHamsterPetsClient.handlePlayGuidebookEffects(packet))));
        CHANNEL.register(SyncShoulderDataS2CPacket.class, (packet, buf) -> {
            buf.writeInt(packet.entityId());
            buf.m_130079_(packet.data());
        }, buf -> new SyncShoulderDataS2CPacket(buf.readInt(), buf.m_130260_()), (packet, context) -> ((NetworkManager.PacketContext)context.get()).queue(() -> EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> AdorableHamsterPetsClient.handleSyncShoulderData(packet.entityId(), packet.data()))));
        CHANNEL.register(PlayDistantSoundS2CPacket.class, (packet, buf) -> {
            buf.m_130085_(packet.soundId());
            buf.writeFloat(packet.volume());
            buf.writeFloat(packet.pitch());
        }, buf -> new PlayDistantSoundS2CPacket(buf.m_130281_(), buf.readFloat(), buf.readFloat()), (packet, context) -> ((NetworkManager.PacketContext)context.get()).queue(() -> EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> AdorableHamsterPetsClient.handlePlayDistantSound(packet))));
    }

    private static /* synthetic */ void lambda$registerCommonPackets$30(Supplier context, HamsterInputC2SPacket packet) {
        HamsterEntity hamster;
        if (!((Boolean)Configs.AHP.enableMountableHamsters.get()).booleanValue()) {
            return;
        }
        Player player = ((NetworkManager.PacketContext)context.get()).getPlayer();
        Entity patt8139$temp = player.m_20202_();
        if (patt8139$temp instanceof HamsterEntity && (hamster = (HamsterEntity)patt8139$temp).m_6688_() == player) {
            hamster.setRiderInput(packet.jumpHeld(), packet.sprintHeld());
        }
    }

    private static /* synthetic */ void lambda$registerCommonPackets$26(Supplier context, RequestHamsterRideC2SPacket packet) {
        HamsterEntity hamster;
        if (!((Boolean)Configs.AHP.enableMountableHamsters.get()).booleanValue()) {
            return;
        }
        Player player = ((NetworkManager.PacketContext)context.get()).getPlayer();
        Entity entity = player.m_9236_().m_6815_(packet.entityId());
        if (entity instanceof HamsterEntity && (hamster = (HamsterEntity)entity).m_20280_((Entity)player) < 64.0) {
            hamster.putPlayerOnBack(player);
        }
    }

    private static /* synthetic */ void lambda$registerCommonPackets$22(Supplier context) {
        Player patt6568$temp = ((NetworkManager.PacketContext)context.get()).getPlayer();
        if (patt6568$temp instanceof PlayerEntityAccessor) {
            PlayerEntityAccessor accessor = (PlayerEntityAccessor)patt6568$temp;
            accessor.ahp$clearHeistHistory();
        }
    }

    private static /* synthetic */ void lambda$registerCommonPackets$18(Supplier context, RequestHamsterMountC2SPacket packet) {
        HamsterEntity hamster;
        Player player = ((NetworkManager.PacketContext)context.get()).getPlayer();
        Entity entity = player.m_9236_().m_6815_(packet.entityId());
        if (entity instanceof HamsterEntity && (hamster = (HamsterEntity)entity).m_21830_((LivingEntity)player) && hamster.m_20280_((Entity)player) < 64.0) {
            hamster.tryShoulderMount(player, ItemStack.f_41583_);
        }
    }

    private static /* synthetic */ void lambda$registerCommonPackets$14(Supplier context) {
        ServerPlayer player = (ServerPlayer)((NetworkManager.PacketContext)context.get()).getPlayer();
        ItemStack bookStack = new ItemStack((ItemLike)ModItems.HAMSTER_GUIDE_BOOK.get());
        CompoundTag nbt = bookStack.m_41784_();
        nbt.m_128359_("patchouli:book", "adorablehamsterpets:hamster_tips_guide_book");
        player.m_150109_().m_150079_(bookStack);
        ((PlayerEntityAccessor)player).ahp$initGuideBookTracking(true);
        CHANNEL.sendToPlayer(player, (Object)new PlayGuidebookEffectsS2CPacket(true));
    }

    private static /* synthetic */ void lambda$registerCommonPackets$10(UpdateRenderStateC2SPacket packet, Supplier context) {
        if (packet.isRendering()) {
            HamsterRenderTracker.addPlayer(packet.entityId(), ((NetworkManager.PacketContext)context.get()).getPlayer().m_20148_());
        } else {
            HamsterRenderTracker.removePlayer(packet.entityId(), ((NetworkManager.PacketContext)context.get()).getPlayer().m_20148_());
        }
    }

    private static /* synthetic */ void lambda$registerCommonPackets$6(Supplier context) {
        Player patt3382$temp = ((NetworkManager.PacketContext)context.get()).getPlayer();
        if (patt3382$temp instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)patt3382$temp;
            ((PlayerEntityAccessor)player).adorablehamsterpets$dismountShoulderHamster(false);
        }
    }

    private static /* synthetic */ void lambda$registerCommonPackets$2(Supplier context) {
        HamsterEntity.tryThrowFromShoulder((ServerPlayer)((NetworkManager.PacketContext)context.get()).getPlayer());
    }

    public record ThrowHamsterC2SPacket() {
    }

    public record DismountHamsterC2SPacket() {
    }

    public record UpdateRenderStateC2SPacket(int entityId, boolean isRendering) {
    }

    public record RequestGuidebookC2SPacket() {
    }

    public record RequestHamsterMountC2SPacket(int entityId) {
    }

    public record ResetHeistHistoryC2SPacket() {
    }

    public record RequestHamsterRideC2SPacket(int entityId) {
    }

    public record HamsterInputC2SPacket(boolean jumpHeld, boolean sprintHeld) {
    }

    public record SpawnBeddingParticlesS2CPacket(BlockPos pos, Direction direction, WoodVariant variant) {
    }

    public record PlayGuidebookEffectsS2CPacket(boolean closeScreen) {
    }

    public record SyncShoulderDataS2CPacket(int entityId, CompoundTag data) {
    }

    public record PlayDistantSoundS2CPacket(ResourceLocation soundId, float volume, float pitch) {
    }
}

