/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.screen;

import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.item.custom.HamsterArmorItem;
import net.dawson.adorablehamsterpets.screen.ModScreenHandlers;
import net.dawson.adorablehamsterpets.screen.slot.HamsterSlot;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class HamsterInventoryScreenHandler
extends AbstractContainerMenu {
    private final Container inventory;
    @Nullable
    private final HamsterEntity hamsterEntityInstance;
    private static final int INVENTORY_SIZE = 8;
    private static final int BLING_SLOT_INDEX = 6;
    private static final int ARMOR_SLOT_INDEX = 7;

    public HamsterInventoryScreenHandler(int syncId, Inventory playerInventory, @Nullable HamsterEntity hamsterEntity) {
        super((MenuType)ModScreenHandlers.HAMSTER_INVENTORY_SCREEN_HANDLER.get(), syncId);
        if (hamsterEntity != null) {
            this.inventory = hamsterEntity;
            this.hamsterEntityInstance = hamsterEntity;
            HamsterInventoryScreenHandler.m_38869_((Container)this.inventory, (int)8);
        } else {
            this.inventory = new SimpleContainer(8);
            this.hamsterEntityInstance = null;
        }
        this.inventory.m_5856_(playerInventory.f_35978_);
        this.setupSlots(playerInventory);
    }

    @Nullable
    public HamsterEntity getHamsterEntity() {
        return this.hamsterEntityInstance;
    }

    private void setupSlots(Inventory playerInventory) {
        int i;
        this.m_38897_(new HamsterSlot(this.inventory, 0, 26, 95));
        this.m_38897_(new HamsterSlot(this.inventory, 1, 44, 95));
        this.m_38897_(new HamsterSlot(this.inventory, 2, 62, 95));
        this.m_38897_(new Slot((Container)new SimpleContainer(1), 0, 80, 95){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public boolean m_8010_(Player playerEntity) {
                return false;
            }

            public boolean m_6659_() {
                return false;
            }
        });
        this.m_38897_(new HamsterSlot(this.inventory, 3, 98, 95));
        this.m_38897_(new HamsterSlot(this.inventory, 4, 116, 95));
        this.m_38897_(new HamsterSlot(this.inventory, 5, 134, 95));
        this.m_38897_(new Slot(this.inventory, 6, 82, 44){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_150930_((Item)ModItems.ACORN_HAT.get()) || stack.m_150930_(Items.f_271209_);
            }

            public int m_6641_() {
                return 1;
            }
        });
        this.m_38897_(new Slot(this.inventory, 7, 134, 44){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof HamsterArmorItem;
            }

            public int m_6641_() {
                return 1;
            }
        });
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 140 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 198));
        }
    }

    public boolean m_6875_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(slotIndex);
        if (slot.m_6657_()) {
            int totalHamsterSlots;
            ItemStack sourceStack = slot.m_7993_();
            itemStack = sourceStack.m_41777_();
            int playerStart = totalHamsterSlots = 9;
            int playerEnd = playerStart + 36;
            if (slotIndex < totalHamsterSlots) {
                boolean isBlingSlot;
                if (slotIndex == 3) {
                    return ItemStack.f_41583_;
                }
                boolean isFromHamster = slot.f_40218_ == this.inventory;
                boolean isArmorSlot = isFromHamster && slot.m_150661_() == 7;
                boolean bl = isBlingSlot = isFromHamster && slot.m_150661_() == 6;
                if (!this.m_38903_(sourceStack, playerStart, playerEnd, true)) {
                    return ItemStack.f_41583_;
                }
                if ((isArmorSlot || isBlingSlot) && this.hamsterEntityInstance != null && !this.hamsterEntityInstance.m_9236_().f_46443_) {
                    SoundEvent soundEvent = SoundEvents.f_11675_;
                    this.hamsterEntityInstance.m_5496_(soundEvent, 0.4f, 0.8f);
                }
            } else if (sourceStack.m_41720_() instanceof HamsterArmorItem) {
                if (!this.m_38903_(sourceStack, 8, 9, false) && !this.insertIntoPouches(sourceStack)) {
                    return ItemStack.f_41583_;
                }
            } else if (sourceStack.m_150930_((Item)ModItems.ACORN_HAT.get()) || sourceStack.m_150930_(Items.f_271209_)) {
                if (!this.m_38903_(sourceStack, 7, 8, false) && !this.insertIntoPouches(sourceStack)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (this.hamsterEntityInstance != null && this.hamsterEntityInstance.isItemDisallowed(sourceStack)) {
                    return ItemStack.f_41583_;
                }
                if (!this.insertIntoPouches(sourceStack)) {
                    return ItemStack.f_41583_;
                }
            }
            if (sourceStack.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (sourceStack.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, sourceStack);
        }
        return itemStack;
    }

    private boolean insertIntoPouches(ItemStack stack) {
        if (this.m_38903_(stack, 0, 3, false)) {
            return true;
        }
        return this.m_38903_(stack, 4, 7, false);
    }
}

