/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public class ClientParticleManager {
    public static final ClientParticleManager INSTANCE = new ClientParticleManager();
    private final Map<String, EmitterEntry> activeEmitters = new ConcurrentHashMap<String, EmitterEntry>();
    private static final int DEFAULT_TIMEOUT_TICKS = 60;

    private ClientParticleManager() {
    }

    public void addOrUpdate(BlockPos pos, String effectId, Consumer<Level> logic, BiPredicate<Level, BlockPos> validityCheck) {
        String key = pos.m_121878_() + ":" + effectId;
        this.activeEmitters.compute(key, (k, current) -> {
            if (current == null) {
                return new EmitterEntry(pos.m_7949_(), logic, validityCheck, 60);
            }
            current.timeoutTicks = 60;
            current.logic = logic;
            current.validityCheck = validityCheck;
            return current;
        });
    }

    public void tick(Level world) {
        if (world == null) {
            return;
        }
        Iterator<Map.Entry<String, EmitterEntry>> iterator = this.activeEmitters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, EmitterEntry> entry = iterator.next();
            EmitterEntry emitter = entry.getValue();
            if (emitter.validityCheck != null && !emitter.validityCheck.test(world, emitter.pos)) {
                iterator.remove();
                continue;
            }
            emitter.logic.accept(world);
            --emitter.timeoutTicks;
            if (emitter.timeoutTicks > 0) continue;
            iterator.remove();
        }
    }

    public void clear() {
        this.activeEmitters.clear();
    }

    private static class EmitterEntry {
        final BlockPos pos;
        Consumer<Level> logic;
        BiPredicate<Level, BlockPos> validityCheck;
        int timeoutTicks;

        EmitterEntry(BlockPos pos, Consumer<Level> logic, BiPredicate<Level, BlockPos> validityCheck, int timeoutTicks) {
            this.pos = pos;
            this.logic = logic;
            this.validityCheck = validityCheck;
            this.timeoutTicks = timeoutTicks;
        }
    }
}

