/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.mixin.accessor.LandPathNodeMakerInvoker;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;

public class HamsterPlacementUtil {
    private static final Set<BlockPathTypes> HAZARDOUS_FLOOR_TYPES = EnumSet.of(BlockPathTypes.LAVA, new BlockPathTypes[]{BlockPathTypes.DAMAGE_FIRE, BlockPathTypes.DANGER_FIRE, BlockPathTypes.POWDER_SNOW, BlockPathTypes.DAMAGE_OTHER, BlockPathTypes.DANGER_OTHER, BlockPathTypes.DAMAGE_CAUTIOUS, BlockPathTypes.WATER});

    public static void trySuffocationRescue(HamsterEntity hamster) {
        if (hamster.suffocationGracePeriod > 0 && hamster.m_5830_()) {
            Level world = hamster.m_9236_();
            BlockPos currentPos = hamster.m_20183_();
            Optional<BlockPos> safePosOpt = HamsterPlacementUtil.findSafeSpawnPosition(currentPos, world, 3, hamster);
            safePosOpt.ifPresent(safePos -> {
                hamster.m_7678_((double)safePos.m_123341_() + 0.5, safePos.m_123342_(), (double)safePos.m_123343_() + 0.5, hamster.m_146908_(), hamster.m_146909_());
                hamster.m_20334_(0.0, 0.0, 0.0);
                hamster.f_19812_ = true;
                AdorableHamsterPets.LOGGER.debug("[HamsterSelfRescue] Hamster {} rescued from {} to safe location {}.", new Object[]{hamster.m_19879_(), currentPos, safePos});
                hamster.suffocationGracePeriod = 0;
            });
        }
    }

    public static Optional<BlockPos> findSafeSpawnPosition(BlockPos initialTarget, Level world, int searchRadius, HamsterEntity hamster) {
        return HamsterPlacementUtil.findSafeSpawnPosition(initialTarget, world, searchRadius, Collections.emptySet(), hamster);
    }

    public static Optional<BlockPos> findSafeSpawnPosition(BlockPos initialTarget, Level world, int searchRadius, Set<BlockPos> occupiedPositions, HamsterEntity hamster) {
        if (HamsterPlacementUtil.isSafeSpawnLocation(initialTarget, world, hamster) && !occupiedPositions.contains(initialTarget)) {
            return Optional.of(initialTarget);
        }
        for (int i = 1; i <= 3; ++i) {
            BlockPos abovePos = initialTarget.m_6630_(i);
            if (!HamsterPlacementUtil.isSafeSpawnLocation(abovePos, world, hamster) || occupiedPositions.contains(abovePos)) continue;
            return Optional.of(abovePos);
        }
        for (int r = 1; r <= searchRadius; ++r) {
            for (int i = -r; i <= r; ++i) {
                for (int j = -r; j <= r; ++j) {
                    BlockPos checkPos;
                    if (Math.abs(i) != r && Math.abs(j) != r || !HamsterPlacementUtil.isSafeSpawnLocation(checkPos = initialTarget.m_7918_(i, 0, j), world, hamster) || occupiedPositions.contains(checkPos)) continue;
                    return Optional.of(checkPos);
                }
            }
        }
        return Optional.empty();
    }

    public static boolean isSafeSpawnLocation(BlockPos pos, Level world, HamsterEntity hamster) {
        BlockPathTypes bodyType = LandPathNodeMakerInvoker.callGetCommonNodeType((BlockGetter)world, pos);
        if (HAZARDOUS_FLOOR_TYPES.contains(bodyType)) {
            return false;
        }
        BlockPos floorPos = pos.m_7495_();
        BlockState floorState = world.m_8055_(floorPos);
        BlockPathTypes floorType = LandPathNodeMakerInvoker.callGetCommonNodeType((BlockGetter)world, floorPos);
        if (HAZARDOUS_FLOOR_TYPES.contains(floorType)) {
            return false;
        }
        if (floorState.m_60812_((BlockGetter)world, floorPos).m_83281_()) {
            return false;
        }
        CollisionContext entityContext = CollisionContext.m_82750_((Entity)hamster);
        return world.m_8055_(pos).m_60742_((BlockGetter)world, pos, entityContext).m_83281_() && world.m_8055_(pos.m_7494_()).m_60742_((BlockGetter)world, pos.m_7494_(), entityContext).m_83281_();
    }
}

