/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.TintedGlassBlock;
import net.minecraft.world.level.block.state.BlockState;

public final class IndoorOutdoorDetector {
    private static final int CACHE_SIZE_BUCKETS = 1024;
    private static final int CACHE_MAX_AGE_TICKS = 18;
    private static final int MIN_RECHECK_INTERVAL_TICKS = 8;
    private static final int MAX_RECHECK_INTERVAL_JITTER_TICKS = 6;
    private static final int HORIZONTAL_OPENNESS_RAY_COUNT = 12;
    private static final int HORIZONTAL_OPENNESS_RAY_MAX_DISTANCE_BLOCKS = 6;
    private static final int HORIZONTAL_OPENNESS_WALL_COLUMN_HEIGHT_BLOCKS = 2;
    private static final int HORIZONTAL_OPENNESS_STRONG_SKYLIGHT_THRESHOLD = 12;
    private static final float HORIZONTAL_OPENNESS_MIN_FRACTION_THRESHOLD = 0.35f;
    private static final int ROOF_CLEARANCE_VERTICAL_SEARCH_RANGE_BLOCKS = 6;
    private static final int SKYLIGHT_CLEAR_COLUMN_MAX_STEPS = 16;
    private static final float WEIGHT_HORIZONTAL_OPENNESS = 0.5f;
    private static final float WEIGHT_ROOF_CLEARANCE = 0.3f;
    private static final float WEIGHT_SKYLIGHT = 0.2f;
    private static final float OUTDOOR_SCORE_THRESHOLD = 0.56f;
    private static final float INDOOR_SCORE_THRESHOLD = 0.44f;
    private static final long[] cacheKeys = new long[1024];
    private static final long[] cacheLastTick = new long[1024];
    private static final int[] cacheNextInterval = new int[1024];
    private static final float[] cacheLastScore = new float[1024];
    private static final byte[] cacheLastState = new byte[1024];

    private IndoorOutdoorDetector() {
    }

    public static boolean isOutdoor(ClientLevel world, double x, double y, double z) {
        boolean needRecheck;
        if (!world.m_6042_().f_223549_()) {
            return false;
        }
        long nowTick = world.m_46467_();
        BlockPos basePos = BlockPos.m_274561_((double)x, (double)(y + 0.2), (double)z);
        long key = IndoorOutdoorDetector.keyFor(world, basePos);
        int idx = IndoorOutdoorDetector.bucketIndex(key);
        if (cacheKeys[idx] != key || nowTick - cacheLastTick[idx] > 18L) {
            IndoorOutdoorDetector.cacheKeys[idx] = key;
            IndoorOutdoorDetector.cacheLastTick[idx] = nowTick;
            IndoorOutdoorDetector.cacheNextInterval[idx] = IndoorOutdoorDetector.randomRecheckInterval(key);
            IndoorOutdoorDetector.cacheLastState[idx] = -1;
        }
        boolean bl = needRecheck = cacheLastState[idx] == -1 || nowTick - cacheLastTick[idx] >= (long)cacheNextInterval[idx];
        if (needRecheck) {
            float score;
            IndoorOutdoorDetector.cacheLastScore[idx] = score = IndoorOutdoorDetector.computeOutdoorScore(world, basePos);
            IndoorOutdoorDetector.cacheLastTick[idx] = nowTick;
            IndoorOutdoorDetector.cacheNextInterval[idx] = IndoorOutdoorDetector.randomRecheckInterval(key);
            byte previous = cacheLastState[idx];
            boolean newIsOutdoor = previous == -1 ? score >= 0.56f : (previous == 1 ? score >= 0.44f : score >= 0.56f);
            IndoorOutdoorDetector.cacheLastState[idx] = newIsOutdoor ? (byte)1 : 0;
        }
        return cacheLastState[idx] == 1;
    }

    private static float computeOutdoorScore(ClientLevel world, BlockPos pos) {
        float horizontalOpenFrac = IndoorOutdoorDetector.horizontalOpennessFraction(world, pos);
        float roofClearanceScore = IndoorOutdoorDetector.roofClearanceFactor(world, pos);
        float skylightScore = IndoorOutdoorDetector.skylightFactorCorrected(world, pos);
        float score = 0.5f * horizontalOpenFrac + 0.3f * roofClearanceScore + 0.2f * skylightScore;
        return Mth.m_14036_((float)score, (float)0.0f, (float)1.0f);
    }

    private static float horizontalOpennessFraction(ClientLevel world, BlockPos base) {
        int openDirections = 0;
        for (int i = 0; i < 12; ++i) {
            double ang = (float)Math.PI * 2 * (float)i / 12.0f;
            double cos = Math.cos(ang);
            double sin = Math.sin(ang);
            boolean reachedOpening = false;
            for (int d = 1; d <= 6 && !reachedOpening; ++d) {
                int sx = base.m_123341_() + (int)Math.round(cos * (double)d);
                int sz = base.m_123343_() + (int)Math.round(sin * (double)d);
                boolean hardBlocked = false;
                for (int h = 0; h < 2; ++h) {
                    BlockPos p = new BlockPos(sx, base.m_123342_() + h, sz);
                    if (!IndoorOutdoorDetector.isNonPorousWindBlock(world.m_8055_(p), world, p)) continue;
                    hardBlocked = true;
                    break;
                }
                if (hardBlocked) break;
                BlockPos check = new BlockPos(sx, base.m_123342_() + 1, sz);
                if (!world.m_45527_(check) && world.m_45517_(LightLayer.SKY, check) < 12) continue;
                reachedOpening = true;
                break;
            }
            if (!reachedOpening) continue;
            ++openDirections;
        }
        float frac = (float)openDirections / 12.0f;
        return frac < 0.35f ? frac * 0.8f : frac;
    }

    private static float roofClearanceFactor(ClientLevel world, BlockPos pos) {
        BlockPos checkPos;
        BlockState state;
        int clearance = 0;
        for (int i = 1; i <= 6 && !IndoorOutdoorDetector.isNonPorousWindBlock(state = world.m_8055_(checkPos = pos.m_6630_(i)), world, checkPos); ++i) {
            ++clearance;
        }
        return Mth.m_14036_((float)((float)clearance / 6.0f), (float)0.0f, (float)1.0f);
    }

    private static float skylightFactorCorrected(ClientLevel world, BlockPos pos) {
        if (!IndoorOutdoorDetector.columnToSkyIsClear(world, pos, 16)) {
            return 0.0f;
        }
        int sky = world.m_45517_(LightLayer.SKY, pos);
        return Mth.m_14036_((float)((float)sky / 15.0f), (float)0.0f, (float)1.0f);
    }

    private static boolean columnToSkyIsClear(ClientLevel world, BlockPos from, int maxSteps) {
        for (int dy = 1; dy <= maxSteps; ++dy) {
            BlockPos p = from.m_6630_(dy);
            BlockState s = world.m_8055_(p);
            if (IndoorOutdoorDetector.isGlassLike(s) || s.m_60734_() instanceof IronBarsBlock) {
                return false;
            }
            if (s.m_60795_() || s.m_60812_((BlockGetter)world, p).m_83281_()) continue;
            return false;
        }
        return true;
    }

    private static boolean isNonPorousWindBlock(BlockState s, ClientLevel world, BlockPos at) {
        if (s.m_60795_()) {
            return false;
        }
        Block block = s.m_60734_();
        if (block instanceof FenceBlock || block instanceof LeavesBlock) {
            return false;
        }
        if (IndoorOutdoorDetector.isGlassLike(s) || block instanceof IronBarsBlock) {
            return true;
        }
        return !s.m_60812_((BlockGetter)world, at).m_83281_();
    }

    private static boolean isGlassLike(BlockState state) {
        Block block = state.m_60734_();
        return block == Blocks.f_50058_ || block instanceof StainedGlassBlock || block instanceof TintedGlassBlock;
    }

    private static long keyFor(ClientLevel world, BlockPos pos) {
        int cellX = pos.m_123341_() >> 1;
        int cellZ = pos.m_123343_() >> 1;
        int yQuart = pos.m_123342_() >> 1;
        long dimHint = world.m_6042_().f_223549_() ? 1L : 2L;
        long k = dimHint << 48 ^ ((long)cellX & 0xFFFFL) << 32 ^ ((long)cellZ & 0xFFFFL) << 16 ^ (long)yQuart & 0xFFFFL;
        return IndoorOutdoorDetector.mix64(k, -3335678366873096957L);
    }

    private static int bucketIndex(long key) {
        return (int)(key & 0x3FFL);
    }

    private static int randomRecheckInterval(long key) {
        long m = IndoorOutdoorDetector.mix64(key, -7046029254386353131L);
        int jitter = (int)(m >>> 57 & 6L);
        return 8 + jitter;
    }

    private static long mix64(long seedA, long seedB) {
        long x = seedA * -7046029254386353131L + seedB + -4658895280553007687L;
        x ^= x >>> 30;
        x *= -4658895280553007687L;
        x ^= x >>> 27;
        x *= -7723592293110705685L;
        x ^= x >>> 31;
        return x;
    }

    static {
        for (int i = 0; i < cacheLastState.length; ++i) {
            IndoorOutdoorDetector.cacheLastState[i] = -1;
        }
    }
}

