/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import dev.architectury.event.events.common.LootEvent;
import java.util.List;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.AhpWorldGenConfig;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ModLootTableModifiers {
    private static final ResourceLocation OAK_LEAVES_ID = Blocks.f_50050_.m_60589_();
    private static final List<ResourceLocation> COMMON_LOOT_LOCATIONS = List.of(BuiltInLootTables.f_78740_, BuiltInLootTables.f_78742_, BuiltInLootTables.f_78759_, BuiltInLootTables.f_78755_, BuiltInLootTables.f_78758_, BuiltInLootTables.f_78757_, BuiltInLootTables.f_78756_, BuiltInLootTables.f_78754_, BuiltInLootTables.f_78748_, BuiltInLootTables.f_78749_, BuiltInLootTables.f_78694_, BuiltInLootTables.f_78696_, BuiltInLootTables.f_78690_);
    private static final List<ResourceLocation> UNCOMMON_LOOT_LOCATIONS = List.of(BuiltInLootTables.f_78742_, BuiltInLootTables.f_78759_, BuiltInLootTables.f_78764_, BuiltInLootTables.f_78686_, BuiltInLootTables.f_78688_, BuiltInLootTables.f_78701_, BuiltInLootTables.f_78695_, BuiltInLootTables.f_78691_, BuiltInLootTables.f_78745_, BuiltInLootTables.f_78743_, BuiltInLootTables.f_78744_);
    private static final List<ResourceLocation> HIGH_TIER_LOOT_LOCATIONS = List.of(BuiltInLootTables.f_78760_, BuiltInLootTables.f_78697_, BuiltInLootTables.f_78698_, BuiltInLootTables.f_78699_, BuiltInLootTables.f_78700_, BuiltInLootTables.f_78741_, BuiltInLootTables.f_78762_, BuiltInLootTables.f_78763_, BuiltInLootTables.f_230876_);
    private static final List<ResourceLocation> LEGENDARY_LOOT_LOCATIONS = List.of(BuiltInLootTables.f_230876_, BuiltInLootTables.f_78689_, BuiltInLootTables.f_78761_, BuiltInLootTables.f_78741_, BuiltInLootTables.f_78692_);

    public static void init() {
        LootEvent.MODIFY_LOOT_TABLE.register((resourceManager, tableId, context, builtin) -> {
            float advancedChance;
            float basicChance;
            float chance;
            AhpWorldGenConfig config = AdorableHamsterPets.WORLD_GEN_CONFIG;
            if (OAK_LEAVES_ID.equals((Object)tableId)) {
                chance = ((Float)config.oakLeavesAcornChance.get()).floatValue();
                context.addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)chance)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ACORN.get()))));
            }
            if (COMMON_LOOT_LOCATIONS.contains(tableId) && (chance = ((Float)config.seedLootChance.get()).floatValue()) > 0.0f) {
                context.addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)chance)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.GREEN_BEAN_SEEDS.get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.CUCUMBER_SEEDS.get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.SUNFLOWER_SEEDS.get())).m_79707_(1)).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))));
            }
            if (UNCOMMON_LOOT_LOCATIONS.contains(tableId) && (chance = ((Float)config.standardArmorLootChance.get()).floatValue()) > 0.0f) {
                context.addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)chance)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_ACORN.get())).m_79707_(3)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_IRON.get())).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_GOLD.get())).m_79707_(1)));
            }
            if (HIGH_TIER_LOOT_LOCATIONS.contains(tableId)) {
                float netheriteChance;
                float diamondChance = ((Float)config.highTierArmorLootChance.get()).floatValue();
                if (diamondChance > 0.0f) {
                    context.addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)diamondChance)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_DIAMOND.get()))));
                }
                if (((Boolean)config.enableNetheriteArmorLoot.get()).booleanValue() && (netheriteChance = ((Float)config.netheriteArmorLootChance.get()).floatValue()) > 0.0f) {
                    context.addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)netheriteChance)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_NETHERITE.get()))));
                }
            }
            if (LEGENDARY_LOOT_LOCATIONS.contains(tableId) && (chance = ((Float)config.accessoryLootChance.get()).floatValue()) > 0.0f) {
                context.addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)chance)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.ACORN_HAT.get()))));
            }
            if (HIGH_TIER_LOOT_LOCATIONS.contains(tableId) && (basicChance = ((Float)config.basicSmithingTemplateLootChance.get()).floatValue()) > 0.0f) {
                context.addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)basicChance)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_IRON.get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_GOLD.get())).m_79707_(1)));
            }
            if (LEGENDARY_LOOT_LOCATIONS.contains(tableId) && (advancedChance = ((Float)config.advancedSmithingTemplateLootChance.get()).floatValue()) > 0.0f) {
                context.addPool(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)advancedChance)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_DIAMOND.get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)ModItems.HAMSTER_ARMOR_TRIM_SMITHING_TEMPLATE_NETHERITE.get())).m_79707_(1)));
            }
        });
    }
}

