/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ParticleEffectsUtil {
    public static ParticleOptions createColoredEffect(float r, float g, float b) {
        return new ColoredEffect(r, g, b);
    }

    public static <T extends ParticleOptions> void spawnParticles(Level world, Vec3 center, T particle, int count, Vec3 spread, double speed) {
        ParticleEffectsUtil.spawnParticles(world, center, particle, count, spread.f_82479_, spread.f_82480_, spread.f_82481_, speed);
    }

    public static <T extends ParticleOptions> void spawnParticles(Level world, Vec3 center, T particle, int count, double spreadX, double spreadY, double spreadZ, double speed) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            if (particle instanceof ColoredEffect) {
                ColoredEffect colored = (ColoredEffect)particle;
                for (int i = 0; i < count; ++i) {
                    double offsetX = (serverWorld.f_46441_.m_188500_() - 0.5) * 2.0 * spreadX;
                    double offsetY = (serverWorld.f_46441_.m_188500_() - 0.5) * 2.0 * spreadY;
                    double offsetZ = (serverWorld.f_46441_.m_188500_() - 0.5) * 2.0 * spreadZ;
                    serverWorld.m_8767_((ParticleOptions)ParticleTypes.f_123811_, center.f_82479_ + offsetX, center.f_82480_ + offsetY, center.f_82481_ + offsetZ, 0, (double)colored.r, (double)colored.g, (double)colored.b, 1.0);
                }
                return;
            }
            serverWorld.m_8767_(particle, center.f_82479_, center.f_82480_, center.f_82481_, count, spreadX, spreadY, spreadZ, speed);
        } else {
            RandomSource random = world.m_213780_();
            for (int i = 0; i < count; ++i) {
                double offsetX = (random.m_188500_() - 0.5) * 2.0 * spreadX;
                double offsetY = (random.m_188500_() - 0.5) * 2.0 * spreadY;
                double offsetZ = (random.m_188500_() - 0.5) * 2.0 * spreadZ;
                double vx = (random.m_188500_() - 0.5) * speed;
                double vy = (random.m_188500_() - 0.5) * speed;
                double vz = (random.m_188500_() - 0.5) * speed;
                world.m_7106_(particle, center.f_82479_ + offsetX, center.f_82480_ + offsetY, center.f_82481_ + offsetZ, vx, vy, vz);
            }
        }
    }

    public static <T extends ParticleOptions> void spawnParticles(Level world, BlockPos pos, T particle, int count, double spreadX, double spreadY, double spreadZ, double speed) {
        ParticleEffectsUtil.spawnParticles(world, Vec3.m_82512_((Vec3i)pos), particle, count, spreadX, spreadY, spreadZ, speed);
    }

    public static <T extends ParticleOptions> void spawnParticles(Level world, BlockPos pos, double yOffset, T particle, int count, double spreadX, double spreadY, double spreadZ, double speed) {
        ParticleEffectsUtil.spawnParticles(world, Vec3.m_82539_((Vec3i)pos).m_82520_(0.0, yOffset, 0.0), particle, count, spreadX, spreadY, spreadZ, speed);
    }

    public static <T extends ParticleOptions> void spawnParticlesWithOffset(Entity entity, T particle, int count, double spreadX, double spreadY, double spreadZ, double speed, double yOffset) {
        Vec3 center = new Vec3(entity.m_20185_(), entity.m_20186_() + yOffset, entity.m_20189_());
        ParticleEffectsUtil.spawnParticles(entity.m_9236_(), center, particle, count, spreadX, spreadY, spreadZ, speed);
    }

    public static <T extends ParticleOptions> void spawnParticlesOnEntity(Entity entity, T particle, int count, double widthScale, double heightScale, double speed, double yOffset) {
        double spreadX = (double)entity.m_20205_() * widthScale / 2.0;
        double spreadY = (double)entity.m_20206_() * heightScale / 2.0;
        double spreadZ = (double)entity.m_20205_() * widthScale / 2.0;
        double centerY = entity.m_20186_() + (double)entity.m_20206_() / 2.0 + yOffset;
        Vec3 center = new Vec3(entity.m_20185_(), centerY, entity.m_20189_());
        ParticleEffectsUtil.spawnParticles(entity.m_9236_(), center, particle, count, spreadX, spreadY, spreadZ, speed);
    }

    public static <T extends ParticleOptions> void spawnMotionTrail(Entity entity, T particle, int countPerTick, double offsetMultiplier, double scatter, double velocityScale, double downwardVelocity) {
        Level world = entity.m_9236_();
        Vec3 velocity = entity.m_20184_();
        if (velocity.m_165925_() < 1.0E-6) {
            return;
        }
        RandomSource random = world.m_213780_();
        for (int i = 0; i < countPerTick; ++i) {
            double baseX = entity.m_20185_() - velocity.f_82479_ * offsetMultiplier;
            double baseY = entity.m_20186_() + (double)entity.m_20206_() / 2.0 - velocity.f_82480_ * offsetMultiplier;
            double baseZ = entity.m_20189_() - velocity.f_82481_ * offsetMultiplier;
            double spawnX = baseX + (random.m_188500_() - 0.5) * ((double)entity.m_20205_() * 0.8);
            double spawnY = baseY + (random.m_188500_() - 0.5) * ((double)entity.m_20206_() * 0.05);
            double spawnZ = baseZ + (random.m_188500_() - 0.5) * ((double)entity.m_20205_() * 0.8);
            Vec3 backwardsVel = velocity.m_82490_(-1.0 * velocityScale);
            double finalVelX = backwardsVel.f_82479_ + random.m_188583_() * scatter;
            double finalVelY = backwardsVel.f_82480_ + random.m_188583_() * scatter - downwardVelocity;
            double finalVelZ = backwardsVel.f_82481_ + random.m_188583_() * scatter;
            world.m_7106_(particle, spawnX, spawnY, spawnZ, finalVelX, finalVelY, finalVelZ);
        }
    }

    public static void spawnBreadcrumbs(ServerLevel world, @Nullable Path path) {
        if (path == null) {
            return;
        }
        int currentNodeIndex = path.m_77399_();
        int pathLength = path.m_77398_();
        for (int i = currentNodeIndex; i < pathLength; ++i) {
            Node node = path.m_77375_(i);
            Vec3 directionVector = Vec3.f_82478_;
            if (i + 1 < pathLength) {
                Node nextNode = path.m_77375_(i + 1);
                directionVector = new Vec3((double)(nextNode.f_77271_ - node.f_77271_), 0.0, (double)(nextNode.f_77273_ - node.f_77273_)).m_82541_();
            }
            for (int p = 0; p < 3; ++p) {
                double distanceAlongPath = world.m_213780_().m_188500_();
                Vec3 pathOffset = directionVector.m_82490_(distanceAlongPath);
                double offsetY = (world.m_213780_().m_188500_() - 0.5) * 0.1;
                ParticleEffectsUtil.spawnParticles((Level)world, new Vec3((double)node.f_77271_ + 0.5 + pathOffset.f_82479_, (double)node.f_77272_ + 0.5 - 0.38 + offsetY, (double)node.f_77273_ + 0.5 + pathOffset.f_82481_), ParticleTypes.f_123757_, 1, 0.2, 0.0, 0.2, 3.0);
            }
        }
    }

    public static void spawnSpinningRing(Level world, BlockPos centerPos, ParticleOptions particle, int count, double radius, double ringThickness, double rotationSpeed, double bobbingHeight, double upwardVelocity, double yOffset) {
        double timeOffset = (double)world.m_46467_() * rotationSpeed;
        double bobbingTimeOffset = (double)world.m_46467_() * (rotationSpeed / 1.5);
        double angleStep = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double angle = timeOffset + (double)i * angleStep;
            double currentRadius = radius + (world.m_213780_().m_188500_() - 0.5) * ringThickness;
            double x = (double)centerPos.m_123341_() + 0.5 + Math.cos(angle) * currentRadius;
            double z = (double)centerPos.m_123343_() + 0.5 + Math.sin(angle) * currentRadius;
            double y = (double)centerPos.m_123342_() + 0.5 + yOffset + Math.sin(bobbingTimeOffset) * bobbingHeight;
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                serverWorld.m_8767_(particle, x, y, z, 0, 0.0, upwardVelocity, 0.0, 1.0);
                continue;
            }
            world.m_7106_(particle, x, y, z, 0.0, upwardVelocity, 0.0);
        }
    }

    public static <T extends ParticleOptions> void spawnSphericalShell(Level world, Vec3 center, T particle, int count, double baseRadius, double radiusVariance) {
        RandomSource random = world.m_213780_();
        for (int i = 0; i < count; ++i) {
            double rZ;
            double rY;
            double rX = random.m_188500_() - 0.5;
            double dist = Math.sqrt(rX * rX + (rY = random.m_188500_() - 0.5) * rY + (rZ = random.m_188500_() - 0.5) * rZ);
            if (dist < 1.0E-4) {
                dist = 1.0;
            }
            double radius = baseRadius + random.m_188500_() * radiusVariance;
            double offsetX = rX / dist * radius;
            double offsetY = rY / dist * radius;
            double offsetZ = rZ / dist * radius;
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                serverWorld.m_8767_(particle, center.f_82479_ + offsetX, center.f_82480_ + offsetY, center.f_82481_ + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                continue;
            }
            world.m_7106_(particle, center.f_82479_ + offsetX, center.f_82480_ + offsetY, center.f_82481_ + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    private record ColoredEffect(float r, float g, float b) implements ParticleOptions
    {
        public ParticleType<?> m_6012_() {
            return ParticleTypes.f_123811_;
        }

        public void m_7711_(FriendlyByteBuf buf) {
        }

        public String m_5942_() {
            return "ahp_colored_effect";
        }
    }
}

