/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class TreeHeistUtil {
    private static final int MAX_TRUNK_SEARCH_DIST = 10;
    private static final int MAX_LOG_COUNT = 128;
    private static final int MAX_CANOPY_COUNT = 300;
    private static final int MAX_BUSH_COUNT = 48;
    private static final int MAX_CANOPY_DISTANCE = 5;

    public static TreeScanResult scanForTree(Level world, BlockPos startPos) {
        BlockPos foundLog;
        BlockState startState = world.m_8055_(startPos);
        if (!startState.m_60713_(Blocks.f_50050_)) {
            if (Configs.AHP.debugTreeDetection) {
                AdorableHamsterPets.LOGGER.warn("[TreeHeist-Scan] Aborted: Start pos {} is not an Oak Leaf block (Found: {}).", (Object)startPos.m_123344_(), (Object)startState.m_60734_());
            }
            return new TreeScanResult(startPos, Collections.singleton(startPos));
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] Starting scan at HitPos: {}. Searching for connected logs...", (Object)startPos.m_123344_());
        }
        if ((foundLog = TreeHeistUtil.findConnectedLog(world, startPos)) != null) {
            if (Configs.AHP.debugTreeDetection) {
                AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] LOG FOUND at {}. Switching to Tree Map Mode.", (Object)foundLog.m_123344_());
            }
            return TreeHeistUtil.mapTreeFromLog(world, foundLog);
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] NO LOG FOUND within range. Switching to Floating Bush Mode.");
        }
        return TreeHeistUtil.mapFloatingBush(world, startPos);
    }

    private static BlockPos findConnectedLog(Level world, BlockPos startNode) {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        queue.add(startNode);
        visited.add(startNode);
        int startDist = TreeHeistUtil.getLeafDistance(world.m_8055_(startNode));
        int iterations = 0;
        int maxIterations = 64;
        while (!queue.isEmpty() && iterations < maxIterations) {
            BlockPos current = (BlockPos)queue.poll();
            ++iterations;
            for (Direction dir : Direction.values()) {
                int dist;
                BlockPos neighbor = current.m_121945_(dir);
                if (!visited.add(neighbor)) continue;
                BlockState state = world.m_8055_(neighbor);
                if (state.m_204336_(BlockTags.f_13106_)) {
                    return neighbor;
                }
                if (!state.m_60713_(Blocks.f_50050_) || (dist = TreeHeistUtil.getLeafDistance(state)) > startDist && dist >= 7 || neighbor.m_123333_((Vec3i)startNode) > 10) continue;
                queue.add(neighbor);
            }
        }
        return null;
    }

    private static TreeScanResult mapTreeFromLog(Level world, BlockPos initialLog) {
        HashSet<BlockPos> treeLogs = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> logQueue = new ArrayDeque<BlockPos>();
        logQueue.add(initialLog);
        treeLogs.add(initialLog);
        BlockPos bottomMostLog = initialLog;
        while (!logQueue.isEmpty() && treeLogs.size() < 128) {
            BlockPos current = (BlockPos)logQueue.poll();
            if (current.m_123342_() < bottomMostLog.m_123342_()) {
                bottomMostLog = current;
            } else if (current.m_123342_() == bottomMostLog.m_123342_() && (current.m_123341_() < bottomMostLog.m_123341_() || current.m_123341_() == bottomMostLog.m_123341_() && current.m_123343_() < bottomMostLog.m_123343_())) {
                bottomMostLog = current;
            }
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos neighbor;
                        if (x == 0 && y == 0 && z == 0 || treeLogs.contains(neighbor = current.m_7918_(x, y, z)) || !world.m_8055_(neighbor).m_204336_(BlockTags.f_13106_)) continue;
                        treeLogs.add(neighbor);
                        logQueue.add(neighbor);
                    }
                }
            }
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] Tree Skeleton Mapped. Total Logs: {}. Anchor Established: {}", (Object)treeLogs.size(), (Object)bottomMostLog.m_123344_());
            if (treeLogs.size() >= 128) {
                AdorableHamsterPets.LOGGER.warn("[TreeHeist-Scan] Log scan hit MAX limit ({})! Tree might be truncated.", (Object)128);
            }
        }
        HashSet<BlockPos> validCanopy = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> leafQueue = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> visitedLeaves = new HashSet<BlockPos>();
        for (BlockPos log : treeLogs) {
            for (Direction dir : Direction.values()) {
                int nDist;
                BlockState nState;
                BlockPos n = log.m_121945_(dir);
                if (treeLogs.contains(n) || !visitedLeaves.add(n) || !(nState = world.m_8055_(n)).m_60713_(Blocks.f_50050_) || (nDist = TreeHeistUtil.getLeafDistance(nState)) > 5) continue;
                leafQueue.add(n);
            }
        }
        while (!leafQueue.isEmpty() && validCanopy.size() < 300) {
            BlockPos current = (BlockPos)leafQueue.poll();
            BlockState state = world.m_8055_(current);
            if (!state.m_204336_(BlockTags.f_13035_)) continue;
            int dist = TreeHeistUtil.getLeafDistance(state);
            validCanopy.add(current);
            for (Direction dir : Direction.values()) {
                int nDist;
                BlockState nState;
                BlockPos n = current.m_121945_(dir);
                if (treeLogs.contains(n) || !visitedLeaves.add(n) || !(nState = world.m_8055_(n)).m_60713_(Blocks.f_50050_) || (nDist = TreeHeistUtil.getLeafDistance(nState)) > 5 || nDist < dist) continue;
                leafQueue.add(n);
            }
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] Canopy Mapped. Valid Oak Leaves: {}", (Object)validCanopy.size());
            if (validCanopy.size() >= 300) {
                AdorableHamsterPets.LOGGER.warn("[TreeHeist-Scan] Canopy scan hit MAX limit ({})!", (Object)300);
            }
        }
        return new TreeScanResult(bottomMostLog, validCanopy);
    }

    private static TreeScanResult mapFloatingBush(Level world, BlockPos startPos) {
        HashSet<BlockPos> validLeaves = new HashSet<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(startPos);
        visited.add(startPos);
        validLeaves.add(startPos);
        BlockPos lowestLeaf = startPos;
        while (!queue.isEmpty() && validLeaves.size() < 48) {
            BlockPos current = (BlockPos)queue.poll();
            if (current.m_123342_() < lowestLeaf.m_123342_() || current.m_123342_() == lowestLeaf.m_123342_() && current.m_123341_() < lowestLeaf.m_123341_() || current.m_123342_() == lowestLeaf.m_123342_() && current.m_123341_() == lowestLeaf.m_123341_() && current.m_123343_() < lowestLeaf.m_123343_()) {
                lowestLeaf = current;
            }
            for (Direction dir : Direction.values()) {
                BlockPos n = current.m_121945_(dir);
                if (!visited.add(n) || !world.m_8055_(n).m_60713_(Blocks.f_50050_)) continue;
                queue.add(n);
                validLeaves.add(n);
            }
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] Bush Mapped. Size: {}. Anchor: {}", (Object)validLeaves.size(), (Object)lowestLeaf.m_123344_());
        }
        return new TreeScanResult(lowestLeaf, validLeaves);
    }

    private static int getLeafDistance(BlockState state) {
        if (state.m_61138_((Property)LeavesBlock.f_54418_)) {
            return (Integer)state.m_61143_((Property)LeavesBlock.f_54418_);
        }
        return 7;
    }

    public static void spawnDebugParticles(Level world, BlockPos anchor, List<Long> leafLongs) {
        if (world.f_46443_ || !(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        if (anchor != null) {
            ParticleEffectsUtil.spawnSpinningRing(world, anchor, (ParticleOptions)ParticleTypes.f_175828_, 10, 0.85, 0.0, 0.7, 0.55, 3.0, 0.0);
        }
        if (!leafLongs.isEmpty()) {
            int particleCount = 200;
            for (int i = 0; i < particleCount; ++i) {
                long leafPosLong = leafLongs.get(world.m_213780_().m_188503_(leafLongs.size()));
                BlockPos leafPos = BlockPos.m_122022_((long)leafPosLong);
                ParticleEffectsUtil.spawnSphericalShell(world, Vec3.m_82512_((Vec3i)leafPos), ParticleTypes.f_175829_, 1, 0.7, 0.2);
            }
        }
    }

    public static void spawnDebugParticles(Level world, TreeScanResult result) {
        if (world.f_46443_) {
            return;
        }
        ArrayList<Long> longs = new ArrayList<Long>();
        for (BlockPos p : result.validCanopyPositions()) {
            longs.add(p.m_121878_());
        }
        TreeHeistUtil.spawnDebugParticles(world, result.treeId(), longs);
    }

    public static BlockPos findExitPosition(Level world, BlockPos startPos) {
        BlockPos check;
        for (int y = 1; y <= 15; ++y) {
            check = startPos.m_6625_(y);
            if (!TreeHeistUtil.isSafeExit(world, check)) continue;
            return check;
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos check2 = startPos.m_121945_(dir);
            if (!TreeHeistUtil.isSafeExit(world, check2)) continue;
            return check2;
        }
        for (int y = 1; y <= 5; ++y) {
            check = startPos.m_6630_(y);
            if (!TreeHeistUtil.isSafeExit(world, check)) continue;
            return check;
        }
        return startPos;
    }

    private static boolean isSafeExit(Level world, BlockPos pos) {
        if (!world.m_8055_(pos).m_60812_((BlockGetter)world, pos).m_83281_()) {
            return false;
        }
        BlockPos below = pos.m_7495_();
        if (world.m_8055_(below).m_60812_((BlockGetter)world, below).m_83281_()) {
            return true;
        }
        return !TreeHeistUtil.isSmallPocket(world, pos);
    }

    private static boolean isSmallPocket(Level world, BlockPos startPos) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        queue.add(startPos);
        visited.add(startPos);
        int airCount = 0;
        int limit = 5;
        while (!queue.isEmpty()) {
            BlockPos current = (BlockPos)queue.poll();
            if (++airCount >= limit) {
                return false;
            }
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                BlockPos neighbor = current.m_121945_(dir);
                if (visited.contains(neighbor) || !world.m_8055_(neighbor).m_60812_((BlockGetter)world, neighbor).m_83281_()) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
        return true;
    }

    public static void sendHeistStartMessage(Player player, float profitability) {
        if (!Configs.AHP.enableTreeHeistStartMessage) {
            return;
        }
        String key = "message.adorablehamsterpets.tree_heist_start.high";
        ChatFormatting color = ChatFormatting.WHITE;
        if (profitability < 0.4f) {
            key = "message.adorablehamsterpets.tree_heist_start.low";
        } else if (profitability < 0.9f) {
            key = "message.adorablehamsterpets.tree_heist_start.medium";
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist] Starting heist for player {}. Profitability: {} ({}%). Selected Message Key: {}", new Object[]{player.m_7755_().getString(), String.format("%.2f", Float.valueOf(profitability)), (int)(profitability * 100.0f), key});
        }
        player.m_5661_((Component)Component.m_237115_((String)key).m_130940_(color), true);
    }

    public record TreeScanResult(BlockPos treeId, Set<BlockPos> validCanopyPositions) {
    }

    public record HeistRecord(BlockPos pos, long timestamp) {
    }
}

