/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.client.particle;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.IndoorOutdoorDetector;
import net.minecraft.class_2400;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;

public class HamsterBeddingParticle
extends class_4003 {
    public static final double BEDDING_ITEM_FLAG = -1.23E-4;
    private static final float UNIVERSAL_DRIFT_ACCEL = 0.002f;
    private static final float DRIFT_PERIOD_TICKS = 3600.0f;
    private static final float SWAY_ROTATION_AMPLITUDE = 0.5f;
    private static final float SWAY_ROTATION_SPEED_MOD = 2.8f;
    private static final float UPWARD_BOOST_AT_APEX = 0.004f;
    private static final float HORIZ_SPEED_CAP = 0.08f;
    private static final int GUST_WINDOW_TICKS = 100;
    private static final float GUST_PROB_PER_WIN = 0.35f;
    private static final int GUST_MIN_LEN = 20;
    private static final int GUST_MAX_LEN = 40;
    private static final int GUST_CELL_BLOCKS = 12;
    private static final float GUST_UP_ACCEL = 0.025f;
    private static final float GUST_HORIZ_ACCEL = 0.06f;
    private static final float GUST_SPIN_IMPULSE = 2.0f;
    private static final float GUST_SPIN_DAMP = 0.85f;
    private static final float COUPLING_MIN = 0.12f;
    private static final float COUPLING_SPAN = 0.78f;
    private static final int PER_PARTICLE_DELAY_MAX = 8;
    private static final float WIND_DRAG = 0.1f;
    private static final float WIND_TARGET_SPEED = 0.09f;
    private static final float GUST_RISE_FRAC = 0.3f;
    private static final float EXTRA_HCAP = 0.075f;
    private static final Set<Long> playedGustSoundsThisTick = new HashSet<Long>();
    private static final Deque<Long> soundStartTimes = new ArrayDeque<Long>();
    private static final int MAX_CONCURRENT_SOUNDS = 3;
    private static final int SOUND_DURATION_TICKS = 65;
    private static long lastTick = -1L;
    private final boolean useFloatyPhysics;
    private long lastAppliedGustKey = Long.MIN_VALUE;
    private final float swayFrequency;
    private final float swayAcceleration;
    private final float swayPhaseOffset;
    private final float swayDirectionX;
    private final float swayDirectionZ;
    private final float constantRollVelocity;
    private float gustSpinVel = 0.0f;
    private float gustCoupling = 0.0f;
    private int gustDelayTicks = 0;

    public HamsterBeddingParticle(class_638 world, double x, double y, double z, double vx, double vy, double vz, class_4002 sprites) {
        super(world, x, y, z, vx, vy, vz);
        boolean bl = this.useFloatyPhysics = vy == -1.23E-4;
        if (this.useFloatyPhysics) {
            this.field_3869 = 0.0;
            this.field_3844 = 0.07f;
            this.field_28786 = 0.92f;
            this.field_3847 = 140 + world.field_9229.method_43048(200);
            float theta = world.field_9229.method_43057() * ((float)Math.PI * 2);
            this.swayDirectionX = class_3532.method_15362((float)theta);
            this.swayDirectionZ = class_3532.method_15374((float)theta);
            this.swayFrequency = 0.09f + world.field_9229.method_43057() * 0.05f;
            this.swayAcceleration = 0.002f + world.field_9229.method_43057() * 0.0025f;
            this.swayPhaseOffset = world.field_9229.method_43057() * ((float)Math.PI * 2);
            this.constantRollVelocity = (world.field_9229.method_43057() - 0.5f) * 0.12f;
        } else {
            this.field_3844 = 0.6f;
            this.field_28786 = 0.9f;
            this.field_3847 = 20 + world.field_9229.method_43048(39);
            this.swayDirectionX = 0.0f;
            this.swayDirectionZ = 0.0f;
            this.swayFrequency = 0.0f;
            this.swayAcceleration = 0.0f;
            this.swayPhaseOffset = 0.0f;
            this.constantRollVelocity = 0.0f;
        }
        this.method_18141(sprites.method_18139(this.field_3840));
        this.method_3080(1.0f, 1.0f);
    }

    public void method_3070() {
        long worldTime = this.field_3851.method_8510();
        if (worldTime != lastTick) {
            playedGustSoundsThisTick.clear();
            while (!soundStartTimes.isEmpty() && worldTime - soundStartTimes.peekFirst() > 65L) {
                soundStartTimes.pollFirst();
            }
            lastTick = worldTime;
        }
        if (this.useFloatyPhysics) {
            float dynamicHorizontalCap;
            float horizontalSpeedSquared;
            float universalDriftAngle;
            if (((Boolean)Configs.AHP.enableDynamicDriftAngle.get()).booleanValue()) {
                float timeWithPartial = (float)worldTime + class_310.method_1551().method_1488();
                universalDriftAngle = timeWithPartial / 3600.0f * ((float)Math.PI * 2);
            } else {
                universalDriftAngle = (float)Math.toRadians(((Integer)Configs.AHP.staticDriftAngle.get()).intValue());
            }
            float driftDirX = class_3532.method_15362((float)universalDriftAngle);
            float driftDirZ = class_3532.method_15374((float)universalDriftAngle);
            boolean isOutdoor = IndoorOutdoorDetector.isOutdoor(this.field_3851, this.field_3874, this.field_3854, this.field_3871);
            if (isOutdoor) {
                this.field_3852 += (double)(driftDirX * 0.002f);
                this.field_3850 += (double)(driftDirZ * 0.002f);
            }
            float phase = ((float)this.field_3866 + this.swayPhaseOffset) * this.swayFrequency;
            float sinPhase = class_3532.method_15374((float)phase);
            float cosPhase = class_3532.method_15362((float)phase);
            float positionInSwing = Math.abs(cosPhase);
            float speedMultiplier = 0.5f + 1.5f * positionInSwing;
            float modifiedAcceleration = sinPhase * this.swayAcceleration * speedMultiplier;
            this.field_3852 += (double)(this.swayDirectionX * modifiedAcceleration);
            this.field_3850 += (double)(this.swayDirectionZ * modifiedAcceleration);
            this.field_3869 += (double)(0.004f * (float)Math.pow(positionInSwing, 4.0));
            float gustStrengthLocal = 0.0f;
            if (isOutdoor) {
                Gust gust = HamsterBeddingParticle.sampleGust(this.field_3851, this.field_3874, this.field_3871);
                if (gust.active) {
                    if (gust.key != this.lastAppliedGustKey) {
                        float vol;
                        if (soundStartTimes.size() < 3 && playedGustSoundsThisTick.add(gust.key) && (vol = ((Float)Configs.AHP.leafGustVolume.get()).floatValue()) > 0.0f) {
                            this.field_3851.method_8486(this.field_3874, this.field_3854, this.field_3871, (class_3414)ModSounds.GENTLE_BREEZE.get(), class_3419.field_15256, vol, 1.0f, false);
                            soundStartTimes.addLast(worldTime);
                        }
                        Random pr = new Random(HamsterBeddingParticle.mix64(gust.key, System.identityHashCode((Object)this)));
                        this.gustCoupling = 0.12f + pr.nextFloat() * 0.78f;
                        this.gustCoupling = (float)Math.sqrt(this.gustCoupling);
                        this.gustDelayTicks = pr.nextInt(9);
                        this.lastAppliedGustKey = gust.key;
                    }
                    int delayedTicksSinceGustStart = Math.max(0, gust.ticksSinceGustStart - this.gustDelayTicks);
                    float gustProgress = (float)delayedTicksSinceGustStart / (float)gust.gustDurationTicks;
                    float rise = HamsterBeddingParticle.smooth01(Math.min(1.0f, gustProgress / 0.3f));
                    float decay = (float)Math.exp(-3.0f * gustProgress);
                    gustStrengthLocal = rise * decay * this.gustCoupling;
                    if (delayedTicksSinceGustStart == 0 && gust.ticksSinceGustStart >= this.gustDelayTicks) {
                        this.gustSpinVel += 2.0f * this.gustCoupling;
                    }
                    float easeOutFactor = 1.0f - (float)Math.pow(1.0f - gustProgress, 3.0);
                    float finalGustDirX = class_3532.method_16439((float)easeOutFactor, (float)driftDirX, (float)gust.gustDirX);
                    float finalGustDirZ = class_3532.method_16439((float)easeOutFactor, (float)driftDirZ, (float)gust.gustDirZ);
                    float along = (float)(this.field_3852 * (double)finalGustDirX + this.field_3850 * (double)finalGustDirZ);
                    float target = 0.09f * gustStrengthLocal;
                    float corr = (target - along) * 0.1f;
                    this.field_3852 += (double)(finalGustDirX * corr);
                    this.field_3850 += (double)(finalGustDirZ * corr);
                    this.field_3869 += (double)(gustStrengthLocal * 0.025f);
                    this.field_3852 += (double)(finalGustDirX * gustStrengthLocal * 0.06f);
                    this.field_3850 += (double)(finalGustDirZ * gustStrengthLocal * 0.06f);
                }
            }
            if ((horizontalSpeedSquared = (float)(this.field_3852 * this.field_3852 + this.field_3850 * this.field_3850)) > (dynamicHorizontalCap = 0.08f + gustStrengthLocal * 0.075f) * dynamicHorizontalCap) {
                float scale = dynamicHorizontalCap / class_3532.method_15355((float)horizontalSpeedSquared);
                this.field_3852 *= (double)scale;
                this.field_3850 *= (double)scale;
            }
            this.field_3857 = this.field_3839;
            this.gustSpinVel *= 0.85f;
            float swayAngularVelocity = cosPhase * this.swayFrequency * 0.5f * 2.8f;
            this.field_3839 += this.constantRollVelocity + swayAngularVelocity + this.gustSpinVel;
        }
        super.method_3070();
        if (this.field_3845) {
            this.field_3847 = Math.min(this.field_3847, this.field_3866 + 10);
        }
    }

    public class_3999 method_18122() {
        return class_3999.field_17829;
    }

    private static Gust sampleGust(class_638 world, double x, double z) {
        int cellZ;
        long worldTime = world.method_8510();
        long gustWindowIndex = Math.floorDiv(worldTime, 100);
        int cellX = class_3532.method_15375((float)((float)x)) / 12;
        long baseSeed = HamsterBeddingParticle.mix64(cellX, cellZ = class_3532.method_15375((float)((float)z)) / 12, gustWindowIndex);
        Random r = new Random(baseSeed);
        if (r.nextFloat() >= 0.35f) {
            return new Gust(false, baseSeed, 0, 0, 0.0f, 0.0f);
        }
        int tickInCurrentWindow = (int)(worldTime % 100L);
        int maxStartTickInWindow = Math.max(1, 59);
        int gustStartTick = 1 + r.nextInt(maxStartTickInWindow);
        int gustDurationTicks = 20 + r.nextInt(21);
        if (tickInCurrentWindow < gustStartTick || tickInCurrentWindow > gustStartTick + gustDurationTicks) {
            long key = baseSeed ^ (long)gustStartTick;
            return new Gust(false, key, 0, gustDurationTicks, 0.0f, 0.0f);
        }
        float theta = r.nextFloat() * ((float)Math.PI * 2);
        float gustDirX = class_3532.method_15362((float)theta);
        float gustDirZ = class_3532.method_15374((float)theta);
        long key = baseSeed ^ (long)gustStartTick;
        int ticksSinceGustStart = tickInCurrentWindow - gustStartTick;
        return new Gust(true, key, ticksSinceGustStart, gustDurationTicks, gustDirX, gustDirZ);
    }

    private static long mix64(long seedA, long seedB) {
        long x = seedA * -7046029254386353131L + seedB + -4658895280553007687L;
        x ^= x >>> 30;
        x *= -4658895280553007687L;
        x ^= x >>> 27;
        x *= -7723592293110705685L;
        x ^= x >>> 31;
        return x;
    }

    private static long mix64(long currentSwayAcceleration, long b, long c) {
        return HamsterBeddingParticle.mix64(HamsterBeddingParticle.mix64(currentSwayAcceleration, b), c);
    }

    private static float smooth01(float x) {
        x = class_3532.method_15363((float)x, (float)0.0f, (float)1.0f);
        return x * x * (3.0f - 2.0f * x);
    }

    private record Gust(boolean active, long key, int ticksSinceGustStart, int gustDurationTicks, float gustDirX, float gustDirZ) {
    }

    public static class Factory
    implements class_707<class_2400> {
        private final class_4002 sprites;

        public Factory(class_4002 sprites) {
            this.sprites = sprites;
        }

        public class_703 createParticle(class_2400 type, class_638 world, double x, double y, double z, double vx, double vy, double vz) {
            return new HamsterBeddingParticle(world, x, y, z, vx, vy, vz, this.sprites);
        }
    }
}

