/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.AI;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.custom.HamsterArmorItem;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5534;
import org.jetbrains.annotations.Nullable;

public class HamsterPlayWithItemGoal
extends class_1352 {
    private static final int LUNGE_DURATION_TICKS = 5;
    private final HamsterEntity hamster;
    private final class_1937 world;
    @Nullable
    private class_1542 targetItem;
    @Nullable
    private class_1657 owner;
    @Nullable
    private class_243 pounceStartPos;
    @Nullable
    private class_243 repositionTarget;
    private int bounceSoundDelayTicks;
    private int playAnimSettleTicks;
    private int repositionAttempts;
    private int lungeTicks;
    private int itemInterestTimer;
    private boolean isFriendlyDelivery = false;
    private State currentState = State.SCANNING;

    public HamsterPlayWithItemGoal(HamsterEntity hamster) {
        this.hamster = hamster;
        this.world = hamster.method_37908();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406, class_1352.class_4134.field_18407));
    }

    public boolean method_6264() {
        HamsterArmorItem armorItem;
        class_1792 class_17922;
        AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] Evaluating canStart...", (Object)this.hamster.method_5628());
        if (this.hamster.isHoldingInterestItem()) {
            if (this.hamster.method_24345()) {
                return false;
            }
            if (!(this.hamster.method_35057() instanceof class_1657)) {
                return false;
            }
            this.owner = (class_1657)this.hamster.method_35057();
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] canStart SUCCEEDED: Resuming existing interaction.", (Object)this.hamster.method_5628());
            return true;
        }
        if (!Configs.AHP.enableItemCarrying) {
            return false;
        }
        if (this.hamster.isHoldingInterestItem() || this.hamster.method_24345()) {
            return false;
        }
        long currentTime = this.world.method_8510();
        if (this.hamster.interestCooldownEndTick > currentTime) {
            return false;
        }
        class_1309 class_13092 = this.hamster.method_35057();
        if (!(class_13092 instanceof class_1657)) {
            return false;
        }
        class_1657 playerOwner = (class_1657)class_13092;
        this.owner = playerOwner;
        List nearbyItems = this.world.method_8390(class_1542.class, this.hamster.method_5829().method_1014(10.0), itemEntity -> (ConfigDataCache.isStealableItem(itemEntity.method_6983()) || ConfigDataCache.isRetrievableItem(itemEntity.method_6983())) && itemEntity.method_24828());
        Optional<class_1542> closestItem = nearbyItems.stream().filter(item -> this.hamster.method_5942().method_6349((class_1297)item, 0) != null).min((item1, item2) -> Float.compare(item1.method_5739((class_1297)this.hamster), item2.method_5739((class_1297)this.hamster)));
        if (closestItem.isEmpty()) {
            return false;
        }
        this.targetItem = closestItem.get();
        class_1799 stack = this.targetItem.method_6983();
        boolean isRetrievable = ConfigDataCache.isRetrievableItem(stack);
        boolean isStealable = ConfigDataCache.isStealableItem(stack);
        boolean hasDiamondArmor = false;
        class_1799 armor = this.hamster.getArmorStack();
        if (!armor.method_7960() && (class_17922 = armor.method_7909()) instanceof HamsterArmorItem && (armorItem = (HamsterArmorItem)class_17922).getMaterial() == HamsterArmorItem.HamsterArmorMaterial.DIAMOND) {
            hasDiamondArmor = true;
        }
        if (isRetrievable || isStealable && hasDiamondArmor) {
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] canStart SUCCEEDED (Guaranteed). Target: {}.", (Object)this.hamster.method_5628(), (Object)stack.method_7909());
            return true;
        }
        if (isStealable) {
            float chance;
            float randomVal = this.hamster.method_6051().method_43057();
            if (randomVal > (chance = ((Float)Configs.AHP.itemThieveryChance.get()).floatValue())) {
                return false;
            }
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] canStart SUCCEEDED (Thievery Roll Passed). Target: {}.", (Object)this.hamster.method_5628(), (Object)stack.method_7909());
            return true;
        }
        return false;
    }

    public boolean method_6266() {
        if (this.hamster.method_24345()) {
            return false;
        }
        if (this.owner == null || !this.owner.method_5805()) {
            return false;
        }
        if (this.itemInterestTimer <= 0) {
            return false;
        }
        if (this.currentState == State.FLEEING || this.currentState == State.RETURNING || this.currentState == State.PLAYING_WITH_ITEM) {
            if (!this.hamster.isHoldingInterestItem()) {
                AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] shouldContinue check failed: Player retrieved item.", (Object)this.hamster.method_5628());
                return false;
            }
        } else if (!(this.currentState != State.MOVING_TO_ITEM && this.currentState != State.POUNCING || this.targetItem != null && this.targetItem.method_5805())) {
            return false;
        }
        return true;
    }

    public void method_6269() {
        class_1799 interestStack;
        this.hamster.setActiveCustomGoalDebugName(((Object)((Object)this)).getClass().getSimpleName());
        if (this.hamster.isHoldingInterestItem()) {
            interestStack = this.hamster.getInterestItemStack();
        } else if (this.targetItem != null) {
            interestStack = this.targetItem.method_6983();
        } else {
            this.method_6270();
            return;
        }
        this.determineMode(interestStack);
        if (this.hamster.isHoldingInterestItem()) {
            this.itemInterestTimer = this.hamster.getItemInterestTimer();
            this.targetItem = null;
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] Resuming interaction. Mode: Friendly={}", (Object)this.hamster.method_5628(), (Object)this.isFriendlyDelivery);
            this.currentState = this.isFriendlyDelivery ? State.RETURNING : (this.hamster.method_5739((class_1297)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue() ? State.FLEEING : State.PLAYING_WITH_ITEM);
        } else {
            this.currentState = State.MOVING_TO_ITEM;
            this.hamster.method_5942().method_6335((class_1297)this.targetItem, 1.5);
            this.itemInterestTimer = this.hamster.method_6051().method_39332((Integer)Configs.AHP.minStealDurationSeconds.get() * 20, (Integer)Configs.AHP.maxStealDurationSeconds.get() * 20);
            this.hamster.setItemInterestTimer(this.itemInterestTimer);
            this.repositionTarget = null;
            this.repositionAttempts = 0;
            AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] Goal started fresh. State: MOVING_TO_ITEM. Duration: {} ticks. Friendly: {}", new Object[]{this.hamster.method_5628(), this.itemInterestTimer, this.isFriendlyDelivery});
        }
    }

    public void method_6270() {
        class_1799 itemHeldInMouthStack;
        AdorableHamsterPets.LOGGER.trace("[PlayWithItemGoal-{}] Goal stopped. Final state was: {}.", (Object)this.hamster.method_5628(), (Object)this.currentState);
        this.hamster.interestCooldownEndTick = this.world.method_8510() + (long)((Integer)Configs.AHP.stealCooldownTicks.get()).intValue();
        if (this.hamster.isHoldingInterestItem() && this.itemInterestTimer <= 0 && !(itemHeldInMouthStack = this.hamster.getInterestItemStack()).method_7960()) {
            this.world.method_8649((class_1297)new class_1542(this.world, this.hamster.method_23317(), this.hamster.method_23318(), this.hamster.method_23321(), itemHeldInMouthStack.method_7972()));
            this.hamster.method_5783(ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_HURT_SOUNDS, this.hamster.method_6051()), 1.0f, 1.0f);
            class_3414 pounceSound = ModSounds.getDynamicItemSound(itemHeldInMouthStack);
            float volume = pounceSound == class_3417.field_20614 ? 0.35f : 1.0f;
            this.world.method_8396(null, this.hamster.method_24515(), pounceSound, class_3419.field_15254, volume, 1.7f);
        }
        this.hamster.setInterestItemStack(class_1799.field_8037);
        this.hamster.setItemInterestTimer(0);
        this.hamster.setTauntingWithItem(false);
        this.hamster.setPresentingItem(false);
        this.hamster.setHoldingInterestItem(false);
        this.hamster.method_5942().method_6340();
        this.targetItem = null;
        this.owner = null;
        this.currentState = State.SCANNING;
        if (this.hamster.getActiveCustomGoalDebugName().equals(((Object)((Object)this)).getClass().getSimpleName())) {
            this.hamster.setActiveCustomGoalDebugName("None");
        }
    }

    public void method_6268() {
        if (this.itemInterestTimer > 0) {
            --this.itemInterestTimer;
            this.hamster.setItemInterestTimer(this.itemInterestTimer);
        }
        if (this.owner == null) {
            return;
        }
        if (this.bounceSoundDelayTicks > 0) {
            --this.bounceSoundDelayTicks;
            if (this.bounceSoundDelayTicks == 0) {
                this.hamster.method_5783((class_3414)ModSounds.HAMSTER_BOUNCE.get(), 0.6f, this.hamster.method_6017() * 1.2f);
            }
        }
        switch (this.currentState) {
            case MOVING_TO_ITEM: {
                if (this.targetItem == null) {
                    return;
                }
                this.hamster.method_5988().method_6226((class_1297)this.targetItem, 25.0f, 25.0f);
                if (this.hamster.method_5942().method_6357()) {
                    this.currentState = State.REPOSITIONING;
                    return;
                }
                if (!((double)this.hamster.method_5739((class_1297)this.targetItem) < 1.5)) break;
                this.currentState = State.POUNCING;
                this.lungeTicks = 5;
                this.pounceStartPos = this.hamster.method_19538();
                this.hamster.method_5942().method_6340();
                this.hamster.triggerAnimOnServer("mainController", "anim_hamster_pounce_on_item");
                this.bounceSoundDelayTicks = 5;
                class_3414 celebrationSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.hamster.method_6051());
                if (celebrationSound == null) break;
                this.hamster.method_5783(celebrationSound, 0.7f, this.hamster.method_6017());
                break;
            }
            case REPOSITIONING: {
                if (this.targetItem == null) {
                    return;
                }
                if (this.repositionAttempts >= 3) {
                    this.itemInterestTimer = 0;
                    return;
                }
                if (this.repositionTarget == null) {
                    ++this.repositionAttempts;
                    this.repositionTarget = class_5534.method_31528((class_1314)this.hamster, (int)2, (int)3, (class_243)class_243.method_24953((class_2382)this.targetItem.method_24515()));
                    if (this.repositionTarget != null) {
                        this.hamster.method_5942().method_6337(this.repositionTarget.field_1352, this.repositionTarget.field_1351, this.repositionTarget.field_1350, 1.55);
                    } else {
                        this.itemInterestTimer = 0;
                        return;
                    }
                }
                if (!this.hamster.method_5942().method_6357()) break;
                this.repositionTarget = null;
                this.currentState = State.MOVING_TO_ITEM;
                this.hamster.method_5942().method_6335((class_1297)this.targetItem, 1.5);
                break;
            }
            case POUNCING: {
                if (this.targetItem == null) {
                    return;
                }
                --this.lungeTicks;
                if (this.pounceStartPos != null && this.lungeTicks >= 0) {
                    double progress = (double)(5 - this.lungeTicks) / 5.0;
                    double easedProgress = progress * progress;
                    double newX = this.pounceStartPos.field_1352 + easedProgress * (this.targetItem.method_23317() - this.pounceStartPos.field_1352);
                    double newZ = this.pounceStartPos.field_1350 + easedProgress * (this.targetItem.method_23321() - this.pounceStartPos.field_1350);
                    this.hamster.method_5814(newX, this.hamster.method_23318(), newZ);
                }
                if (this.lungeTicks >= 0) break;
                class_1799 stackToSteal = this.targetItem.method_6983().method_7972();
                if (stackToSteal.method_7960()) {
                    this.itemInterestTimer = 0;
                    return;
                }
                this.hamster.setInterestItemStack(stackToSteal);
                this.targetItem.method_31472();
                this.hamster.setHoldingInterestItem(true);
                class_3414 pounceSound = ModSounds.getDynamicItemSound(stackToSteal);
                float volume = pounceSound == class_3417.field_20614 ? 0.35f : 1.0f;
                this.world.method_8396(null, this.hamster.method_24515(), pounceSound, class_3419.field_15254, volume, 1.7f);
                if (!this.world.field_9236) {
                    ParticleEffectsUtil.spawnParticles(this.world, new class_243(this.hamster.method_23317(), this.hamster.method_23318() + 0.5, this.hamster.method_23321()), class_2398.field_11207, 5, new class_243(0.1, 0.1, 0.1), 0.05);
                    ParticleEffectsUtil.spawnParticles(this.world, new class_243(this.hamster.method_23317(), this.hamster.method_23318() + 0.5, this.hamster.method_23321()), new class_2392(class_2398.field_11218, stackToSteal), 18, new class_243(0.2, 0.2, 0.2), 0.1);
                }
                if (this.isFriendlyDelivery) {
                    this.currentState = State.RETURNING;
                    break;
                }
                this.currentState = State.FLEEING;
                break;
            }
            case FLEEING: {
                this.hamster.setTauntingWithItem(false);
                if (this.hamster.method_5739((class_1297)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue()) {
                    class_243 fleePos = class_5534.method_31534((class_1314)this.hamster, (int)((Integer)Configs.AHP.maxFleeDistance.get()), (int)7, (class_243)this.owner.method_19538());
                    if (fleePos == null) break;
                    this.hamster.method_5942().method_6337(fleePos.field_1352, fleePos.field_1351, fleePos.field_1350, 1.5);
                    break;
                }
                this.currentState = State.PLAYING_WITH_ITEM;
                this.hamster.method_5942().method_6340();
                break;
            }
            case RETURNING: {
                this.hamster.setPresentingItem(false);
                this.hamster.method_5942().method_6335((class_1297)this.owner, 1.5);
                double distToOwner = this.hamster.method_5739((class_1297)this.owner);
                if (!(distToOwner <= 2.5)) break;
                this.currentState = State.PLAYING_WITH_ITEM;
                this.hamster.method_5942().method_6340();
                break;
            }
            case PLAYING_WITH_ITEM: {
                this.hamster.method_5988().method_6226((class_1297)this.owner, 25.0f, 25.0f);
                if (!this.hamster.isTauntingWithItem() && !this.hamster.isPresentingItem() && this.playAnimSettleTicks == 0) {
                    this.playAnimSettleTicks = 5;
                }
                if (this.playAnimSettleTicks > 0) {
                    --this.playAnimSettleTicks;
                }
                if (this.hamster.method_5942().method_6357() && this.playAnimSettleTicks == 0) {
                    if (this.isFriendlyDelivery) {
                        this.hamster.setPresentingItem(true);
                    } else {
                        this.hamster.setTauntingWithItem(true);
                    }
                }
                if (this.isFriendlyDelivery) {
                    if (!((double)this.hamster.method_5739((class_1297)this.owner) > 5.0)) break;
                    this.currentState = State.RETURNING;
                    this.hamster.setPresentingItem(false);
                    this.playAnimSettleTicks = 0;
                    break;
                }
                if (!(this.hamster.method_5739((class_1297)this.owner) < (float)((Integer)Configs.AHP.minFleeDistance.get()).intValue())) break;
                this.currentState = State.FLEEING;
                this.hamster.setTauntingWithItem(false);
                this.playAnimSettleTicks = 0;
            }
        }
    }

    private void determineMode(class_1799 stack) {
        if (ConfigDataCache.isRetrievableItem(stack)) {
            this.isFriendlyDelivery = true;
            return;
        }
        if (ConfigDataCache.isStealableItem(stack)) {
            HamsterArmorItem armorItem;
            class_1792 class_17922;
            class_1799 armor = this.hamster.getArmorStack();
            this.isFriendlyDelivery = !armor.method_7960() && (class_17922 = armor.method_7909()) instanceof HamsterArmorItem && (armorItem = (HamsterArmorItem)class_17922).getMaterial() == HamsterArmorItem.HamsterArmorMaterial.DIAMOND;
            return;
        }
        this.isFriendlyDelivery = false;
    }

    private static enum State {
        SCANNING,
        MOVING_TO_ITEM,
        REPOSITIONING,
        POUNCING,
        FLEEING,
        RETURNING,
        PLAYING_WITH_ITEM;

    }
}

