/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.client;

import java.util.HashMap;
import java.util.Map;
import net.dawson.adorablehamsterpets.AdorableHamsterPetsClient;
import net.dawson.adorablehamsterpets.client.sound.HamsterCleaningSoundInstance;
import net.dawson.adorablehamsterpets.entity.client.HamsterModel;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterAcornHatLayer;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterArmorLayer;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterOverlayLayer;
import net.dawson.adorablehamsterpets.entity.client.layer.HamsterPinkPetalOverlayLayer;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.entity.custom.HamsterVariant;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.HamsterMouthItemOffsets;
import net.dawson.adorablehamsterpets.util.HamsterSeatOffsets;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_5819;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_898;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class HamsterRenderer
extends GeoEntityRenderer<HamsterEntity> {
    private final float adultShadowRadius;
    private static final Map<Integer, HamsterCleaningSoundInstance> activeCleaningSounds = new HashMap<Integer, HamsterCleaningSoundInstance>();
    public static final ThreadLocal<Boolean> IS_RENDERING_PASSENGER = ThreadLocal.withInitial(() -> false);
    private static final String SEAT_BONE = "body_child";

    public HamsterRenderer(class_5617.class_5618 ctx) {
        super(ctx, (GeoModel)new HamsterModel());
        this.field_4673 = this.adultShadowRadius = 0.2f;
        this.addRenderLayer(new HamsterOverlayLayer((GeoRenderer<HamsterEntity>)this));
        this.addRenderLayer(new HamsterArmorLayer((GeoRenderer<HamsterEntity>)this));
        this.addRenderLayer(new HamsterPinkPetalOverlayLayer((GeoRenderer<HamsterEntity>)this));
        this.addRenderLayer(new HamsterAcornHatLayer((GeoRenderer<HamsterEntity>)this));
    }

    public class_2960 getTextureLocation(HamsterEntity entity) {
        HamsterVariant variant = HamsterVariant.byId(entity.getVariant());
        String baseTextureName = variant.getBaseTextureName();
        return class_2960.method_43902((String)"adorablehamsterpets", (String)("textures/entity/hamster/" + baseTextureName + ".png"));
    }

    public void preRender(class_4587 poseStack, HamsterEntity animatable, BakedGeoModel model, @Nullable class_4597 bufferSource, @Nullable class_4588 buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (class_1297)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        model.getBone("left_foot").ifPresent(bone -> bone.setTrackingMatrices(true));
        model.getBone("nose").ifPresent(bone -> bone.setTrackingMatrices(true));
        model.getBone(SEAT_BONE).ifPresent(bone -> bone.setTrackingMatrices(true));
    }

    public void render(HamsterEntity entity, float entityYaw, float partialTick, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
        AnimatableManager manager;
        AnimatableInstanceCache cache;
        boolean isCleaning = entity.isCleaning();
        HamsterCleaningSoundInstance sound = activeCleaningSounds.get(entity.method_5628());
        if (isCleaning && (sound == null || sound.method_4793())) {
            sound = new HamsterCleaningSoundInstance(entity);
            activeCleaningSounds.put(entity.method_5628(), sound);
            class_310.method_1551().method_1483().method_4873((class_1113)sound);
        } else if (!isCleaning && sound != null) {
            sound.stop();
            activeCleaningSounds.remove(entity.method_5628());
        }
        this.field_4673 = entity.method_6109() ? this.adultShadowRadius * 0.5f : this.adultShadowRadius;
        AdorableHamsterPetsClient.onHamsterRendered(entity.method_5628());
        poseStack.method_22903();
        float targetYOffset = 0.0f;
        class_2338 pos = entity.method_24515();
        class_2680 blockState = entity.method_37908().method_8320(pos);
        if (blockState.method_27852(class_2246.field_10477)) {
            targetYOffset = 0.125f;
        }
        entity.renderedSnowYOffset += (targetYOffset - entity.renderedSnowYOffset) * 0.15f;
        poseStack.method_22904(0.0, (double)entity.renderedSnowYOffset, 0.0);
        if (!entity.isShoulderPet() && (cache = entity.getAnimatableInstanceCache()) != null && (manager = cache.getManagerForId((long)entity.method_5628())) != null) {
            manager.updatedAt(0.0);
        }
        super.method_3936((class_1297)entity, entityYaw, partialTick, poseStack, bufferSource, packedLight);
        poseStack.method_22909();
    }

    public void renderFinal(class_4587 poseStack, HamsterEntity animatable, BakedGeoModel model, class_4597 bufferSource, @Nullable class_4588 buffer, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.renderFinal(poseStack, (class_1297)animatable, model, bufferSource, buffer, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
        if (!animatable.method_5685().isEmpty()) {
            model.getBone(SEAT_BONE).ifPresent(bone -> this.renderPassengersForBone(poseStack, animatable, (GeoBone)bone, bufferSource, packedLight, partialTick));
        }
        if (animatable.isHoldingInterestItem()) {
            model.getBone("nose").ifPresent(bone -> this.renderItemForBone(poseStack, animatable, (GeoBone)bone, bufferSource, packedLight, packedOverlay));
        }
        if (animatable.particleEffectId != null) {
            this.handleParticleKeyframes(animatable, model);
        }
        if (animatable.soundEffectId != null) {
            this.handleSoundKeyframes(animatable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderPassengersForBone(class_4587 matrices, HamsterEntity hamster, GeoBone bone, class_4597 bufferSource, int packedLight, float partialTick) {
        class_310 client = class_310.method_1551();
        class_898 dispatcher = client.method_1561();
        Matrix4f modelBase = new Matrix4f((Matrix4fc)this.modelRenderTranslations);
        Matrix3f modelBaseNormal = new Matrix3f((Matrix4fc)modelBase).invert().transpose();
        dispatcher.method_3948(false);
        try {
            for (class_1297 passenger : hamster.method_5685()) {
                if (!(passenger instanceof class_1309)) continue;
                class_1309 living = (class_1309)passenger;
                if (passenger == client.field_1724 && client.field_1690.method_31044().method_31034()) continue;
                matrices.method_22903();
                try {
                    matrices.method_23760().method_23761().set((Matrix4fc)modelBase);
                    matrices.method_23760().method_23762().set((Matrix3fc)modelBaseNormal);
                    Matrix4f bonePose = new Matrix4f((Matrix4fc)bone.getModelSpaceMatrix());
                    Vector3f t = bonePose.getTranslation(new Vector3f());
                    Quaternionf r = bonePose.getUnnormalizedRotation(new Quaternionf());
                    Matrix4f boneTR = new Matrix4f().identity().translate((Vector3fc)t).rotate((Quaternionfc)r);
                    matrices.method_23760().method_23761().mul((Matrix4fc)boneTR);
                    matrices.method_23760().method_23762().set((Matrix3fc)new Matrix3f((Matrix4fc)matrices.method_23760().method_23761()).invert().transpose());
                    float mountScale = hamster.getScale();
                    if (mountScale != 1.0f) {
                        float inv = 1.0f / mountScale;
                        matrices.method_22905(inv, inv, inv);
                    }
                    class_243 seat = HamsterSeatOffsets.visualSeatOffset(living, hamster.getScale());
                    matrices.method_22904(seat.field_1352, seat.field_1351, seat.field_1350);
                    float passengerYaw = class_3532.method_17821((float)partialTick, (float)passenger.field_5982, (float)passenger.method_36454());
                    matrices.method_22907(class_7833.field_40716.rotationDegrees(passengerYaw - 180.0f));
                    IS_RENDERING_PASSENGER.set(true);
                    try {
                        dispatcher.method_3954(passenger, 0.0, 0.0, 0.0, passengerYaw, partialTick, matrices, bufferSource, packedLight);
                    }
                    finally {
                        IS_RENDERING_PASSENGER.set(false);
                    }
                }
                finally {
                    matrices.method_22909();
                }
            }
        }
        finally {
            dispatcher.method_3948(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderItemForBone(class_4587 matrices, HamsterEntity hamster, GeoBone bone, class_4597 bufferSource, int packedLight, int packedOverlay) {
        class_1799 itemStack = hamster.getInterestItemStack();
        if (itemStack.method_7960()) {
            return;
        }
        class_918 itemRenderer = class_310.method_1551().method_1480();
        Matrix4f modelBase = new Matrix4f((Matrix4fc)this.modelRenderTranslations);
        Matrix3f modelBaseNormal = new Matrix3f((Matrix4fc)modelBase).invert().transpose();
        matrices.method_22903();
        try {
            matrices.method_23760().method_23761().set((Matrix4fc)modelBase);
            matrices.method_23760().method_23762().set((Matrix3fc)modelBaseNormal);
            Matrix4f bonePose = new Matrix4f((Matrix4fc)bone.getModelSpaceMatrix());
            matrices.method_23760().method_23761().mul((Matrix4fc)bonePose);
            matrices.method_23760().method_23762().set((Matrix3fc)new Matrix3f((Matrix4fc)matrices.method_23760().method_23761()).invert().transpose());
            HamsterMouthItemOffsets.applyMouthItemTransforms(matrices);
            itemRenderer.method_23178(itemStack, class_811.field_4320, packedLight, packedOverlay, matrices, bufferSource, hamster.method_37908(), hamster.method_5628());
        }
        finally {
            matrices.method_22909();
        }
    }

    private void handleParticleKeyframes(HamsterEntity animatable, BakedGeoModel model) {
        class_5819 random = animatable.method_6051();
        switch (animatable.particleEffectId) {
            case "attack_poof": {
                model.getBone("left_foot").ifPresent(bone -> {
                    Vector3d pos = bone.getWorldPosition();
                    for (int i = 0; i < 8; ++i) {
                        double d = random.method_43059() * 0.1;
                        double e = random.method_43059() * 0.2;
                        double f = random.method_43059() * 0.1;
                        animatable.method_37908().method_8406((class_2394)class_2398.field_11203, pos.x + d, pos.y + e, pos.z + f, random.method_43059() * 0.05, random.method_43059() * 0.05, random.method_43059() * 0.05);
                    }
                });
                break;
            }
            case "seeking_dust": {
                model.getBone("nose").ifPresent(bone -> {
                    Vector3d pos = bone.getWorldPosition();
                    class_2338 blockBelow = class_2338.method_49637((double)pos.x, (double)(pos.y - 0.1), (double)pos.z).method_10074();
                    class_2680 state = animatable.method_37908().method_8320(blockBelow);
                    if (state.method_26215()) {
                        state = class_2246.field_10566.method_9564();
                    }
                    for (int i = 0; i < 12; ++i) {
                        double d = random.method_43059() * 0.2;
                        double e = random.method_43059() * 0.03;
                        double f = random.method_43059() * 0.2;
                        animatable.method_37908().method_8406((class_2394)new class_2388(class_2398.field_11206, state), pos.x + d, pos.y + e, pos.z + f, 0.0, 0.0, 0.0);
                    }
                });
            }
        }
        animatable.particleEffectId = null;
    }

    private void handleSoundKeyframes(HamsterEntity animatable) {
        class_310 client = class_310.method_1551();
        switch (animatable.soundEffectId) {
            case "hamster_step_sound": {
                class_2338 pos = animatable.method_24515();
                class_2680 blockState = animatable.method_37908().method_8320(pos.method_10074());
                if (blockState.method_26215()) {
                    blockState = animatable.method_37908().method_8320(pos.method_10087(2));
                }
                if (blockState.method_26215()) break;
                class_2498 group = blockState.method_26231();
                float volume = blockState.method_27852(class_2246.field_10255) ? 0.060000002f : 0.1f;
                client.method_1483().method_4873((class_1113)new class_1109(group.method_10594(), class_3419.field_15254, volume, group.method_10599() * 1.5f, animatable.method_6051(), animatable.method_23317(), animatable.method_23318(), animatable.method_23321()));
                break;
            }
            case "hamster_beg_bounce": {
                class_3414 bounceSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BOUNCE_SOUNDS, animatable.method_6051());
                if (bounceSound == null) break;
                float basePitch = animatable.method_6017();
                float randomPitchAddition = animatable.method_6051().method_43057() * 0.2f;
                float finalPitch = basePitch * 1.2f + randomPitchAddition;
                client.method_1483().method_4873((class_1113)new class_1109(bounceSound, class_3419.field_15254, 0.6f, finalPitch, animatable.method_6051(), animatable.method_23317(), animatable.method_23318(), animatable.method_23321()));
                break;
            }
            case "hamster_thump_sound": {
                float thumpPitch = 1.0f + animatable.method_6051().method_43057() * 0.4f;
                client.method_1483().method_4873((class_1113)new class_1109((class_3414)ModSounds.HAMSTER_THUMP.get(), class_3419.field_15254, 0.3f, thumpPitch, animatable.method_6051(), animatable.method_23317(), animatable.method_23318(), animatable.method_23321()));
            }
        }
        animatable.soundEffectId = null;
    }
}

