/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.entity.custom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.accessor.PlayerEntityAccessor;
import net.dawson.adorablehamsterpets.advancement.criterion.ModCriteria;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.entity.ModEntities;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.ModItems;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.dawson.adorablehamsterpets.util.TreeHeistUtil;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4208;
import net.minecraft.class_5321;

public class HamsterTreeSearcherEntity
extends class_1297 {
    private static final Map<class_4208, Integer> ACTIVE_HEISTS = new ConcurrentHashMap<class_4208, Integer>();
    private class_2487 hamsterNbt = new class_2487();
    private final List<Long> validLeafPositions = new ArrayList<Long>();
    private int searchTimer;
    private int maxSearchDuration;
    private int validationTimer;
    private int rummageTimer;
    private float dropChanceMultiplier = 1.0f;
    private boolean isExhausted = false;
    private class_2338 treeAnchor = null;
    private boolean hasAcornHat = false;
    private int dropCooldown = 0;
    private boolean isRegistered = false;
    private static final int VALIDATION_INTERVAL = 20;
    private static final int BASE_DURATION_MIN = 180;
    private static final int BASE_DURATION_MAX = 280;
    private static final float HAT_DROP_CHANCE_MULTIPLIER = 2.0f;
    private static final float BASE_DROP_CHANCE = 0.03f;
    private static final float DURATION_MULTIPLIER = 2.0f;

    public HamsterTreeSearcherEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.field_5960 = true;
        this.method_5875(true);
        this.method_5648(true);
    }

    protected void method_5693() {
    }

    public static boolean isTreeBlocked(class_1937 world, class_2338 anchor) {
        if (anchor == null || world.method_8608()) {
            return false;
        }
        class_4208 key = class_4208.method_19443((class_5321)world.method_27983(), (class_2338)anchor);
        return ACTIVE_HEISTS.containsKey(key);
    }

    private void registerHeist() {
        if (this.method_37908().method_8608() || this.treeAnchor == null || this.isRegistered) {
            return;
        }
        class_4208 key = class_4208.method_19443((class_5321)this.method_37908().method_27983(), (class_2338)this.treeAnchor);
        ACTIVE_HEISTS.put(key, this.method_5628());
        this.isRegistered = true;
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Registry] Registered heist for Tree {} (Entity {}). Active Heists: {}", new Object[]{this.treeAnchor.method_23854(), this.method_5628(), ACTIVE_HEISTS.size()});
        }
    }

    private void unregisterHeist() {
        if (this.method_37908().method_8608() || this.treeAnchor == null || !this.isRegistered) {
            return;
        }
        class_4208 key = class_4208.method_19443((class_5321)this.method_37908().method_27983(), (class_2338)this.treeAnchor);
        if (ACTIVE_HEISTS.remove(key, this.method_5628())) {
            this.isRegistered = false;
            if (Configs.AHP.debugTreeDetection) {
                AdorableHamsterPets.LOGGER.info("[TreeHeist-Registry] Unregistered heist for Tree {} (Entity {}). Active Heists: {}", new Object[]{this.treeAnchor.method_23854(), this.method_5628(), ACTIVE_HEISTS.size()});
            }
        }
    }

    public class_2338 getTreeAnchor() {
        return this.treeAnchor;
    }

    public void initializeSearch(class_2338 startPos, TreeHeistUtil.TreeScanResult scanResult, class_2487 originalHamsterNbt) {
        class_2487 invNbt;
        this.hamsterNbt = originalHamsterNbt;
        this.method_5814((double)startPos.method_10263() + 0.5, (double)startPos.method_10264() + 0.5, (double)startPos.method_10260() + 0.5);
        this.validLeafPositions.clear();
        for (class_2338 pos : scanResult.validCanopyPositions()) {
            this.validLeafPositions.add(pos.method_10063());
        }
        this.treeAnchor = scanResult.treeId();
        this.registerHeist();
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Init] Searcher Entity Initialized. Anchor: {}. Canopy: {}.", (Object)this.treeAnchor.method_23854(), (Object)this.validLeafPositions.size());
        }
        if (this.validLeafPositions.isEmpty()) {
            if (Configs.AHP.debugTreeDetection) {
                AdorableHamsterPets.LOGGER.warn("[TreeHeist-Init] No valid leaves found. Aborting.");
            }
            this.popOut(false);
            return;
        }
        if (Configs.AHP.debugTreeDetection) {
            TreeHeistUtil.spawnDebugParticles(this.method_37908(), scanResult);
            AdorableHamsterPets.LOGGER.info("[TreeHeist] Identified Tree ID: {} | Canopy Size: {}", (Object)this.treeAnchor, (Object)this.validLeafPositions.size());
        }
        if (this.hamsterNbt.method_25928("Owner")) {
            UUID ownerUuid = this.hamsterNbt.method_25926("Owner");
            class_1657 player = this.method_37908().method_18470(ownerUuid);
            if (player instanceof PlayerEntityAccessor) {
                PlayerEntityAccessor accessor = (PlayerEntityAccessor)player;
                this.dropChanceMultiplier = accessor.ahp$getHeistProfitability(this.treeAnchor);
                accessor.ahp$registerTreeHeist(this.treeAnchor);
                if (this.dropChanceMultiplier <= 0.01f) {
                    this.isExhausted = true;
                }
                if (!this.isExhausted) {
                    TreeHeistUtil.sendHeistStartMessage(player, this.dropChanceMultiplier);
                }
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    ModCriteria.TREE_HEIST_STARTED.trigger(serverPlayer);
                }
            }
        }
        int baseDuration = this.field_5974.method_39332(180, 280);
        this.hasAcornHat = false;
        if (this.hamsterNbt.method_10573("Inventory", 10) && (invNbt = this.hamsterNbt.method_10562("Inventory")).method_10573("Items", 9)) {
            class_2499 itemsList = invNbt.method_10554("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                class_1799 stack;
                class_2487 itemTag = itemsList.method_10602(i);
                int slot = itemTag.method_10571("Slot") & 0xFF;
                if (slot != 6 || !(stack = class_1799.method_7915((class_2487)itemTag)).method_31574((class_1792)ModItems.ACORN_HAT.get())) continue;
                this.hasAcornHat = true;
                break;
            }
        }
        if (this.isExhausted) {
            baseDuration = Math.max(60, (int)((float)baseDuration * 0.1f));
        }
        this.searchTimer = baseDuration;
        this.maxSearchDuration = baseDuration;
        this.validationTimer = 20;
        if (Configs.AHP.debugTreeDetection) {
            float baseChance = ((Float)Configs.AHP.acornDropChance.get()).floatValue();
            float estimatedFinalChance = baseChance * this.dropChanceMultiplier;
            if (this.hasAcornHat) {
                estimatedFinalChance *= 2.0f;
            }
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Stats] Heist Initialized:\n  - Tree Anchor: {}\n  - Base Profitability (History): {}%\n  - Acorn Hat Equipped: {}\n  - Hat Multiplier: {}x\n  - FINAL Drop Chance per Rummage: {}% (Base: {}%)\n", new Object[]{this.treeAnchor.method_23854(), String.format("%.1f", Float.valueOf(this.dropChanceMultiplier * 100.0f)), this.hasAcornHat, Float.valueOf(this.hasAcornHat ? 2.0f : 1.0f), String.format("%.2f", Float.valueOf(estimatedFinalChance * 100.0f)), String.format("%.2f", Float.valueOf(baseChance * 100.0f))});
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            return;
        }
        if (!this.isRegistered && this.treeAnchor != null) {
            this.registerHeist();
        }
        if (this.validLeafPositions.isEmpty()) {
            if (this.field_6012 > 5) {
                this.method_31472();
            }
            return;
        }
        if (this.dropCooldown > 0) {
            --this.dropCooldown;
        }
        if (Configs.AHP.debugTreeDetection) {
            TreeHeistUtil.spawnDebugParticles(this.method_37908(), this.treeAnchor, this.validLeafPositions);
        }
        if (--this.validationTimer <= 0) {
            this.validationTimer = 20;
            if (!this.validateTreeIntegrity()) {
                this.popOut(false);
                return;
            }
        }
        if (--this.rummageTimer <= 0) {
            this.rummageTimer = this.field_5974.method_39332(3, 5);
            this.rummage();
        }
        if (--this.searchTimer <= 0) {
            this.popOut(true);
        }
    }

    public void method_36209() {
        super.method_36209();
        if (!this.method_37908().method_8608()) {
            this.unregisterHeist();
        }
    }

    private boolean validateTreeIntegrity() {
        int samples = Math.min(3, this.validLeafPositions.size());
        int failures = 0;
        for (int i = 0; i < samples; ++i) {
            long posLong = this.validLeafPositions.get(this.field_5974.method_43048(this.validLeafPositions.size()));
            class_2338 pos = class_2338.method_10092((long)posLong);
            if (this.method_37908().method_8320(pos).method_27852(class_2246.field_10503)) continue;
            ++failures;
        }
        return failures <= samples / 2;
    }

    private void rummage() {
        class_2338 currentPos = this.method_24515();
        class_2338 targetPos = null;
        ArrayList<class_2338> nearbyExposed = new ArrayList<class_2338>();
        ArrayList<class_2338> nearbyBuried = new ArrayList<class_2338>();
        for (Long l : this.validLeafPositions) {
            class_2338 p = class_2338.method_10092((long)l);
            if (p.equals((Object)currentPos) || p.method_19455((class_2382)currentPos) > 2) continue;
            if (this.isLeafExposed(this.method_37908(), p)) {
                nearbyExposed.add(p);
                continue;
            }
            nearbyBuried.add(p);
        }
        if (!nearbyExposed.isEmpty()) {
            targetPos = (class_2338)nearbyExposed.get(this.field_5974.method_43048(nearbyExposed.size()));
        } else if (!nearbyBuried.isEmpty()) {
            targetPos = (class_2338)nearbyBuried.get(this.field_5974.method_43048(nearbyBuried.size()));
        } else {
            ArrayList<class_2338> allExposed = new ArrayList<class_2338>();
            for (Long posLong : this.validLeafPositions) {
                class_2338 p = class_2338.method_10092((long)posLong);
                if (!this.isLeafExposed(this.method_37908(), p)) continue;
                allExposed.add(p);
            }
            if (!allExposed.isEmpty()) {
                targetPos = (class_2338)allExposed.get(this.field_5974.method_43048(allExposed.size()));
            } else {
                long l = this.validLeafPositions.get(this.field_5974.method_43048(this.validLeafPositions.size()));
                targetPos = class_2338.method_10092((long)l);
            }
        }
        this.method_5814((double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264() + 0.5, (double)targetPos.method_10260() + 0.5);
        ParticleEffectsUtil.spawnParticles(this.method_37908(), new class_243(this.method_23317(), this.method_23318(), this.method_23321()), ModParticles.getForVariant(WoodVariant.BAMBOO), 50, new class_243(0.4, 0.4, 0.4), 0.0);
        ParticleEffectsUtil.spawnParticles(this.method_37908(), new class_243(this.method_23317() + 0.5, this.method_23318() + 0.5, this.method_23321() + 0.5), class_2398.field_23956, 7, new class_243(0.4, 0.4, 0.4), 0.1);
        float dropChance = ((Float)Configs.AHP.acornDropChance.get()).floatValue() * this.dropChanceMultiplier;
        if (this.hasAcornHat) {
            dropChance *= 2.0f;
        }
        if (this.field_5974.method_43057() < dropChance && this.dropCooldown <= 0) {
            class_2338 class_23382 = TreeHeistUtil.findExitPosition(this.method_37908(), targetPos);
            class_1799 acornStack = new class_1799((class_1935)ModItems.ACORN.get());
            class_1542 acornEntity = new class_1542(this.method_37908(), (double)class_23382.method_10263() + 0.5, (double)class_23382.method_10264() + 0.7, (double)class_23382.method_10260() + 0.5, acornStack);
            double velX = (this.field_5974.method_43058() - 0.5) * 0.7;
            double velY = 0.0;
            double velZ = (this.field_5974.method_43058() - 0.5) * 0.7;
            acornEntity.method_18800(velX, velY, velZ);
            class_3414 acornPopSound = ModSounds.getDynamicItemSound(acornStack);
            this.method_37908().method_43128(null, (double)class_23382.method_10263() + 0.5, (double)class_23382.method_10264() + 0.5, (double)class_23382.method_10260() + 0.5, acornPopSound, class_3419.field_15254, 0.5f, 1.8f);
            this.method_37908().method_43128(null, (double)class_23382.method_10263() + 0.5, (double)class_23382.method_10264() + 0.5, (double)class_23382.method_10260() + 0.5, (class_3414)ModSounds.HAMSTER_DING.get(), class_3419.field_15254, 0.7f, 1.0f + (this.field_5974.method_43057() - 0.5f) * 0.2f);
            this.method_37908().method_8649((class_1297)acornEntity);
            this.dropCooldown = 20;
        }
    }

    private boolean isLeafExposed(class_1937 world, class_2338 pos) {
        for (class_2350 dir : class_2350.values()) {
            if (!world.method_22347(pos.method_10093(dir))) continue;
            return true;
        }
        return false;
    }

    private void popOut(boolean success) {
        if (this.method_37908().field_9236) {
            return;
        }
        class_3218 serverWorld = (class_3218)this.method_37908();
        this.unregisterHeist();
        class_2338 startPoint = this.method_24515();
        class_2338 exitPos = TreeHeistUtil.findExitPosition(this.method_37908(), startPoint);
        HamsterEntity newHamster = (HamsterEntity)((class_1299)ModEntities.HAMSTER.get()).method_5883((class_1937)serverWorld);
        if (newHamster != null) {
            class_3414 celebrateSound;
            newHamster.method_5651(this.hamsterNbt);
            newHamster.setFallFlyImmunityTicks(0);
            newHamster.method_5808((double)exitPos.method_10263() + 0.5, (double)exitPos.method_10264() + 0.1, (double)exitPos.method_10260() + 0.5, this.field_5974.method_43057() * 360.0f, 0.0f);
            newHamster.method_18799(class_243.field_1353);
            newHamster.setThrown(false);
            newHamster.setKnockedOut(false);
            newHamster.method_24346(false);
            newHamster.field_6007 = true;
            if (success && !this.isExhausted) {
                class_1799 prize = new class_1799((class_1935)ModItems.ACORN.get());
                newHamster.setInterestItemStack(prize);
                newHamster.setHoldingInterestItem(true);
                newHamster.setItemInterestTimer(1200);
                class_3414 sparkleSound = ModSounds.getRandomSoundFrom(ModSounds.DIAMOND_SPARKLE_SOUNDS, this.field_5974);
                if (sparkleSound != null) {
                    serverWorld.method_8396(null, newHamster.method_24515(), sparkleSound, class_3419.field_15254, 0.5f, 1.0f);
                }
                newHamster.scheduleTreeHeistCelebration();
            } else {
                UUID ownerUuid;
                class_1657 owner;
                newHamster.setSulking(true);
                newHamster.triggerAnimOnServer("mainController", "anim_hamster_sulk");
                if (this.isExhausted && this.hamsterNbt.method_25928("Owner") && (owner = serverWorld.method_18470(ownerUuid = this.hamsterNbt.method_25926("Owner"))) != null) {
                    owner.method_7353((class_2561)class_2561.method_43471((String)"message.adorablehamsterpets.tree_heist_exhausted").method_27692(class_124.field_1061), true);
                    if (owner instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)owner;
                        ModCriteria.TREE_HEIST_DEPLETION.trigger(serverPlayer);
                    }
                }
            }
            serverWorld.method_30771((class_1297)newHamster);
            newHamster.triggerLeafPopEffects(startPoint, true);
            if (success && !this.isExhausted && (celebrateSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_CELEBRATE_SOUNDS, this.field_5974)) != null) {
                serverWorld.method_8396(null, newHamster.method_24515(), celebrateSound, class_3419.field_15254, 1.0f, 1.0f);
            }
        }
        this.method_31472();
    }

    protected void method_5652(class_2487 nbt) {
        nbt.method_10566("HamsterNBT", (class_2520)this.hamsterNbt);
        nbt.method_10569("SearchTimer", this.searchTimer);
        nbt.method_10569("MaxSearchDuration", this.maxSearchDuration);
        nbt.method_10569("RummageTimer", this.rummageTimer);
        if (this.treeAnchor != null) {
            nbt.method_10544("TreeAnchor", this.treeAnchor.method_10063());
        }
        nbt.method_10556("IsExhausted", this.isExhausted);
        nbt.method_10548("DropMultiplier", this.dropChanceMultiplier);
        nbt.method_10556("HasAcornHat", this.hasAcornHat);
        nbt.method_10569("DropCooldown", this.dropCooldown);
        class_2499 posList = new class_2499();
        for (Long pos : this.validLeafPositions) {
            posList.add((Object)class_2503.method_23251((long)pos));
        }
        nbt.method_10566("ValidLeafPositions", (class_2520)posList);
    }

    protected void method_5749(class_2487 nbt) {
        this.hamsterNbt = nbt.method_10562("HamsterNBT");
        this.searchTimer = nbt.method_10550("SearchTimer");
        this.maxSearchDuration = nbt.method_10550("MaxSearchDuration");
        this.rummageTimer = nbt.method_10550("RummageTimer");
        if (nbt.method_10545("TreeAnchor")) {
            this.treeAnchor = class_2338.method_10092((long)nbt.method_10537("TreeAnchor"));
        }
        this.isExhausted = nbt.method_10577("IsExhausted");
        this.dropChanceMultiplier = nbt.method_10583("DropMultiplier");
        this.hasAcornHat = nbt.method_10577("HasAcornHat");
        this.dropCooldown = nbt.method_10550("DropCooldown");
        this.validLeafPositions.clear();
        if (nbt.method_10573("ValidLeafPositions", 9)) {
            class_2499 list = nbt.method_10554("ValidLeafPositions", 4);
            for (class_2520 element : list) {
                if (!(element instanceof class_2503)) continue;
                class_2503 nbtLong = (class_2503)element;
                this.validLeafPositions.add(nbtLong.method_10699());
            }
        }
        this.validationTimer = 20;
    }
}

