/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.fabric.datagen;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;
import me.fzzyhmstrs.fzzy_config.api.ConfigApiJava;
import me.fzzyhmstrs.fzzy_config.util.Translatable;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.AhpConfig;
import net.dawson.adorablehamsterpets.config.AhpRootConfig;
import net.dawson.adorablehamsterpets.config.AhpWorldGenConfig;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_2960;

public class EnUsGenerator
extends FabricLanguageProvider {
    private static final String BASE_RESOURCE_PATH = "assets/adorablehamsterpets/lang/en_us_base.json";
    private static final Gson GSON = new Gson();

    public EnUsGenerator(FabricDataOutput output) {
        super(output);
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder builder) {
        HashSet<String> seen = new HashSet<String>();
        try (InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(BASE_RESOURCE_PATH);){
            if (stream != null) {
                JsonObject obj = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class);
                for (Map.Entry e : obj.entrySet()) {
                    builder.add((String)e.getKey(), ((JsonElement)e.getValue()).getAsString());
                    seen.add((String)e.getKey());
                }
            } else {
                AdorableHamsterPets.LOGGER.warn("Could not locate {}", (Object)BASE_RESOURCE_PATH);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to read assets/adorablehamsterpets/lang/en_us_base.json", ex);
        }
        BiConsumer<String, String> safeSingleWriter = (key, value) -> {
            if (seen.add((String)key)) {
                builder.add(key, value);
            }
        };
        ManualScraper scraper = (clazz, idStr) -> {
            String baseKey = "adorablehamsterpets." + idStr;
            if (clazz.isAnnotationPresent(Translatable.Name.class)) {
                safeSingleWriter.accept(baseKey, clazz.getAnnotation(Translatable.Name.class).value());
            }
            if (clazz.isAnnotationPresent(Translatable.Desc.class)) {
                safeSingleWriter.accept(baseKey + ".desc", clazz.getAnnotation(Translatable.Desc.class).value());
            }
        };
        scraper.scrape(AhpRootConfig.class, "root");
        ConfigApiJava.buildTranslations(AhpRootConfig.class, (class_2960)class_2960.method_43902((String)"adorablehamsterpets", (String)"root"), (String)"en_us", (boolean)false, safeSingleWriter);
        scraper.scrape(AhpConfig.class, "main");
        ConfigApiJava.buildTranslations(AhpConfig.class, (class_2960)class_2960.method_43902((String)"adorablehamsterpets", (String)"main"), (String)"en_us", (boolean)false, safeSingleWriter);
        scraper.scrape(AhpWorldGenConfig.class, "worldgen");
        ConfigApiJava.buildTranslations(AhpWorldGenConfig.class, (class_2960)class_2960.method_43902((String)"adorablehamsterpets", (String)"worldgen"), (String)"en_us", (boolean)false, safeSingleWriter);
    }

    @FunctionalInterface
    private static interface ManualScraper {
        public void scrape(Class<?> var1, String var2);
    }
}

