/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.item.custom;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.dawson.adorablehamsterpets.block.custom.HamsterBedBlock;
import net.dawson.adorablehamsterpets.block.custom.WoodVariant;
import net.dawson.adorablehamsterpets.block.entity.HamsterBedBlockEntity;
import net.dawson.adorablehamsterpets.config.ConfigDataCache;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.config.WanderDistance;
import net.dawson.adorablehamsterpets.entity.custom.HamsterEntity;
import net.dawson.adorablehamsterpets.item.client.HamsterBedRenderProvider;
import net.dawson.adorablehamsterpets.item.custom.fabric.HamsterBedItemImpl;
import net.dawson.adorablehamsterpets.particles.ModParticles;
import net.dawson.adorablehamsterpets.sound.ModSounds;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class HamsterBedItem
extends class_1747
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final WoodVariant variant;
    private final Supplier<Object> renderProvider = new Supplier<Object>(){
        private Object provider;

        @Override
        public Object get() {
            if (this.provider == null && Platform.getEnvironment() == Env.CLIENT) {
                this.provider = HamsterBedRenderProvider.create();
            }
            return this.provider;
        }
    };

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static HamsterBedItem create(class_2248 block, WoodVariant variant, class_1792.class_1793 settings) {
        void var2_2;
        void var1_1;
        return HamsterBedItemImpl.create(block, (WoodVariant)var1_1, (class_1792.class_1793)var2_2);
    }

    public Supplier<Object> getRenderProvider() {
        return this.renderProvider;
    }

    public HamsterBedItem(class_2248 block, WoodVariant variant, class_1792.class_1793 settings) {
        super(block, settings);
        this.variant = variant;
        GeoItem.registerSyncedAnimatable((GeoAnimatable)this);
    }

    protected boolean method_7710(class_2338 pos, class_1937 world, @Nullable class_1657 player, class_1799 stack, class_2680 state) {
        if (!world.field_9236) {
            class_2586 be;
            class_3414 rustleSound = ModSounds.getRandomSoundFrom(ModSounds.HAMSTER_BED_LEAVES_RUSTLE_SOUNDS, world.method_8409());
            if (rustleSound != null) {
                world.method_8396(null, pos, rustleSound, class_3419.field_15245, 0.5f, 1.5f);
            }
            if ((be = world.method_8321(pos)) instanceof HamsterBedBlockEntity) {
                HamsterBedBlockEntity bedEntity = (HamsterBedBlockEntity)be;
                bedEntity.triggerAnim("hamster_bed_controller", "anim_bed_being_placed");
                WoodVariant variant = this.variant;
                if (stack.method_7985() && stack.method_7969().method_10545("WoodVariant")) {
                    try {
                        variant = WoodVariant.valueOf(stack.method_7969().method_10558("WoodVariant"));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                ParticleEffectsUtil.spawnParticles(world, pos, 0.3, ModParticles.getForVariant(variant), 30, 0.1, 0.2, 0.1, 0.0);
            }
        }
        return world.method_8652(pos, (class_2680)state.method_11657(HamsterBedBlock.WOOD_VARIANT, (Comparable)((Object)this.variant)), 11);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        WoodVariant stackVariant = this.variant;
        if (stack.method_7985() && stack.method_7969().method_10545("WoodVariant")) {
            try {
                stackVariant = WoodVariant.valueOf(stack.method_7969().method_10558("WoodVariant"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (Configs.AHP.enableItemTooltips) {
            if (class_437.method_25442()) {
                class_2487 nbt;
                class_5250 hintText;
                class_5250 statusText;
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.hamster_bed.description1").method_27692(class_124.field_1065));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.hamster_bed.description2").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.jade.wander_controls1").method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.jade.wander_controls2").method_27692(class_124.field_1080));
                class_5250 lureName = ConfigDataCache.getFirstItemNameFromList(Configs.AHP.lureItems).method_27661().method_27695(new class_124[]{class_124.field_1065, class_124.field_1067});
                class_5250 repellentName = ConfigDataCache.getFirstItemNameFromList(Configs.AHP.bedAvoidanceFoods).method_27661().method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.adorablehamsterpets.jade.lure_hint", (Object[])new Object[]{lureName}).method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.adorablehamsterpets.jade.repellent_hint", (Object[])new Object[]{repellentName}).method_27692(class_124.field_1080));
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.adorablehamsterpets.jade.unlink_hint", (Object[])new Object[]{repellentName}).method_27692(class_124.field_1080));
                boolean configEnabled = (Boolean)Configs.AHP.enableRespawnInBed.get();
                if (!configEnabled) {
                    statusText = class_2561.method_43471((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_status.disabled_config");
                    hintText = class_2561.method_43471((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_hint.disabled_config");
                } else {
                    statusText = class_2561.method_43471((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_status.inactive");
                    class_2561 tributeName = ConfigDataCache.getFirstItemNameFromList(Configs.AHP.resurrectionTributes);
                    hintText = class_2561.method_43469((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_hint.inactive", (Object[])new Object[]{tributeName.method_27661().method_27695(new class_124[]{class_124.field_1065, class_124.field_1067})});
                }
                tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.adorablehamsterpets.hamster_bed.respawn_status.label", (Object[])new Object[]{statusText}));
                tooltip.add((class_2561)hintText);
                if (stack.method_7985() && (nbt = stack.method_7969()).method_10545("LinkedHamsterUuid") && nbt.method_10545("LinkedHamsterName")) {
                    class_5250 hamsterName = class_2561.class_2562.method_10877((String)nbt.method_10558("LinkedHamsterName"));
                    tooltip.add((class_2561)class_2561.method_43470((String)""));
                    if (hamsterName != null) {
                        tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.adorablehamsterpets.hamster_bed.linked_to", (Object[])new Object[]{hamsterName}).method_27692(class_124.field_1060));
                    }
                    if (nbt.method_10545("WanderDistance")) {
                        try {
                            WanderDistance wanderDistance = WanderDistance.valueOf(nbt.method_10558("WanderDistance"));
                            int radius = switch (wanderDistance) {
                                case WanderDistance.NEAR -> (Integer)Configs.AHP.wanderDistanceNear.get();
                                case WanderDistance.FAR -> (Integer)Configs.AHP.wanderDistanceFar.get();
                                default -> (Integer)Configs.AHP.wanderDistanceMedium.get();
                            };
                            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.adorablehamsterpets.hamster_bed.wander_distance", (Object[])new Object[]{class_2561.method_43471((String)wanderDistance.translationKey()), radius}).method_27692(class_124.field_1075));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                    }
                }
            } else {
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.hamster_bed.description1").method_27692(class_124.field_1065));
                tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.adorablehamsterpets.shift_for_info").method_27692(class_124.field_1063));
            }
        } else if (!Platform.isModLoaded((String)"emi")) {
            tooltip.add((class_2561)class_2561.method_43470((String)"Adorable Hamster Pets").method_27695(new class_124[]{class_124.field_1078, class_124.field_1056}));
        }
        super.method_7851(stack, world, tooltip, context);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.field_9236) {
            return;
        }
        if (!stack.method_7985() || !stack.method_7969().method_10545("LinkedHamsterUuid")) {
            return;
        }
        UUID linkedUuid = stack.method_7969().method_25926("LinkedHamsterUuid");
        if (entity instanceof class_1657) {
            world.method_8390(HamsterEntity.class, entity.method_5829().method_1014(16.0), e -> e.method_5667().equals(linkedUuid)).stream().findFirst().ifPresent(hamster -> {
                String newJson;
                Object newName = hamster.method_16914() ? hamster.method_5477() : hamster.method_5476().method_27661().method_27693(" " + hamster.method_5628());
                String currentJson = stack.method_7969().method_10558("LinkedHamsterName");
                if (!currentJson.equals(newJson = class_2561.class_2562.method_10867((class_2561)newName))) {
                    stack.method_7948().method_10582("LinkedHamsterName", newJson);
                }
            });
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public WoodVariant getVariant() {
        return this.variant;
    }

    public String method_7876() {
        return this.method_7869();
    }

    public void createRenderer(Consumer<Object> consumer) {
        if (Platform.getEnvironment() == Env.CLIENT) {
            consumer.accept(HamsterBedRenderProvider.create());
        }
    }
}

