/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.mixin.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.platform.Platform;
import java.util.List;
import java.util.Map;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.client.announcements.Announcement;
import net.dawson.adorablehamsterpets.client.announcements.AnnouncementManager;
import net.dawson.adorablehamsterpets.client.announcements.Semver;
import net.dawson.adorablehamsterpets.mixin.accessor.BookContentsBuilderAccessor;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import vazkii.patchouli.client.book.BookCategory;
import vazkii.patchouli.client.book.BookContents;
import vazkii.patchouli.client.book.BookContentsBuilder;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.common.book.Book;

@Mixin(value={BookContentsBuilder.class}, remap=false)
public class BookContentsBuilderMixin {
    @Inject(method={"build"}, at={@At(value="HEAD")})
    private void adorablehamsterpets$onBuild(class_1937 level, CallbackInfoReturnable<BookContents> cir) {
        class_2960 announcementsId;
        BookContentsBuilderAccessor accessor = (BookContentsBuilderAccessor)((Object)this);
        Book hamsterBook = accessor.getBook();
        if (hamsterBook == null || !hamsterBook.id.equals((Object)class_2960.method_43902((String)"adorablehamsterpets", (String)"hamster_tips_guide_book"))) {
            return;
        }
        AdorableHamsterPets.LOGGER.debug("[AHP Mixin] Found target book. Starting virtual content injection.");
        Map<class_2960, BookCategory> categories = accessor.getCategories();
        Map<class_2960, BookEntry> entries = accessor.getEntries();
        class_2960 updatesId = class_2960.method_43902((String)"adorablehamsterpets", (String)"update_notes");
        if (!categories.containsKey(updatesId)) {
            BookCategory updatesCategory = this.createVirtualCategory(hamsterBook, "book.adorablehamsterpets.category.update_notes", "minecraft:writable_book", 99, updatesId);
            categories.put(updatesId, updatesCategory);
        }
        if (!categories.containsKey(announcementsId = class_2960.method_43902((String)"adorablehamsterpets", (String)"announcements"))) {
            BookCategory announcementsCategory = this.createVirtualCategory(hamsterBook, "book.adorablehamsterpets.category.announcements", "adorablehamsterpets:announcement_bell_icon", 98, announcementsId);
            categories.put(announcementsId, announcementsCategory);
        }
        BookContentsBuilder self = (BookContentsBuilder)this;
        List<Announcement> allMessages = AnnouncementManager.INSTANCE.getAllManifestMessages();
        Semver installedVersion = Semver.parse(Platform.getMod((String)"adorablehamsterpets").getVersion().toString());
        List<Announcement> sortedMessages = allMessages.stream().map(a -> {
            if ("update".equals(a.kind())) {
                Semver msgVer = Semver.parse(a.semver());
                String newKind = a.id().startsWith("update-") ? "update_available" : (msgVer.compareTo(installedVersion) > 0 ? "update_available" : "patch_notes");
                return new Announcement(a.id(), newKind, a.semver(), a.title(), a.markdown(), a.published());
            }
            return a;
        }).filter(a -> {
            Semver msgVer = Semver.parse(a.semver());
            if ("update_available".equals(a.kind())) {
                return msgVer.compareTo(installedVersion) > 0;
            }
            if ("patch_notes".equals(a.kind())) {
                return msgVer.compareTo(installedVersion) <= 0;
            }
            return true;
        }).sorted((a1, a2) -> {
            boolean c2;
            boolean u2;
            boolean u1 = "update_available".equals(a1.kind());
            if (u1 != (u2 = "update_available".equals(a2.kind()))) {
                return u1 ? -1 : 1;
            }
            Semver v1 = Semver.parse(a1.semver());
            Semver v2 = Semver.parse(a2.semver());
            boolean c1 = "patch_notes".equals(a1.kind()) && v1.equals(installedVersion);
            boolean bl = c2 = "patch_notes".equals(a2.kind()) && v2.equals(installedVersion);
            if (c1 != c2) {
                return c1 ? -1 : 1;
            }
            return a2.published().compareTo(a1.published());
        }).toList();
        for (int i = 0; i < sortedMessages.size(); ++i) {
            String icon;
            Announcement announcement = sortedMessages.get(i);
            class_2960 entryId = class_2960.method_43902((String)"adorablehamsterpets", (String)("announcement_" + announcement.id()));
            if (entries.containsKey(entryId)) continue;
            String kind = announcement.kind();
            boolean isUpdateRelated = "update_available".equals(kind) || "patch_notes".equals(kind);
            class_2960 categoryId = isUpdateRelated ? updatesId : announcementsId;
            boolean priority = false;
            if ("update_available".equals(kind)) {
                icon = "minecraft:nether_star";
                priority = true;
            } else if ("patch_notes".equals(kind)) {
                icon = "minecraft:writable_book";
                if (Semver.parse(announcement.semver()).equals(installedVersion)) {
                    priority = true;
                }
            } else {
                icon = "adorablehamsterpets:announcement_bell_icon";
            }
            BookEntry entry = this.createVirtualEntry(hamsterBook, announcement.title(), icon, priority, categoryId, entryId, i);
            entry.initCategory(entryId, categories::get);
            entries.put(entryId, entry);
            try {
                entry.build(level, self);
                continue;
            }
            catch (Exception e) {
                AdorableHamsterPets.LOGGER.error("[AHP Mixin] Failed to build virtual entry {}", (Object)entryId, (Object)e);
            }
        }
        if (categories.containsKey(updatesId)) {
            BookCategory cat = categories.get(updatesId);
            cat.build(self);
            cat.updateLockStatus(true);
            AdorableHamsterPets.LOGGER.debug("[AHP Mixin] Built 'update_notes' category with {} entries.", (Object)cat.getEntries().size());
        }
        if (categories.containsKey(announcementsId)) {
            BookCategory cat = categories.get(announcementsId);
            cat.build(self);
            cat.updateLockStatus(true);
            AdorableHamsterPets.LOGGER.debug("[AHP Mixin] Built 'announcements' category with {} entries.", (Object)cat.getEntries().size());
        }
        AdorableHamsterPets.LOGGER.debug("[AHP Mixin] After injection: {} categories, {} entries.", (Object)categories.size(), (Object)entries.size());
    }

    private BookCategory createVirtualCategory(Book book, String nameKey, String icon, int sortnum, class_2960 id) {
        JsonObject json = new JsonObject();
        json.addProperty("name", nameKey);
        json.addProperty("description", nameKey + ".desc");
        json.addProperty("icon", icon);
        json.addProperty("sortnum", (Number)sortnum);
        json.addProperty("parent", "");
        return new BookCategory(json, id, book);
    }

    private BookEntry createVirtualEntry(Book book, String name, String icon, boolean priority, class_2960 categoryId, class_2960 entryId, int sortnum) {
        JsonObject json = new JsonObject();
        json.addProperty("name", name);
        json.addProperty("icon", icon);
        json.addProperty("priority", Boolean.valueOf(priority));
        json.addProperty("sortnum", (Number)sortnum);
        json.addProperty("category", categoryId.toString());
        json.add("pages", (JsonElement)new JsonArray());
        return new BookEntry(json, entryId, book, "adorablehamsterpets");
    }
}

