/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import net.minecraft.class_1922;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2354;
import net.minecraft.class_2389;
import net.minecraft.class_2397;
import net.minecraft.class_2506;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_5555;
import net.minecraft.class_638;

public final class IndoorOutdoorDetector {
    private static final int CACHE_SIZE_BUCKETS = 1024;
    private static final int CACHE_MAX_AGE_TICKS = 18;
    private static final int MIN_RECHECK_INTERVAL_TICKS = 8;
    private static final int MAX_RECHECK_INTERVAL_JITTER_TICKS = 6;
    private static final int HORIZONTAL_OPENNESS_RAY_COUNT = 12;
    private static final int HORIZONTAL_OPENNESS_RAY_MAX_DISTANCE_BLOCKS = 6;
    private static final int HORIZONTAL_OPENNESS_WALL_COLUMN_HEIGHT_BLOCKS = 2;
    private static final int HORIZONTAL_OPENNESS_STRONG_SKYLIGHT_THRESHOLD = 12;
    private static final float HORIZONTAL_OPENNESS_MIN_FRACTION_THRESHOLD = 0.35f;
    private static final int ROOF_CLEARANCE_VERTICAL_SEARCH_RANGE_BLOCKS = 6;
    private static final int SKYLIGHT_CLEAR_COLUMN_MAX_STEPS = 16;
    private static final float WEIGHT_HORIZONTAL_OPENNESS = 0.5f;
    private static final float WEIGHT_ROOF_CLEARANCE = 0.3f;
    private static final float WEIGHT_SKYLIGHT = 0.2f;
    private static final float OUTDOOR_SCORE_THRESHOLD = 0.56f;
    private static final float INDOOR_SCORE_THRESHOLD = 0.44f;
    private static final long[] cacheKeys = new long[1024];
    private static final long[] cacheLastTick = new long[1024];
    private static final int[] cacheNextInterval = new int[1024];
    private static final float[] cacheLastScore = new float[1024];
    private static final byte[] cacheLastState = new byte[1024];

    private IndoorOutdoorDetector() {
    }

    public static boolean isOutdoor(class_638 world, double x, double y, double z) {
        boolean needRecheck;
        if (!world.method_8597().comp_642()) {
            return false;
        }
        long nowTick = world.method_8510();
        class_2338 basePos = class_2338.method_49637((double)x, (double)(y + 0.2), (double)z);
        long key = IndoorOutdoorDetector.keyFor(world, basePos);
        int idx = IndoorOutdoorDetector.bucketIndex(key);
        if (cacheKeys[idx] != key || nowTick - cacheLastTick[idx] > 18L) {
            IndoorOutdoorDetector.cacheKeys[idx] = key;
            IndoorOutdoorDetector.cacheLastTick[idx] = nowTick;
            IndoorOutdoorDetector.cacheNextInterval[idx] = IndoorOutdoorDetector.randomRecheckInterval(key);
            IndoorOutdoorDetector.cacheLastState[idx] = -1;
        }
        boolean bl = needRecheck = cacheLastState[idx] == -1 || nowTick - cacheLastTick[idx] >= (long)cacheNextInterval[idx];
        if (needRecheck) {
            float score;
            IndoorOutdoorDetector.cacheLastScore[idx] = score = IndoorOutdoorDetector.computeOutdoorScore(world, basePos);
            IndoorOutdoorDetector.cacheLastTick[idx] = nowTick;
            IndoorOutdoorDetector.cacheNextInterval[idx] = IndoorOutdoorDetector.randomRecheckInterval(key);
            byte previous = cacheLastState[idx];
            boolean newIsOutdoor = previous == -1 ? score >= 0.56f : (previous == 1 ? score >= 0.44f : score >= 0.56f);
            IndoorOutdoorDetector.cacheLastState[idx] = newIsOutdoor ? (byte)1 : 0;
        }
        return cacheLastState[idx] == 1;
    }

    private static float computeOutdoorScore(class_638 world, class_2338 pos) {
        float horizontalOpenFrac = IndoorOutdoorDetector.horizontalOpennessFraction(world, pos);
        float roofClearanceScore = IndoorOutdoorDetector.roofClearanceFactor(world, pos);
        float skylightScore = IndoorOutdoorDetector.skylightFactorCorrected(world, pos);
        float score = 0.5f * horizontalOpenFrac + 0.3f * roofClearanceScore + 0.2f * skylightScore;
        return class_3532.method_15363((float)score, (float)0.0f, (float)1.0f);
    }

    private static float horizontalOpennessFraction(class_638 world, class_2338 base) {
        int openDirections = 0;
        for (int i = 0; i < 12; ++i) {
            double ang = (float)Math.PI * 2 * (float)i / 12.0f;
            double cos = Math.cos(ang);
            double sin = Math.sin(ang);
            boolean reachedOpening = false;
            for (int d = 1; d <= 6 && !reachedOpening; ++d) {
                int sx = base.method_10263() + (int)Math.round(cos * (double)d);
                int sz = base.method_10260() + (int)Math.round(sin * (double)d);
                boolean hardBlocked = false;
                for (int h = 0; h < 2; ++h) {
                    class_2338 p = new class_2338(sx, base.method_10264() + h, sz);
                    if (!IndoorOutdoorDetector.isNonPorousWindBlock(world.method_8320(p), world, p)) continue;
                    hardBlocked = true;
                    break;
                }
                if (hardBlocked) break;
                class_2338 check = new class_2338(sx, base.method_10264() + 1, sz);
                if (!world.method_8311(check) && world.method_8314(class_1944.field_9284, check) < 12) continue;
                reachedOpening = true;
                break;
            }
            if (!reachedOpening) continue;
            ++openDirections;
        }
        float frac = (float)openDirections / 12.0f;
        return frac < 0.35f ? frac * 0.8f : frac;
    }

    private static float roofClearanceFactor(class_638 world, class_2338 pos) {
        class_2338 checkPos;
        class_2680 state;
        int clearance = 0;
        for (int i = 1; i <= 6 && !IndoorOutdoorDetector.isNonPorousWindBlock(state = world.method_8320(checkPos = pos.method_10086(i)), world, checkPos); ++i) {
            ++clearance;
        }
        return class_3532.method_15363((float)((float)clearance / 6.0f), (float)0.0f, (float)1.0f);
    }

    private static float skylightFactorCorrected(class_638 world, class_2338 pos) {
        if (!IndoorOutdoorDetector.columnToSkyIsClear(world, pos, 16)) {
            return 0.0f;
        }
        int sky = world.method_8314(class_1944.field_9284, pos);
        return class_3532.method_15363((float)((float)sky / 15.0f), (float)0.0f, (float)1.0f);
    }

    private static boolean columnToSkyIsClear(class_638 world, class_2338 from, int maxSteps) {
        for (int dy = 1; dy <= maxSteps; ++dy) {
            class_2338 p = from.method_10086(dy);
            class_2680 s = world.method_8320(p);
            if (IndoorOutdoorDetector.isGlassLike(s) || s.method_26204() instanceof class_2389) {
                return false;
            }
            if (s.method_26215() || s.method_26220((class_1922)world, p).method_1110()) continue;
            return false;
        }
        return true;
    }

    private static boolean isNonPorousWindBlock(class_2680 s, class_638 world, class_2338 at) {
        if (s.method_26215()) {
            return false;
        }
        class_2248 block = s.method_26204();
        if (block instanceof class_2354 || block instanceof class_2397) {
            return false;
        }
        if (IndoorOutdoorDetector.isGlassLike(s) || block instanceof class_2389) {
            return true;
        }
        return !s.method_26220((class_1922)world, at).method_1110();
    }

    private static boolean isGlassLike(class_2680 state) {
        class_2248 block = state.method_26204();
        return block == class_2246.field_10033 || block instanceof class_2506 || block instanceof class_5555;
    }

    private static long keyFor(class_638 world, class_2338 pos) {
        int cellX = pos.method_10263() >> 1;
        int cellZ = pos.method_10260() >> 1;
        int yQuart = pos.method_10264() >> 1;
        long dimHint = world.method_8597().comp_642() ? 1L : 2L;
        long k = dimHint << 48 ^ ((long)cellX & 0xFFFFL) << 32 ^ ((long)cellZ & 0xFFFFL) << 16 ^ (long)yQuart & 0xFFFFL;
        return IndoorOutdoorDetector.mix64(k, -3335678366873096957L);
    }

    private static int bucketIndex(long key) {
        return (int)(key & 0x3FFL);
    }

    private static int randomRecheckInterval(long key) {
        long m = IndoorOutdoorDetector.mix64(key, -7046029254386353131L);
        int jitter = (int)(m >>> 57 & 6L);
        return 8 + jitter;
    }

    private static long mix64(long seedA, long seedB) {
        long x = seedA * -7046029254386353131L + seedB + -4658895280553007687L;
        x ^= x >>> 30;
        x *= -4658895280553007687L;
        x ^= x >>> 27;
        x *= -7723592293110705685L;
        x ^= x >>> 31;
        return x;
    }

    static {
        for (int i = 0; i < cacheLastState.length; ++i) {
            IndoorOutdoorDetector.cacheLastState[i] = -1;
        }
    }
}

