/*
 * Decompiled with CFR 0.152.
 */
package net.dawson.adorablehamsterpets.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.dawson.adorablehamsterpets.AdorableHamsterPets;
import net.dawson.adorablehamsterpets.config.Configs;
import net.dawson.adorablehamsterpets.util.ParticleEffectsUtil;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;

public class TreeHeistUtil {
    private static final int MAX_TRUNK_SEARCH_DIST = 10;
    private static final int MAX_LOG_COUNT = 128;
    private static final int MAX_CANOPY_COUNT = 300;
    private static final int MAX_BUSH_COUNT = 48;
    private static final int MAX_CANOPY_DISTANCE = 5;

    public static TreeScanResult scanForTree(class_1937 world, class_2338 startPos) {
        class_2338 foundLog;
        class_2680 startState = world.method_8320(startPos);
        if (!startState.method_27852(class_2246.field_10503)) {
            if (Configs.AHP.debugTreeDetection) {
                AdorableHamsterPets.LOGGER.warn("[TreeHeist-Scan] Aborted: Start pos {} is not an Oak Leaf block (Found: {}).", (Object)startPos.method_23854(), (Object)startState.method_26204());
            }
            return new TreeScanResult(startPos, Collections.singleton(startPos));
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] Starting scan at HitPos: {}. Searching for connected logs...", (Object)startPos.method_23854());
        }
        if ((foundLog = TreeHeistUtil.findConnectedLog(world, startPos)) != null) {
            if (Configs.AHP.debugTreeDetection) {
                AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] LOG FOUND at {}. Switching to Tree Map Mode.", (Object)foundLog.method_23854());
            }
            return TreeHeistUtil.mapTreeFromLog(world, foundLog);
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] NO LOG FOUND within range. Switching to Floating Bush Mode.");
        }
        return TreeHeistUtil.mapFloatingBush(world, startPos);
    }

    private static class_2338 findConnectedLog(class_1937 world, class_2338 startNode) {
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        queue.add(startNode);
        visited.add(startNode);
        int startDist = TreeHeistUtil.getLeafDistance(world.method_8320(startNode));
        int iterations = 0;
        int maxIterations = 64;
        while (!queue.isEmpty() && iterations < maxIterations) {
            class_2338 current = (class_2338)queue.poll();
            ++iterations;
            for (class_2350 dir : class_2350.values()) {
                int dist;
                class_2338 neighbor = current.method_10093(dir);
                if (!visited.add(neighbor)) continue;
                class_2680 state = world.method_8320(neighbor);
                if (state.method_26164(class_3481.field_15475)) {
                    return neighbor;
                }
                if (!state.method_27852(class_2246.field_10503) || (dist = TreeHeistUtil.getLeafDistance(state)) > startDist && dist >= 7 || neighbor.method_19455((class_2382)startNode) > 10) continue;
                queue.add(neighbor);
            }
        }
        return null;
    }

    private static TreeScanResult mapTreeFromLog(class_1937 world, class_2338 initialLog) {
        HashSet<class_2338> treeLogs = new HashSet<class_2338>();
        ArrayDeque<class_2338> logQueue = new ArrayDeque<class_2338>();
        logQueue.add(initialLog);
        treeLogs.add(initialLog);
        class_2338 bottomMostLog = initialLog;
        while (!logQueue.isEmpty() && treeLogs.size() < 128) {
            class_2338 current = (class_2338)logQueue.poll();
            if (current.method_10264() < bottomMostLog.method_10264()) {
                bottomMostLog = current;
            } else if (current.method_10264() == bottomMostLog.method_10264() && (current.method_10263() < bottomMostLog.method_10263() || current.method_10263() == bottomMostLog.method_10263() && current.method_10260() < bottomMostLog.method_10260())) {
                bottomMostLog = current;
            }
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        class_2338 neighbor;
                        if (x == 0 && y == 0 && z == 0 || treeLogs.contains(neighbor = current.method_10069(x, y, z)) || !world.method_8320(neighbor).method_26164(class_3481.field_15475)) continue;
                        treeLogs.add(neighbor);
                        logQueue.add(neighbor);
                    }
                }
            }
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] Tree Skeleton Mapped. Total Logs: {}. Anchor Established: {}", (Object)treeLogs.size(), (Object)bottomMostLog.method_23854());
            if (treeLogs.size() >= 128) {
                AdorableHamsterPets.LOGGER.warn("[TreeHeist-Scan] Log scan hit MAX limit ({})! Tree might be truncated.", (Object)128);
            }
        }
        HashSet<class_2338> validCanopy = new HashSet<class_2338>();
        ArrayDeque<class_2338> leafQueue = new ArrayDeque<class_2338>();
        HashSet<class_2338> visitedLeaves = new HashSet<class_2338>();
        for (class_2338 log : treeLogs) {
            for (class_2350 dir : class_2350.values()) {
                int nDist;
                class_2680 nState;
                class_2338 n = log.method_10093(dir);
                if (treeLogs.contains(n) || !visitedLeaves.add(n) || !(nState = world.method_8320(n)).method_27852(class_2246.field_10503) || (nDist = TreeHeistUtil.getLeafDistance(nState)) > 5) continue;
                leafQueue.add(n);
            }
        }
        while (!leafQueue.isEmpty() && validCanopy.size() < 300) {
            class_2338 current = (class_2338)leafQueue.poll();
            class_2680 state = world.method_8320(current);
            if (!state.method_26164(class_3481.field_15503)) continue;
            int dist = TreeHeistUtil.getLeafDistance(state);
            validCanopy.add(current);
            for (class_2350 dir : class_2350.values()) {
                int nDist;
                class_2680 nState;
                class_2338 n = current.method_10093(dir);
                if (treeLogs.contains(n) || !visitedLeaves.add(n) || !(nState = world.method_8320(n)).method_27852(class_2246.field_10503) || (nDist = TreeHeistUtil.getLeafDistance(nState)) > 5 || nDist < dist) continue;
                leafQueue.add(n);
            }
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] Canopy Mapped. Valid Oak Leaves: {}", (Object)validCanopy.size());
            if (validCanopy.size() >= 300) {
                AdorableHamsterPets.LOGGER.warn("[TreeHeist-Scan] Canopy scan hit MAX limit ({})!", (Object)300);
            }
        }
        return new TreeScanResult(bottomMostLog, validCanopy);
    }

    private static TreeScanResult mapFloatingBush(class_1937 world, class_2338 startPos) {
        HashSet<class_2338> validLeaves = new HashSet<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        queue.add(startPos);
        visited.add(startPos);
        validLeaves.add(startPos);
        class_2338 lowestLeaf = startPos;
        while (!queue.isEmpty() && validLeaves.size() < 48) {
            class_2338 current = (class_2338)queue.poll();
            if (current.method_10264() < lowestLeaf.method_10264() || current.method_10264() == lowestLeaf.method_10264() && current.method_10263() < lowestLeaf.method_10263() || current.method_10264() == lowestLeaf.method_10264() && current.method_10263() == lowestLeaf.method_10263() && current.method_10260() < lowestLeaf.method_10260()) {
                lowestLeaf = current;
            }
            for (class_2350 dir : class_2350.values()) {
                class_2338 n = current.method_10093(dir);
                if (!visited.add(n) || !world.method_8320(n).method_27852(class_2246.field_10503)) continue;
                queue.add(n);
                validLeaves.add(n);
            }
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist-Scan] Bush Mapped. Size: {}. Anchor: {}", (Object)validLeaves.size(), (Object)lowestLeaf.method_23854());
        }
        return new TreeScanResult(lowestLeaf, validLeaves);
    }

    private static int getLeafDistance(class_2680 state) {
        if (state.method_28498((class_2769)class_2397.field_11199)) {
            return (Integer)state.method_11654((class_2769)class_2397.field_11199);
        }
        return 7;
    }

    public static void spawnDebugParticles(class_1937 world, class_2338 anchor, List<Long> leafLongs) {
        if (world.field_9236 || !(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        if (anchor != null) {
            ParticleEffectsUtil.spawnSpinningRing(world, anchor, (class_2394)class_2398.field_29642, 10, 0.85, 0.0, 0.7, 0.55, 3.0, 0.0);
        }
        if (!leafLongs.isEmpty()) {
            int particleCount = 200;
            for (int i = 0; i < particleCount; ++i) {
                long leafPosLong = leafLongs.get(world.method_8409().method_43048(leafLongs.size()));
                class_2338 leafPos = class_2338.method_10092((long)leafPosLong);
                ParticleEffectsUtil.spawnSphericalShell(world, class_243.method_24953((class_2382)leafPos), class_2398.field_29643, 1, 0.7, 0.2);
            }
        }
    }

    public static void spawnDebugParticles(class_1937 world, TreeScanResult result) {
        if (world.field_9236) {
            return;
        }
        ArrayList<Long> longs = new ArrayList<Long>();
        for (class_2338 p : result.validCanopyPositions()) {
            longs.add(p.method_10063());
        }
        TreeHeistUtil.spawnDebugParticles(world, result.treeId(), longs);
    }

    public static class_2338 findExitPosition(class_1937 world, class_2338 startPos) {
        class_2338 check;
        for (int y = 1; y <= 15; ++y) {
            check = startPos.method_10087(y);
            if (!TreeHeistUtil.isSafeExit(world, check)) continue;
            return check;
        }
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            class_2338 check2 = startPos.method_10093(dir);
            if (!TreeHeistUtil.isSafeExit(world, check2)) continue;
            return check2;
        }
        for (int y = 1; y <= 5; ++y) {
            check = startPos.method_10086(y);
            if (!TreeHeistUtil.isSafeExit(world, check)) continue;
            return check;
        }
        return startPos;
    }

    private static boolean isSafeExit(class_1937 world, class_2338 pos) {
        if (!world.method_8320(pos).method_26220((class_1922)world, pos).method_1110()) {
            return false;
        }
        class_2338 below = pos.method_10074();
        if (world.method_8320(below).method_26220((class_1922)world, below).method_1110()) {
            return true;
        }
        return !TreeHeistUtil.isSmallPocket(world, pos);
    }

    private static boolean isSmallPocket(class_1937 world, class_2338 startPos) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        queue.add(startPos);
        visited.add(startPos);
        int airCount = 0;
        int limit = 5;
        while (!queue.isEmpty()) {
            class_2338 current = (class_2338)queue.poll();
            if (++airCount >= limit) {
                return false;
            }
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2338 neighbor = current.method_10093(dir);
                if (visited.contains(neighbor) || !world.method_8320(neighbor).method_26220((class_1922)world, neighbor).method_1110()) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
        return true;
    }

    public static void sendHeistStartMessage(class_1657 player, float profitability) {
        if (!Configs.AHP.enableTreeHeistStartMessage) {
            return;
        }
        String key = "message.adorablehamsterpets.tree_heist_start.high";
        class_124 color = class_124.field_1068;
        if (profitability < 0.4f) {
            key = "message.adorablehamsterpets.tree_heist_start.low";
        } else if (profitability < 0.9f) {
            key = "message.adorablehamsterpets.tree_heist_start.medium";
        }
        if (Configs.AHP.debugTreeDetection) {
            AdorableHamsterPets.LOGGER.info("[TreeHeist] Starting heist for player {}. Profitability: {} ({}%). Selected Message Key: {}", new Object[]{player.method_5477().getString(), String.format("%.2f", Float.valueOf(profitability)), (int)(profitability * 100.0f), key});
        }
        player.method_7353((class_2561)class_2561.method_43471((String)key).method_27692(color), true);
    }

    public record TreeScanResult(class_2338 treeId, Set<class_2338> validCanopyPositions) {
    }

    public record HeistRecord(class_2338 pos, long timestamp) {
    }
}

