/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.customfirework.dispenser;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import net.mcreator.customfirework.firework.CustomTextFirework;
import net.mcreator.customfirework.firework.TextToParticleConverter;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public class CustomFireworkDispenserBehavior
extends DefaultDispenseItemBehavior {
    protected ItemStack execute(BlockSource source, ItemStack stack) {
        ServerLevel world = source.level();
        if (world.isClientSide()) {
            return stack;
        }
        ServerLevel serverLevel = world;
        Direction direction = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        double x = (double)source.pos().getX() + 0.5 + (double)direction.getStepX() * 0.5;
        double y = (double)source.pos().getY() + 0.5 + (double)direction.getStepY() * 0.5;
        double z = (double)source.pos().getZ() + 0.5 + (double)direction.getStepZ() * 0.5;
        String text = TextToParticleConverter.getItemText(stack);
        ItemStack fireworkItem = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        FireworkExplosion explosion = new FireworkExplosion(FireworkExplosion.Shape.SMALL_BALL, IntList.of(), IntList.of(), false, false);
        fireworkItem.set(DataComponents.FIREWORKS, (Object)new Fireworks(0, List.of(explosion)));
        FireworkRocketEntity firework = new FireworkRocketEntity((Level)world, x, y, z, fireworkItem);
        double velocityMultiplier = 0.6;
        firework.setDeltaMovement((double)direction.getStepX() * velocityMultiplier, (double)direction.getStepY() * velocityMultiplier + 0.1, (double)direction.getStepZ() * velocityMultiplier);
        CustomTextFirework.trackRocket(serverLevel, firework, text);
        world.addFreshEntity((Entity)firework);
        world.playSound(null, x, y, z, SoundEvents.FIREWORK_ROCKET_LAUNCH, SoundSource.NEUTRAL, 1.0f, 1.0f);
        stack.shrink(1);
        return stack;
    }
}

