/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.customfirework.firework;

import it.unimi.dsi.fastutil.ints.IntList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.mcreator.customfirework.firework.TextToParticleConverter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CustomTextFirework {
    private static final Map<Integer, RocketData> activeRockets = new HashMap<Integer, RocketData>();

    public static void launchTextFirework(Level world, double x, double y, double z, ItemStack originalItem) {
        if (world.isClientSide()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        String text = TextToParticleConverter.getItemText(originalItem);
        ItemStack fireworkItem = new ItemStack((ItemLike)Items.FIREWORK_ROCKET);
        FireworkExplosion explosion = new FireworkExplosion(FireworkExplosion.Shape.SMALL_BALL, IntList.of(), IntList.of(), false, false);
        fireworkItem.set(DataComponents.FIREWORKS, (Object)new Fireworks(1, List.of(explosion)));
        FireworkRocketEntity firework = new FireworkRocketEntity(world, x + 0.5, y + 1.0, z + 0.5, fireworkItem);
        world.addFreshEntity((Entity)firework);
        CustomTextFirework.trackRocket(serverLevel, firework, text);
    }

    public static void trackRocket(ServerLevel world, FireworkRocketEntity firework, String text) {
        activeRockets.put(firework.getId(), new RocketData(firework, text));
        CustomTextFirework.scheduleRocketCheck(world, firework.getId());
    }

    private static void scheduleRocketCheck(final ServerLevel world, final int rocketId) {
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){
            int checks = 0;

            @Override
            public void run() {
                ++this.checks;
                if (this.checks > 100) {
                    activeRockets.remove(rocketId);
                    timer.cancel();
                    return;
                }
                if (!world.getServer().isStopped()) {
                    world.getServer().execute(() -> {
                        RocketData data = activeRockets.get(rocketId);
                        if (data != null) {
                            FireworkRocketEntity rocket = data.rocket;
                            if (!rocket.isAlive() || rocket.isRemoved()) {
                                rocket.discard();
                                CustomTextFirework.createTextExplosion(world, rocket.getX(), rocket.getY(), rocket.getZ(), data.text);
                                activeRockets.remove(rocketId);
                                timer.cancel();
                            }
                        } else {
                            timer.cancel();
                        }
                    });
                }
            }
        }, 100L, 50L);
    }

    public static void createTextExplosion(ServerLevel world, double x, double y, double z, String text) {
        world.playSound(null, x, y, z, SoundEvents.FIREWORK_ROCKET_LARGE_BLAST, SoundSource.AMBIENT, 3.0f, 0.8f);
        List<double[][]> coordsList = TextToParticleConverter.textToCoordinates(text);
        double[][] centeredCoords = TextToParticleConverter.centerCoordinates(coordsList);
        double scale = 2.5;
        double pointSpread = 0.2;
        for (double[] coord : centeredCoords) {
            double centerX = x + coord[0] * scale;
            double centerY = y + coord[1] * scale;
            double centerZ = z;
            for (ServerPlayer player : world.players()) {
                world.sendParticles(player, (ParticleOptions)ParticleTypes.FIREWORK, true, false, centerX, centerY, centerZ, 1, 0.05, 0.05, 0.0, 0.005);
            }
        }
        world.playSound(null, x, y, z, SoundEvents.FIREWORK_ROCKET_TWINKLE, SoundSource.AMBIENT, 2.0f, 1.0f);
    }

    private static class RocketData {
        FireworkRocketEntity rocket;
        String text;
        long launchTime;

        RocketData(FireworkRocketEntity rocket, String text) {
            this.rocket = rocket;
            this.text = text;
            this.launchTime = System.currentTimeMillis();
        }
    }
}

