/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.customfirework.firework;

import java.util.List;
import net.mcreator.customfirework.firework.TextToParticleConverter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class TextFireworkParticleHelper {
    public static void createAnimatedText(Level world, double x, double y, double z, String text, int animationTicks) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        List<double[][]> coordsList = TextToParticleConverter.textToCoordinates(text);
        double[][] centeredCoords = TextToParticleConverter.centerCoordinates(coordsList);
        int particlesPerTick = Math.max(1, centeredCoords.length / animationTicks);
        for (int i = 0; i < centeredCoords.length; ++i) {
            double[] coord = centeredCoords[i];
            for (int j = 0; j < 2; ++j) {
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.FIREWORK, x + coord[0], y + coord[1], z, 1, 0.02, 0.02, 0.02, 0.0);
            }
        }
    }

    public static void createExplosiveText(Level world, double x, double y, double z, String text) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        List<double[][]> coordsList = TextToParticleConverter.textToCoordinates(text);
        double[][] centeredCoords = TextToParticleConverter.centerCoordinates(coordsList);
        for (int rotation = 0; rotation < 4; ++rotation) {
            double angle = Math.toRadians(rotation * 90);
            for (double[] coord : centeredCoords) {
                double rotatedX = coord[0] * Math.cos(angle);
                double rotatedZ = coord[0] * Math.sin(angle);
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.FIREWORK, x + rotatedX, y + coord[1], z + rotatedZ, 2, 0.1, 0.1, 0.1, 0.05);
            }
        }
    }
}

