/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.customfirework.firework;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;

public class TextToParticleConverter {
    private static final Map<Character, double[][]> CHARACTER_COORDS = new HashMap<Character, double[][]>();

    public static String getItemText(ItemStack stack) {
        if (stack.has(DataComponents.CUSTOM_NAME)) {
            return stack.getHoverName().getString().toUpperCase();
        }
        return " ";
    }

    public static List<double[][]> textToCoordinates(String text) {
        ArrayList<double[][]> allCoords = new ArrayList<double[][]>();
        if (text == null || text.isEmpty()) {
            text = " ";
        }
        if (text.length() > 13) {
            text = text.substring(0, 13);
        }
        char[] chars = text.toCharArray();
        double offsetX = 0.0;
        for (char c : chars) {
            Object charCoords = CHARACTER_COORDS.get(Character.valueOf(c));
            if (charCoords == null) {
                charCoords = new double[][]{{0.15, 0.0}};
            }
            double[][] offsetCoords = new double[((double[][])charCoords).length][2];
            for (int i = 0; i < ((double[][])charCoords).length; ++i) {
                offsetCoords[i][0] = charCoords[i][0] + offsetX;
                offsetCoords[i][1] = charCoords[i][1];
            }
            allCoords.add(offsetCoords);
            offsetX += 0.65;
        }
        return allCoords;
    }

    public static double[][] centerCoordinates(List<double[][]> coordsList) {
        ArrayList<double[]> flatList = new ArrayList<double[]>();
        for (double[][] coords : coordsList) {
            for (double[] coord : coords) {
                flatList.add(coord);
            }
        }
        if (flatList.isEmpty()) {
            return new double[][]{{0.0, 0.0}};
        }
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        for (double[] coord : flatList) {
            minX = Math.min(minX, coord[0]);
            maxX = Math.max(maxX, coord[0]);
            minY = Math.min(minY, coord[1]);
            maxY = Math.max(maxY, coord[1]);
        }
        double centerX = (minX + maxX) / 2.0;
        double centerY = (minY + maxY) / 2.0;
        double[][] result = new double[flatList.size()][2];
        for (int i = 0; i < flatList.size(); ++i) {
            result[i][0] = ((double[])flatList.get(i))[0] - centerX;
            result[i][1] = ((double[])flatList.get(i))[1] - centerY;
        }
        return result;
    }

    /*
     * Opcode count of 19163 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        CHARACTER_COORDS.put(Character.valueOf('0'), new double[][]{{-0.15, 0.6}, {-0.1, 0.65}, {-0.05, 0.68}, {0.0, 0.7}, {0.05, 0.68}, {0.1, 0.65}, {0.15, 0.6}, {0.18, 0.5}, {0.2, 0.4}, {0.22, 0.3}, {0.23, 0.2}, {0.24, 0.1}, {0.24, 0.0}, {0.23, -0.1}, {0.22, -0.2}, {0.2, -0.3}, {0.18, -0.4}, {0.15, -0.5}, {0.1, -0.55}, {0.05, -0.58}, {0.0, -0.6}, {-0.05, -0.58}, {-0.1, -0.55}, {-0.15, -0.5}, {-0.18, -0.4}, {-0.2, -0.3}, {-0.22, -0.2}, {-0.23, -0.1}, {-0.24, 0.0}, {-0.23, 0.1}, {-0.22, 0.2}, {-0.2, 0.3}, {-0.18, 0.4}, {-0.15, 0.5}});
        CHARACTER_COORDS.put(Character.valueOf('1'), new double[][]{{-0.1, 0.45}, {-0.05, 0.5}, {0.0, 0.55}, {0.05, 0.6}, {0.1, 0.6}, {0.1, 0.55}, {0.1, 0.5}, {0.1, 0.45}, {0.1, 0.4}, {0.1, 0.35}, {0.1, 0.3}, {0.1, 0.25}, {0.1, 0.2}, {0.1, 0.15}, {0.1, 0.1}, {0.1, 0.05}, {0.1, 0.0}, {0.1, -0.05}, {0.1, -0.1}, {0.1, -0.15}, {0.1, -0.2}, {0.1, -0.25}, {0.1, -0.3}, {0.1, -0.35}, {0.1, -0.4}, {0.1, -0.45}, {0.1, -0.5}, {0.1, -0.55}, {0.1, -0.6}});
        CHARACTER_COORDS.put(Character.valueOf('2'), new double[][]{{-0.2, 0.5}, {-0.15, 0.58}, {-0.1, 0.63}, {-0.05, 0.66}, {0.0, 0.68}, {0.05, 0.66}, {0.1, 0.63}, {0.15, 0.58}, {0.2, 0.5}, {0.22, 0.4}, {0.23, 0.3}, {0.22, 0.2}, {0.2, 0.1}, {0.15, 0.0}, {0.1, -0.1}, {0.05, -0.15}, {0.0, -0.2}, {-0.05, -0.25}, {-0.1, -0.3}, {-0.15, -0.35}, {-0.18, -0.4}, {-0.2, -0.45}, {-0.2, -0.5}, {-0.2, -0.55}, {-0.15, -0.6}, {-0.1, -0.6}, {-0.05, -0.6}, {0.0, -0.6}, {0.05, -0.6}, {0.1, -0.6}, {0.15, -0.6}, {0.2, -0.6}});
        CHARACTER_COORDS.put(Character.valueOf('3'), new double[][]{{-0.2, 0.6}, {-0.1, 0.6}, {0.0, 0.6}, {0.1, 0.6}, {0.15, 0.58}, {0.18, 0.54}, {0.2, 0.5}, {0.22, 0.4}, {0.23, 0.3}, {0.22, 0.2}, {0.2, 0.1}, {0.15, 0.05}, {0.1, 0.0}, {0.05, 0.0}, {0.0, 0.0}, {0.05, 0.0}, {0.1, 0.0}, {0.15, -0.05}, {0.2, -0.1}, {0.22, -0.2}, {0.23, -0.3}, {0.22, -0.4}, {0.2, -0.5}, {0.15, -0.54}, {0.1, -0.58}, {0.0, -0.6}, {-0.1, -0.6}, {-0.2, -0.6}});
        CHARACTER_COORDS.put(Character.valueOf('4'), new double[][]{{-0.2, 0.6}, {-0.2, 0.55}, {-0.2, 0.5}, {-0.2, 0.45}, {-0.2, 0.4}, {-0.2, 0.35}, {-0.2, 0.3}, {-0.2, 0.25}, {-0.2, 0.2}, {-0.2, 0.15}, {-0.2, 0.1}, {-0.2, 0.05}, {-0.2, 0.0}, {-0.2, -0.05}, {-0.2, -0.05}, {-0.15, -0.05}, {-0.1, -0.05}, {-0.05, -0.05}, {0.0, -0.05}, {0.05, -0.05}, {0.1, -0.05}, {0.15, -0.05}, {0.2, -0.05}, {0.2, 0.6}, {0.2, 0.55}, {0.2, 0.5}, {0.2, 0.45}, {0.2, 0.4}, {0.2, 0.35}, {0.2, 0.3}, {0.2, 0.25}, {0.2, 0.2}, {0.2, 0.15}, {0.2, 0.1}, {0.2, 0.05}, {0.2, 0.0}, {0.2, -0.05}, {0.2, -0.1}, {0.2, -0.15}, {0.2, -0.2}, {0.2, -0.25}, {0.2, -0.3}, {0.2, -0.35}, {0.2, -0.4}, {0.2, -0.45}, {0.2, -0.5}, {0.2, -0.55}, {0.2, -0.6}});
        CHARACTER_COORDS.put(Character.valueOf('5'), new double[][]{{0.2, 0.6}, {0.15, 0.6}, {0.1, 0.6}, {0.05, 0.6}, {0.0, 0.6}, {-0.05, 0.6}, {-0.1, 0.6}, {-0.15, 0.6}, {-0.2, 0.6}, {-0.2, 0.55}, {-0.2, 0.5}, {-0.2, 0.45}, {-0.2, 0.4}, {-0.2, 0.35}, {-0.2, 0.3}, {-0.2, 0.25}, {-0.2, 0.2}, {-0.2, 0.15}, {-0.2, 0.1}, {-0.2, 0.05}, {-0.15, 0.05}, {-0.1, 0.05}, {-0.05, 0.05}, {0.0, 0.05}, {0.05, 0.05}, {0.1, 0.05}, {0.15, 0.05}, {0.18, 0.0}, {0.2, -0.05}, {0.22, -0.15}, {0.23, -0.25}, {0.22, -0.35}, {0.2, -0.45}, {0.15, -0.52}, {0.1, -0.57}, {0.0, -0.6}, {-0.1, -0.6}, {-0.2, -0.6}});
        CHARACTER_COORDS.put(Character.valueOf('6'), new double[][]{{0.2, 0.6}, {0.1, 0.6}, {0.0, 0.6}, {-0.1, 0.58}, {-0.15, 0.54}, {-0.18, 0.5}, {-0.2, 0.4}, {-0.22, 0.3}, {-0.23, 0.2}, {-0.23, 0.1}, {-0.23, 0.0}, {-0.23, -0.1}, {-0.22, -0.2}, {-0.2, -0.3}, {-0.18, -0.4}, {-0.15, -0.48}, {-0.1, -0.55}, {0.0, -0.6}, {0.1, -0.55}, {0.15, -0.48}, {0.18, -0.4}, {0.2, -0.3}, {0.22, -0.2}, {0.23, -0.1}, {0.23, 0.0}, {0.2, 0.05}, {0.15, 0.08}, {0.1, 0.1}, {0.05, 0.1}, {0.0, 0.1}, {-0.05, 0.1}, {-0.1, 0.1}, {-0.15, 0.1}, {-0.2, 0.1}});
        CHARACTER_COORDS.put(Character.valueOf('7'), new double[][]{{-0.35, 0.65}, {-0.32, 0.65}, {-0.29, 0.65}, {-0.26, 0.65}, {-0.23, 0.65}, {-0.2, 0.65}, {-0.17, 0.65}, {-0.14, 0.65}, {-0.11, 0.65}, {-0.08, 0.65}, {-0.05, 0.65}, {-0.02, 0.65}, {0.01, 0.65}, {0.04, 0.65}, {0.07, 0.65}, {0.1, 0.65}, {0.13, 0.65}, {0.16, 0.65}, {0.19, 0.65}, {0.22, 0.65}, {0.25, 0.65}, {0.28, 0.65}, {0.31, 0.65}, {0.34, 0.65}, {0.33, 0.62}, {0.32, 0.59}, {0.31, 0.56}, {0.3, 0.53}, {0.29, 0.5}, {0.28, 0.47}, {0.27, 0.44}, {0.26, 0.41}, {0.25, 0.38}, {0.24, 0.35}, {0.23, 0.32}, {0.22, 0.29}, {0.21, 0.26}, {0.2, 0.23}, {0.19, 0.2}, {0.18, 0.17}, {0.17, 0.14}, {0.16, 0.11}, {0.15, 0.08}, {0.14, 0.05}, {0.13, 0.02}, {0.12, -0.01}, {0.11, -0.04}, {0.1, -0.07}, {0.09, -0.1}, {0.08, -0.13}, {0.07, -0.16}, {0.06, -0.19}, {0.05, -0.22}, {0.04, -0.25}, {0.03, -0.28}, {0.02, -0.31}, {0.01, -0.34}, {0.0, -0.37}, {-0.01, -0.4}, {-0.02, -0.43}, {-0.03, -0.46}, {-0.04, -0.49}, {-0.05, -0.52}, {-0.06, -0.55}, {-0.07, -0.58}, {-0.08, -0.61}, {-0.09, -0.64}, {-0.1, -0.67}, {-0.11, -0.7}, {-0.12, -0.73}, {-0.13, -0.76}, {-0.14, -0.79}, {-0.15, -0.82}});
        CHARACTER_COORDS.put(Character.valueOf('8'), new double[][]{{-0.12, 0.4}, {-0.1, 0.48}, {-0.05, 0.53}, {0.0, 0.55}, {0.05, 0.53}, {0.1, 0.48}, {0.12, 0.4}, {0.1, 0.32}, {0.05, 0.27}, {0.0, 0.25}, {-0.05, 0.27}, {-0.1, 0.32}, {-0.08, 0.2}, {-0.05, 0.15}, {0.0, 0.12}, {0.05, 0.15}, {0.08, 0.2}, {0.08, 0.0}, {0.05, -0.05}, {0.0, -0.08}, {-0.05, -0.05}, {-0.08, 0.0}, {-0.15, -0.15}, {-0.12, -0.25}, {-0.08, -0.35}, {-0.03, -0.43}, {0.0, -0.47}, {0.03, -0.43}, {0.08, -0.35}, {0.12, -0.25}, {0.15, -0.15}, {0.12, -0.05}, {0.08, 0.03}, {0.03, 0.08}, {0.0, 0.1}, {-0.03, 0.08}, {-0.08, 0.03}, {-0.12, -0.05}});
        CHARACTER_COORDS.put(Character.valueOf('9'), new double[][]{{-0.15, 0.3}, {-0.12, 0.38}, {-0.08, 0.45}, {-0.03, 0.5}, {0.0, 0.53}, {0.03, 0.5}, {0.08, 0.45}, {0.12, 0.38}, {0.15, 0.3}, {0.18, 0.2}, {0.2, 0.1}, {0.2, 0.0}, {0.18, -0.1}, {0.15, -0.2}, {0.1, 0.15}, {0.05, 0.15}, {0.0, 0.15}, {-0.05, 0.15}, {-0.1, 0.15}, {0.12, -0.3}, {0.08, -0.4}, {0.03, -0.48}, {0.0, -0.53}, {-0.03, -0.56}, {-0.08, -0.58}, {-0.15, -0.6}, {-0.25, -0.6}});
        CHARACTER_COORDS.put(Character.valueOf('A'), new double[][]{{-0.25, -0.65}, {-0.23, -0.55}, {-0.21, -0.45}, {-0.19, -0.35}, {-0.17, -0.25}, {-0.15, -0.15}, {-0.13, -0.05}, {-0.11, 0.05}, {-0.09, 0.15}, {-0.07, 0.25}, {-0.05, 0.35}, {-0.03, 0.45}, {-0.01, 0.55}, {0.0, 0.65}, {0.01, 0.55}, {0.03, 0.45}, {0.05, 0.35}, {0.07, 0.25}, {0.09, 0.15}, {0.11, 0.05}, {0.13, -0.05}, {0.15, -0.15}, {0.17, -0.25}, {0.19, -0.35}, {0.21, -0.45}, {0.23, -0.55}, {0.25, -0.65}, {-0.18, -0.2}, {-0.15, -0.2}, {-0.12, -0.2}, {-0.09, -0.2}, {-0.06, -0.2}, {-0.03, -0.2}, {0.0, -0.2}, {0.03, -0.2}, {0.06, -0.2}, {0.09, -0.2}, {0.12, -0.2}, {0.15, -0.2}, {0.18, -0.2}});
        CHARACTER_COORDS.put(Character.valueOf('B'), new double[][]{{-0.2, 0.65}, {-0.2, 0.6}, {-0.2, 0.5}, {-0.2, 0.4}, {-0.2, 0.3}, {-0.2, 0.2}, {-0.2, 0.1}, {-0.2, 0.0}, {-0.2, -0.1}, {-0.2, -0.2}, {-0.2, -0.3}, {-0.2, -0.4}, {-0.2, -0.5}, {-0.2, -0.6}, {-0.2, -0.65}, {-0.15, 0.65}, {-0.1, 0.65}, {-0.05, 0.65}, {0.0, 0.65}, {0.05, 0.64}, {0.1, 0.62}, {0.15, 0.58}, {0.18, 0.53}, {0.2, 0.47}, {0.21, 0.4}, {0.21, 0.32}, {0.2, 0.24}, {0.18, 0.17}, {0.15, 0.11}, {0.1, 0.06}, {0.05, 0.02}, {0.0, 0.0}, {-0.05, 0.0}, {-0.1, 0.0}, {-0.15, 0.0}, {-0.15, -0.02}, {-0.1, -0.04}, {-0.05, -0.05}, {0.0, -0.06}, {0.05, -0.08}, {0.1, -0.12}, {0.15, -0.18}, {0.18, -0.25}, {0.2, -0.33}, {0.21, -0.42}, {0.2, -0.5}, {0.18, -0.56}, {0.15, -0.6}, {0.1, -0.63}, {0.05, -0.65}, {0.0, -0.66}, {-0.05, -0.66}, {-0.1, -0.65}, {-0.15, -0.65}});
        CHARACTER_COORDS.put(Character.valueOf('C'), new double[][]{{0.25, 0.5}, {0.22, 0.56}, {0.18, 0.6}, {0.13, 0.64}, {0.08, 0.66}, {0.02, 0.68}, {-0.04, 0.68}, {-0.1, 0.66}, {-0.15, 0.63}, {-0.19, 0.58}, {-0.22, 0.52}, {-0.24, 0.45}, {-0.25, 0.38}, {-0.26, 0.3}, {-0.26, 0.22}, {-0.26, 0.14}, {-0.26, 0.06}, {-0.26, -0.02}, {-0.26, -0.1}, {-0.26, -0.18}, {-0.26, -0.26}, {-0.25, -0.34}, {-0.24, -0.42}, {-0.22, -0.49}, {-0.19, -0.55}, {-0.15, -0.6}, {-0.1, -0.64}, {-0.04, -0.67}, {0.02, -0.68}, {0.08, -0.67}, {0.13, -0.64}, {0.18, -0.6}, {0.22, -0.55}, {0.25, -0.48}});
        CHARACTER_COORDS.put(Character.valueOf('D'), new double[][]{{-0.2, 0.65}, {-0.2, 0.55}, {-0.2, 0.45}, {-0.2, 0.35}, {-0.2, 0.25}, {-0.2, 0.15}, {-0.2, 0.05}, {-0.2, -0.05}, {-0.2, -0.15}, {-0.2, -0.25}, {-0.2, -0.35}, {-0.2, -0.45}, {-0.2, -0.55}, {-0.2, -0.65}, {-0.15, 0.65}, {-0.1, 0.65}, {-0.05, 0.65}, {0.0, 0.65}, {0.05, 0.64}, {0.1, 0.62}, {0.15, 0.59}, {0.19, 0.54}, {0.22, 0.48}, {0.24, 0.41}, {0.25, 0.33}, {0.26, 0.25}, {0.26, 0.17}, {0.26, 0.09}, {0.26, 0.01}, {0.26, -0.07}, {0.26, -0.15}, {0.26, -0.23}, {0.26, -0.31}, {0.25, -0.39}, {0.24, -0.46}, {0.22, -0.52}, {0.19, -0.57}, {0.15, -0.61}, {0.1, -0.64}, {0.05, -0.65}, {0.0, -0.66}, {-0.05, -0.66}, {-0.1, -0.65}, {-0.15, -0.65}});
        CHARACTER_COORDS.put(Character.valueOf('E'), new double[][]{{0.25, 0.65}, {0.2, 0.65}, {0.15, 0.65}, {0.1, 0.65}, {0.05, 0.65}, {0.0, 0.65}, {-0.05, 0.65}, {-0.1, 0.65}, {-0.15, 0.65}, {-0.2, 0.65}, {-0.2, 0.6}, {-0.2, 0.5}, {-0.2, 0.4}, {-0.2, 0.3}, {-0.2, 0.2}, {-0.2, 0.1}, {-0.2, 0.0}, {-0.2, -0.1}, {-0.2, -0.2}, {-0.2, -0.3}, {-0.2, -0.4}, {-0.2, -0.5}, {-0.2, -0.6}, {-0.2, -0.65}, {-0.15, 0.0}, {-0.1, 0.0}, {-0.05, 0.0}, {0.0, 0.0}, {0.05, 0.0}, {0.1, 0.0}, {0.15, 0.0}, {0.2, 0.0}, {-0.15, -0.65}, {-0.1, -0.65}, {-0.05, -0.65}, {0.0, -0.65}, {0.05, -0.65}, {0.1, -0.65}, {0.15, -0.65}, {0.2, -0.65}, {0.25, -0.65}});
        CHARACTER_COORDS.put(Character.valueOf('F'), new double[][]{{-0.2, -0.65}, {-0.2, -0.55}, {-0.2, -0.45}, {-0.2, -0.35}, {-0.2, -0.25}, {-0.2, -0.15}, {-0.2, -0.05}, {-0.2, 0.05}, {-0.2, 0.15}, {-0.2, 0.25}, {-0.2, 0.35}, {-0.2, 0.45}, {-0.2, 0.55}, {-0.2, 0.65}, {-0.15, 0.65}, {-0.1, 0.65}, {-0.05, 0.65}, {0.0, 0.65}, {0.05, 0.65}, {0.1, 0.65}, {0.15, 0.65}, {0.2, 0.65}, {0.25, 0.65}, {-0.15, 0.0}, {-0.1, 0.0}, {-0.05, 0.0}, {0.0, 0.0}, {0.05, 0.0}, {0.1, 0.0}, {0.15, 0.0}, {0.2, 0.0}});
        CHARACTER_COORDS.put(Character.valueOf('G'), new double[][]{{0.25, 0.45}, {0.22, 0.52}, {0.18, 0.58}, {0.13, 0.62}, {0.08, 0.65}, {0.02, 0.67}, {-0.04, 0.68}, {-0.1, 0.66}, {-0.15, 0.63}, {-0.19, 0.58}, {-0.22, 0.52}, {-0.24, 0.45}, {-0.25, 0.37}, {-0.26, 0.29}, {-0.26, 0.21}, {-0.26, 0.13}, {-0.26, 0.05}, {-0.26, -0.03}, {-0.26, -0.11}, {-0.26, -0.19}, {-0.26, -0.27}, {-0.25, -0.35}, {-0.24, -0.43}, {-0.22, -0.5}, {-0.19, -0.56}, {-0.15, -0.61}, {-0.1, -0.64}, {-0.04, -0.67}, {0.02, -0.68}, {0.08, -0.67}, {0.13, -0.64}, {0.18, -0.6}, {0.22, -0.55}, {0.25, -0.48}, {0.26, -0.4}, {0.27, -0.32}, {0.27, -0.24}, {0.27, -0.16}, {0.27, -0.08}, {0.27, 0.0}, {0.22, 0.0}, {0.17, 0.0}, {0.12, 0.0}, {0.07, 0.0}});
        CHARACTER_COORDS.put(Character.valueOf('H'), new double[][]{{-0.25, 0.65}, {-0.25, 0.55}, {-0.25, 0.45}, {-0.25, 0.35}, {-0.25, 0.25}, {-0.25, 0.15}, {-0.25, 0.05}, {-0.25, -0.05}, {-0.25, -0.15}, {-0.25, -0.25}, {-0.25, -0.35}, {-0.25, -0.45}, {-0.25, -0.55}, {-0.25, -0.65}, {0.25, 0.65}, {0.25, 0.55}, {0.25, 0.45}, {0.25, 0.35}, {0.25, 0.25}, {0.25, 0.15}, {0.25, 0.05}, {0.25, -0.05}, {0.25, -0.15}, {0.25, -0.25}, {0.25, -0.35}, {0.25, -0.45}, {0.25, -0.55}, {0.25, -0.65}, {-0.25, 0.0}, {-0.2, 0.0}, {-0.15, 0.0}, {-0.1, 0.0}, {-0.05, 0.0}, {0.0, 0.0}, {0.05, 0.0}, {0.1, 0.0}, {0.15, 0.0}, {0.2, 0.0}, {0.25, 0.0}});
        CHARACTER_COORDS.put(Character.valueOf('I'), new double[][]{{-0.2, 0.65}, {-0.15, 0.65}, {-0.1, 0.65}, {-0.05, 0.65}, {0.0, 0.65}, {0.05, 0.65}, {0.1, 0.65}, {0.15, 0.65}, {0.2, 0.65}, {0.0, 0.6}, {0.0, 0.5}, {0.0, 0.4}, {0.0, 0.3}, {0.0, 0.2}, {0.0, 0.1}, {0.0, 0.0}, {0.0, -0.1}, {0.0, -0.2}, {0.0, -0.3}, {0.0, -0.4}, {0.0, -0.5}, {0.0, -0.6}, {-0.2, -0.65}, {-0.15, -0.65}, {-0.1, -0.65}, {-0.05, -0.65}, {0.0, -0.65}, {0.05, -0.65}, {0.1, -0.65}, {0.15, -0.65}, {0.2, -0.65}});
        CHARACTER_COORDS.put(Character.valueOf('J'), new double[][]{{-0.1, 0.65}, {-0.05, 0.65}, {0.0, 0.65}, {0.05, 0.65}, {0.1, 0.65}, {0.15, 0.65}, {0.2, 0.65}, {0.25, 0.65}, {0.2, 0.6}, {0.2, 0.5}, {0.2, 0.4}, {0.2, 0.3}, {0.2, 0.2}, {0.2, 0.1}, {0.2, 0.0}, {0.2, -0.1}, {0.2, -0.2}, {0.2, -0.3}, {0.19, -0.4}, {0.17, -0.48}, {0.14, -0.55}, {0.1, -0.6}, {0.05, -0.64}, {0.0, -0.66}, {-0.05, -0.67}, {-0.1, -0.66}, {-0.15, -0.63}, {-0.18, -0.58}, {-0.2, -0.52}});
        CHARACTER_COORDS.put(Character.valueOf('K'), new double[][]{{-0.25, 0.65}, {-0.25, 0.55}, {-0.25, 0.45}, {-0.25, 0.35}, {-0.25, 0.25}, {-0.25, 0.15}, {-0.25, 0.05}, {-0.25, -0.05}, {-0.25, -0.15}, {-0.25, -0.25}, {-0.25, -0.35}, {-0.25, -0.45}, {-0.25, -0.55}, {-0.25, -0.65}, {0.25, 0.65}, {0.22, 0.58}, {0.18, 0.51}, {0.14, 0.44}, {0.1, 0.37}, {0.06, 0.3}, {0.02, 0.23}, {-0.02, 0.16}, {-0.06, 0.09}, {-0.1, 0.02}, {-0.14, -0.05}, {-0.18, -0.05}, {-0.22, -0.05}, {-0.18, 0.0}, {-0.14, 0.0}, {-0.1, -0.07}, {-0.06, -0.14}, {-0.02, -0.21}, {0.02, -0.28}, {0.06, -0.35}, {0.1, -0.42}, {0.14, -0.49}, {0.18, -0.56}, {0.22, -0.61}, {0.25, -0.65}});
        CHARACTER_COORDS.put(Character.valueOf('L'), new double[][]{{-0.2, 0.65}, {-0.2, 0.55}, {-0.2, 0.45}, {-0.2, 0.35}, {-0.2, 0.25}, {-0.2, 0.15}, {-0.2, 0.05}, {-0.2, -0.05}, {-0.2, -0.15}, {-0.2, -0.25}, {-0.2, -0.35}, {-0.2, -0.45}, {-0.2, -0.55}, {-0.2, -0.65}, {-0.15, -0.65}, {-0.1, -0.65}, {-0.05, -0.65}, {0.0, -0.65}, {0.05, -0.65}, {0.1, -0.65}, {0.15, -0.65}, {0.2, -0.65}, {0.25, -0.65}});
        CHARACTER_COORDS.put(Character.valueOf('M'), new double[][]{{-0.3, -0.65}, {-0.3, -0.55}, {-0.3, -0.45}, {-0.3, -0.35}, {-0.3, -0.25}, {-0.3, -0.15}, {-0.3, -0.05}, {-0.3, 0.05}, {-0.3, 0.15}, {-0.3, 0.25}, {-0.3, 0.35}, {-0.3, 0.45}, {-0.3, 0.55}, {-0.3, 0.65}, {-0.27, 0.6}, {-0.24, 0.54}, {-0.21, 0.48}, {-0.18, 0.42}, {-0.15, 0.36}, {-0.12, 0.3}, {-0.09, 0.24}, {-0.06, 0.18}, {-0.03, 0.12}, {0.0, 0.06}, {0.0, 0.0}, {0.0, -0.06}, {0.03, 0.12}, {0.06, 0.18}, {0.09, 0.24}, {0.12, 0.3}, {0.15, 0.36}, {0.18, 0.42}, {0.21, 0.48}, {0.24, 0.54}, {0.27, 0.6}, {0.3, 0.65}, {0.3, 0.55}, {0.3, 0.45}, {0.3, 0.35}, {0.3, 0.25}, {0.3, 0.15}, {0.3, 0.05}, {0.3, -0.05}, {0.3, -0.15}, {0.3, -0.25}, {0.3, -0.35}, {0.3, -0.45}, {0.3, -0.55}, {0.3, -0.65}});
        CHARACTER_COORDS.put(Character.valueOf('N'), new double[][]{{-0.25, -0.65}, {-0.25, -0.55}, {-0.25, -0.45}, {-0.25, -0.35}, {-0.25, -0.25}, {-0.25, -0.15}, {-0.25, -0.05}, {-0.25, 0.05}, {-0.25, 0.15}, {-0.25, 0.25}, {-0.25, 0.35}, {-0.25, 0.45}, {-0.25, 0.55}, {-0.25, 0.65}, {-0.22, 0.6}, {-0.19, 0.52}, {-0.16, 0.44}, {-0.13, 0.36}, {-0.1, 0.28}, {-0.07, 0.2}, {-0.04, 0.12}, {-0.01, 0.04}, {0.02, -0.04}, {0.05, -0.12}, {0.08, -0.2}, {0.11, -0.28}, {0.14, -0.36}, {0.17, -0.44}, {0.2, -0.52}, {0.22, -0.6}, {0.25, -0.65}, {0.25, -0.55}, {0.25, -0.45}, {0.25, -0.35}, {0.25, -0.25}, {0.25, -0.15}, {0.25, -0.05}, {0.25, 0.05}, {0.25, 0.15}, {0.25, 0.25}, {0.25, 0.35}, {0.25, 0.45}, {0.25, 0.55}, {0.25, 0.65}});
        CHARACTER_COORDS.put(Character.valueOf('O'), new double[][]{{-0.15, 0.62}, {-0.1, 0.66}, {-0.04, 0.68}, {0.02, 0.68}, {0.08, 0.66}, {0.14, 0.62}, {0.18, 0.56}, {0.21, 0.49}, {0.23, 0.41}, {0.24, 0.33}, {0.25, 0.25}, {0.25, 0.17}, {0.25, 0.09}, {0.25, 0.01}, {0.25, -0.07}, {0.25, -0.15}, {0.24, -0.23}, {0.23, -0.31}, {0.21, -0.39}, {0.18, -0.46}, {0.14, -0.52}, {0.08, -0.58}, {0.02, -0.62}, {-0.04, -0.64}, {-0.1, -0.64}, {-0.15, -0.62}, {-0.19, -0.56}, {-0.22, -0.49}, {-0.24, -0.41}, {-0.25, -0.33}, {-0.26, -0.25}, {-0.26, -0.17}, {-0.26, -0.09}, {-0.26, -0.01}, {-0.26, 0.07}, {-0.26, 0.15}, {-0.25, 0.23}, {-0.24, 0.31}, {-0.22, 0.39}, {-0.19, 0.46}, {-0.15, 0.54}});
        CHARACTER_COORDS.put(Character.valueOf('P'), new double[][]{{-0.2, -0.65}, {-0.2, -0.55}, {-0.2, -0.45}, {-0.2, -0.35}, {-0.2, -0.25}, {-0.2, -0.15}, {-0.2, -0.05}, {-0.2, 0.05}, {-0.2, 0.15}, {-0.2, 0.25}, {-0.2, 0.35}, {-0.2, 0.45}, {-0.2, 0.55}, {-0.2, 0.65}, {-0.15, 0.65}, {-0.1, 0.65}, {-0.05, 0.65}, {0.0, 0.65}, {0.05, 0.64}, {0.1, 0.62}, {0.14, 0.58}, {0.17, 0.53}, {0.19, 0.47}, {0.2, 0.4}, {0.2, 0.33}, {0.19, 0.26}, {0.17, 0.19}, {0.14, 0.13}, {0.1, 0.08}, {0.05, 0.04}, {0.0, 0.02}, {-0.05, 0.0}, {-0.1, 0.0}, {-0.15, 0.0}});
        CHARACTER_COORDS.put(Character.valueOf('Q'), new double[][]{{-0.15, 0.62}, {-0.1, 0.66}, {-0.04, 0.68}, {0.02, 0.68}, {0.08, 0.66}, {0.14, 0.62}, {0.18, 0.56}, {0.21, 0.49}, {0.23, 0.41}, {0.24, 0.33}, {0.25, 0.25}, {0.25, 0.17}, {0.25, 0.09}, {0.25, 0.01}, {0.25, -0.07}, {0.25, -0.15}, {0.24, -0.23}, {0.23, -0.31}, {0.21, -0.39}, {0.18, -0.46}, {0.14, -0.52}, {0.08, -0.58}, {0.02, -0.62}, {-0.04, -0.64}, {-0.1, -0.64}, {-0.15, -0.62}, {-0.19, -0.56}, {-0.22, -0.49}, {-0.24, -0.41}, {-0.25, -0.33}, {-0.26, -0.25}, {-0.26, -0.17}, {-0.26, -0.09}, {-0.26, -0.01}, {-0.26, 0.07}, {-0.26, 0.15}, {-0.25, 0.23}, {-0.24, 0.31}, {-0.22, 0.39}, {-0.19, 0.46}, {-0.15, 0.54}, {0.1, -0.3}, {0.14, -0.38}, {0.18, -0.46}, {0.22, -0.54}, {0.26, -0.62}, {0.3, -0.7}});
        CHARACTER_COORDS.put(Character.valueOf('R'), new double[][]{{-0.2, -0.65}, {-0.2, -0.55}, {-0.2, -0.45}, {-0.2, -0.35}, {-0.2, -0.25}, {-0.2, -0.15}, {-0.2, -0.05}, {-0.2, 0.05}, {-0.2, 0.15}, {-0.2, 0.25}, {-0.2, 0.35}, {-0.2, 0.45}, {-0.2, 0.55}, {-0.2, 0.65}, {-0.15, 0.65}, {-0.1, 0.65}, {-0.05, 0.65}, {0.0, 0.65}, {0.05, 0.64}, {0.1, 0.62}, {0.14, 0.58}, {0.17, 0.53}, {0.19, 0.47}, {0.2, 0.4}, {0.2, 0.33}, {0.19, 0.26}, {0.17, 0.19}, {0.14, 0.13}, {0.1, 0.08}, {0.05, 0.04}, {0.0, 0.02}, {-0.05, 0.0}, {-0.1, 0.0}, {-0.05, -0.08}, {0.0, -0.16}, {0.05, -0.24}, {0.1, -0.32}, {0.14, -0.4}, {0.18, -0.48}, {0.22, -0.56}, {0.25, -0.65}});
        CHARACTER_COORDS.put(Character.valueOf('S'), new double[][]{{0.25, 0.48}, {0.22, 0.54}, {0.18, 0.59}, {0.13, 0.63}, {0.07, 0.65}, {0.01, 0.67}, {-0.05, 0.67}, {-0.11, 0.65}, {-0.16, 0.61}, {-0.2, 0.56}, {-0.22, 0.5}, {-0.23, 0.43}, {-0.23, 0.36}, {-0.22, 0.29}, {-0.2, 0.22}, {-0.17, 0.16}, {-0.13, 0.11}, {-0.09, 0.07}, {-0.05, 0.04}, {0.0, 0.02}, {0.05, 0.0}, {0.09, -0.03}, {0.13, -0.07}, {0.17, -0.12}, {0.2, -0.18}, {0.22, -0.25}, {0.23, -0.32}, {0.23, -0.39}, {0.22, -0.46}, {0.2, -0.52}, {0.16, -0.57}, {0.11, -0.61}, {0.05, -0.64}, {-0.01, -0.66}, {-0.07, -0.66}, {-0.13, -0.64}, {-0.18, -0.6}, {-0.22, -0.55}, {-0.25, -0.48}});
        CHARACTER_COORDS.put(Character.valueOf('T'), new double[][]{{-0.25, 0.65}, {-0.2, 0.65}, {-0.15, 0.65}, {-0.1, 0.65}, {-0.05, 0.65}, {0.0, 0.65}, {0.05, 0.65}, {0.1, 0.65}, {0.15, 0.65}, {0.2, 0.65}, {0.25, 0.65}, {0.0, 0.6}, {0.0, 0.5}, {0.0, 0.4}, {0.0, 0.3}, {0.0, 0.2}, {0.0, 0.1}, {0.0, 0.0}, {0.0, -0.1}, {0.0, -0.2}, {0.0, -0.3}, {0.0, -0.4}, {0.0, -0.5}, {0.0, -0.6}, {0.0, -0.65}});
        CHARACTER_COORDS.put(Character.valueOf('U'), new double[][]{{-0.25, 0.65}, {-0.25, 0.55}, {-0.25, 0.45}, {-0.25, 0.35}, {-0.25, 0.25}, {-0.25, 0.15}, {-0.25, 0.05}, {-0.25, -0.05}, {-0.24, -0.15}, {-0.23, -0.25}, {-0.21, -0.34}, {-0.18, -0.42}, {-0.14, -0.49}, {-0.1, -0.55}, {-0.05, -0.6}, {0.0, -0.64}, {0.05, -0.66}, {0.1, -0.66}, {0.15, -0.64}, {0.19, -0.6}, {0.22, -0.55}, {0.24, -0.49}, {0.26, -0.42}, {0.27, -0.34}, {0.28, -0.25}, {0.28, -0.15}, {0.28, -0.05}, {0.28, 0.05}, {0.28, 0.15}, {0.28, 0.25}, {0.28, 0.35}, {0.28, 0.45}, {0.28, 0.55}, {0.28, 0.65}});
        CHARACTER_COORDS.put(Character.valueOf('V'), new double[][]{{-0.3, 0.65}, {-0.28, 0.58}, {-0.26, 0.51}, {-0.24, 0.44}, {-0.22, 0.37}, {-0.2, 0.3}, {-0.18, 0.23}, {-0.16, 0.16}, {-0.14, 0.09}, {-0.12, 0.02}, {-0.1, -0.05}, {-0.08, -0.12}, {-0.06, -0.19}, {-0.04, -0.26}, {-0.02, -0.33}, {0.0, -0.4}, {0.0, -0.5}, {0.0, -0.6}, {0.0, -0.65}, {0.02, -0.33}, {0.04, -0.26}, {0.06, -0.19}, {0.08, -0.12}, {0.1, -0.05}, {0.12, 0.02}, {0.14, 0.09}, {0.16, 0.16}, {0.18, 0.23}, {0.2, 0.3}, {0.22, 0.37}, {0.24, 0.44}, {0.26, 0.51}, {0.28, 0.58}, {0.3, 0.65}});
        CHARACTER_COORDS.put(Character.valueOf('W'), new double[][]{{-0.35, 0.65}, {-0.34, 0.55}, {-0.33, 0.45}, {-0.32, 0.35}, {-0.31, 0.25}, {-0.3, 0.15}, {-0.29, 0.05}, {-0.28, -0.05}, {-0.27, -0.15}, {-0.26, -0.25}, {-0.25, -0.35}, {-0.24, -0.45}, {-0.23, -0.55}, {-0.22, -0.62}, {-0.2, -0.55}, {-0.18, -0.45}, {-0.16, -0.35}, {-0.14, -0.25}, {-0.12, -0.15}, {-0.1, -0.05}, {-0.08, 0.05}, {-0.06, 0.15}, {-0.04, 0.25}, {-0.02, 0.35}, {0.0, 0.45}, {0.02, 0.35}, {0.04, 0.25}, {0.06, 0.15}, {0.08, 0.05}, {0.1, -0.05}, {0.12, -0.15}, {0.14, -0.25}, {0.16, -0.35}, {0.18, -0.45}, {0.2, -0.55}, {0.22, -0.62}, {0.23, -0.55}, {0.24, -0.45}, {0.25, -0.35}, {0.26, -0.25}, {0.27, -0.15}, {0.28, -0.05}, {0.29, 0.05}, {0.3, 0.15}, {0.31, 0.25}, {0.32, 0.35}, {0.33, 0.45}, {0.34, 0.55}, {0.35, 0.65}});
        CHARACTER_COORDS.put(Character.valueOf('X'), new double[][]{{-0.25, 0.65}, {-0.22, 0.58}, {-0.19, 0.51}, {-0.16, 0.44}, {-0.13, 0.37}, {-0.1, 0.3}, {-0.07, 0.23}, {-0.04, 0.16}, {-0.01, 0.09}, {0.02, 0.02}, {0.05, -0.05}, {0.08, -0.12}, {0.11, -0.19}, {0.14, -0.26}, {0.17, -0.33}, {0.2, -0.4}, {0.22, -0.47}, {0.24, -0.54}, {0.26, -0.61}, {0.27, -0.65}, {0.25, 0.65}, {0.22, 0.58}, {0.19, 0.51}, {0.16, 0.44}, {0.13, 0.37}, {0.1, 0.3}, {0.07, 0.23}, {0.04, 0.16}, {0.01, 0.09}, {-0.02, 0.02}, {-0.05, -0.05}, {-0.08, -0.12}, {-0.11, -0.19}, {-0.14, -0.26}, {-0.17, -0.33}, {-0.2, -0.4}, {-0.22, -0.47}, {-0.24, -0.54}, {-0.26, -0.61}, {-0.27, -0.65}});
        CHARACTER_COORDS.put(Character.valueOf('Y'), new double[][]{{-0.25, 0.65}, {-0.22, 0.58}, {-0.19, 0.51}, {-0.16, 0.44}, {-0.13, 0.37}, {-0.1, 0.3}, {-0.07, 0.23}, {-0.04, 0.16}, {-0.01, 0.09}, {0.0, 0.02}, {0.25, 0.65}, {0.22, 0.58}, {0.19, 0.51}, {0.16, 0.44}, {0.13, 0.37}, {0.1, 0.3}, {0.07, 0.23}, {0.04, 0.16}, {0.01, 0.09}, {0.0, 0.02}, {0.0, 0.0}, {0.0, -0.1}, {0.0, -0.2}, {0.0, -0.3}, {0.0, -0.4}, {0.0, -0.5}, {0.0, -0.6}, {0.0, -0.65}});
        CHARACTER_COORDS.put(Character.valueOf('Z'), new double[][]{{-0.25, 0.65}, {-0.2, 0.65}, {-0.15, 0.65}, {-0.1, 0.65}, {-0.05, 0.65}, {0.0, 0.65}, {0.05, 0.65}, {0.1, 0.65}, {0.15, 0.65}, {0.2, 0.65}, {0.25, 0.65}, {0.22, 0.6}, {0.19, 0.53}, {0.16, 0.46}, {0.13, 0.39}, {0.1, 0.32}, {0.07, 0.25}, {0.04, 0.18}, {0.01, 0.11}, {-0.02, 0.04}, {-0.05, -0.03}, {-0.08, -0.1}, {-0.11, -0.17}, {-0.14, -0.24}, {-0.17, -0.31}, {-0.2, -0.38}, {-0.22, -0.45}, {-0.24, -0.52}, {-0.26, -0.59}, {-0.25, -0.65}, {-0.2, -0.65}, {-0.15, -0.65}, {-0.1, -0.65}, {-0.05, -0.65}, {0.0, -0.65}, {0.05, -0.65}, {0.1, -0.65}, {0.15, -0.65}, {0.2, -0.65}, {0.25, -0.65}});
        CHARACTER_COORDS.put(Character.valueOf(' '), new double[0][]);
        CHARACTER_COORDS.put(Character.valueOf('!'), new double[][]{{0.0, 0.65}, {0.0, 0.55}, {0.0, 0.45}, {0.0, 0.35}, {0.0, 0.25}, {0.0, 0.15}, {0.0, 0.05}, {0.0, -0.3}, {0.0, -0.4}, {0.0, -0.5}});
        CHARACTER_COORDS.put(Character.valueOf('?'), new double[][]{{-0.15, 0.5}, {-0.1, 0.58}, {-0.05, 0.63}, {0.0, 0.66}, {0.05, 0.66}, {0.1, 0.64}, {0.14, 0.6}, {0.17, 0.54}, {0.18, 0.47}, {0.18, 0.4}, {0.16, 0.33}, {0.13, 0.27}, {0.09, 0.22}, {0.05, 0.18}, {0.0, 0.15}, {0.0, 0.1}, {0.0, 0.05}, {0.0, -0.3}, {0.0, -0.4}, {0.0, -0.5}});
        CHARACTER_COORDS.put(Character.valueOf('-'), new double[][]{{-0.2, 0.0}, {-0.15, 0.0}, {-0.1, 0.0}, {-0.05, 0.0}, {0.0, 0.0}, {0.05, 0.0}, {0.1, 0.0}, {0.15, 0.0}, {0.2, 0.0}});
        CHARACTER_COORDS.put(Character.valueOf('+'), new double[][]{{-0.2, 0.0}, {-0.15, 0.0}, {-0.1, 0.0}, {-0.05, 0.0}, {0.0, 0.0}, {0.05, 0.0}, {0.1, 0.0}, {0.15, 0.0}, {0.2, 0.0}, {0.0, 0.25}, {0.0, 0.2}, {0.0, 0.15}, {0.0, 0.1}, {0.0, 0.05}, {0.0, -0.05}, {0.0, -0.1}, {0.0, -0.15}, {0.0, -0.2}, {0.0, -0.25}});
        CHARACTER_COORDS.put(Character.valueOf('='), new double[][]{{-0.2, 0.15}, {-0.15, 0.15}, {-0.1, 0.15}, {-0.05, 0.15}, {0.0, 0.15}, {0.05, 0.15}, {0.1, 0.15}, {0.15, 0.15}, {0.2, 0.15}, {-0.2, -0.15}, {-0.15, -0.15}, {-0.1, -0.15}, {-0.05, -0.15}, {0.0, -0.15}, {0.05, -0.15}, {0.1, -0.15}, {0.15, -0.15}, {0.2, -0.15}});
    }
}

