/*
 * Decompiled with CFR 0.152.
 */
package tech.jarno.primitivestart;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.balm.api.config.BalmConfig;
import net.blay09.mods.balm.api.entity.BalmEntities;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.LivingDeathEvent;
import net.blay09.mods.balm.api.item.BalmItems;
import net.blay09.mods.balm.api.module.BalmModule;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.jarno.primitivestart.PrimitiveStartConfig;
import tech.jarno.primitivestart.block.ModBlocks;
import tech.jarno.primitivestart.entity.ModEntities;
import tech.jarno.primitivestart.item.ModItems;
import tech.jarno.primitivestart.item.tier.ModToolMaterials;

public class PrimitiveStart
implements BalmModule {
    public static final Logger logger = LoggerFactory.getLogger(PrimitiveStart.class);
    public static final String MOD_ID = "primitivestart";
    public static final TagKey<Block> NEEDS_COPPER_TOOL = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"primitivestart", (String)"needs_copper_tool"));

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static PrimitiveStartConfig config() {
        return (PrimitiveStartConfig)Balm.getConfig().getActiveConfig(PrimitiveStartConfig.class);
    }

    public static Item getItemFromId(String itemId) {
        ResourceLocation location = ResourceLocation.parse((String)itemId);
        return (Item)BuiltInRegistries.ITEM.get(location);
    }

    public void registerConfig(BalmConfig config) {
        config.registerConfig(PrimitiveStartConfig.class);
    }

    public void registerItems(BalmItems items) {
        ModItems.initialize(items);
    }

    public void registerBlocks(BalmBlocks blocks) {
        ModBlocks.initialize(blocks);
    }

    public void registerEntities(BalmEntities entities) {
        ModEntities.initialize(entities);
    }

    public ResourceLocation getId() {
        return PrimitiveStart.id("common");
    }

    public void initialize() {
        Balm.getEvents().onEvent(BreakBlockEvent.class, this::onBlockBreak);
        Balm.getEvents().onEvent(LivingDeathEvent.class, this::onLivingDeath);
    }

    private void onLivingDeath(LivingDeathEvent event) {
        Animal animal;
        Level level;
        block6: {
            block5: {
                if (!PrimitiveStart.config().enableBoneDrops) {
                    return;
                }
                LivingEntity entity = event.getEntity();
                level = entity.level();
                if (!(entity instanceof Animal)) break block5;
                animal = (Animal)entity;
                if (!level.isClientSide) break block6;
            }
            return;
        }
        for (int i = 0; i < 2; ++i) {
            this.attemptBoneDrop(animal, level);
        }
    }

    private void attemptBoneDrop(Animal animal, Level level) {
        Item boneItem;
        if (animal.getRandom().nextBoolean() && (boneItem = PrimitiveStart.getItemFromId(PrimitiveStart.config().boneDropItem)) != Items.AIR) {
            ItemStack bone = new ItemStack((ItemLike)boneItem);
            ItemEntity itemEntity = new ItemEntity(level, animal.getX(), animal.getY(), animal.getZ(), bone);
            level.addFreshEntity((Entity)itemEntity);
        }
    }

    private void onBlockBreak(BreakBlockEvent event) {
        int chance;
        Level level = event.getLevel();
        Player player = event.getPlayer();
        if (level.isClientSide()) {
            return;
        }
        BlockState state = event.getState();
        ItemStack tool = player.getMainHandItem();
        if (PrimitiveStart.config().requireAxeForLogs && state.is(BlockTags.LOGS) && !player.isCreative() && !tool.isCorrectToolForDrops(state)) {
            event.setCanceled(true);
            level.destroyBlock(event.getPos(), false);
        }
        if (state.is(NEEDS_COPPER_TOOL) && !player.isCreative() && !this.isToolCopperTierOrHigher(tool)) {
            event.setCanceled(true);
            level.destroyBlock(event.getPos(), false);
        }
        if (PrimitiveStart.config().enableStickDrops && state.is(BlockTags.LEAVES) && (chance = PrimitiveStart.config().stickDropChance) > 0 && player.getRandom().nextInt(100) + 1 <= chance) {
            ItemEntity item = new ItemEntity(EntityType.ITEM, level);
            item.setItem(new ItemStack((ItemLike)Items.STICK));
            item.setPos(Vec3.atCenterOf((Vec3i)event.getPos()));
            level.addFreshEntity((Entity)item);
        }
    }

    private boolean isToolCopperTierOrHigher(ItemStack tool) {
        if (tool.isEmpty()) {
            return false;
        }
        Item item = tool.getItem();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            Tier tier = tieredItem.getTier();
            if (tier == ModToolMaterials.COPPER || tier == ModToolMaterials.PLATED) {
                return true;
            }
            if (tier == Tiers.IRON || tier == Tiers.DIAMOND || tier == Tiers.NETHERITE) {
                return true;
            }
        }
        return false;
    }
}

