/*
 * Decompiled with CFR 0.152.
 */
package tech.jarno.primitivestart.forge;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmRuntimeLoadContext;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.module.BalmModule;
import net.blay09.mods.balm.forge.ForgeLoadContext;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import tech.jarno.primitivestart.PrimitiveStart;
import tech.jarno.primitivestart.forge.client.ForgePrimitiveStartClient;

@Mod(value="primitivestart")
public class ForgePrimitiveStart {
    public ForgePrimitiveStart(FMLJavaModLoadingContext context) {
        ForgeLoadContext loadContext = new ForgeLoadContext(context.getModEventBus());
        Balm.initializeMod((String)"primitivestart", (BalmRuntimeLoadContext)loadContext, (BalmModule)new PrimitiveStart());
        MinecraftForge.EVENT_BUS.addListener(this::onEntityInteract);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> BalmClient.initializeMod((String)"primitivestart", (BalmRuntimeLoadContext)loadContext, ForgePrimitiveStartClient::initialize));
    }

    private void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!PrimitiveStart.config().enablePlucking) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Entity entity = event.getTarget();
        if (entity instanceof Chicken) {
            Chicken chicken = (Chicken)entity;
            if (stack.getItem() instanceof ShearsItem && chicken.hurtTime == 0 && chicken.isAlive()) {
                if (!event.getLevel().isClientSide) {
                    Item featherItem = PrimitiveStart.getItemFromId(PrimitiveStart.config().featherDropItem);
                    if (featherItem != Items.AIR) {
                        chicken.spawnAtLocation(new ItemStack((ItemLike)featherItem));
                    }
                    chicken.hurt(chicken.damageSources().generic(), 1.0f);
                    stack.hurtAndBreak(1, (LivingEntity)event.getEntity(), event.getEntity().getEquipmentSlotForItem(stack));
                }
                event.setCanceled(true);
            }
        }
    }
}

