/*
 * Decompiled with CFR 0.152.
 */
package tech.jarno.primitivestart.neoforge;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmRuntimeLoadContext;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.module.BalmModule;
import net.blay09.mods.balm.neoforge.NeoForgeLoadContext;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import tech.jarno.primitivestart.PrimitiveStart;
import tech.jarno.primitivestart.neoforge.client.NeoForgePrimitiveStartClient;

@Mod(value="primitivestart")
public class NeoForgePrimitiveStart {
    public NeoForgePrimitiveStart(IEventBus modEventBus) {
        NeoForgeLoadContext context = new NeoForgeLoadContext(modEventBus);
        Balm.initializeMod((String)"primitivestart", (BalmRuntimeLoadContext)context, (BalmModule)new PrimitiveStart());
        NeoForge.EVENT_BUS.addListener(this::onEntityInteract);
        if (FMLEnvironment.dist.isClient()) {
            BalmClient.initializeMod((String)"primitivestart", (BalmRuntimeLoadContext)context, NeoForgePrimitiveStartClient::initialize);
        }
    }

    private void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!PrimitiveStart.config().enablePlucking) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Entity entity = event.getTarget();
        if (entity instanceof Chicken) {
            Chicken chicken = (Chicken)entity;
            if (stack.getItem() instanceof ShearsItem && chicken.hurtTime == 0 && chicken.isAlive()) {
                if (!event.getLevel().isClientSide) {
                    Item featherItem = PrimitiveStart.getItemFromId(PrimitiveStart.config().featherDropItem);
                    if (featherItem != Items.AIR) {
                        chicken.spawnAtLocation(new ItemStack((ItemLike)featherItem));
                    }
                    chicken.hurt(chicken.damageSources().generic(), 1.0f);
                    stack.hurtAndBreak(1, (LivingEntity)event.getEntity(), event.getEntity().getEquipmentSlotForItem(stack));
                }
                event.setCanceled(true);
            }
        }
    }
}

