/*
 * Decompiled with CFR 0.152.
 */
package tech.jarno.primitivestart;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.balm.api.config.BalmConfig;
import net.blay09.mods.balm.api.entity.BalmEntities;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.LivingDeathEvent;
import net.blay09.mods.balm.api.item.BalmItems;
import net.blay09.mods.balm.api.module.BalmModule;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.jarno.primitivestart.PrimitiveStartConfig;
import tech.jarno.primitivestart.block.ModBlocks;
import tech.jarno.primitivestart.entity.ModEntities;
import tech.jarno.primitivestart.item.ModItems;
import tech.jarno.primitivestart.item.tier.ModToolMaterials;

public class PrimitiveStart
implements BalmModule {
    public static final Logger logger = LoggerFactory.getLogger(PrimitiveStart.class);
    public static final String MOD_ID = "primitivestart";
    public static final TagKey<Block> NEEDS_COPPER_TOOL = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("primitivestart", "needs_copper_tool"));

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static PrimitiveStartConfig config() {
        return (PrimitiveStartConfig)Balm.getConfig().getActiveConfig(PrimitiveStartConfig.class);
    }

    public static Item getItemFromId(String itemId) {
        ResourceLocation location = new ResourceLocation(itemId);
        return (Item)BuiltInRegistries.f_257033_.m_7745_(location);
    }

    public void registerConfig(BalmConfig config) {
        config.registerConfig(PrimitiveStartConfig.class);
    }

    public void registerItems(BalmItems items) {
        ModItems.initialize(items);
    }

    public void registerBlocks(BalmBlocks blocks) {
        ModBlocks.initialize(blocks);
    }

    public void registerEntities(BalmEntities entities) {
        ModEntities.initialize(entities);
    }

    public ResourceLocation getId() {
        return PrimitiveStart.id("common");
    }

    public void initialize() {
        Balm.getEvents().onEvent(BreakBlockEvent.class, this::onBlockBreak);
        Balm.getEvents().onEvent(LivingDeathEvent.class, this::onLivingDeath);
    }

    private void onLivingDeath(LivingDeathEvent event) {
        Animal animal;
        Level level;
        block6: {
            block5: {
                if (!PrimitiveStart.config().enableBoneDrops) {
                    return;
                }
                LivingEntity entity = event.getEntity();
                level = entity.m_9236_();
                if (!(entity instanceof Animal)) break block5;
                animal = (Animal)entity;
                if (!level.f_46443_) break block6;
            }
            return;
        }
        for (int i = 0; i < 2; ++i) {
            this.attemptBoneDrop(animal, level);
        }
    }

    private void attemptBoneDrop(Animal animal, Level level) {
        Item boneItem;
        if (animal.m_217043_().m_188499_() && (boneItem = PrimitiveStart.getItemFromId(PrimitiveStart.config().boneDropItem)) != Items.f_41852_) {
            ItemStack bone = new ItemStack((ItemLike)boneItem);
            ItemEntity itemEntity = new ItemEntity(level, animal.m_20185_(), animal.m_20186_(), animal.m_20189_(), bone);
            level.m_7967_((Entity)itemEntity);
        }
    }

    private void onBlockBreak(BreakBlockEvent event) {
        int chance;
        Level level = event.getLevel();
        Player player = event.getPlayer();
        if (level.m_5776_()) {
            return;
        }
        BlockState state = event.getState();
        ItemStack tool = player.m_21205_();
        if (PrimitiveStart.config().requireAxeForLogs && state.m_204336_(BlockTags.f_13106_) && !player.m_7500_() && !tool.m_41735_(state)) {
            event.setCanceled(true);
            level.m_46961_(event.getPos(), false);
        }
        if (state.m_204336_(NEEDS_COPPER_TOOL) && !player.m_7500_() && !this.isToolCopperTierOrHigher(tool)) {
            event.setCanceled(true);
            level.m_46961_(event.getPos(), false);
        }
        if (PrimitiveStart.config().enableStickDrops && state.m_204336_(BlockTags.f_13035_) && (chance = PrimitiveStart.config().stickDropChance) > 0 && player.m_217043_().m_188503_(100) + 1 <= chance) {
            ItemEntity item = new ItemEntity(EntityType.f_20461_, level);
            item.m_32045_(new ItemStack((ItemLike)Items.f_42398_));
            item.m_146884_(Vec3.m_82512_((Vec3i)event.getPos()));
            level.m_7967_((Entity)item);
        }
    }

    private boolean isToolCopperTierOrHigher(ItemStack tool) {
        if (tool.m_41619_()) {
            return false;
        }
        Item item = tool.m_41720_();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            Tier tier = tieredItem.m_43314_();
            if (tier == ModToolMaterials.COPPER || tier == ModToolMaterials.PLATED) {
                return true;
            }
            if (tier.m_6604_() >= 2) {
                return true;
            }
        }
        return false;
    }
}

