/*
 * Decompiled with CFR 0.152.
 */
package tech.jarno.primitivestart.forge;

import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmRuntimeLoadContext;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.module.BalmModule;
import net.blay09.mods.balm.forge.ForgeLoadContext;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.ForgeTier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import tech.jarno.primitivestart.PrimitiveStart;
import tech.jarno.primitivestart.forge.client.ForgePrimitiveStartClient;
import tech.jarno.primitivestart.item.tier.ModToolMaterials;

@Mod(value="primitivestart")
public class ForgePrimitiveStart {
    public ForgePrimitiveStart(FMLJavaModLoadingContext context) {
        ForgeLoadContext loadContext = new ForgeLoadContext(context.getModEventBus());
        this.registerTiers();
        Balm.initializeMod((String)"primitivestart", (BalmRuntimeLoadContext)loadContext, (BalmModule)new PrimitiveStart());
        MinecraftForge.EVENT_BUS.addListener(this::onEntityInteract);
        if (FMLEnvironment.dist.isClient()) {
            BalmClient.initializeMod((String)"primitivestart", (BalmRuntimeLoadContext)loadContext, ForgePrimitiveStartClient::initialize);
        }
    }

    private void registerTiers() {
        TierSortingRegistry.registerTier((Tier)new ForgeTier(ModToolMaterials.COPPER.m_6604_(), ModToolMaterials.COPPER.m_6609_(), ModToolMaterials.COPPER.m_6624_(), ModToolMaterials.COPPER.m_6631_(), ModToolMaterials.COPPER.m_6601_(), PrimitiveStart.NEEDS_COPPER_TOOL, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_151051_})), (ResourceLocation)new ResourceLocation("primitivestart", "copper"), List.of(Tiers.STONE), List.of(Tiers.IRON));
        TierSortingRegistry.registerTier((Tier)new ForgeTier(ModToolMaterials.PLATED.m_6604_(), ModToolMaterials.PLATED.m_6609_(), ModToolMaterials.PLATED.m_6624_(), ModToolMaterials.PLATED.m_6631_(), ModToolMaterials.PLATED.m_6601_(), ModToolMaterials.PLATED.getIncorrectBlocksForDrops(), () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42417_})), (ResourceLocation)new ResourceLocation("primitivestart", "plated"), List.of(Tiers.IRON), List.of(Tiers.DIAMOND));
    }

    private void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!PrimitiveStart.config().enablePlucking) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Entity entity = event.getTarget();
        if (entity instanceof Chicken) {
            Chicken chicken = (Chicken)entity;
            if (stack.m_41720_() instanceof ShearsItem && chicken.f_20916_ == 0 && chicken.m_6084_()) {
                if (!event.getLevel().f_46443_) {
                    Item featherItem = PrimitiveStart.getItemFromId(PrimitiveStart.config().featherDropItem);
                    if (featherItem != Items.f_41852_) {
                        chicken.m_19983_(new ItemStack((ItemLike)featherItem));
                    }
                    chicken.m_6469_(chicken.m_269291_().m_269264_(), 1.0f);
                    stack.m_41622_(1, (LivingEntity)event.getEntity(), p -> p.m_21190_(event.getHand()));
                }
                event.setCanceled(true);
            }
        }
    }
}

