/*
 * Decompiled with CFR 0.152.
 */
package tech.jarno.primitivestart;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.block.BalmBlocks;
import net.blay09.mods.balm.api.config.BalmConfig;
import net.blay09.mods.balm.api.entity.BalmEntities;
import net.blay09.mods.balm.api.event.BreakBlockEvent;
import net.blay09.mods.balm.api.event.LivingDeathEvent;
import net.blay09.mods.balm.api.item.BalmItems;
import net.blay09.mods.balm.api.module.BalmModule;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.jarno.primitivestart.PrimitiveStartConfig;
import tech.jarno.primitivestart.block.ModBlocks;
import tech.jarno.primitivestart.entity.ModEntities;
import tech.jarno.primitivestart.item.ModItems;
import tech.jarno.primitivestart.item.tier.ModToolMaterials;

public class PrimitiveStart
implements BalmModule {
    public static final Logger logger = LoggerFactory.getLogger(PrimitiveStart.class);
    public static final String MOD_ID = "primitivestart";
    public static final class_6862<class_2248> NEEDS_COPPER_TOOL = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960("primitivestart", "needs_copper_tool"));

    public static class_2960 id(String path) {
        return new class_2960(MOD_ID, path);
    }

    public static PrimitiveStartConfig config() {
        return (PrimitiveStartConfig)Balm.getConfig().getActiveConfig(PrimitiveStartConfig.class);
    }

    public static class_1792 getItemFromId(String itemId) {
        class_2960 location = new class_2960(itemId);
        return (class_1792)class_7923.field_41178.method_10223(location);
    }

    public void registerConfig(BalmConfig config) {
        config.registerConfig(PrimitiveStartConfig.class);
    }

    public void registerItems(BalmItems items) {
        ModItems.initialize(items);
    }

    public void registerBlocks(BalmBlocks blocks) {
        ModBlocks.initialize(blocks);
    }

    public void registerEntities(BalmEntities entities) {
        ModEntities.initialize(entities);
    }

    public class_2960 getId() {
        return PrimitiveStart.id("common");
    }

    public void initialize() {
        Balm.getEvents().onEvent(BreakBlockEvent.class, this::onBlockBreak);
        Balm.getEvents().onEvent(LivingDeathEvent.class, this::onLivingDeath);
    }

    private void onLivingDeath(LivingDeathEvent event) {
        class_1429 animal;
        class_1937 level;
        block6: {
            block5: {
                if (!PrimitiveStart.config().enableBoneDrops) {
                    return;
                }
                class_1309 entity = event.getEntity();
                level = entity.method_37908();
                if (!(entity instanceof class_1429)) break block5;
                animal = (class_1429)entity;
                if (!level.field_9236) break block6;
            }
            return;
        }
        for (int i = 0; i < 2; ++i) {
            this.attemptBoneDrop(animal, level);
        }
    }

    private void attemptBoneDrop(class_1429 animal, class_1937 level) {
        class_1792 boneItem;
        if (animal.method_6051().method_43056() && (boneItem = PrimitiveStart.getItemFromId(PrimitiveStart.config().boneDropItem)) != class_1802.field_8162) {
            class_1799 bone = new class_1799((class_1935)boneItem);
            class_1542 itemEntity = new class_1542(level, animal.method_23317(), animal.method_23318(), animal.method_23321(), bone);
            level.method_8649((class_1297)itemEntity);
        }
    }

    private void onBlockBreak(BreakBlockEvent event) {
        int chance;
        class_1937 level = event.getLevel();
        class_1657 player = event.getPlayer();
        if (level.method_8608()) {
            return;
        }
        class_2680 state = event.getState();
        class_1799 tool = player.method_6047();
        if (PrimitiveStart.config().requireAxeForLogs && state.method_26164(class_3481.field_15475) && !player.method_7337() && !tool.method_7951(state)) {
            event.setCanceled(true);
            level.method_22352(event.getPos(), false);
        }
        if (state.method_26164(NEEDS_COPPER_TOOL) && !player.method_7337() && !this.isToolCopperTierOrHigher(tool)) {
            event.setCanceled(true);
            level.method_22352(event.getPos(), false);
        }
        if (PrimitiveStart.config().enableStickDrops && state.method_26164(class_3481.field_15503) && (chance = PrimitiveStart.config().stickDropChance) > 0 && player.method_6051().method_43048(100) + 1 <= chance) {
            class_1542 item = new class_1542(class_1299.field_6052, level);
            item.method_6979(new class_1799((class_1935)class_1802.field_8600));
            item.method_33574(class_243.method_24953((class_2382)event.getPos()));
            level.method_8649((class_1297)item);
        }
    }

    private boolean isToolCopperTierOrHigher(class_1799 tool) {
        if (tool.method_7960()) {
            return false;
        }
        class_1792 item = tool.method_7909();
        if (item instanceof class_1831) {
            class_1831 tieredItem = (class_1831)item;
            class_1832 tier = tieredItem.method_8022();
            if (tier == ModToolMaterials.COPPER || tier == ModToolMaterials.PLATED) {
                return true;
            }
            if (tier.method_8024() >= 2) {
                return true;
            }
        }
        return false;
    }
}

