/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.scpfr.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.scpfr.ScpfrMod;
import net.mcreator.scpfr.procedures.ABTSendProcedure;
import net.mcreator.scpfr.procedures.ActColorProcedure;
import net.mcreator.scpfr.procedures.ActStyleProcedure;
import net.mcreator.scpfr.procedures.BackProcedure;
import net.mcreator.scpfr.procedures.Chat2ColorProcedure;
import net.mcreator.scpfr.procedures.Chat2StyleProcedure;
import net.mcreator.scpfr.procedures.ChatColorProcedure;
import net.mcreator.scpfr.procedures.ChatStyleProcedure;
import net.mcreator.scpfr.procedures.ItemColorProcedure;
import net.mcreator.scpfr.procedures.ItemStyleProcedure;
import net.mcreator.scpfr.procedures.NDNKeycardProcedure;
import net.mcreator.scpfr.procedures.SBTSendProcedure;
import net.mcreator.scpfr.procedures.SendACProcedure;
import net.mcreator.scpfr.procedures.StitleColorProcedure;
import net.mcreator.scpfr.procedures.StitleStyleProcedure;
import net.mcreator.scpfr.procedures.TMTSendProcedure;
import net.mcreator.scpfr.world.inventory.ACGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ACGUIButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public ACGUIButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public ACGUIButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(ACGUIButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(ACGUIButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            ACGUIButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = ACGUIMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SendACProcedure.execute((LevelAccessor)world, x, y, z, guistate);
        }
        if (buttonID == 1) {
            BackProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
        if (buttonID == 2) {
            TMTSendProcedure.execute((LevelAccessor)world, x, y, z, guistate);
        }
        if (buttonID == 3) {
            ABTSendProcedure.execute((LevelAccessor)world, x, y, z, guistate);
        }
        if (buttonID == 4) {
            SBTSendProcedure.execute((LevelAccessor)world, x, y, z, guistate);
        }
        if (buttonID == 5) {
            StitleColorProcedure.execute((LevelAccessor)world, guistate);
        }
        if (buttonID == 6) {
            ActStyleProcedure.execute((LevelAccessor)world, guistate);
        }
        if (buttonID == 7) {
            ActColorProcedure.execute((LevelAccessor)world, guistate);
        }
        if (buttonID == 8) {
            StitleStyleProcedure.execute((LevelAccessor)world, guistate);
        }
        if (buttonID == 9) {
            Chat2ColorProcedure.execute((LevelAccessor)world, guistate);
        }
        if (buttonID == 10) {
            Chat2StyleProcedure.execute((LevelAccessor)world, guistate);
        }
        if (buttonID == 11) {
            ChatColorProcedure.execute((LevelAccessor)world, guistate);
        }
        if (buttonID == 12) {
            ChatStyleProcedure.execute((LevelAccessor)world, guistate);
        }
        if (buttonID == 13) {
            ItemColorProcedure.execute((LevelAccessor)world, guistate);
        }
        if (buttonID == 14) {
            NDNKeycardProcedure.execute((Entity)entity, guistate);
        }
        if (buttonID == 15) {
            ItemStyleProcedure.execute((LevelAccessor)world, guistate);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ScpfrMod.addNetworkMessage(ACGUIButtonMessage.class, ACGUIButtonMessage::buffer, ACGUIButtonMessage::new, ACGUIButtonMessage::handler);
    }
}

