/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.scpfr.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.scpfr.ScpfrMod;
import net.mcreator.scpfr.procedures.CDCD1RecipeProcedure;
import net.mcreator.scpfr.procedures.CDCD2RecipeProcedure;
import net.mcreator.scpfr.procedures.ED1RecipeProcedure;
import net.mcreator.scpfr.procedures.ED2RecipeProcedure;
import net.mcreator.scpfr.procedures.HD1RecipeProcedure;
import net.mcreator.scpfr.procedures.HD2RecipeProcedure;
import net.mcreator.scpfr.procedures.LD1RecipeProcedure;
import net.mcreator.scpfr.procedures.LD2RecipeProcedure;
import net.mcreator.scpfr.procedures.ODRecipeProcedure;
import net.mcreator.scpfr.procedures.RDRecipeProcedure;
import net.mcreator.scpfr.world.inventory.MDCrafteryMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MDCrafteryButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MDCrafteryButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MDCrafteryButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MDCrafteryButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MDCrafteryButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MDCrafteryButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = MDCrafteryMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            RDRecipeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            ED2RecipeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            ED1RecipeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            CDCD2RecipeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            CDCD1RecipeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            ODRecipeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            HD2RecipeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            HD1RecipeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 8) {
            LD2RecipeProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 9) {
            LD1RecipeProcedure.execute((LevelAccessor)world, x, y, z);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ScpfrMod.addNetworkMessage(MDCrafteryButtonMessage.class, MDCrafteryButtonMessage::buffer, MDCrafteryButtonMessage::new, MDCrafteryButtonMessage::handler);
    }
}

