/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.scpfr.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.scpfr.ScpfrMod;
import net.mcreator.scpfr.procedures.BackProcedure;
import net.mcreator.scpfr.procedures.DayButtonProcedure;
import net.mcreator.scpfr.procedures.EarlyMorningPProcedure;
import net.mcreator.scpfr.procedures.EveningButtonProcedure;
import net.mcreator.scpfr.procedures.LateEveningPProcedure;
import net.mcreator.scpfr.procedures.MNButtonProcedure;
import net.mcreator.scpfr.procedures.MorningButtonProcedure;
import net.mcreator.scpfr.procedures.NightButtonProcedure;
import net.mcreator.scpfr.procedures.RainButtonProcedure;
import net.mcreator.scpfr.procedures.RainClearButtonProcedure;
import net.mcreator.scpfr.procedures.ThunderButtonProcedure;
import net.mcreator.scpfr.world.inventory.MainMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MainButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MainButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MainButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MainButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MainButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MainButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = MainMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            RainButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 1) {
            ThunderButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 2) {
            EarlyMorningPProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 3) {
            RainClearButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 4) {
            MorningButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 5) {
            DayButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 6) {
            EveningButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 7) {
            LateEveningPProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 8) {
            NightButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 9) {
            MNButtonProcedure.execute((LevelAccessor)world, x, y, z);
        }
        if (buttonID == 10) {
            BackProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ScpfrMod.addNetworkMessage(MainButtonMessage.class, MainButtonMessage::buffer, MainButtonMessage::new, MainButtonMessage::handler);
    }
}

