/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.advancement;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.pepper.faunify.entity.BeetleEntity;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SerializationContext;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;

public class CatchAllBeetlesTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    static final ResourceLocation ID = new ResourceLocation("faunify", "catch_all_beetles");

    public ResourceLocation m_7295_() {
        return ID;
    }

    protected TriggerInstance createInstance(JsonObject json, ContextAwarePredicate player, DeserializationContext context) {
        ItemPredicate item = ItemPredicate.m_45051_((JsonElement)json.get("item"));
        return new TriggerInstance(player, item);
    }

    public void trigger(ServerPlayer player, Entity caughtEntity, ItemStack usedItem) {
        this.m_66234_(player, instance -> instance.matches(player, caughtEntity, usedItem));
    }

    public static class TriggerInstance
    extends AbstractCriterionTriggerInstance {
        private final ItemPredicate item;

        public TriggerInstance(ContextAwarePredicate player, ItemPredicate item) {
            super(ID, player);
            this.item = item;
        }

        public static TriggerInstance caughtAllBeetleVariants() {
            return new TriggerInstance(ContextAwarePredicate.f_285567_, ItemPredicate.f_45028_);
        }

        public boolean matches(ServerPlayer player, Entity entity, ItemStack item) {
            BeetleEntity.Variant[] allVariants;
            if (!this.item.m_45049_(item)) {
                return false;
            }
            if (!(entity instanceof BeetleEntity)) {
                return false;
            }
            BeetleEntity beetle = (BeetleEntity)entity;
            CompoundTag data = player.getPersistentData();
            String key = "faunify:caught_beetle_" + beetle.getVariant().m_7912_();
            data.m_128379_(key, true);
            for (BeetleEntity.Variant variant : allVariants = BeetleEntity.Variant.values()) {
                String variantKey = "faunify:caught_beetle_" + variant.m_7912_();
                if (data.m_128471_(variantKey)) continue;
                return false;
            }
            return true;
        }

        public JsonObject m_7683_(SerializationContext context) {
            JsonObject json = super.m_7683_(context);
            json.add("item", this.item.m_45048_());
            return json;
        }
    }
}

