/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.blocks;

import com.pepper.faunify.blocks.BugCatcherBlock;
import com.pepper.faunify.blocks.entity.InsectHabitatBlockEntity;
import com.pepper.faunify.items.BugNetItem;
import com.pepper.faunify.registry.FaunifyTriggers;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InsectHabitatBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DecorationState> DECORATION = EnumProperty.m_61587_((String)"decoration", DecorationState.class);
    private static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)-5.0, (double)0.0, (double)-1.0, (double)21.0, (double)15.0, (double)17.0);
    private static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)-5.0, (double)0.0, (double)-1.0, (double)21.0, (double)15.0, (double)17.0);
    private static final VoxelShape SHAPE_WEST = Block.m_49796_((double)-1.0, (double)0.0, (double)-5.0, (double)17.0, (double)15.0, (double)21.0);
    private static final VoxelShape SHAPE_EAST = Block.m_49796_((double)-1.0, (double)0.0, (double)-5.0, (double)17.0, (double)15.0, (double)21.0);
    private final DyeColor color;

    public InsectHabitatBlock(BlockBehaviour.Properties properties, DyeColor color) {
        super(properties);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(DECORATION, (Comparable)((Object)DecorationState.EMPTY))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DECORATION, FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        BlockEntity be = level.m_7702_(pos);
        if (!(be instanceof InsectHabitatBlockEntity)) {
            return InteractionResult.PASS;
        }
        InsectHabitatBlockEntity habitat = (InsectHabitatBlockEntity)be;
        if (stack.m_41720_() instanceof BugNetItem) {
            boolean isMultiPart;
            if (this.hasStoredEntity(stack) && !habitat.hasBug() && (isMultiPart = this.isMultiPartEntity(stack))) {
                if (!level.f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.faunify.bug_too_big"), true);
                }
                return InteractionResult.SUCCESS;
            }
            if (!level.f_46443_) {
                CompoundTag bugData;
                if (this.hasStoredEntity(stack) && !habitat.hasBug()) {
                    CompoundTag bugData2 = this.extractBugData(stack);
                    if (bugData2 != null) {
                        float snappedRotation = this.snapToCardinal(player.m_146908_()) + 180.0f;
                        Direction habitatFacing = (Direction)state.m_61143_((Property)FACING);
                        float rotationOffset = switch (habitatFacing) {
                            case Direction.SOUTH -> 180.0f;
                            case Direction.WEST -> 270.0f;
                            case Direction.EAST -> 90.0f;
                            default -> 0.0f;
                        };
                        float finalRotation = (snappedRotation - rotationOffset) % 360.0f;
                        if (finalRotation < 0.0f) {
                            finalRotation += 360.0f;
                        }
                        habitat.storeBug(bugData2, finalRotation);
                        if (player instanceof ServerPlayer) {
                            ServerPlayer serverPlayer = (ServerPlayer)player;
                            CompoundTag entityTag = bugData2.m_128469_("StoredEntity");
                            if (entityTag != null && level instanceof ServerLevel) {
                                Entity tempEntity;
                                ServerLevel serverLevel = (ServerLevel)level;
                                Optional entityTypeOpt = EntityType.m_20637_((CompoundTag)entityTag);
                                if (entityTypeOpt.isPresent() && (tempEntity = ((EntityType)entityTypeOpt.get()).m_20615_((Level)serverLevel)) != null) {
                                    tempEntity.m_20258_(entityTag);
                                    FaunifyTriggers.STORE_BUG.trigger(serverPlayer, tempEntity, stack);
                                }
                            }
                        }
                        ItemStack emptyNet = new ItemStack((ItemLike)stack.m_41720_());
                        emptyNet.m_41721_(stack.m_41773_());
                        player.m_21008_(hand, emptyNet);
                        level.m_5594_(null, pos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        return InteractionResult.SUCCESS;
                    }
                } else if (!this.hasStoredEntity(stack) && habitat.hasBug() && (bugData = habitat.removeBug()) != null) {
                    ItemStack filledNet = this.createFilledBugNet(stack, bugData);
                    player.m_21008_(hand, filledNet);
                    level.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        if (stack.m_150930_(Items.f_42435_)) {
            if (!habitat.hasDirt()) {
                if (!level.f_46443_) {
                    habitat.setHasDirt(true);
                    this.updateDecorationState(level, pos, habitat);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_144209_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        } else if (stack.m_150930_(Items.f_42398_)) {
            if (habitat.hasDirt() && !habitat.hasStick()) {
                if (!level.f_46443_) {
                    habitat.setHasStick(true);
                    this.updateDecorationState(level, pos, habitat);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!habitat.hasDirt()) {
                if (!level.f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.faunify.needs_dirt"), true);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        } else if (stack.m_204117_(ItemTags.f_13143_)) {
            if (habitat.hasDirt() && !habitat.hasLeaves()) {
                if (!level.f_46443_) {
                    habitat.setHasLeaves(true, stack.m_41777_());
                    this.updateDecorationState(level, pos, habitat);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    level.m_5594_(null, pos, SoundEvents.f_11991_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            if (!habitat.hasDirt()) {
                if (!level.f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)"message.faunify.needs_dirt"), true);
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
            default -> SHAPE_NORTH;
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new InsectHabitatBlockEntity(pos, state);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof InsectHabitatBlockEntity) {
                InsectHabitatBlockEntity habitat = (InsectHabitatBlockEntity)be;
                if (!level.f_46443_ && level instanceof ServerLevel) {
                    CompoundTag bugData;
                    ServerLevel serverLevel = (ServerLevel)level;
                    if (habitat.hasBug() && (bugData = habitat.getStoredBugData()) != null) {
                        this.spawnStoredEntity(serverLevel, pos, bugData);
                    }
                    if (habitat.hasDirt()) {
                        Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42435_));
                    }
                    if (habitat.hasStick()) {
                        Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_42398_));
                    }
                    if (habitat.hasLeaves()) {
                        ItemStack leafStack = habitat.getStoredLeafType();
                        if (leafStack != null && !leafStack.m_41619_()) {
                            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)leafStack);
                        } else {
                            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)Items.f_41896_));
                        }
                    }
                }
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    private void updateDecorationState(Level level, BlockPos pos, InsectHabitatBlockEntity habitat) {
        DecorationState newState = !habitat.hasDirt() ? DecorationState.EMPTY : (habitat.hasStick() && habitat.hasLeaves() ? DecorationState.STICKLEAVES : (habitat.hasStick() ? DecorationState.STICK : (habitat.hasLeaves() ? DecorationState.LEAVES : DecorationState.DIRT)));
        level.m_7731_(pos, (BlockState)level.m_8055_(pos).m_61124_(DECORATION, (Comparable)((Object)newState)), 3);
    }

    private float snapToCardinal(float yRot) {
        if ((yRot %= 360.0f) < 0.0f) {
            yRot += 360.0f;
        }
        if (yRot >= 315.0f || yRot < 45.0f) {
            return 0.0f;
        }
        if (yRot >= 45.0f && yRot < 135.0f) {
            return 90.0f;
        }
        if (yRot >= 135.0f && yRot < 225.0f) {
            return 180.0f;
        }
        return 270.0f;
    }

    private void spawnStoredEntity(ServerLevel level, BlockPos pos, CompoundTag bugData) {
        Entity entity;
        if (!bugData.m_128441_("StoredEntity")) {
            return;
        }
        CompoundTag entityTag = bugData.m_128469_("StoredEntity");
        level.m_5594_(null, pos, SoundEvents.f_11752_, SoundSource.BLOCKS, 1.0f, 1.0f);
        Optional entityTypeOpt = EntityType.m_20637_((CompoundTag)entityTag);
        if (entityTypeOpt.isPresent() && (entity = ((EntityType)entityTypeOpt.get()).m_20615_((Level)level)) != null) {
            entity.m_20258_(entityTag);
            entity.m_20084_(UUID.randomUUID());
            if (entity instanceof LivingEntity) {
                CompoundTag nbt = new CompoundTag();
                entity.m_20240_(nbt);
                if (nbt.m_128441_("Caught")) {
                    nbt.m_128473_("Caught");
                    entity.m_20258_(nbt);
                }
                if (entity instanceof BugCatcherBlock.ICatchable) {
                    BugCatcherBlock.ICatchable catchable = (BugCatcherBlock.ICatchable)entity;
                    catchable.setCaught(false);
                }
            }
            entity.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5, level.f_46441_.m_188501_() * 360.0f, 0.0f);
            level.m_7967_(entity);
        }
    }

    private boolean hasStoredEntity(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128441_("StoredEntity");
    }

    private boolean isMultiPartEntity(ItemStack stack) {
        if (!stack.m_41782_()) {
            return false;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("StoredEntity")) {
            return false;
        }
        CompoundTag entityTag = tag.m_128469_("StoredEntity");
        boolean hasParts = entityTag.m_128441_("Parts");
        boolean hasSegments = entityTag.m_128441_("Segments");
        boolean hasPartEntities = entityTag.m_128441_("PartEntities");
        boolean hasPartsLower = entityTag.m_128441_("parts");
        boolean hasSegmentsLower = entityTag.m_128441_("segments");
        boolean hasChildUUID = entityTag.m_128441_("ChildUUID");
        boolean hasParentUUID = entityTag.m_128441_("ParentUUID");
        String entityId = entityTag.m_128461_("id");
        boolean isPartEntity = entityId.contains("_head") || entityId.contains("_body") || entityId.contains("_tail") || entityId.contains("_segment") || entityId.contains("_part");
        return hasParts || hasSegments || hasPartEntities || hasPartsLower || hasSegmentsLower || hasChildUUID || hasParentUUID || isPartEntity;
    }

    @Nullable
    private CompoundTag extractBugData(ItemStack bugNet) {
        CompoundTag stackTag = bugNet.m_41783_();
        if (stackTag == null || !stackTag.m_128441_("StoredEntity")) {
            return null;
        }
        CompoundTag bugData = new CompoundTag();
        bugData.m_128365_("StoredEntity", (Tag)stackTag.m_128469_("StoredEntity"));
        if (stackTag.m_128441_("StoredEntityType")) {
            bugData.m_128359_("StoredEntityType", stackTag.m_128461_("StoredEntityType"));
        }
        return bugData;
    }

    private ItemStack createFilledBugNet(ItemStack emptyNet, CompoundTag bugData) {
        ItemStack filledNet = new ItemStack((ItemLike)emptyNet.m_41720_());
        filledNet.m_41721_(emptyNet.m_41773_());
        CompoundTag stackTag = filledNet.m_41784_();
        if (bugData.m_128441_("StoredEntity")) {
            stackTag.m_128365_("StoredEntity", (Tag)bugData.m_128469_("StoredEntity"));
        }
        if (bugData.m_128441_("StoredEntityType")) {
            stackTag.m_128359_("StoredEntityType", bugData.m_128461_("StoredEntityType"));
        }
        return filledNet;
    }

    public static enum DecorationState implements StringRepresentable
    {
        EMPTY("empty"),
        DIRT("dirt"),
        LEAVES("leaves"),
        STICK("stick"),
        STICKLEAVES("stickleaves");

        private final String name;

        private DecorationState(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

