/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.blocks;

import com.google.common.annotations.VisibleForTesting;
import com.pepper.faunify.entity.SilkwormEntity;
import com.pepper.faunify.registry.FaunifyEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SilkwormEggsBlock
extends Block {
    private static final int MIN_SILKWORMS_SPAWN = 1;
    private static final int MAX_SILKWORMS_SPAWN = 3;
    private static final int DEFAULT_MIN_HATCH_TICK_DELAY = 3600;
    private static final int DEFAULT_MAX_HATCH_TICK_DELAY = 12000;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);
    private static int minHatchTickDelay = 3600;
    private static int maxHatchTickDelay = 12000;

    public SilkwormEggsBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return SilkwormEggsBlock.mayPlaceOn((BlockGetter)level, pos.m_7495_());
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.m_186460_(pos, (Block)this, SilkwormEggsBlock.getSilkwormEggsHatchDelay(level.m_213780_()));
    }

    private static int getSilkwormEggsHatchDelay(RandomSource random) {
        return random.m_216339_(minHatchTickDelay, maxHatchTickDelay);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return !this.m_7898_(state, (LevelReader)level, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            this.destroyBlock((Level)level, pos);
        } else {
            this.hatchSilkwormEggs(level, pos, random);
        }
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        if (entity.m_6095_().equals(EntityType.f_20450_)) {
            this.destroyBlock(level, pos);
        }
    }

    private static boolean mayPlaceOn(BlockGetter level, BlockPos pos) {
        BlockState blockBelow = level.m_8055_(pos);
        return blockBelow.m_60734_() instanceof LeavesBlock;
    }

    private void hatchSilkwormEggs(ServerLevel level, BlockPos pos, RandomSource random) {
        this.destroyBlock((Level)level, pos);
        level.m_5594_((Player)null, pos, SoundEvents.f_215687_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.spawnSilkworms(level, pos, random);
    }

    private void destroyBlock(Level level, BlockPos pos) {
        level.m_46961_(pos, false);
    }

    private void spawnSilkworms(ServerLevel level, BlockPos pos, RandomSource random) {
        int count = random.m_216339_(1, 4);
        for (int i = 1; i <= count; ++i) {
            SilkwormEntity silkworm = (SilkwormEntity)((EntityType)FaunifyEntities.SILKWORM.get()).m_20615_((Level)level);
            if (silkworm == null) continue;
            double xOffset = this.getRandomSilkwormPositionOffset(random);
            double zOffset = this.getRandomSilkwormPositionOffset(random);
            int yaw = random.m_216339_(1, 361);
            silkworm.m_7678_((double)pos.m_123341_() + xOffset, (double)pos.m_123342_() + 0.1, (double)pos.m_123343_() + zOffset, yaw, 0.0f);
            int roll = random.m_188503_(100);
            if (roll < 99) {
                silkworm.setVariant(SilkwormEntity.Variant.NORMAL);
            } else {
                silkworm.setVariant(SilkwormEntity.Variant.HUNGRY);
            }
            silkworm.m_21530_();
            level.m_7967_((Entity)silkworm);
        }
    }

    private double getRandomSilkwormPositionOffset(RandomSource random) {
        double halfWidth = 0.2;
        return Mth.m_14008_((double)random.m_188500_(), (double)halfWidth, (double)(1.0 - halfWidth));
    }

    @VisibleForTesting
    public static void setHatchDelay(int min, int max) {
        minHatchTickDelay = min;
        maxHatchTickDelay = max;
    }

    @VisibleForTesting
    public static void setDefaultHatchDelay() {
        minHatchTickDelay = 3600;
        maxHatchTickDelay = 12000;
    }
}

