/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.blocks.entity;

import com.pepper.faunify.registry.FaunifyBlockEntities;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BugCatcherBlockEntity
extends BlockEntity {
    @Nullable
    private CompoundTag storedBugData = null;
    private Entity cachedEntity = null;
    private float storedYRot = 0.0f;

    public BugCatcherBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FaunifyBlockEntities.BUG_CATCHER.get(), pos, state);
    }

    public void m_7651_() {
        super.m_7651_();
        this.cachedEntity = null;
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128350_("StoredYRot", this.storedYRot);
        if (this.storedBugData != null) {
            tag.m_128365_("StoredBug", (Tag)this.storedBugData);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.storedYRot = tag.m_128457_("StoredYRot");
        if (tag.m_128441_("StoredBug")) {
            this.storedBugData = tag.m_128469_("StoredBug");
            this.cachedEntity = null;
        } else {
            this.storedBugData = null;
            this.cachedEntity = null;
        }
    }

    public boolean hasBug() {
        return this.storedBugData != null;
    }

    @Nullable
    public CompoundTag getStoredBugData() {
        return this.storedBugData;
    }

    public float getStoredYRot() {
        return this.storedYRot;
    }

    @Nullable
    public Entity getCachedEntity() {
        CompoundTag entityTag;
        Optional entityTypeOpt;
        if (this.cachedEntity == null && this.storedBugData != null && this.f_58857_ != null && (entityTypeOpt = EntityType.m_20637_((CompoundTag)(entityTag = this.storedBugData.m_128469_("StoredEntity").m_6426_()))).isPresent()) {
            this.cachedEntity = ((EntityType)entityTypeOpt.get()).m_20615_(this.f_58857_);
            if (this.cachedEntity != null) {
                this.cachedEntity.m_20258_(entityTag);
                this.cachedEntity.m_6034_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5);
                this.cachedEntity.f_19854_ = (double)this.f_58858_.m_123341_() + 0.5;
                this.cachedEntity.f_19855_ = this.f_58858_.m_123342_();
                this.cachedEntity.f_19856_ = (double)this.f_58858_.m_123343_() + 0.5;
                this.cachedEntity.f_19790_ = (double)this.f_58858_.m_123341_() + 0.5;
                this.cachedEntity.f_19791_ = this.f_58858_.m_123342_();
                this.cachedEntity.f_19792_ = (double)this.f_58858_.m_123343_() + 0.5;
                float normalizedRot = this.storedYRot % 360.0f;
                if (normalizedRot < 0.0f) {
                    normalizedRot += 360.0f;
                }
                this.cachedEntity.m_146922_(normalizedRot);
                this.cachedEntity.f_19859_ = normalizedRot;
                this.cachedEntity.m_146926_(0.0f);
                this.cachedEntity.f_19860_ = 0.0f;
                Entity entity = this.cachedEntity;
                if (entity instanceof Mob) {
                    Mob mob = (Mob)entity;
                    mob.m_21557_(true);
                }
                this.cachedEntity.m_20334_(0.0, 0.0, 0.0);
                this.cachedEntity.m_20331_(true);
                this.cachedEntity.f_19797_ = 0;
            }
        }
        return this.cachedEntity;
    }

    public void storeBug(CompoundTag bugData, float yRot) {
        this.storedBugData = bugData;
        this.storedYRot = yRot;
        this.cachedEntity = null;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    @Nullable
    public CompoundTag removeBug() {
        CompoundTag data = this.storedBugData;
        this.storedBugData = null;
        this.storedYRot = 0.0f;
        this.cachedEntity = null;
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
        return data;
    }
}

