/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.blocks.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.pepper.faunify.blocks.entity.InsectHabitatBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class InsectHabitatRenderer
implements BlockEntityRenderer<InsectHabitatBlockEntity> {
    private final EntityRenderDispatcher entityRenderer = Minecraft.m_91087_().m_91290_();

    public InsectHabitatRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(InsectHabitatBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay) {
        Entity entity;
        if (blockEntity.hasBug() && (entity = blockEntity.getCachedEntity()) != null) {
            this.renderBug(blockEntity, entity, partialTick, poseStack, bufferSource, combinedLight);
        }
    }

    public int m_142163_() {
        return 80;
    }

    private void renderBug(InsectHabitatBlockEntity blockEntity, Entity entity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight) {
        double centerX = (double)blockEntity.m_58899_().m_123341_() + 0.5;
        double centerY = blockEntity.m_58899_().m_123342_();
        double centerZ = (double)blockEntity.m_58899_().m_123343_() + 0.5;
        entity.m_6034_(centerX, centerY, centerZ);
        entity.f_19854_ = centerX;
        entity.f_19855_ = centerY;
        entity.f_19856_ = centerZ;
        entity.f_19790_ = centerX;
        entity.f_19791_ = centerY;
        entity.f_19792_ = centerZ;
        float storedRot = blockEntity.getStoredYRot();
        entity.m_146922_(storedRot);
        entity.f_19859_ = storedRot;
        entity.m_146926_(0.0f);
        entity.f_19860_ = 0.0f;
        entity.m_20334_(0.0, 0.0, 0.0);
        entity.f_19797_ = 0;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.1, 0.5);
        BlockState blockState = blockEntity.m_58900_();
        Direction facing = (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        float blockRotation = this.getRotationFromDirection(facing);
        float scale = 0.6f;
        InsectHabitatRenderer.renderMobStatic(entity, scale, this.entityRenderer, poseStack, 0.0f, bufferSource, combinedLight, storedRot, blockRotation);
        poseStack.m_85849_();
    }

    private float getRotationFromDirection(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 270.0f;
            case Direction.EAST -> 90.0f;
            default -> 0.0f;
        };
    }

    public static void renderMobStatic(Entity mob, float scale, EntityRenderDispatcher renderer, PoseStack matrixStack, float partialTicks, MultiBufferSource bufferIn, int combinedLightIn, float rot, float blockRot) {
        float normalizedRot = rot % 360.0f;
        if (normalizedRot < 0.0f) {
            normalizedRot += 360.0f;
        }
        float totalRotation = normalizedRot + blockRot;
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(-totalRotation));
        matrixStack.m_85841_(scale, scale, scale);
        renderer.m_114468_(false);
        renderer.m_114384_(mob, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrixStack, bufferIn, combinedLightIn);
        renderer.m_114468_(true);
    }
}

