/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BeeflyEntity
extends Animal
implements GeoEntity,
FlyingAnimal {
    private static final double PLAYER_DETECTION_RANGE = 4.0;
    private static final int MAX_FLIGHT_HEIGHT = 5;
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(BeeflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HAS_POLLEN = SynchedEntityData.m_135353_(BeeflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    protected float flyProgress;
    protected float prevFlyProgress;
    public int timeFlying = 0;
    public int groundedFor = 0;
    public boolean landingFlag;
    @Nullable
    private BlockPos savedFlowerPos;
    private int remainingCooldownBeforeLocatingNewFlower = Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)60);
    private int numCropsGrownSinceVisitingFlower;

    public BeeflyEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new BeeflyMoveController(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22280_, 0.6);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BeeflyPollinateGoal());
        this.f_21345_.m_25352_(2, (Goal)new BeeflyGoToKnownFlowerGoal());
        this.f_21345_.m_25352_(3, (Goal)new BeeflySeekCropsGoal());
        this.f_21345_.m_25352_(4, (Goal)new BeeflyGrowCropGoal());
        this.f_21345_.m_25352_(5, (Goal)new BeeflyFlightGoal(this));
    }

    public static boolean canSpawn(EntityType<BeeflyEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        return spawnData;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevFlyProgress = this.flyProgress;
        this.tickFlight();
        if (this.hasPollen() && this.getCropsGrownSinceVisitingFlower() < 3 && this.f_19796_.m_188501_() < 0.05f) {
            for (int i = 0; i < this.f_19796_.m_188503_(2) + 1; ++i) {
                this.spawnFluidParticle(this.m_9236_(), this.m_20185_() - (double)0.3f, this.m_20185_() + (double)0.3f, this.m_20189_() - (double)0.3f, this.m_20189_() + (double)0.3f, this.m_20227_(0.5), (ParticleOptions)ParticleTypes.f_123782_);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && this.remainingCooldownBeforeLocatingNewFlower > 0) {
            --this.remainingCooldownBeforeLocatingNewFlower;
        }
    }

    public void tickFlight() {
        if (this.m_29443_() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.m_29443_() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.m_29443_()) {
            ++this.timeFlying;
            this.m_20242_(true);
            if (this.groundedFor > 0) {
                this.setFlying(false);
            }
        } else {
            this.timeFlying = 0;
            this.m_20242_(false);
        }
        if (this.groundedFor > 0) {
            --this.groundedFor;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.m_29443_() && this.m_6084_() && !this.m_20160_()) {
                if (this.landingFlag) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.1, 0.0));
                }
                if ((this.f_19862_ || this.m_20072_()) && !this.landingFlag) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.05, 0.0));
                }
            }
            if (this.m_29443_() && this.timeFlying > 40 && this.m_20096_()) {
                this.setFlying(false);
            }
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new BeeflyFlyingNavigation((Mob)this, level, 0.75f);
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob otherParent) {
        return null;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<BeeflyEntity> event) {
        if (!this.m_29443_() && this.m_20096_()) {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Flying", this.m_29443_());
        tag.m_128379_("HasPollen", this.hasPollen());
        tag.m_128405_("TimeFlying", this.timeFlying);
        tag.m_128405_("GroundedFor", this.groundedFor);
        tag.m_128379_("LandingFlag", this.landingFlag);
        if (this.hasSavedFlowerPos()) {
            tag.m_128356_("FlowerPos", this.savedFlowerPos.m_121878_());
        }
        tag.m_128405_("CropsGrownSinceVisitingFlower", this.numCropsGrownSinceVisitingFlower);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setFlying(tag.m_128471_("Flying"));
        this.setHasPollen(tag.m_128471_("HasPollen"));
        this.timeFlying = tag.m_128451_("TimeFlying");
        this.groundedFor = tag.m_128451_("GroundedFor");
        this.landingFlag = tag.m_128471_("LandingFlag");
        if (tag.m_128441_("FlowerPos")) {
            this.savedFlowerPos = BlockPos.m_122022_((long)tag.m_128454_("FlowerPos"));
        }
        this.numCropsGrownSinceVisitingFlower = tag.m_128451_("CropsGrownSinceVisitingFlower");
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6094_() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(HAS_POLLEN, (Object)false);
    }

    public boolean m_29443_() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public boolean hasPollen() {
        return (Boolean)this.f_19804_.m_135370_(HAS_POLLEN);
    }

    public void setHasPollen(boolean hasPollen) {
        this.f_19804_.m_135381_(HAS_POLLEN, (Object)hasPollen);
    }

    public float getFlyProgress(float partialTicks) {
        return (this.prevFlyProgress + (this.flyProgress - this.prevFlyProgress) * partialTicks) * 0.2f;
    }

    protected void m_7840_(double fallDistance, boolean onGround, BlockState state, BlockPos pos) {
    }

    public float m_5610_(BlockPos pos, LevelReader level) {
        return level.m_8055_(pos).m_60795_() ? 10.0f : 0.0f;
    }

    @Nullable
    public BlockPos getSavedFlowerPos() {
        return this.savedFlowerPos;
    }

    public boolean hasSavedFlowerPos() {
        return this.savedFlowerPos != null;
    }

    public void setSavedFlowerPos(BlockPos pos) {
        this.savedFlowerPos = pos;
    }

    boolean isFlowerValid(BlockPos pos) {
        return this.m_9236_().m_46749_(pos) && this.m_9236_().m_8055_(pos).m_204336_(BlockTags.f_13041_);
    }

    void pathfindRandomlyTowards(BlockPos pos) {
        Vec3 targetPos;
        Vec3 vec3 = Vec3.m_82539_((Vec3i)pos);
        int verticalOffset = 0;
        BlockPos currentPos = this.m_20183_();
        int heightDiff = (int)vec3.f_82480_ - currentPos.m_123342_();
        if (heightDiff > 2) {
            verticalOffset = 4;
        } else if (heightDiff < -2) {
            verticalOffset = -4;
        }
        int horizontalRange = 6;
        int verticalRange = 8;
        int manhattanDist = currentPos.m_123333_((Vec3i)pos);
        if (manhattanDist < 15) {
            horizontalRange = manhattanDist / 2;
            verticalRange = manhattanDist / 2;
        }
        if ((targetPos = AirRandomPos.m_148387_((PathfinderMob)this, (int)horizontalRange, (int)verticalRange, (int)verticalOffset, (Vec3)vec3, (double)0.3141592741012573)) != null) {
            this.f_21344_.m_26529_(0.5f);
            this.f_21344_.m_26519_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 1.0);
        }
    }

    boolean closerThan(BlockPos pos, int distance) {
        return pos.m_123314_((Vec3i)this.m_20183_(), (double)distance);
    }

    boolean isTooFarAway(BlockPos pos) {
        return !this.closerThan(pos, 32);
    }

    int getCropsGrownSinceVisitingFlower() {
        return this.numCropsGrownSinceVisitingFlower;
    }

    void resetNumCropsGrownSinceVisitingFlower() {
        this.numCropsGrownSinceVisitingFlower = 0;
    }

    void incrementNumCropsGrownSinceVisitingFlower() {
        ++this.numCropsGrownSinceVisitingFlower;
    }

    private void spawnFluidParticle(Level level, double minX, double maxX, double minZ, double maxZ, double y, ParticleOptions particle) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_(particle, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)minX, (double)maxX), y, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)minZ, (double)maxZ), 1, 0.0, 0.0, 0.0, 0.0);
        } else {
            level.m_7106_(particle, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)minX, (double)maxX), y, Mth.m_14139_((double)level.f_46441_.m_188500_(), (double)minZ, (double)maxZ), 0.0, 0.0, 0.0);
        }
    }

    private static class BeeflyMoveController
    extends MoveControl {
        private final BeeflyEntity beefly;

        public BeeflyMoveController(BeeflyEntity beefly) {
            super((Mob)beefly);
            this.beefly = beefly;
        }

        public void m_8126_() {
            if (!this.beefly.m_29443_() && this.beefly.m_20096_()) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                return;
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vector3d = new Vec3(this.f_24975_ - this.beefly.m_20185_(), this.f_24976_ - this.beefly.m_20186_(), this.f_24977_ - this.beefly.m_20189_());
                double d0 = vector3d.m_82553_();
                double width = this.beefly.m_20191_().m_82309_();
                Vec3 vector3d1 = vector3d.m_82490_(this.f_24978_ * 0.05 / d0);
                this.beefly.m_20256_(this.beefly.m_20184_().m_82549_(vector3d1).m_82490_(0.95).m_82520_(0.0, -0.01, 0.0));
                if (d0 < width) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                } else if (d0 >= width) {
                    float yaw = -((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f;
                    this.beefly.m_146922_(Mth.m_14148_((float)this.beefly.m_146908_(), (float)yaw, (float)8.0f));
                }
            }
        }
    }

    class BeeflyPollinateGoal
    extends Goal {
        private static final int MIN_POLLINATION_TICKS = 200;
        private final Predicate<BlockState> VALID_POLLINATION_BLOCKS = state -> {
            if (state.m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                return false;
            }
            if (state.m_204336_(BlockTags.f_13041_)) {
                if (state.m_60713_(Blocks.f_50355_)) {
                    return state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER;
                }
                return true;
            }
            return false;
        };
        private static final double ARRIVAL_THRESHOLD = 0.1;
        private static final float SPEED_MODIFIER = 0.35f;
        private static final float HOVER_HEIGHT_WITHIN_FLOWER = 0.6f;
        private static final float HOVER_POS_OFFSET = 0.33333334f;
        private int successfulPollinatingTicks;
        private boolean pollinating;
        @Nullable
        private Vec3 hoverPos;
        private int pollinatingTicks;
        private static final int MAX_POLLINATING_TICKS = 400;

        BeeflyPollinateGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            if (BeeflyEntity.this.hasPollen()) {
                return false;
            }
            if (BeeflyEntity.this.remainingCooldownBeforeLocatingNewFlower > 0) {
                return false;
            }
            if (BeeflyEntity.this.m_9236_().m_46471_()) {
                return false;
            }
            Optional<BlockPos> optional = this.findNearbyFlower();
            if (optional.isPresent()) {
                BeeflyEntity.this.savedFlowerPos = optional.get();
                BeeflyEntity.this.f_21344_.m_26519_((double)BeeflyEntity.this.savedFlowerPos.m_123341_() + 0.5, (double)BeeflyEntity.this.savedFlowerPos.m_123342_() + 0.5, (double)BeeflyEntity.this.savedFlowerPos.m_123343_() + 0.5, (double)1.2f);
                return true;
            }
            BeeflyEntity.this.remainingCooldownBeforeLocatingNewFlower = Mth.m_216271_((RandomSource)BeeflyEntity.this.f_19796_, (int)20, (int)60);
            return false;
        }

        public boolean m_8045_() {
            if (!this.pollinating) {
                return false;
            }
            if (!BeeflyEntity.this.hasSavedFlowerPos()) {
                return false;
            }
            if (BeeflyEntity.this.m_9236_().m_46471_()) {
                return false;
            }
            if (this.hasPollinatedLongEnough()) {
                return BeeflyEntity.this.f_19796_.m_188501_() < 0.2f;
            }
            if (BeeflyEntity.this.f_19797_ % 20 == 0 && !BeeflyEntity.this.isFlowerValid(BeeflyEntity.this.savedFlowerPos)) {
                BeeflyEntity.this.savedFlowerPos = null;
                return false;
            }
            return true;
        }

        private boolean hasPollinatedLongEnough() {
            return this.successfulPollinatingTicks > 200;
        }

        boolean isPollinating() {
            return this.pollinating;
        }

        public void m_8056_() {
            this.successfulPollinatingTicks = 0;
            this.pollinatingTicks = 0;
            this.pollinating = true;
            BeeflyEntity.this.resetNumCropsGrownSinceVisitingFlower();
            BeeflyEntity.this.setFlying(true);
            BeeflyEntity.this.landingFlag = false;
        }

        public void m_8041_() {
            if (this.hasPollinatedLongEnough()) {
                BeeflyEntity.this.setHasPollen(true);
            }
            this.pollinating = false;
            BeeflyEntity.this.f_21344_.m_26573_();
            BeeflyEntity.this.remainingCooldownBeforeLocatingNewFlower = 200;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            ++this.pollinatingTicks;
            if (!BeeflyEntity.this.m_29443_()) {
                BeeflyEntity.this.setFlying(true);
            }
            BeeflyEntity.this.landingFlag = false;
            BeeflyEntity.this.groundedFor = 0;
            if (this.pollinatingTicks > 400) {
                BeeflyEntity.this.savedFlowerPos = null;
            } else {
                Vec3 vec3 = Vec3.m_82539_((Vec3i)BeeflyEntity.this.savedFlowerPos).m_82520_(0.0, (double)0.6f, 0.0);
                if (vec3.m_82554_(BeeflyEntity.this.m_20182_()) > 1.0) {
                    this.hoverPos = vec3;
                    this.setWantedPos();
                } else {
                    if (this.hoverPos == null) {
                        this.hoverPos = vec3;
                    }
                    boolean flag = BeeflyEntity.this.m_20182_().m_82554_(this.hoverPos) <= 0.1;
                    boolean flag1 = true;
                    if (!flag && this.pollinatingTicks > 400) {
                        BeeflyEntity.this.savedFlowerPos = null;
                    } else {
                        if (flag) {
                            boolean flag2;
                            boolean bl = flag2 = BeeflyEntity.this.f_19796_.m_188503_(25) == 0;
                            if (flag2) {
                                this.hoverPos = new Vec3(vec3.m_7096_() + (double)this.getOffset(), vec3.m_7098_(), vec3.m_7094_() + (double)this.getOffset());
                                BeeflyEntity.this.f_21344_.m_26573_();
                            } else {
                                flag1 = false;
                            }
                            BeeflyEntity.this.m_21563_().m_24946_(vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_());
                        }
                        if (flag1) {
                            this.setWantedPos();
                        }
                        ++this.successfulPollinatingTicks;
                    }
                }
            }
        }

        private void setWantedPos() {
            BeeflyEntity.this.m_21566_().m_6849_(this.hoverPos.m_7096_(), this.hoverPos.m_7098_(), this.hoverPos.m_7094_(), (double)0.35f);
        }

        private float getOffset() {
            return (BeeflyEntity.this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.33333334f;
        }

        private Optional<BlockPos> findNearbyFlower() {
            return this.findNearestBlock(this.VALID_POLLINATION_BLOCKS, 5.0);
        }

        private Optional<BlockPos> findNearestBlock(Predicate<BlockState> predicate, double range) {
            BlockPos blockpos = BeeflyEntity.this.m_20183_();
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            int i = 0;
            while ((double)i <= range) {
                int j = 0;
                while ((double)j < range) {
                    int k = 0;
                    while (k <= j) {
                        int l;
                        int n = l = k < j && k > -j ? j : 0;
                        while (l <= j) {
                            mutablePos.m_122154_((Vec3i)blockpos, k, i - 1, l);
                            if (blockpos.m_123314_((Vec3i)mutablePos, range) && predicate.test(BeeflyEntity.this.m_9236_().m_8055_((BlockPos)mutablePos))) {
                                return Optional.of(mutablePos.m_7949_());
                            }
                            l = l > 0 ? -l : 1 - l;
                        }
                        k = k > 0 ? -k : 1 - k;
                    }
                    ++j;
                }
                i = i > 0 ? -i : 1 - i;
            }
            return Optional.empty();
        }
    }

    class BeeflyGoToKnownFlowerGoal
    extends Goal {
        private static final int MAX_TRAVELLING_TICKS = 600;
        int travellingTicks;

        BeeflyGoToKnownFlowerGoal() {
            this.travellingTicks = BeeflyEntity.this.m_9236_().f_46441_.m_188503_(10);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return BeeflyEntity.this.savedFlowerPos != null && !BeeflyEntity.this.hasPollen() && !BeeflyEntity.this.m_21536_() && BeeflyEntity.this.isFlowerValid(BeeflyEntity.this.savedFlowerPos) && !BeeflyEntity.this.closerThan(BeeflyEntity.this.savedFlowerPos, 2);
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8056_() {
            this.travellingTicks = 0;
            BeeflyEntity.this.setFlying(true);
            BeeflyEntity.this.landingFlag = false;
            super.m_8056_();
        }

        public void m_8041_() {
            this.travellingTicks = 0;
            BeeflyEntity.this.f_21344_.m_26573_();
            BeeflyEntity.this.f_21344_.m_26566_();
        }

        public void m_8037_() {
            if (BeeflyEntity.this.savedFlowerPos != null) {
                ++this.travellingTicks;
                if (!BeeflyEntity.this.m_29443_()) {
                    BeeflyEntity.this.setFlying(true);
                }
                BeeflyEntity.this.landingFlag = false;
                if (this.travellingTicks > this.m_183277_(600)) {
                    BeeflyEntity.this.savedFlowerPos = null;
                } else if (!BeeflyEntity.this.f_21344_.m_26572_()) {
                    if (BeeflyEntity.this.isTooFarAway(BeeflyEntity.this.savedFlowerPos)) {
                        BeeflyEntity.this.savedFlowerPos = null;
                    } else {
                        BeeflyEntity.this.pathfindRandomlyTowards(BeeflyEntity.this.savedFlowerPos);
                    }
                }
            }
        }
    }

    class BeeflySeekCropsGoal
    extends Goal {
        private static final int MAX_TRAVELLING_TICKS = 600;
        private static final double ARRIVAL_THRESHOLD = 1.5;
        private static final float HOVER_HEIGHT_ABOVE_CROP = 1.2f;
        private static final float SPEED_MODIFIER = 0.35f;
        private static final float HOVER_POS_OFFSET = 0.33333334f;
        private int travellingTicks;
        @Nullable
        private BlockPos targetCropPos;
        @Nullable
        private Vec3 hoverPos;
        private boolean isHovering;

        BeeflySeekCropsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.travellingTicks = 0;
            this.isHovering = false;
        }

        public boolean m_8036_() {
            if (!BeeflyEntity.this.hasPollen()) {
                return false;
            }
            if (BeeflyEntity.this.getCropsGrownSinceVisitingFlower() >= 3) {
                return false;
            }
            if (BeeflyEntity.this.f_19796_.m_188501_() < 0.7f) {
                return false;
            }
            this.targetCropPos = this.findNearbyCrop();
            return this.targetCropPos != null;
        }

        public boolean m_8045_() {
            if (!BeeflyEntity.this.hasPollen()) {
                return false;
            }
            if (BeeflyEntity.this.getCropsGrownSinceVisitingFlower() >= 3) {
                return false;
            }
            if (this.travellingTicks > 600) {
                return false;
            }
            return this.targetCropPos != null;
        }

        public void m_8056_() {
            this.travellingTicks = 0;
            this.isHovering = false;
            this.hoverPos = null;
            BeeflyEntity.this.setFlying(true);
            BeeflyEntity.this.landingFlag = false;
            if (this.targetCropPos != null) {
                Vec3 targetVec = Vec3.m_82539_((Vec3i)this.targetCropPos).m_82520_(0.0, (double)1.2f, 0.0);
                BeeflyEntity.this.f_21344_.m_26519_(targetVec.f_82479_, targetVec.f_82480_, targetVec.f_82481_, 1.0);
            }
        }

        public void m_8041_() {
            this.targetCropPos = null;
            this.hoverPos = null;
            this.travellingTicks = 0;
            this.isHovering = false;
            BeeflyEntity.this.f_21344_.m_26573_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            BlockState state;
            ++this.travellingTicks;
            if (!BeeflyEntity.this.m_29443_()) {
                BeeflyEntity.this.setFlying(true);
            }
            BeeflyEntity.this.landingFlag = false;
            BeeflyEntity.this.groundedFor = 0;
            if (this.targetCropPos == null) {
                return;
            }
            if (!(this.travellingTicks % 20 != 0 || (state = BeeflyEntity.this.m_9236_().m_8055_(this.targetCropPos)).m_204336_(BlockTags.f_13074_) && this.isGrowable(state, this.targetCropPos))) {
                this.targetCropPos = this.findNearbyCrop();
                if (this.targetCropPos != null) {
                    this.isHovering = false;
                    this.hoverPos = null;
                } else {
                    return;
                }
            }
            if (this.targetCropPos == null) {
                return;
            }
            Vec3 cropCenter = Vec3.m_82539_((Vec3i)this.targetCropPos).m_82520_(0.0, (double)1.2f, 0.0);
            double distance = cropCenter.m_82554_(BeeflyEntity.this.m_20182_());
            if (distance < 1.5) {
                if (!this.isHovering) {
                    this.isHovering = true;
                    this.hoverPos = cropCenter;
                }
                if (BeeflyEntity.this.f_19796_.m_188503_(25) == 0) {
                    this.hoverPos = new Vec3(cropCenter.m_7096_() + (double)this.getOffset(), cropCenter.m_7098_(), cropCenter.m_7094_() + (double)this.getOffset());
                    BeeflyEntity.this.f_21344_.m_26573_();
                }
                BeeflyEntity.this.m_21563_().m_24946_(cropCenter.m_7096_(), cropCenter.m_7098_(), cropCenter.m_7094_());
                this.setWantedPos();
            } else if (BeeflyEntity.this.f_21344_.m_26571_()) {
                BeeflyEntity.this.f_21344_.m_26519_(cropCenter.f_82479_, cropCenter.f_82480_, cropCenter.f_82481_, 1.0);
            }
        }

        private void setWantedPos() {
            if (this.hoverPos != null) {
                BeeflyEntity.this.m_21566_().m_6849_(this.hoverPos.m_7096_(), this.hoverPos.m_7098_(), this.hoverPos.m_7094_(), (double)0.35f);
            }
        }

        private float getOffset() {
            return (BeeflyEntity.this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.33333334f;
        }

        @Nullable
        private BlockPos findNearbyCrop() {
            BlockPos beeflyPos = BeeflyEntity.this.m_20183_();
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            int range = 10;
            for (int x = -range; x <= range; ++x) {
                for (int z = -range; z <= range; ++z) {
                    for (int y = -3; y <= 3; ++y) {
                        mutablePos.m_122178_(beeflyPos.m_123341_() + x, beeflyPos.m_123342_() + y, beeflyPos.m_123343_() + z);
                        BlockState state = BeeflyEntity.this.m_9236_().m_8055_((BlockPos)mutablePos);
                        if (!state.m_204336_(BlockTags.f_13074_) || !this.isGrowable(state, (BlockPos)mutablePos)) continue;
                        return mutablePos.m_7949_();
                    }
                }
            }
            return null;
        }

        private boolean isGrowable(BlockState state, BlockPos pos) {
            Block block = state.m_60734_();
            if (block instanceof CropBlock) {
                CropBlock cropBlock = (CropBlock)block;
                return !cropBlock.m_52307_(state);
            }
            if (block instanceof StemBlock) {
                int age = (Integer)state.m_61143_((Property)StemBlock.f_57013_);
                return age < 7;
            }
            if (state.m_60713_(Blocks.f_50685_)) {
                int age = (Integer)state.m_61143_((Property)SweetBerryBushBlock.f_57244_);
                return age < 3;
            }
            return state.m_60713_(Blocks.f_152538_) || state.m_60713_(Blocks.f_152539_);
        }
    }

    class BeeflyGrowCropGoal
    extends Goal {
        static final int GROW_CHANCE = 30;

        BeeflyGrowCropGoal() {
        }

        public boolean m_8036_() {
            if (BeeflyEntity.this.getCropsGrownSinceVisitingFlower() >= 3) {
                return false;
            }
            if (BeeflyEntity.this.f_19796_.m_188501_() < 0.3f) {
                return false;
            }
            return BeeflyEntity.this.hasPollen();
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public void m_8037_() {
            if (BeeflyEntity.this.f_19796_.m_188503_(this.m_183277_(30)) == 0) {
                for (int i = 1; i <= 2; ++i) {
                    BlockPos blockpos = BeeflyEntity.this.m_20183_().m_6625_(i);
                    BlockState blockstate = BeeflyEntity.this.m_9236_().m_8055_(blockpos);
                    Block block = blockstate.m_60734_();
                    BlockState newState = null;
                    if (!blockstate.m_204336_(BlockTags.f_13074_)) continue;
                    if (block instanceof CropBlock) {
                        CropBlock cropBlock = (CropBlock)block;
                        if (!cropBlock.m_52307_(blockstate)) {
                            newState = cropBlock.m_52289_(cropBlock.m_52305_(blockstate) + 1);
                        }
                    } else if (block instanceof StemBlock) {
                        age = (Integer)blockstate.m_61143_((Property)StemBlock.f_57013_);
                        if (age < 7) {
                            newState = (BlockState)blockstate.m_61124_((Property)StemBlock.f_57013_, (Comparable)Integer.valueOf(age + 1));
                        }
                    } else if (blockstate.m_60713_(Blocks.f_50685_)) {
                        age = (Integer)blockstate.m_61143_((Property)SweetBerryBushBlock.f_57244_);
                        if (age < 3) {
                            newState = (BlockState)blockstate.m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(age + 1));
                        }
                    } else if (blockstate.m_60713_(Blocks.f_152538_) || blockstate.m_60713_(Blocks.f_152539_)) {
                        ((BonemealableBlock)blockstate.m_60734_()).m_214148_((ServerLevel)BeeflyEntity.this.m_9236_(), BeeflyEntity.this.f_19796_, blockpos, blockstate);
                        BeeflyEntity.this.incrementNumCropsGrownSinceVisitingFlower();
                    }
                    if (newState == null) continue;
                    BeeflyEntity.this.m_9236_().m_46796_(2005, blockpos, 0);
                    BeeflyEntity.this.m_9236_().m_46597_(blockpos, newState);
                    BeeflyEntity.this.incrementNumCropsGrownSinceVisitingFlower();
                    if (BeeflyEntity.this.getCropsGrownSinceVisitingFlower() < 3) continue;
                    BeeflyEntity.this.setHasPollen(false);
                    BeeflyEntity.this.resetNumCropsGrownSinceVisitingFlower();
                    BeeflyEntity.this.savedFlowerPos = null;
                    BeeflyEntity.this.remainingCooldownBeforeLocatingNewFlower = 2400;
                }
            }
        }
    }

    class BeeflyFlightGoal
    extends Goal {
        private final BeeflyEntity beefly;
        private double x;
        private double y;
        private double z;
        private int flyDuration;
        private int restDuration;
        private int currentTimer;
        private boolean shouldRest;
        private int landingTimer;
        private Vec3 landingTarget;

        public BeeflyFlightGoal(BeeflyEntity beefly) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.beefly = beefly;
            this.resetTimers();
            this.landingTimer = 0;
        }

        private void resetTimers() {
            this.flyDuration = 160 + this.beefly.m_217043_().m_188503_(81);
            this.restDuration = 80 + this.beefly.m_217043_().m_188503_(81);
            this.currentTimer = 0;
            this.shouldRest = false;
            this.landingTimer = 0;
        }

        public boolean m_8036_() {
            if (this.beefly.m_20160_() || this.beefly.m_20159_()) {
                return false;
            }
            if (!this.beefly.m_29443_() && this.beefly.m_20096_()) {
                AABB searchBox = this.beefly.m_20191_().m_82400_(4.0);
                List nearbyPlayers = this.beefly.m_9236_().m_45976_(Player.class, searchBox);
                if (!nearbyPlayers.isEmpty()) {
                    this.shouldRest = false;
                    this.currentTimer = 0;
                    this.landingTimer = 0;
                    Vec3 target = this.getPosition();
                    if (target != null) {
                        this.x = target.f_82479_;
                        this.y = target.f_82480_;
                        this.z = target.f_82481_;
                        return true;
                    }
                }
            }
            if (!this.beefly.m_29443_() && this.beefly.m_217043_().m_188503_(80) != 0 && !this.shouldRest) {
                return false;
            }
            Vec3 target = this.getPosition();
            if (target == null) {
                return false;
            }
            this.x = target.f_82479_;
            this.y = target.f_82480_;
            this.z = target.f_82481_;
            return true;
        }

        public boolean m_8045_() {
            if (!this.beefly.m_29443_() && this.beefly.m_20096_() && this.currentTimer >= this.restDuration) {
                return false;
            }
            if (this.beefly.landingFlag) {
                return !this.beefly.m_20096_() && this.beefly.groundedFor <= 0;
            }
            return this.beefly.m_29443_() && !this.beefly.m_21573_().m_26571_() && this.beefly.groundedFor <= 0;
        }

        public void m_8056_() {
            this.beefly.setFlying(true);
            this.beefly.m_21573_().m_26519_(this.x, this.y, this.z, 0.5);
        }

        public void m_8041_() {
            this.beefly.m_21573_().m_26573_();
            this.beefly.landingFlag = false;
            this.landingTimer = 0;
            this.landingTarget = null;
            this.x = 0.0;
            this.y = 0.0;
            this.z = 0.0;
            super.m_8041_();
        }

        public void m_8037_() {
            if (!this.beefly.m_29443_() && this.beefly.m_20096_()) {
                ++this.currentTimer;
                BlockPos beeflyPos = this.beefly.m_20183_();
                BlockState stateAtPos = this.beefly.m_9236_().m_8055_(beeflyPos);
                if (!stateAtPos.m_60795_() && !stateAtPos.m_247087_()) {
                    return;
                }
                this.beefly.m_20256_(Vec3.f_82478_);
                return;
            }
            ++this.currentTimer;
            if (this.beefly.m_29443_()) {
                if (this.currentTimer >= this.flyDuration) {
                    this.shouldRest = true;
                    this.beefly.landingFlag = true;
                    if (this.landingTarget == null) {
                        this.landingTarget = this.findLandingPos();
                    }
                }
                if (this.beefly.landingFlag) {
                    if (this.landingTarget == null) {
                        this.landingTarget = this.findLandingPos();
                    }
                    if (this.landingTarget != null) {
                        ++this.landingTimer;
                        if (this.landingTimer % 20 == 0) {
                            Vec3 nextPos = this.getDescentPosition(this.landingTarget, this.landingTimer);
                            this.beefly.m_21573_().m_26519_(nextPos.f_82479_, nextPos.f_82480_, nextPos.f_82481_, 0.25);
                        }
                        if (this.beefly.m_20096_() || this.beefly.m_20186_() - this.landingTarget.f_82480_ < 1.5 && this.landingTimer > 60) {
                            this.beefly.setFlying(false);
                            this.currentTimer = 0;
                            this.shouldRest = false;
                            this.beefly.landingFlag = false;
                            this.landingTarget = null;
                            this.landingTimer = 0;
                            this.resetTimers();
                        }
                    } else {
                        this.beefly.landingFlag = false;
                        this.shouldRest = false;
                        this.landingTimer = 0;
                    }
                }
            }
            if (this.isOverWaterOrVoid() || this.beefly.m_20072_()) {
                this.beefly.setFlying(true);
                this.beefly.landingFlag = false;
                this.shouldRest = false;
                this.landingTimer = 0;
                this.landingTarget = null;
            }
        }

        private Vec3 getPosition() {
            if (this.shouldRest) {
                this.landingTarget = this.findLandingPos();
                return this.getCirclingPosition(this.landingTarget);
            }
            return this.findFlightPos();
        }

        private Vec3 getCirclingPosition(Vec3 target) {
            double angle = this.beefly.m_217043_().m_188500_() * Math.PI * 2.0;
            double radius = 2.0 + this.beefly.m_217043_().m_188500_() * 2.0;
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double yOffset = 3.0 + this.beefly.m_217043_().m_188500_() * 2.0;
            return new Vec3(target.f_82479_ + xOffset, target.f_82480_ + yOffset, target.f_82481_ + zOffset);
        }

        private Vec3 getDescentPosition(Vec3 target, int timer) {
            if (target == null) {
                return this.beefly.m_20182_();
            }
            double progress = Math.min((double)timer / 120.0, 1.0);
            double angle = (double)timer * 0.1 % (Math.PI * 2);
            double radius = 2.5 * (1.0 - progress * 0.6);
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double currentHeight = this.beefly.m_20186_();
            double targetHeight = target.f_82480_ + 0.5;
            double descentHeight = currentHeight - (currentHeight - targetHeight) * progress * 0.2;
            return new Vec3(target.f_82479_ + xOffset, Math.max(descentHeight, targetHeight), target.f_82481_ + zOffset);
        }

        private Vec3 findFlightPos() {
            int range = 13;
            Vec3 heightAdjusted = this.beefly.m_20182_().m_82520_((double)(this.beefly.m_217043_().m_188503_(range * 2) - range), 0.0, (double)(this.beefly.m_217043_().m_188503_(range * 2) - range));
            Vec3 ground = this.groundPosition(heightAdjusted);
            int minHeight = 2;
            int heightVariation = this.beefly.m_217043_().m_188503_(5 - minHeight + 1);
            heightAdjusted = new Vec3(heightAdjusted.f_82479_, ground.f_82480_ + (double)minHeight + (double)heightVariation, heightAdjusted.f_82481_);
            BlockHitResult result = this.beefly.m_9236_().m_45547_(new ClipContext(this.beefly.m_146892_(), heightAdjusted, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.beefly));
            if (result.m_6662_() == HitResult.Type.MISS) {
                return heightAdjusted;
            }
            return result.m_82450_();
        }

        private Vec3 findLandingPos() {
            Vec3 currentPos = this.beefly.m_20182_();
            Vec3 ground = this.groundPosition(currentPos);
            BlockPos landingPos = BlockPos.m_274446_((Position)ground);
            while (landingPos.m_123342_() < this.beefly.m_9236_().m_151558_() && !this.beefly.m_9236_().m_8055_(landingPos).m_60795_() && !this.beefly.m_9236_().m_8055_(landingPos).m_247087_()) {
                landingPos = landingPos.m_7494_();
            }
            return Vec3.m_82512_((Vec3i)landingPos);
        }

        private Vec3 groundPosition(Vec3 airPosition) {
            BlockPos.MutableBlockPos ground = new BlockPos.MutableBlockPos();
            ground.m_122169_(airPosition.f_82479_, airPosition.f_82480_, airPosition.f_82481_);
            boolean flag = false;
            while (ground.m_123342_() < this.beefly.m_9236_().m_151558_() && !this.beefly.m_9236_().m_8055_((BlockPos)ground).m_60804_((BlockGetter)this.beefly.m_9236_(), (BlockPos)ground) && this.beefly.m_9236_().m_6425_((BlockPos)ground).m_76178_()) {
                ground.m_122184_(0, 1, 0);
                flag = true;
            }
            ground.m_122184_(0, -1, 0);
            while (ground.m_123342_() > this.beefly.m_9236_().m_141937_() && !this.beefly.m_9236_().m_8055_((BlockPos)ground).m_60804_((BlockGetter)this.beefly.m_9236_(), (BlockPos)ground) && this.beefly.m_9236_().m_6425_((BlockPos)ground).m_76178_()) {
                ground.m_122184_(0, -1, 0);
            }
            return Vec3.m_82512_((Vec3i)(flag ? ground.m_7494_() : ground.m_7495_()));
        }

        private boolean isOverWaterOrVoid() {
            BlockPos position = this.beefly.m_20183_();
            while (position.m_123342_() > this.beefly.m_9236_().m_141937_() && this.beefly.m_9236_().m_46859_(position) && this.beefly.m_9236_().m_6425_(position).m_76178_()) {
                position = position.m_7495_();
            }
            return !this.beefly.m_9236_().m_6425_(position).m_76178_() || this.beefly.m_9236_().m_8055_(position).m_60713_(Blocks.f_50191_) || position.m_123342_() <= this.beefly.m_9236_().m_141937_();
        }
    }

    private static class BeeflyFlyingNavigation
    extends FlyingPathNavigation {
        private float distanceModifier;

        public BeeflyFlyingNavigation(Mob mob, Level level, float distanceModifier) {
            super(mob, level);
            this.distanceModifier = distanceModifier;
        }

        protected void m_7636_() {
            boolean flag;
            Vec3 vector3d = this.m_7475_();
            this.f_26505_ = this.f_26494_.m_20205_() * this.distanceModifier;
            BlockPos vector3i = this.f_26496_.m_77400_();
            double d0 = Math.abs(this.f_26494_.m_20185_() - ((double)vector3i.m_123341_() + 0.5));
            double d1 = Math.abs(this.f_26494_.m_20186_() - (double)vector3i.m_123342_());
            double d2 = Math.abs(this.f_26494_.m_20189_() - ((double)vector3i.m_123343_() + 0.5));
            boolean bl = flag = d0 < (double)this.f_26505_ && d2 < (double)this.f_26505_ && d1 < 1.0;
            if (flag || this.m_264193_(this.f_26496_.m_77401_().f_77282_) && this.m_26559_(vector3d)) {
                this.f_26496_.m_77374_();
            }
            this.m_6481_(vector3d);
        }

        private boolean m_26559_(Vec3 currentPosition) {
            Vec3 vector3d3;
            if (this.f_26496_.m_77399_() + 1 >= this.f_26496_.m_77398_()) {
                return false;
            }
            Vec3 vector3d = Vec3.m_82539_((Vec3i)this.f_26496_.m_77400_());
            if (!currentPosition.m_82509_((Position)vector3d, 2.0)) {
                return false;
            }
            Vec3 vector3d1 = Vec3.m_82539_((Vec3i)this.f_26496_.m_77396_(this.f_26496_.m_77399_() + 1));
            Vec3 vector3d2 = vector3d1.m_82546_(vector3d);
            return vector3d2.m_82526_(vector3d3 = currentPosition.m_82546_(vector3d)) > 0.0;
        }
    }
}

