/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.entity.client.IFlyingBug;
import com.pepper.faunify.entity.goal.BugFlightGoal;
import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BeetleEntity
extends Animal
implements GeoEntity,
FlyingAnimal,
IFlyingBug {
    private static final int FLAP_INTERVAL = 15;
    private static final double FALL_DETECTION_THRESHOLD = -0.4;
    private static final double CLIMB_SPEED = 0.08;
    private static final int MAX_CLIMB_TIME = 20;
    private static final int CLIMB_COOLDOWN = 40;
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(BeetleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(BeetleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(BeetleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> CAUGHT = SynchedEntityData.m_135353_(BeetleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    protected float flyProgress;
    protected float prevFlyProgress;
    public int timeFlying = 0;
    public int groundedFor = 0;
    public boolean landingFlag;
    private int climbingTime = 0;
    private int climbCooldown = 0;
    private BlockPos lastClimbPos;
    private PathNavigation groundNavigation;
    private PathNavigation flyingNavigation;
    private Vec3 prevPosition = Vec3.f_82478_;
    private double actualMovementSpeed = 0.0;

    public BeetleEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new BeetleMoveController(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(2, new BugFlightGoal<BeetleEntity>(this, 3, 150));
        this.f_21345_.m_25352_(3, (Goal)new GroundLookAroundGoal((Mob)this));
    }

    public static boolean canSpawn(EntityType<BeetleEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant(BeetleEntity.getRandomVariant(world.m_213780_()));
        super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        return spawnData;
    }

    public void m_8119_() {
        boolean shouldClimb;
        super.m_8119_();
        if (this.isCaught()) {
            return;
        }
        this.prevFlyProgress = this.flyProgress;
        this.tickFlight();
        Vec3 currentPos = this.m_20182_();
        this.actualMovementSpeed = currentPos.m_82554_(this.prevPosition);
        this.prevPosition = currentPos;
        if (!(this.m_9236_().f_46443_ || this.m_29443_() || this.m_20096_() || this.m_20072_())) {
            Vec3 motion = this.m_20184_();
            if (motion.f_82480_ < -0.4) {
                this.setFlying(true);
                this.groundedFor = 0;
            }
        }
        if (this.climbCooldown > 0) {
            --this.climbCooldown;
        }
        boolean bl = shouldClimb = this.f_19862_ && !this.m_29443_() && this.isCollidingWithBlock() && this.climbCooldown <= 0;
        if (this.isClimbing() && !this.m_29443_()) {
            BlockPos currentPos2 = this.m_20183_();
            if (this.lastClimbPos != null && this.lastClimbPos.equals((Object)currentPos2)) {
                ++this.climbingTime;
            } else {
                this.climbingTime = 0;
                this.lastClimbPos = currentPos2;
            }
            if (this.climbingTime >= 20) {
                this.setClimbing(false);
                this.climbCooldown = 40;
                this.climbingTime = 0;
                this.lastClimbPos = null;
                if (!this.m_9236_().f_46443_) {
                    this.f_21344_.m_26573_();
                    this.f_21345_.m_25386_().forEach(goal -> goal.m_8041_());
                }
            } else {
                boolean hasBlockAbove;
                Vec3 deltaMovement = this.m_20184_();
                boolean shouldApplyClimbMovement = true;
                if (this.m_20096_() && !(hasBlockAbove = this.isCollidingWithBlock())) {
                    shouldApplyClimbMovement = false;
                }
                if (shouldApplyClimbMovement) {
                    this.m_20334_(deltaMovement.f_82479_, 0.08, deltaMovement.f_82481_);
                }
            }
        } else {
            this.climbingTime = 0;
            this.lastClimbPos = null;
        }
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(shouldClimb);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isCaught()) {
            return;
        }
    }

    public void tickFlight() {
        if (this.m_29443_() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.m_29443_() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.m_20072_()) {
            this.m_20242_(false);
            if (!this.m_9236_().f_46443_) {
                Vec3 motion = this.m_20184_();
                if (motion.f_82480_ < 0.05) {
                    this.m_20334_(motion.f_82479_ * 0.9, motion.f_82480_ + 0.1, motion.f_82481_ * 0.9);
                }
            }
        }
        if (this.m_29443_()) {
            ++this.timeFlying;
            if (!this.m_20072_()) {
                this.m_20242_(true);
            }
            this.f_21344_ = this.flyingNavigation;
            if (this.groundedFor > 0) {
                this.setFlying(false);
            }
        } else {
            this.timeFlying = 0;
            this.m_20242_(false);
            this.f_21344_ = this.groundNavigation;
        }
        if (this.groundedFor > 0) {
            --this.groundedFor;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.m_29443_() && this.m_6084_() && !this.m_20160_() && !this.m_20072_()) {
                if (this.landingFlag) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.08, 0.0));
                }
                if (this.f_19862_ && !this.landingFlag) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, 0.04, 0.0));
                }
            }
            if (this.m_29443_() && this.timeFlying > 40 && this.m_20096_()) {
                this.setFlying(false);
            }
        }
    }

    protected PathNavigation m_6037_(Level level) {
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
        this.flyingNavigation = new BeetleFlyingNavigation((Mob)this, level, 0.75f);
        return this.groundNavigation;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.isCaught()) {
            super.m_7023_(Vec3.f_82478_);
            return;
        }
        if (this.isClimbing() && !this.m_29443_()) {
            Vec3 reducedVector = travelVector.m_82490_(0.4);
            super.m_7023_(reducedVector);
        } else {
            super.m_7023_(travelVector);
        }
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob otherParent) {
        return null;
    }

    protected void m_7840_(double fallDistance, boolean onGround, BlockState state, BlockPos pos) {
        if (!this.m_29443_()) {
            super.m_7840_(fallDistance, onGround, state, pos);
        }
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<BeetleEntity> event) {
        if (this.isCaught()) {
            event.getController().stop();
            return PlayState.STOP;
        }
        boolean flying = this.m_29443_();
        boolean climbing = this.isClimbing();
        boolean moving = this.isActuallyMoving();
        boolean grounded = this.m_20096_();
        if (flying) {
            event.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (climbing || moving && grounded) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Flying", this.m_29443_());
        tag.m_128405_("TimeFlying", this.timeFlying);
        tag.m_128405_("GroundedFor", this.groundedFor);
        tag.m_128379_("LandingFlag", this.landingFlag);
        tag.m_128405_("Variant", this.getVariant().id);
        tag.m_128379_("Caught", this.isCaught());
        tag.m_128405_("ClimbingTime", this.climbingTime);
        tag.m_128405_("ClimbCooldown", this.climbCooldown);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setFlying(tag.m_128471_("Flying"));
        this.timeFlying = tag.m_128451_("TimeFlying");
        this.groundedFor = tag.m_128451_("GroundedFor");
        this.landingFlag = tag.m_128471_("LandingFlag");
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
        this.setCaught(tag.m_128471_("Caught"));
        this.climbingTime = tag.m_128451_("ClimbingTime");
        this.climbCooldown = tag.m_128451_("ClimbCooldown");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
        this.f_19804_.m_135372_(CAUGHT, (Object)false);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6094_() {
        return !this.isCaught();
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    protected float m_6118_() {
        return 0.0f;
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(false);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte flags = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        flags = climbing ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)flags);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean m_29443_() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    @Override
    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public float getFlyProgress(float partialTicks) {
        return (this.prevFlyProgress + (this.flyProgress - this.prevFlyProgress) * partialTicks) * 0.2f;
    }

    public boolean isActuallyMoving() {
        Vec3 delta = this.m_20184_();
        double horizontalSpeed = Math.sqrt(delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_);
        return horizontalSpeed > 0.003;
    }

    @Override
    public boolean getLandingFlag() {
        return this.landingFlag;
    }

    @Override
    public void setLandingFlag(boolean flag) {
        this.landingFlag = flag;
    }

    @Override
    public int getGroundedFor() {
        return this.groundedFor;
    }

    public boolean isCaught() {
        return (Boolean)this.f_19804_.m_135370_(CAUGHT);
    }

    public void setCaught(boolean caught) {
        this.f_19804_.m_135381_(CAUGHT, (Object)caught);
    }

    private boolean isCollidingWithBlock() {
        boolean hasAdjacentAtCurrentLevel;
        BlockPos pos = this.m_20183_();
        BlockState state = this.m_9236_().m_8055_(pos);
        if (!state.m_60795_() && !state.m_247087_()) {
            return true;
        }
        BlockPos north = pos.m_122012_();
        BlockPos south = pos.m_122019_();
        BlockPos east = pos.m_122029_();
        BlockPos west = pos.m_122024_();
        boolean bl = hasAdjacentAtCurrentLevel = !this.m_9236_().m_8055_(north).m_60795_() && !this.m_9236_().m_8055_(north).m_247087_() || !this.m_9236_().m_8055_(south).m_60795_() && !this.m_9236_().m_8055_(south).m_247087_() || !this.m_9236_().m_8055_(east).m_60795_() && !this.m_9236_().m_8055_(east).m_247087_() || !this.m_9236_().m_8055_(west).m_60795_() && !this.m_9236_().m_8055_(west).m_247087_();
        if (hasAdjacentAtCurrentLevel) {
            return true;
        }
        BlockPos posBelow = pos.m_7495_();
        BlockPos northBelow = posBelow.m_122012_();
        BlockPos southBelow = posBelow.m_122019_();
        BlockPos eastBelow = posBelow.m_122029_();
        BlockPos westBelow = posBelow.m_122024_();
        return !this.m_9236_().m_8055_(northBelow).m_60795_() && !this.m_9236_().m_8055_(northBelow).m_247087_() || !this.m_9236_().m_8055_(southBelow).m_60795_() && !this.m_9236_().m_8055_(southBelow).m_247087_() || !this.m_9236_().m_8055_(eastBelow).m_60795_() && !this.m_9236_().m_8055_(eastBelow).m_247087_() || !this.m_9236_().m_8055_(westBelow).m_60795_() && !this.m_9236_().m_8055_(westBelow).m_247087_();
    }

    private static Variant getRandomVariant(RandomSource random) {
        int roll = random.m_188503_(111);
        if (roll < 10) {
            return Variant.ATLAS;
        }
        if (roll < 20) {
            return Variant.DYNASTID;
        }
        if (roll < 30) {
            return Variant.ELEPHANT;
        }
        if (roll < 40) {
            return Variant.GOLIATH;
        }
        if (roll < 50) {
            return Variant.HERCULES;
        }
        if (roll < 60) {
            return Variant.CYCLOMMATUS;
        }
        if (roll < 70) {
            return Variant.GIANT;
        }
        if (roll < 80) {
            return Variant.GIRAFFE;
        }
        if (roll < 90) {
            return Variant.MIYAMA;
        }
        if (roll < 100) {
            return Variant.RAINBOW;
        }
        if (roll < 110) {
            return Variant.SAW;
        }
        return Variant.GOLDEN;
    }

    private static class BeetleMoveController
    extends MoveControl {
        private final BeetleEntity beetle;

        public BeetleMoveController(BeetleEntity beetle) {
            super((Mob)beetle);
            this.beetle = beetle;
        }

        public void m_8126_() {
            if (this.beetle.isCaught()) {
                return;
            }
            if (this.beetle.m_29443_() && !this.beetle.m_20072_()) {
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                    Vec3 vector3d = new Vec3(this.f_24975_ - this.beetle.m_20185_(), this.f_24976_ - this.beetle.m_20186_(), this.f_24977_ - this.beetle.m_20189_());
                    double d0 = vector3d.m_82553_();
                    double width = this.beetle.m_20191_().m_82309_();
                    if (d0 > 0.001) {
                        Vec3 vector3d1 = vector3d.m_82490_(this.f_24978_ * 0.05 / d0);
                        this.beetle.m_20256_(this.beetle.m_20184_().m_82549_(vector3d1).m_82490_(0.95).m_82520_(0.0, -0.01, 0.0));
                        if (d0 >= width) {
                            float yaw = -((float)Mth.m_14136_((double)vector3d1.f_82479_, (double)vector3d1.f_82481_)) * 57.295776f;
                            this.beetle.m_146922_(Mth.m_14148_((float)this.beetle.m_146908_(), (float)yaw, (float)8.0f));
                        }
                    }
                    if (d0 < width) {
                        this.f_24981_ = MoveControl.Operation.WAIT;
                    }
                } else {
                    Vec3 currentMotion = this.beetle.m_20184_();
                    double horizontalSpeed = Math.sqrt(currentMotion.f_82479_ * currentMotion.f_82479_ + currentMotion.f_82481_ * currentMotion.f_82481_);
                    if (horizontalSpeed < 0.05) {
                        double yaw = Math.toRadians(this.beetle.m_146908_());
                        Vec3 forwardMotion = new Vec3(-Math.sin(yaw) * 0.02, 0.0, Math.cos(yaw) * 0.02);
                        this.beetle.m_20256_(currentMotion.m_82549_(forwardMotion));
                    }
                }
            } else {
                super.m_8126_();
            }
        }
    }

    public static enum Variant implements StringRepresentable
    {
        ATLAS(0, "atlas"),
        DYNASTID(1, "dynastid"),
        ELEPHANT(2, "elephant"),
        GOLIATH(3, "goliath"),
        HERCULES(4, "hercules"),
        CYCLOMMATUS(5, "cyclommatus"),
        GIANT(6, "giant"),
        GIRAFFE(7, "giraffe"),
        MIYAMA(8, "miyama"),
        RAINBOW(9, "rainbow"),
        SAW(10, "saw"),
        GOLDEN(11, "golden");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    private static class BeetleFlyingNavigation
    extends FlyingPathNavigation {
        private float distanceModifier;

        public BeetleFlyingNavigation(Mob mob, Level level, float distanceModifier) {
            super(mob, level);
            this.distanceModifier = distanceModifier;
        }

        protected void m_7636_() {
            boolean flag;
            Vec3 vector3d = this.m_7475_();
            this.f_26505_ = this.f_26494_.m_20205_() * this.distanceModifier;
            BlockPos vector3i = this.f_26496_.m_77400_();
            double d0 = Math.abs(this.f_26494_.m_20185_() - ((double)vector3i.m_123341_() + 0.5));
            double d1 = Math.abs(this.f_26494_.m_20186_() - (double)vector3i.m_123342_());
            double d2 = Math.abs(this.f_26494_.m_20189_() - ((double)vector3i.m_123343_() + 0.5));
            boolean bl = flag = d0 < (double)this.f_26505_ && d2 < (double)this.f_26505_ && d1 < 1.0;
            if (flag || this.m_264193_(this.f_26496_.m_77401_().f_77282_) && this.m_26559_(vector3d)) {
                this.f_26496_.m_77374_();
            }
            this.m_6481_(vector3d);
        }

        private boolean m_26559_(Vec3 currentPosition) {
            Vec3 vector3d3;
            if (this.f_26496_.m_77399_() + 1 >= this.f_26496_.m_77398_()) {
                return false;
            }
            Vec3 vector3d = Vec3.m_82539_((Vec3i)this.f_26496_.m_77400_());
            if (!currentPosition.m_82509_((Position)vector3d, 2.0)) {
                return false;
            }
            Vec3 vector3d1 = Vec3.m_82539_((Vec3i)this.f_26496_.m_77396_(this.f_26496_.m_77399_() + 1));
            Vec3 vector3d2 = vector3d1.m_82546_(vector3d);
            return vector3d2.m_82526_(vector3d3 = currentPosition.m_82546_(vector3d)) > 0.0;
        }
    }
}

