/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.particle.FaunifyParticleTypes;
import com.pepper.faunify.registry.FaunifyBlocks;
import com.pepper.faunify.registry.FaunifyEntities;
import com.pepper.faunify.registry.FaunifySounds;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.entity.BrushableBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ChinchillaEntity
extends TamableAnimal
implements GeoEntity {
    public static final float DEFAULT_HEALTH = 8.0f;
    public static final float TAMED_HEALTH = 20.0f;
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(ChinchillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(ChinchillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BATHING = SynchedEntityData.m_135353_(ChinchillaEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public ChinchillaEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new ChinchillaMoveControl(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.5){

            public boolean m_8036_() {
                return !ChinchillaEntity.this.m_21824_() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new DustBatheGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new DustBatheSuspiciousGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.3, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42405_}), false));
        this.f_21345_.m_25352_(6, (Goal)new BreedGoal((Animal)this, 1.3));
        this.f_21345_.m_25352_(7, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.3, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new SleepGoal(200));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f){

            public boolean m_8036_() {
                return !ChinchillaEntity.this.m_5803_() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !ChinchillaEntity.this.m_5803_() && super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(11, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return !ChinchillaEntity.this.m_5803_() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !ChinchillaEntity.this.m_5803_() && super.m_8045_();
            }
        });
    }

    public static boolean canSpawn(EntityType<ChinchillaEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant((Variant)((Object)Util.m_214670_((Object[])Variant.values(), (RandomSource)world.m_213780_())));
        super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        return spawnData;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)player) || this.m_21824_() || item == Items.f_41939_ && !this.m_21824_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            if (this.m_5803_()) {
                this.setSleeping(false);
                this.m_21839_(true);
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6898_(itemstack) && this.m_6162_()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_146740_(ChinchillaEntity.m_216967_((int)(-this.m_146764_())), true);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 1, d0, d1, d2, 0.0);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (item == Items.f_42405_ && this.m_21223_() < this.m_21233_()) {
                Level i;
                this.m_5634_(3.0f);
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                if ((i = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)i;
                    for (int i2 = 0; i2 < 5; ++i2) {
                        double offsetX = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        double offsetY = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 1.0;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)FaunifyParticleTypes.HEALTH.get()), this.m_20185_() + offsetX, this.m_20186_() + (double)this.m_20192_() + offsetY, this.m_20189_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (this.m_6898_(itemstack) && this.m_146764_() == 0 && !this.m_27593_()) {
                if (!player.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_27595_(player);
                return InteractionResult.SUCCESS;
            }
            InteractionResult interactionresult = super.m_6071_(player, hand);
            if ((!interactionresult.m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)player)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (item == Items.f_41939_) {
            if (!player.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0) {
                this.m_21828_(player);
                this.m_21816_(player.m_20148_());
                this.m_21839_(true);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void m_21828_(Player player) {
        super.m_21828_(player);
        this.m_21051_(Attributes.f_22276_).m_22100_(20.0);
        this.m_21153_(20.0f);
    }

    public boolean m_7848_(Animal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(otherAnimal instanceof ChinchillaEntity)) {
            return false;
        }
        ChinchillaEntity otherChinchilla = (ChinchillaEntity)otherAnimal;
        if (!otherChinchilla.m_21824_()) {
            return false;
        }
        if (otherChinchilla.m_21825_()) {
            return false;
        }
        return this.m_27593_() && otherChinchilla.m_27593_();
    }

    @Nullable
    public ChinchillaEntity getBreedOffspring(ServerLevel serverLevel, AgeableMob otherParent) {
        ChinchillaEntity babyChinchilla = (ChinchillaEntity)((EntityType)FaunifyEntities.CHINCHILLA.get()).m_20615_((Level)serverLevel);
        if (babyChinchilla != null && otherParent instanceof ChinchillaEntity) {
            ChinchillaEntity parent = (ChinchillaEntity)otherParent;
            if (this.m_21824_()) {
                babyChinchilla.m_21816_(this.m_21805_());
                babyChinchilla.m_7105_(true);
            }
            Variant selectedVariant = this.f_19796_.m_188499_() ? this.getVariant() : parent.getVariant();
            babyChinchilla.setVariant(selectedVariant);
            babyChinchilla.m_21530_();
        }
        return babyChinchilla;
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_41720_() == Items.f_42405_;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        if (this.m_5803_()) {
            this.setSleeping(false);
        }
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        if (this.m_21825_()) {
            this.m_21837_(false);
        }
        return result;
    }

    protected SoundEvent m_7515_() {
        int soundIndex = this.f_19796_.m_188503_(3);
        switch (soundIndex) {
            case 0: {
                return (SoundEvent)FaunifySounds.CHINCHILLA_IDLE_1.get();
            }
            case 1: {
                return (SoundEvent)FaunifySounds.CHINCHILLA_IDLE_2.get();
            }
            case 2: {
                return (SoundEvent)FaunifySounds.CHINCHILLA_IDLE_3.get();
            }
        }
        return (SoundEvent)FaunifySounds.CHINCHILLA_IDLE_1.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.CHINCHILLA_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<ChinchillaEntity> event) {
        LivingEntity target = this.m_5448_();
        if (target != null && !target.m_6084_()) {
            this.m_6710_(null);
            target = null;
        }
        if (this.m_5803_()) {
            event.getController().setAnimation(RawAnimation.begin().then("sleep", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.m_21825_()) {
            event.getController().setAnimation(RawAnimation.begin().then("stand", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isDustBathing()) {
            BlockParticleOption gravelParticle = new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49994_.m_49966_());
            for (int i = 0; i < 3; ++i) {
                double offsetX = ((double)this.m_217043_().m_188501_() - 0.5) * 0.5;
                double offsetZ = ((double)this.m_217043_().m_188501_() - 0.5) * 0.5;
                this.m_9236_().m_7106_((ParticleOptions)gravelParticle, this.m_20185_() + offsetX, this.m_20186_() + 0.1, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
            }
            event.getController().setAnimation(RawAnimation.begin().then("bath", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (this.isFollowingPlayerWithFood()) {
            if (event.isMoving()) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(BATHING, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().id);
        tag.m_128379_("Sleeping", this.m_5803_());
        tag.m_128379_("Bathing", this.isDustBathing());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
        this.setSleeping(tag.m_128471_("Sleeping"));
        this.setDustBathing(tag.m_128471_("Bathing"));
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public void setSleeping(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
    }

    public boolean isDustBathing() {
        return (Boolean)this.f_19804_.m_135370_(BATHING);
    }

    public void setDustBathing(boolean bathing) {
        this.f_19804_.m_135381_(BATHING, (Object)bathing);
        if (bathing) {
            this.m_21573_().m_26573_();
        }
    }

    private boolean isFollowingPlayerWithFood() {
        Player player = this.m_9236_().m_45930_((Entity)this, 10.0);
        if (player != null) {
            ItemStack heldItem = player.m_21205_();
            return heldItem.m_41720_() == Items.f_42405_;
        }
        return false;
    }

    static class ChinchillaMoveControl
    extends MoveControl {
        private final ChinchillaEntity chinchilla;

        public ChinchillaMoveControl(ChinchillaEntity chinchillaEntity) {
            super((Mob)chinchillaEntity);
            this.chinchilla = chinchillaEntity;
        }

        public void m_8126_() {
            if (!this.chinchilla.m_5803_()) {
                super.m_8126_();
            }
        }
    }

    public class DustBatheGoal
    extends Goal {
        private final ChinchillaEntity chinchilla;
        private static final int DUST_BATH_DURATION = 35;
        private int dustBathTimer = 0;
        private BlockPos bathingBlock;

        public DustBatheGoal(ChinchillaEntity chinchilla) {
            this.chinchilla = chinchilla;
        }

        public boolean m_8036_() {
            if (this.chinchilla.m_21825_() || this.chinchilla.m_5803_()) {
                return false;
            }
            BlockPos pos = this.chinchilla.m_20183_().m_7495_();
            return this.chinchilla.m_9236_().m_8055_(pos).m_60713_(Blocks.f_49994_);
        }

        public void m_8056_() {
            this.bathingBlock = this.chinchilla.m_20183_().m_7495_();
            this.chinchilla.setDustBathing(true);
            this.dustBathTimer = 35;
            this.chinchilla.m_21573_().m_26573_();
        }

        public void m_8037_() {
            this.chinchilla.m_20256_(Vec3.f_82478_);
            this.chinchilla.m_146922_(this.chinchilla.f_19859_);
            this.chinchilla.m_146926_(0.0f);
            this.chinchilla.m_5496_(SoundEvents.f_12334_, 0.5f, 1.0f);
            if (this.dustBathTimer > 0) {
                --this.dustBathTimer;
            } else {
                this.chinchilla.setDustBathing(false);
                this.chinchilla.m_9236_().m_46597_(this.bathingBlock, ((Block)FaunifyBlocks.DUST_BLOCK.get()).m_49966_());
            }
        }

        public boolean m_8045_() {
            return this.chinchilla.isDustBathing() && this.chinchilla.m_9236_().m_8055_(this.bathingBlock).m_60713_(Blocks.f_49994_);
        }

        public void m_8041_() {
            this.chinchilla.setDustBathing(false);
            this.chinchilla.m_21573_().m_26573_();
            this.chinchilla.m_20256_(Vec3.f_82478_);
        }

        public EnumSet<Goal.Flag> m_7684_() {
            return EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK);
        }
    }

    public class DustBatheSuspiciousGoal
    extends Goal {
        private final ChinchillaEntity chinchilla;
        private static final int DUST_BATH_DURATION = 35;
        private static final int BRUSH_STAGE_TIME = 5;
        private int dustBathTimer = 0;
        private int brushStageTimer = 5;
        private boolean isSuspicious = false;
        private boolean hasDroppedItem = false;
        private BlockPos bathingBlock;

        public DustBatheSuspiciousGoal(ChinchillaEntity chinchilla) {
            this.chinchilla = chinchilla;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (this.chinchilla.m_21825_() || this.chinchilla.m_5803_()) {
                return false;
            }
            BlockPos pos = this.chinchilla.m_20183_().m_7495_();
            return this.chinchilla.m_9236_().m_8055_(pos).m_60713_(Blocks.f_276445_);
        }

        public void m_8056_() {
            this.bathingBlock = this.chinchilla.m_20183_().m_7495_();
            this.chinchilla.setDustBathing(true);
            this.chinchilla.m_21573_().m_26573_();
            this.dustBathTimer = 35;
            this.brushStageTimer = 5;
            this.isSuspicious = this.chinchilla.m_9236_().m_8055_(this.bathingBlock).m_60713_(Blocks.f_276445_);
            this.hasDroppedItem = false;
        }

        public void m_8037_() {
            this.chinchilla.m_20256_(Vec3.f_82478_);
            this.chinchilla.m_146922_(this.chinchilla.f_19859_);
            this.chinchilla.m_146926_(0.0f);
            this.chinchilla.m_5496_(SoundEvents.f_12334_, 0.5f, 1.0f);
            if (this.dustBathTimer > 0) {
                --this.dustBathTimer;
            }
            if (this.dustBathTimer <= 0) {
                if (this.isSuspicious) {
                    if (this.brushStageTimer-- <= 0) {
                        this.dustAwaySuspiciousGravel(this.bathingBlock);
                        this.brushStageTimer = 5;
                    }
                } else {
                    this.chinchilla.m_9236_().m_46597_(this.bathingBlock, ((Block)FaunifyBlocks.DUST_BLOCK.get()).m_49966_());
                    if (!this.hasDroppedItem) {
                        this.dropLootFromSuspiciousGravel();
                        this.hasDroppedItem = true;
                    }
                    this.chinchilla.setDustBathing(false);
                }
            }
        }

        public boolean m_8045_() {
            return this.chinchilla.isDustBathing() && this.chinchilla.m_9236_().m_8055_(this.bathingBlock).m_60713_(Blocks.f_276445_);
        }

        public void m_8041_() {
            this.chinchilla.setDustBathing(false);
            this.chinchilla.m_21573_().m_26573_();
            this.chinchilla.m_20256_(Vec3.f_82478_);
        }

        private void dustAwaySuspiciousGravel(BlockPos pos) {
            Player nearestPlayer;
            BrushableBlockEntity blockEntity;
            ServerLevel serverLevel;
            BlockState state;
            Level level = this.chinchilla.m_9236_();
            if (level instanceof ServerLevel && (state = (serverLevel = (ServerLevel)level).m_8055_(pos)).m_60734_() instanceof BrushableBlock && (blockEntity = (BrushableBlockEntity)serverLevel.m_7702_(pos)) != null && (nearestPlayer = (Player)serverLevel.m_8795_(p -> (double)p.m_20270_((Entity)this.chinchilla) < 5.0).stream().findFirst().orElse(null)) != null) {
                blockEntity.m_276923_(serverLevel.m_46467_(), nearestPlayer, Direction.UP);
            }
        }

        private void dropLootFromSuspiciousGravel() {
            Level level = this.chinchilla.m_9236_();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            ResourceLocation lootTableId = this.chinchilla.m_217043_().m_188503_(5) == 0 ? BuiltInLootTables.f_279604_ : BuiltInLootTables.f_279573_;
            LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(lootTableId);
            LootParams.Builder builder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)this.chinchilla.m_20182_()).m_287289_(LootContextParams.f_81455_, (Object)this.chinchilla);
            ObjectArrayList loot = lootTable.m_287195_(builder.m_287235_(LootContextParamSets.f_81410_));
            for (ItemStack stack : loot) {
                if (stack.m_41619_()) continue;
                ItemEntity itemEntity = new ItemEntity((Level)serverLevel, this.chinchilla.m_20185_(), this.chinchilla.m_20186_(), this.chinchilla.m_20189_(), stack);
                serverLevel.m_7967_((Entity)itemEntity);
            }
        }
    }

    public class SleepGoal
    extends Goal {
        private final int countdownTime;
        private int countdown;

        public SleepGoal(int countdownTime) {
            this.countdownTime = countdownTime;
            this.countdown = ChinchillaEntity.this.f_19796_.m_188503_(SleepGoal.m_186073_((int)countdownTime));
            this.m_7021_(EnumSet.noneOf(Goal.Flag.class));
        }

        public boolean m_8036_() {
            if (ChinchillaEntity.this.m_20069_()) {
                return false;
            }
            if (ChinchillaEntity.this.m_21824_() && !ChinchillaEntity.this.m_21825_()) {
                return false;
            }
            if (ChinchillaEntity.this.f_20900_ == 0.0f && ChinchillaEntity.this.f_20901_ == 0.0f && ChinchillaEntity.this.f_20902_ == 0.0f) {
                return this.canSleep() || ChinchillaEntity.this.m_5803_();
            }
            return false;
        }

        public boolean m_8045_() {
            if (ChinchillaEntity.this.m_20069_()) {
                return false;
            }
            if (ChinchillaEntity.this.m_21824_() && !ChinchillaEntity.this.m_21825_()) {
                return false;
            }
            return this.canSleep();
        }

        private boolean canSleep() {
            if (this.countdown > 0) {
                --this.countdown;
                return false;
            }
            return ChinchillaEntity.this.m_9236_().m_46462_();
        }

        public void m_8041_() {
            ChinchillaEntity.this.setSleeping(false);
            this.countdown = ChinchillaEntity.this.f_19796_.m_188503_(this.countdownTime);
        }

        public void m_8056_() {
            ChinchillaEntity.this.m_6862_(false);
            ChinchillaEntity.this.setSleeping(true);
            ChinchillaEntity.this.m_21573_().m_26573_();
            ChinchillaEntity.this.m_21566_().m_6849_(ChinchillaEntity.this.m_20185_(), ChinchillaEntity.this.m_20186_(), ChinchillaEntity.this.m_20189_(), 0.0);
        }
    }

    public static enum Variant implements StringRepresentable
    {
        GREY(0, "grey"),
        BROWN(1, "brown"),
        BLACK(2, "black"),
        WHITE(3, "white");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

