/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.config.FaunifyClientConfig;
import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.EnumSet;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class DragonflyEntity
extends Animal
implements GeoEntity,
FlyingAnimal {
    private static final int CONTINUOUS_FLAP_INTERVAL = 10;
    private static final double PLAYER_DETECTION_RANGE = 4.0;
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(DragonflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(DragonflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HOVERING = SynchedEntityData.m_135353_(DragonflyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    protected float flyProgress;
    protected float prevFlyProgress;
    public int timeFlying = 0;
    public int groundedFor = 0;
    private int continuousFlapTimer = 0;
    public boolean landingFlag;

    public DragonflyEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new DragonflyMoveController(this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.6);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new DartingGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new GroundLookAroundGoal((Mob)this));
    }

    public static boolean canSpawn(EntityType<DragonflyEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant((Variant)((Object)Util.m_214670_((Object[])Variant.values(), (RandomSource)world.m_213780_())));
        super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        return spawnData;
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevFlyProgress = this.flyProgress;
        this.tickFlight();
    }

    public void tickFlight() {
        if (this.m_29443_() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.m_29443_() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.m_29443_()) {
            ++this.timeFlying;
            this.m_20242_(true);
            if (this.groundedFor > 0 && !this.landingFlag) {
                this.setFlying(false);
            }
            if (!this.m_9236_().f_46443_) {
                ++this.continuousFlapTimer;
                if (this.continuousFlapTimer >= 10) {
                    if (!((Boolean)FaunifyClientConfig.DRAGONFLY_PHOBIA_FRIENDLY.get()).booleanValue()) {
                        this.m_5496_((SoundEvent)FaunifySounds.BUG_FLY_FAST_TACKY.get(), 0.1f, 0.8f);
                    }
                    this.continuousFlapTimer = 0;
                }
            }
        } else {
            this.timeFlying = 0;
            this.m_20242_(false);
            this.continuousFlapTimer = 0;
        }
        if (this.groundedFor > 0) {
            --this.groundedFor;
        }
        if (!this.m_9236_().f_46443_ && this.m_29443_() && this.m_6084_() && !this.m_20160_()) {
            if (this.landingFlag) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.06, 0.0));
            }
            if ((this.f_19862_ || this.m_20072_()) && !this.landingFlag) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.05, 0.0));
            }
        }
    }

    protected PathNavigation m_6037_(Level level) {
        return new DragonflyFlyingNavigation((Mob)this, level, 0.75f);
    }

    public boolean m_6094_() {
        return true;
    }

    protected float m_6118_() {
        return 0.0f;
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(false);
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob otherParent) {
        return null;
    }

    protected void m_7840_(double fallDistance, boolean onGround, BlockState state, BlockPos pos) {
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
    }

    private PlayState predicate(AnimationState<DragonflyEntity> event) {
        if (!this.m_29443_()) {
            event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("fly", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Flying", this.m_29443_());
        tag.m_128405_("TimeFlying", this.timeFlying);
        tag.m_128405_("GroundedFor", this.groundedFor);
        tag.m_128379_("LandingFlag", this.landingFlag);
        tag.m_128405_("ContinuousFlapTimer", this.continuousFlapTimer);
        tag.m_128405_("Variant", this.getVariant().id);
        tag.m_128379_("Hovering", this.isHovering());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setFlying(tag.m_128471_("Flying"));
        this.timeFlying = tag.m_128451_("TimeFlying");
        this.groundedFor = tag.m_128451_("GroundedFor");
        this.landingFlag = tag.m_128471_("LandingFlag");
        this.continuousFlapTimer = tag.m_128451_("ContinuousFlapTimer");
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
        this.setHovering(tag.m_128471_("Hovering"));
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
        this.f_19804_.m_135372_(HOVERING, (Object)false);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean m_29443_() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public boolean isHovering() {
        return (Boolean)this.f_19804_.m_135370_(HOVERING);
    }

    public void setHovering(boolean hovering) {
        this.f_19804_.m_135381_(HOVERING, (Object)hovering);
    }

    public float getFlyProgress(float partialTicks) {
        return (this.prevFlyProgress + (this.flyProgress - this.prevFlyProgress) * partialTicks) * 0.2f;
    }

    private static class DragonflyMoveController
    extends MoveControl {
        private final DragonflyEntity dragonfly;

        public DragonflyMoveController(DragonflyEntity dragonfly) {
            super((Mob)dragonfly);
            this.dragonfly = dragonfly;
        }

        public void m_8126_() {
            if (!this.dragonfly.m_29443_() && this.dragonfly.m_20096_()) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                this.dragonfly.m_20256_(Vec3.f_82478_);
                return;
            }
            if (this.dragonfly.isHovering()) {
                this.dragonfly.m_20256_(this.dragonfly.m_20184_().m_82542_(0.6, 0.8, 0.6));
                this.f_24981_ = MoveControl.Operation.WAIT;
                return;
            }
            if (this.dragonfly.landingFlag) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                return;
            }
        }
    }

    private static class DartingGoal
    extends Goal {
        private final DragonflyEntity dragonfly;
        private Vec3 dartTarget;
        private Vec3 dartDirection;
        private int hoverTimer;
        private int dartTimer;
        private int maxDartTime;
        private boolean isDarting;
        private int flyDuration;
        private int restDuration;
        private int currentTimer;
        private boolean shouldRest;
        private int landingTimer;
        private Vec3 landingTarget;
        private float targetYaw;
        private boolean hasPickedDirection;
        private Player nearestPlayer;
        private int fleeTimer;
        private static final int MIN_HOVER_TIME = 20;
        private static final int MAX_HOVER_TIME = 40;
        private static final int MIN_HOVER_TIME_SCARED = 2;
        private static final int MAX_HOVER_TIME_SCARED = 5;
        private static final int MIN_DART_TIME = 8;
        private static final int MAX_DART_TIME = 20;
        private static final int MIN_DART_TIME_SCARED = 5;
        private static final int MAX_DART_TIME_SCARED = 12;
        private static final double PLAYER_SCARE_RANGE = 6.0;
        private static final double MAX_HEIGHT_ABOVE_GROUND = 3.0;
        private static final double MIN_HEIGHT_ABOVE_GROUND = 1.5;
        private static final double DART_SPEED_INITIAL = 0.55;
        private static final double DART_SPEED_FINAL = 0.08;
        private static final double DART_SPEED_SCARED = 0.7;
        private static final double VELOCITY_STOP_THRESHOLD = 0.03;
        private static final float ROTATION_SPEED = 6.0f;
        private static final float ROTATION_SPEED_SCARED = 12.0f;

        public DartingGoal(DragonflyEntity dragonfly) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.dragonfly = dragonfly;
            this.flyDuration = 200 + dragonfly.m_217043_().m_188503_(160);
            this.restDuration = 30 + dragonfly.m_217043_().m_188503_(30);
            this.currentTimer = 0;
            this.shouldRest = false;
            this.landingTimer = 0;
            this.hoverTimer = 0;
            this.dartTimer = 0;
            this.maxDartTime = 0;
            this.isDarting = false;
            this.dartDirection = null;
            this.hasPickedDirection = false;
            this.nearestPlayer = null;
            this.fleeTimer = 0;
        }

        public boolean m_8036_() {
            if (this.dragonfly.m_20160_() || this.dragonfly.m_20159_()) {
                return false;
            }
            if (!this.dragonfly.m_29443_() && this.dragonfly.m_20096_()) {
                AABB searchBox = this.dragonfly.m_20191_().m_82400_(4.0);
                List nearbyPlayers = this.dragonfly.m_9236_().m_45976_(Player.class, searchBox);
                boolean hasSurvivalPlayers = false;
                for (Player player : nearbyPlayers) {
                    if (player.m_7500_() || player.m_5833_()) continue;
                    hasSurvivalPlayers = true;
                    break;
                }
                if (hasSurvivalPlayers) {
                    this.shouldRest = false;
                    this.currentTimer = 0;
                    this.landingTimer = 0;
                    return true;
                }
                if (this.shouldRest && this.currentTimer < this.restDuration) {
                    return false;
                }
                if (!this.shouldRest && this.dragonfly.m_217043_().m_188503_(100) != 0) {
                    return false;
                }
            }
            return true;
        }

        public void m_8056_() {
            if (!this.dragonfly.landingFlag) {
                this.dragonfly.setFlying(true);
                this.dragonfly.setHovering(false);
                this.isDarting = true;
                boolean isScared = this.isPlayerNearby();
                this.dartTimer = isScared ? 5 + this.dragonfly.m_217043_().m_188503_(7) : 8 + this.dragonfly.m_217043_().m_188503_(12);
                this.maxDartTime = this.dartTimer;
                this.hasPickedDirection = false;
                float yaw = this.dragonfly.m_146908_();
                float pitch = -10.0f + this.dragonfly.m_217043_().m_188501_() * 20.0f;
                this.dartDirection = this.getDirectionFromRotation(yaw, pitch);
                double distance = 4.0 + this.dragonfly.m_217043_().m_188500_() * 4.0;
                this.dartTarget = this.dragonfly.m_20182_().m_82549_(this.dartDirection.m_82490_(distance));
                this.dartTarget = this.validateDartTarget(this.dartTarget);
            }
        }

        public void m_8041_() {
            this.dragonfly.m_21573_().m_26573_();
            if (!this.dragonfly.landingFlag) {
                this.dragonfly.setHovering(false);
                this.isDarting = false;
                this.hoverTimer = 0;
                this.dartTimer = 0;
                this.maxDartTime = 0;
                this.landingTimer = 0;
                this.landingTarget = null;
                this.dartTarget = null;
                this.dartDirection = null;
                this.hasPickedDirection = false;
                this.nearestPlayer = null;
                this.fleeTimer = 0;
            }
            super.m_8041_();
        }

        public void m_8037_() {
            if (!this.dragonfly.m_29443_() && this.dragonfly.m_20096_()) {
                ++this.currentTimer;
                BlockPos bugPos = this.dragonfly.m_20183_();
                BlockState stateAtPos = this.dragonfly.m_9236_().m_8055_(bugPos);
                if (!stateAtPos.m_60795_() && !stateAtPos.m_247087_()) {
                    return;
                }
                this.dragonfly.m_20256_(Vec3.f_82478_);
                return;
            }
            ++this.currentTimer;
            if (this.dragonfly.f_19862_ && this.dragonfly.m_29443_() && !this.dragonfly.landingFlag) {
                this.handleCollisionRecovery();
            }
            if (this.dragonfly.m_20072_()) {
                this.dragonfly.m_20256_(this.dragonfly.m_20184_().m_82520_(0.0, 0.15, 0.0));
                this.dragonfly.setFlying(true);
                this.dragonfly.m_20242_(true);
            }
            this.enforceHeightLimits();
            this.nearestPlayer = this.findNearestPlayer();
            if (this.nearestPlayer != null && this.dragonfly.m_29443_() && !this.dragonfly.landingFlag) {
                this.currentTimer = 0;
            }
            if (this.dragonfly.m_29443_() && !this.dragonfly.landingFlag && this.currentTimer >= this.flyDuration) {
                if (!this.isOverWaterOrVoid()) {
                    this.shouldRest = true;
                    this.dragonfly.landingFlag = true;
                    this.dragonfly.setHovering(false);
                    this.isDarting = false;
                    if (this.landingTarget == null) {
                        this.landingTarget = this.findLandingPos();
                    }
                    return;
                }
                this.currentTimer = this.flyDuration / 2;
            }
            if (this.dragonfly.m_29443_() && !this.dragonfly.landingFlag) {
                boolean isScared;
                boolean bl = isScared = this.nearestPlayer != null;
                if (this.isDarting) {
                    --this.dartTimer;
                    this.dragonfly.setHovering(false);
                    if (this.dartDirection != null) {
                        Vec3 avoidDirection;
                        if (this.dartTimer > this.maxDartTime / 2 && this.isObstacleAhead(this.dartDirection, 2.0) && (avoidDirection = this.findAvoidanceDirection(this.dartDirection)) != null) {
                            this.dartDirection = avoidDirection;
                            this.dartTarget = this.dragonfly.m_20182_().m_82549_(this.dartDirection.m_82490_(4.0));
                            this.dartTarget = this.validateDartTarget(this.dartTarget);
                        }
                        double progress = 1.0 - (double)this.dartTimer / (double)this.maxDartTime;
                        double smoothProgress = progress * progress * (3.0 - 2.0 * progress);
                        double currentSpeed = isScared ? 0.7 : 0.55 + -0.47000000000000003 * smoothProgress;
                        Vec3 dartVelocity = this.dartDirection.m_82490_(currentSpeed);
                        this.dragonfly.m_20256_(dartVelocity);
                        float targetYaw = (float)(Mth.m_14136_((double)dartVelocity.f_82481_, (double)dartVelocity.f_82479_) * 57.29577951308232) - 90.0f;
                        float rotSpeed = isScared ? 12.0f : 15.0f;
                        this.dragonfly.m_146922_(Mth.m_14148_((float)this.dragonfly.m_146908_(), (float)targetYaw, (float)rotSpeed));
                        if (this.dartTarget != null) {
                            double distanceToTarget = this.dragonfly.m_20182_().m_82554_(this.dartTarget);
                            if (distanceToTarget < 0.5 || this.dartTimer <= 0) {
                                this.isDarting = false;
                                this.dartDirection = null;
                                this.hasPickedDirection = false;
                                this.dragonfly.setHovering(true);
                                this.hoverTimer = isScared ? 2 + this.dragonfly.m_217043_().m_188503_(3) : 20 + this.dragonfly.m_217043_().m_188503_(20);
                                this.dartTarget = null;
                            }
                        } else if (this.dartTimer <= 0) {
                            this.isDarting = false;
                            this.dartDirection = null;
                            this.hasPickedDirection = false;
                            this.dragonfly.setHovering(true);
                            this.hoverTimer = isScared ? 2 + this.dragonfly.m_217043_().m_188503_(3) : 20 + this.dragonfly.m_217043_().m_188503_(20);
                        }
                    }
                } else {
                    --this.hoverTimer;
                    this.dragonfly.setHovering(true);
                    Vec3 vel = this.dragonfly.m_20184_();
                    this.dragonfly.m_20256_(vel.m_82542_(0.75, 0.88, 0.75));
                    double speed = Math.sqrt(vel.f_82479_ * vel.f_82479_ + vel.f_82481_ * vel.f_82481_);
                    if (!this.hasPickedDirection && this.hoverTimer < (isScared ? 3 : 30)) {
                        this.targetYaw = isScared && this.nearestPlayer != null ? this.getFleeYaw(this.nearestPlayer) : this.dragonfly.m_217043_().m_188501_() * 360.0f;
                        this.hasPickedDirection = true;
                    }
                    if (this.hasPickedDirection) {
                        float currentYaw = this.dragonfly.m_146908_();
                        float yawDifference = Math.abs(Mth.m_14177_((float)(this.targetYaw - currentYaw)));
                        float rotSpeed = isScared ? 12.0f : 6.0f;
                        this.dragonfly.m_146922_(Mth.m_14148_((float)currentYaw, (float)this.targetYaw, (float)rotSpeed));
                        if (this.hoverTimer <= 0 && speed < 0.03 && yawDifference < 20.0f) {
                            Vec3 avoidDirection;
                            this.isDarting = true;
                            this.dragonfly.setHovering(false);
                            this.dartTimer = isScared ? 5 + this.dragonfly.m_217043_().m_188503_(7) : 8 + this.dragonfly.m_217043_().m_188503_(12);
                            this.maxDartTime = this.dartTimer;
                            this.hasPickedDirection = false;
                            float pitch = -10.0f + this.dragonfly.m_217043_().m_188501_() * 20.0f;
                            this.dartDirection = this.getDirectionFromRotation(this.targetYaw, pitch);
                            if (this.isObstacleAhead(this.dartDirection, 3.0) && (avoidDirection = this.findAvoidanceDirection(this.dartDirection)) != null) {
                                float avoidYaw;
                                this.dartDirection = avoidDirection;
                                this.targetYaw = avoidYaw = (float)(Mth.m_14136_((double)this.dartDirection.f_82481_, (double)this.dartDirection.f_82479_) * 57.29577951308232) - 90.0f;
                            }
                            double distance = isScared ? 6.0 + this.dragonfly.m_217043_().m_188500_() * 4.0 : 4.0 + this.dragonfly.m_217043_().m_188500_() * 4.0;
                            this.dartTarget = this.dragonfly.m_20182_().m_82549_(this.dartDirection.m_82490_(distance));
                            this.dartTarget = this.validateDartTarget(this.dartTarget);
                        }
                    }
                    if (isScared && !this.hasPickedDirection) {
                        this.targetYaw = this.getFleeYaw(this.nearestPlayer);
                        this.hasPickedDirection = true;
                        if (this.hoverTimer > 3) {
                            this.hoverTimer = 1 + this.dragonfly.m_217043_().m_188503_(3);
                        }
                    }
                }
            }
            if (this.dragonfly.landingFlag) {
                if (this.landingTarget == null) {
                    this.landingTarget = this.findLandingPos();
                }
                if (this.landingTarget != null) {
                    ++this.landingTimer;
                    if (this.landingTimer % 12 == 0) {
                        Vec3 nextPos = this.getDescentPosition(this.landingTarget, this.landingTimer);
                        this.dragonfly.m_21573_().m_26519_(nextPos.f_82479_, nextPos.f_82480_, nextPos.f_82481_, (double)0.4f);
                    }
                    double distanceToLanding = this.dragonfly.m_20186_() - this.landingTarget.f_82480_;
                    if (this.dragonfly.m_20096_() || distanceToLanding < 0.5 && this.landingTimer > 60) {
                        this.dragonfly.m_20256_(Vec3.f_82478_);
                        this.dragonfly.setFlying(false);
                        this.dragonfly.setHovering(false);
                        this.dragonfly.m_20242_(false);
                        this.dragonfly.landingFlag = false;
                        this.landingTarget = null;
                        this.landingTimer = 0;
                        this.isDarting = false;
                        this.hoverTimer = 0;
                        this.dartTimer = 0;
                        this.maxDartTime = 0;
                        this.dartDirection = null;
                        this.hasPickedDirection = false;
                        this.nearestPlayer = null;
                        this.fleeTimer = 0;
                        this.currentTimer = 0;
                        this.shouldRest = true;
                        this.flyDuration = 200 + this.dragonfly.m_217043_().m_188503_(160);
                        this.restDuration = 30 + this.dragonfly.m_217043_().m_188503_(30);
                    }
                } else {
                    this.dragonfly.landingFlag = false;
                    this.shouldRest = false;
                    this.landingTimer = 0;
                }
            }
        }

        public boolean m_8045_() {
            if (this.dragonfly.landingFlag) {
                return !this.dragonfly.m_20096_();
            }
            if (!this.dragonfly.m_29443_() && this.dragonfly.m_20096_() && this.shouldRest) {
                return this.currentTimer < this.restDuration;
            }
            return this.dragonfly.m_29443_();
        }

        private Player findNearestPlayer() {
            AABB searchBox = this.dragonfly.m_20191_().m_82400_(6.0);
            List nearbyPlayers = this.dragonfly.m_9236_().m_45976_(Player.class, searchBox);
            if (nearbyPlayers.isEmpty()) {
                return null;
            }
            Player nearest = null;
            double nearestDist = Double.MAX_VALUE;
            for (Player player : nearbyPlayers) {
                double dist;
                if (player.m_7500_() || player.m_5833_() || !((dist = this.dragonfly.m_20280_((Entity)player)) < nearestDist)) continue;
                nearestDist = dist;
                nearest = player;
            }
            return nearest;
        }

        private float getFleeYaw(Player player) {
            Vec3 toPlayer = player.m_20182_().m_82546_(this.dragonfly.m_20182_());
            float yawToPlayer = (float)(Mth.m_14136_((double)toPlayer.f_82481_, (double)toPlayer.f_82479_) * 57.29577951308232) - 90.0f;
            return Mth.m_14177_((float)(yawToPlayer + 180.0f));
        }

        private Vec3 getDirectionFromRotation(float yaw, float pitch) {
            float yawRad = yaw * ((float)Math.PI / 180);
            float pitchRad = pitch * ((float)Math.PI / 180);
            double xDir = -Math.sin(yawRad) * Math.cos(pitchRad);
            double yDir = -Math.sin(pitchRad);
            double zDir = Math.cos(yawRad) * Math.cos(pitchRad);
            return new Vec3(xDir, yDir, zDir).m_82541_();
        }

        private Vec3 validateDartTarget(Vec3 target) {
            Vec3 currentPos = this.dragonfly.m_20182_();
            Vec3 targetGround = this.groundPosition(target);
            double targetHeightAboveGround = target.f_82480_ - targetGround.f_82480_;
            if (targetHeightAboveGround < 1.5) {
                target = new Vec3(target.f_82479_, targetGround.f_82480_ + 1.5 + 0.3, target.f_82481_);
            } else if (targetHeightAboveGround > 3.0) {
                target = new Vec3(target.f_82479_, targetGround.f_82480_ + 3.0 - 0.3, target.f_82481_);
            }
            BlockHitResult result = this.dragonfly.m_9236_().m_45547_(new ClipContext(this.dragonfly.m_146892_(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.dragonfly));
            if (result.m_6662_() != HitResult.Type.MISS) {
                Vec3 hitPos = result.m_82450_();
                Vec3 direction = target.m_82546_(currentPos).m_82541_();
                target = hitPos.m_82546_(direction.m_82490_(1.5));
                Vec3 safeGround = this.groundPosition(target);
                double heightAtHit = hitPos.f_82480_ - safeGround.f_82480_;
                target = heightAtHit < 2.0 ? new Vec3(target.f_82479_, safeGround.f_82480_ + 3.0 - 0.3, target.f_82481_) : new Vec3(target.f_82479_, safeGround.f_82480_ + 1.5 + 0.3, target.f_82481_);
                BlockHitResult recheck = this.dragonfly.m_9236_().m_45547_(new ClipContext(this.dragonfly.m_146892_(), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.dragonfly));
                if (recheck.m_6662_() != HitResult.Type.MISS) {
                    Vec3 shortDirection = direction.m_82490_(2.0);
                    target = currentPos.m_82549_(shortDirection);
                    Vec3 shortGround = this.groundPosition(target);
                    target = new Vec3(target.f_82479_, shortGround.f_82480_ + 1.5 + 0.5, target.f_82481_);
                }
            }
            return target;
        }

        private void enforceHeightLimits() {
            Vec3 currentPos = this.dragonfly.m_20182_();
            Vec3 groundPos = this.groundPosition(currentPos);
            double heightAboveGround = currentPos.f_82480_ - groundPos.f_82480_;
            if (heightAboveGround > 3.5) {
                this.dragonfly.m_20256_(this.dragonfly.m_20184_().m_82520_(0.0, -0.12, 0.0));
                if (this.isDarting && this.dartTarget != null && this.dartTarget.f_82480_ > currentPos.f_82480_) {
                    this.isDarting = false;
                    this.dartDirection = null;
                    this.hasPickedDirection = false;
                    this.dragonfly.setHovering(true);
                    this.hoverTimer = 20;
                    this.dartTarget = null;
                }
            } else if (heightAboveGround < 1.3 && !this.dragonfly.landingFlag) {
                this.dragonfly.m_20256_(this.dragonfly.m_20184_().m_82520_(0.0, 0.08, 0.0));
            }
        }

        private Vec3 getDescentPosition(Vec3 target, int timer) {
            if (target == null) {
                return this.dragonfly.m_20182_();
            }
            double progress = Math.min((double)timer / 120.0, 1.0);
            double angle = (double)timer * 0.1 % (Math.PI * 2);
            double radius = 2.5 * (1.0 - progress * 0.6);
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            double currentHeight = this.dragonfly.m_20186_();
            double targetHeight = target.f_82480_ + 0.5;
            double descentHeight = currentHeight - (currentHeight - targetHeight) * progress * 0.2;
            return new Vec3(target.f_82479_ + xOffset, Math.max(descentHeight, targetHeight), target.f_82481_ + zOffset);
        }

        private Vec3 findLandingPos() {
            Vec3 currentPos = this.dragonfly.m_20182_();
            Vec3 ground = this.groundPosition(currentPos);
            BlockPos landingPos = BlockPos.m_274446_((Position)ground);
            while (landingPos.m_123342_() < this.dragonfly.m_9236_().m_151558_() && !this.dragonfly.m_9236_().m_8055_(landingPos).m_60795_() && !this.dragonfly.m_9236_().m_8055_(landingPos).m_247087_()) {
                landingPos = landingPos.m_7494_();
            }
            return new Vec3((double)landingPos.m_123341_() + 0.5, (double)landingPos.m_123342_(), (double)landingPos.m_123343_() + 0.5);
        }

        private boolean isPlayerNearby() {
            return this.nearestPlayer != null;
        }

        private void handleCollisionRecovery() {
            this.isDarting = false;
            this.dragonfly.setHovering(true);
            this.dartDirection = null;
            this.hasPickedDirection = false;
            this.dartTarget = null;
            Vec3 currentPos = this.dragonfly.m_20182_();
            Vec3 downPos = currentPos.m_82520_(0.0, -1.5, 0.0);
            BlockHitResult downCheck = this.dragonfly.m_9236_().m_45547_(new ClipContext(currentPos, downPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.dragonfly));
            if (downCheck.m_6662_() == HitResult.Type.MISS) {
                this.dragonfly.m_20256_(this.dragonfly.m_20184_().m_82542_(0.3, 0.3, 0.3).m_82520_(0.0, -0.15, 0.0));
            } else {
                float newYaw = this.dragonfly.m_146908_() + 90.0f + this.dragonfly.m_217043_().m_188501_() * 180.0f;
                this.dragonfly.m_146922_(newYaw);
                this.dragonfly.m_20256_(this.dragonfly.m_20184_().m_82542_(-0.5, 0.5, -0.5));
            }
            this.hoverTimer = 5 + this.dragonfly.m_217043_().m_188503_(10);
        }

        private boolean isObstacleAhead(Vec3 direction, double distance) {
            Vec3 startPos = this.dragonfly.m_146892_();
            Vec3 endPos = startPos.m_82549_(direction.m_82490_(distance));
            BlockHitResult result = this.dragonfly.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.dragonfly));
            return result.m_6662_() != HitResult.Type.MISS;
        }

        private Vec3 findAvoidanceDirection(Vec3 currentDirection) {
            float baseYaw = (float)(Mth.m_14136_((double)currentDirection.f_82481_, (double)currentDirection.f_82479_) * 57.29577951308232) - 90.0f;
            float[] yawOffsets = new float[]{-45.0f, 45.0f, -90.0f, 90.0f, -135.0f, 135.0f};
            float[] pitchOffsets = new float[]{-20.0f, 20.0f, -30.0f, 30.0f};
            for (float yawOffset : yawOffsets) {
                float[] fArray = pitchOffsets;
                int n = fArray.length;
                for (int i = 0; i < n; ++i) {
                    float testYaw = baseYaw + yawOffset;
                    float pitchOffset = fArray[i];
                    float testPitch = pitchOffset;
                    Vec3 testDirection = this.getDirectionFromRotation(testYaw, testPitch);
                    if (this.isObstacleAhead(testDirection, 3.0)) continue;
                    return testDirection;
                }
            }
            Vec3 downDirection = this.getDirectionFromRotation(baseYaw, -45.0f);
            if (!this.isObstacleAhead(downDirection, 2.0)) {
                return downDirection;
            }
            return this.getDirectionFromRotation(baseYaw + 180.0f, 0.0f);
        }

        private Vec3 groundPosition(Vec3 airPosition) {
            BlockPos.MutableBlockPos ground = new BlockPos.MutableBlockPos();
            ground.m_122169_(airPosition.f_82479_, airPosition.f_82480_, airPosition.f_82481_);
            boolean flag = false;
            while (ground.m_123342_() < this.dragonfly.m_9236_().m_151558_() && !this.dragonfly.m_9236_().m_8055_((BlockPos)ground).m_60804_((BlockGetter)this.dragonfly.m_9236_(), (BlockPos)ground) && this.dragonfly.m_9236_().m_6425_((BlockPos)ground).m_76178_()) {
                ground.m_122184_(0, 1, 0);
                flag = true;
            }
            ground.m_122184_(0, -1, 0);
            while (ground.m_123342_() > this.dragonfly.m_9236_().m_141937_() && !this.dragonfly.m_9236_().m_8055_((BlockPos)ground).m_60804_((BlockGetter)this.dragonfly.m_9236_(), (BlockPos)ground) && this.dragonfly.m_9236_().m_6425_((BlockPos)ground).m_76178_()) {
                ground.m_122184_(0, -1, 0);
            }
            return Vec3.m_82512_((Vec3i)(flag ? ground.m_7494_() : ground.m_7495_()));
        }

        private boolean isOverWaterOrVoid() {
            BlockPos position = this.dragonfly.m_20183_();
            while (position.m_123342_() > this.dragonfly.m_9236_().m_141937_() && this.dragonfly.m_9236_().m_46859_(position) && this.dragonfly.m_9236_().m_6425_(position).m_76178_()) {
                position = position.m_7495_();
            }
            return !this.dragonfly.m_9236_().m_6425_(position).m_76178_() || this.dragonfly.m_9236_().m_8055_(position).m_60713_(Blocks.f_50191_) || position.m_123342_() <= this.dragonfly.m_9236_().m_141937_();
        }
    }

    public static enum Variant implements StringRepresentable
    {
        WHITETAIL(0, "whitetail"),
        DARNER(1, "darner"),
        SKIMMER(2, "skimmer"),
        DAMSEL(3, "damsel"),
        PETALTAIL(4, "petaltail");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }

    private static class DragonflyFlyingNavigation
    extends FlyingPathNavigation {
        private float distanceModifier;

        public DragonflyFlyingNavigation(Mob mob, Level level, float distanceModifier) {
            super(mob, level);
            this.distanceModifier = distanceModifier;
        }

        protected void m_7636_() {
            boolean flag;
            Vec3 vector3d = this.m_7475_();
            this.f_26505_ = this.f_26494_.m_20205_() * this.distanceModifier;
            BlockPos vector3i = this.f_26496_.m_77400_();
            double d0 = Math.abs(this.f_26494_.m_20185_() - ((double)vector3i.m_123341_() + 0.5));
            double d1 = Math.abs(this.f_26494_.m_20186_() - (double)vector3i.m_123342_());
            double d2 = Math.abs(this.f_26494_.m_20189_() - ((double)vector3i.m_123343_() + 0.5));
            boolean bl = flag = d0 < (double)this.f_26505_ && d2 < (double)this.f_26505_ && d1 < 1.0;
            if (flag || this.m_264193_(this.f_26496_.m_77401_().f_77282_) && this.m_26559_(vector3d)) {
                this.f_26496_.m_77374_();
            }
            this.m_6481_(vector3d);
        }

        private boolean m_26559_(Vec3 currentPosition) {
            Vec3 vector3d3;
            if (this.f_26496_.m_77399_() + 1 >= this.f_26496_.m_77398_()) {
                return false;
            }
            Vec3 vector3d = Vec3.m_82539_((Vec3i)this.f_26496_.m_77400_());
            if (!currentPosition.m_82509_((Position)vector3d, 2.0)) {
                return false;
            }
            Vec3 vector3d1 = Vec3.m_82539_((Vec3i)this.f_26496_.m_77396_(this.f_26496_.m_77399_() + 1));
            Vec3 vector3d2 = vector3d1.m_82546_(vector3d);
            return vector3d2.m_82526_(vector3d3 = currentPosition.m_82546_(vector3d)) > 0.0;
        }
    }
}

