/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GrasshopperEntity
extends Animal
implements GeoEntity {
    private static final float BUOYANCY = 0.03f;
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(GrasshopperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private Vec3 prevPosition = Vec3.f_82478_;
    private boolean isJumping = false;
    private int globalJumpCooldown = 0;

    public GrasshopperEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22288_, 0.6);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new GrasshopperJumpGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new GrasshopperWalkGoal(this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new GroundLookAroundGoal((Mob)this));
    }

    public static boolean canSpawn(EntityType<GrasshopperEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant((Variant)((Object)Util.m_214670_((Object[])Variant.values(), (RandomSource)world.m_213780_())));
        super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        return spawnData;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_20069_()) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_, motion.f_82480_ + (double)0.03f, motion.f_82481_);
        }
        Vec3 currentPos = this.m_20182_();
        currentPos.m_82554_(this.prevPosition);
        this.prevPosition = currentPos;
        if (this.globalJumpCooldown > 0) {
            --this.globalJumpCooldown;
        }
        if (this.m_20096_() && this.isJumping) {
            this.isJumping = false;
        }
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public void m_7023_(Vec3 travelVector) {
        super.m_7023_(travelVector);
    }

    public void m_6478_(MoverType moverType, Vec3 movement) {
        super.m_6478_(moverType, movement);
    }

    protected PathNavigation m_6037_(Level level) {
        GroundPathNavigation navigation = new GroundPathNavigation((Mob)this, level);
        navigation.m_7008_(true);
        return navigation;
    }

    protected void m_6135_() {
        Vec3 velocity = this.m_20184_();
        double jumpPower = this.m_6118_();
        if (this.isJumping) {
            this.m_20334_(velocity.f_82479_, jumpPower, velocity.f_82481_);
        } else {
            this.m_20334_(velocity.f_82479_, jumpPower * 1.5, velocity.f_82481_);
        }
        this.f_19812_ = true;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob otherParent) {
        return null;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 10, this::predicate)});
    }

    private PlayState predicate(AnimationState<GrasshopperEntity> event) {
        boolean moving = this.isActuallyMoving();
        if (!this.m_20096_()) {
            event.getController().setAnimation(RawAnimation.begin().then("jump", Animation.LoopType.PLAY_ONCE));
            return PlayState.CONTINUE;
        }
        if (moving && this.m_20096_()) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().id);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6094_() {
        return true;
    }

    protected float m_6118_() {
        return 0.42f * this.m_20098_();
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource source) {
        return false;
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean isActuallyMoving() {
        Vec3 delta = this.m_20184_();
        double horizontalSpeed = Math.sqrt(delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_);
        return horizontalSpeed > 0.003;
    }

    public void m_6862_(boolean jumping) {
        this.isJumping = jumping;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public int getGlobalJumpCooldown() {
        return this.globalJumpCooldown;
    }

    public void setGlobalJumpCooldown(int ticks) {
        this.globalJumpCooldown = ticks;
    }

    public static class GrasshopperJumpGoal
    extends Goal {
        private final GrasshopperEntity grasshopper;
        private int jumpDuration = 0;
        private int pauseBetweenJumps = 0;
        private int jumpsInSequence = 0;
        private double targetX;
        private double targetZ;

        public GrasshopperJumpGoal(GrasshopperEntity grasshopper) {
            this.grasshopper = grasshopper;
        }

        public boolean m_8036_() {
            if (!this.grasshopper.m_20096_() || this.grasshopper.getGlobalJumpCooldown() > 0 || this.pauseBetweenJumps > 0) {
                return false;
            }
            return this.grasshopper.m_217043_().m_188501_() < 0.7f;
        }

        public boolean m_8045_() {
            return !this.grasshopper.m_20096_() || this.jumpDuration > 0 || this.pauseBetweenJumps > 0;
        }

        public void m_8056_() {
            this.jumpsInSequence = 0;
            this.executeJump();
        }

        private boolean isWaterAt(double x, double z) {
            BlockPos targetPos = new BlockPos((int)x, (int)this.grasshopper.m_20186_(), (int)z);
            BlockState state = this.grasshopper.m_9236_().m_8055_(targetPos);
            BlockState stateBelow = this.grasshopper.m_9236_().m_8055_(targetPos.m_7495_());
            return state.m_60819_().m_76170_() || stateBelow.m_60819_().m_76170_();
        }

        private void executeJump() {
            int attempts = 0;
            int maxAttempts = 8;
            double chosenX = 0.0;
            double chosenZ = 0.0;
            boolean foundGround = false;
            while (attempts < maxAttempts && !foundGround) {
                double angle;
                double distance = 2.0 + this.grasshopper.m_217043_().m_188500_() * 3.0;
                if (this.grasshopper.isActuallyMoving()) {
                    Vec3 velocity = this.grasshopper.m_20184_();
                    angle = Math.atan2(velocity.f_82481_, velocity.f_82479_);
                } else {
                    angle = this.grasshopper.m_217043_().m_188500_() * Math.PI * 2.0;
                }
                chosenX = this.grasshopper.m_20185_() + Math.cos(angle) * distance;
                chosenZ = this.grasshopper.m_20189_() + Math.sin(angle) * distance;
                if (!this.isWaterAt(chosenX, chosenZ)) {
                    foundGround = true;
                    continue;
                }
                ++attempts;
            }
            if (!foundGround) {
                this.m_8041_();
                return;
            }
            this.jumpDuration = 15;
            ++this.jumpsInSequence;
            this.targetX = chosenX;
            this.targetZ = chosenZ;
            float yaw = (float)(Math.atan2(this.targetZ - this.grasshopper.m_20189_(), this.targetX - this.grasshopper.m_20185_()) * 180.0 / Math.PI) - 90.0f;
            this.grasshopper.m_146922_(yaw);
            this.grasshopper.f_19859_ = yaw;
            this.grasshopper.m_5616_(yaw);
            this.grasshopper.f_20886_ = yaw;
            double jumpHeight = 1.5 + this.grasshopper.m_217043_().m_188500_() * 1.5;
            double verticalVelocity = Math.sqrt(0.16 * jumpHeight);
            Vec3 currentPos = this.grasshopper.m_20182_();
            double dx = this.targetX - currentPos.f_82479_;
            double dz = this.targetZ - currentPos.f_82481_;
            double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
            double horizontalVelocity = 0.35;
            double vx = dx / horizontalDistance * horizontalVelocity;
            double vz = dz / horizontalDistance * horizontalVelocity;
            this.grasshopper.m_20334_(vx, verticalVelocity, vz);
            this.grasshopper.f_19812_ = true;
            this.grasshopper.m_6862_(true);
            this.grasshopper.m_5496_((SoundEvent)FaunifySounds.BOING.get(), 2.5f, 1.5f);
        }

        public void m_8037_() {
            if (this.pauseBetweenJumps > 0) {
                --this.pauseBetweenJumps;
                return;
            }
            if (this.jumpDuration > 0) {
                --this.jumpDuration;
                if (!this.grasshopper.m_20096_()) {
                    double dz;
                    Vec3 velocity = this.grasshopper.m_20184_();
                    double dx = this.targetX - this.grasshopper.m_20185_();
                    double horizontalDistance = Math.sqrt(dx * dx + (dz = this.targetZ - this.grasshopper.m_20189_()) * dz);
                    if (horizontalDistance > 0.1) {
                        double speed = 0.04;
                        this.grasshopper.m_20334_(velocity.f_82479_ + dx / horizontalDistance * speed, velocity.f_82480_, velocity.f_82481_ + dz / horizontalDistance * speed);
                    }
                }
            } else if (this.grasshopper.m_20096_() && this.jumpsInSequence < 3) {
                if (this.grasshopper.m_217043_().m_188501_() < 0.6f) {
                    this.pauseBetweenJumps = 10 + this.grasshopper.m_217043_().m_188503_(10);
                    this.grasshopper.m_6862_(false);
                } else {
                    this.m_8041_();
                }
            } else if (this.grasshopper.m_20096_() && this.jumpsInSequence >= 3) {
                this.m_8041_();
            }
            if (this.pauseBetweenJumps == 1 && this.grasshopper.m_20096_()) {
                this.executeJump();
            }
        }

        public void m_8041_() {
            this.jumpDuration = 0;
            this.pauseBetweenJumps = 0;
            this.jumpsInSequence = 0;
            this.grasshopper.m_6862_(false);
            this.grasshopper.setGlobalJumpCooldown(60 + this.grasshopper.m_217043_().m_188503_(60));
        }
    }

    public static class GrasshopperWalkGoal
    extends WaterAvoidingRandomStrollGoal {
        private final GrasshopperEntity grasshopper;

        public GrasshopperWalkGoal(GrasshopperEntity grasshopper, double speedModifier) {
            super((PathfinderMob)grasshopper, speedModifier);
            this.grasshopper = grasshopper;
        }

        public boolean m_8036_() {
            return (this.grasshopper.m_20069_() || this.grasshopper.getGlobalJumpCooldown() > 0) && super.m_8036_();
        }

        public boolean m_8045_() {
            return (this.grasshopper.m_20069_() || this.grasshopper.getGlobalJumpCooldown() > 0) && super.m_8045_();
        }
    }

    public static enum Variant implements StringRepresentable
    {
        GREEN(0, "green"),
        BROWN(1, "brown"),
        GREENBROWN(2, "greenbrown");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

