/*
 * Decompiled with CFR 0.152.
 */
package com.pepper.faunify.entity;

import com.mojang.serialization.Codec;
import com.pepper.faunify.entity.goal.GroundLookAroundGoal;
import com.pepper.faunify.registry.FaunifySounds;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class LeafInsectEntity
extends Animal
implements GeoEntity {
    private static final float BUOYANCY = 0.03f;
    private static final double CLIMB_SPEED = 0.1;
    private static final int MAX_CLIMB_TIME = 20;
    private static final int CLIMB_COOLDOWN = 40;
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(LeafInsectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(LeafInsectEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private PathNavigation groundNavigation;
    private Vec3 prevPosition = Vec3.f_82478_;
    private double actualMovementSpeed = 0.0;
    private int climbingTime = 0;
    private int climbCooldown = 0;
    private BlockPos lastClimbPos;

    public LeafInsectEntity(EntityType<? extends Animal> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 16.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(2, (Goal)new GroundLookAroundGoal((Mob)this));
    }

    public static boolean canSpawn(EntityType<LeafInsectEntity> entityType, LevelAccessor level, MobSpawnType spawnType, BlockPos position, RandomSource random) {
        return Animal.m_218104_(entityType, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)position, (RandomSource)random);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setVariant((Variant)((Object)Util.m_214670_((Object[])Variant.values(), (RandomSource)world.m_213780_())));
        super.m_6518_(world, difficulty, spawnReason, spawnData, dataTag);
        if (spawnData == null) {
            spawnData = new AgeableMob.AgeableMobGroupData(false);
        }
        return spawnData;
    }

    public void m_8119_() {
        BlockPos currentPos;
        boolean shouldClimb;
        super.m_8119_();
        if (this.m_20069_()) {
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_, motion.f_82480_ + (double)0.03f, motion.f_82481_);
        }
        if (this.climbCooldown > 0) {
            --this.climbCooldown;
        }
        boolean bl = shouldClimb = this.f_19862_ && this.isCollidingWithBlock() && this.climbCooldown <= 0;
        if (this.isClimbing()) {
            currentPos = this.m_20183_();
            if (this.lastClimbPos != null && this.lastClimbPos.equals((Object)currentPos)) {
                ++this.climbingTime;
            } else {
                this.climbingTime = 0;
                this.lastClimbPos = currentPos;
            }
            if (this.climbingTime >= 20) {
                this.setClimbing(false);
                this.climbCooldown = 40;
                this.climbingTime = 0;
                this.lastClimbPos = null;
                if (!this.m_9236_().f_46443_) {
                    this.f_21344_.m_26573_();
                    this.f_21345_.m_25386_().forEach(goal -> goal.m_8041_());
                }
            } else if (this.f_19862_) {
                boolean hasBlockAbove;
                Vec3 deltaMovement = this.m_20184_();
                boolean shouldApplyClimbMovement = true;
                if (this.m_20096_() && !(hasBlockAbove = this.isCollidingWithBlock())) {
                    shouldApplyClimbMovement = false;
                }
                if (shouldApplyClimbMovement) {
                    this.m_20334_(deltaMovement.f_82479_, 0.1, deltaMovement.f_82481_);
                }
            }
        } else {
            this.climbingTime = 0;
            this.lastClimbPos = null;
        }
        currentPos = this.m_20182_();
        this.actualMovementSpeed = currentPos.m_82554_(this.prevPosition);
        this.prevPosition = currentPos;
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(shouldClimb);
        }
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public void m_7023_(Vec3 travelVector) {
        super.m_7023_(travelVector);
    }

    public void m_6478_(MoverType moverType, Vec3 movement) {
        super.m_6478_(moverType, movement);
    }

    protected PathNavigation m_6037_(Level level) {
        GroundPathNavigation navigation = new GroundPathNavigation((Mob)this, level);
        navigation.m_7008_(true);
        this.groundNavigation = navigation;
        return navigation;
    }

    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob otherParent) {
        return null;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)FaunifySounds.BUG_HURT.get();
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 10, this::predicate)});
    }

    private PlayState predicate(AnimationState<LeafInsectEntity> event) {
        boolean climbing = this.isClimbing();
        boolean moving = this.isActuallyMoving();
        boolean grounded = this.m_20096_();
        if (climbing || moving && grounded) {
            event.getController().setAnimation(RawAnimation.begin().then("walk", Animation.LoopType.LOOP));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(RawAnimation.begin().then("idle", Animation.LoopType.LOOP));
        return PlayState.CONTINUE;
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Variant", this.getVariant().id);
        tag.m_128405_("ClimbingTime", this.climbingTime);
        tag.m_128405_("ClimbCooldown", this.climbCooldown);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(Variant.byId(tag.m_128451_("Variant")));
        this.climbingTime = tag.m_128451_("ClimbingTime");
        this.climbCooldown = tag.m_128451_("ClimbCooldown");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)0);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6094_() {
        return true;
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    protected float m_6118_() {
        return 0.0f;
    }

    public void m_6862_(boolean jumping) {
        super.m_6862_(false);
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean climbing) {
        byte flags = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        flags = climbing ? (byte)(flags | 1) : (byte)(flags & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)flags);
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public boolean isActuallyMoving() {
        Vec3 delta = this.m_20184_();
        double horizontalSpeed = Math.sqrt(delta.f_82479_ * delta.f_82479_ + delta.f_82481_ * delta.f_82481_);
        return horizontalSpeed > 0.003;
    }

    private boolean isCollidingWithBlock() {
        boolean hasAdjacentAtCurrentLevel;
        BlockPos pos = this.m_20183_();
        BlockState state = this.m_9236_().m_8055_(pos);
        if (!state.m_60795_() && !state.m_247087_()) {
            return true;
        }
        BlockPos north = pos.m_122012_();
        BlockPos south = pos.m_122019_();
        BlockPos east = pos.m_122029_();
        BlockPos west = pos.m_122024_();
        boolean bl = hasAdjacentAtCurrentLevel = !this.m_9236_().m_8055_(north).m_60795_() && !this.m_9236_().m_8055_(north).m_247087_() || !this.m_9236_().m_8055_(south).m_60795_() && !this.m_9236_().m_8055_(south).m_247087_() || !this.m_9236_().m_8055_(east).m_60795_() && !this.m_9236_().m_8055_(east).m_247087_() || !this.m_9236_().m_8055_(west).m_60795_() && !this.m_9236_().m_8055_(west).m_247087_();
        if (hasAdjacentAtCurrentLevel) {
            return true;
        }
        BlockPos posBelow = pos.m_7495_();
        BlockPos northBelow = posBelow.m_122012_();
        BlockPos southBelow = posBelow.m_122019_();
        BlockPos eastBelow = posBelow.m_122029_();
        BlockPos westBelow = posBelow.m_122024_();
        return !this.m_9236_().m_8055_(northBelow).m_60795_() && !this.m_9236_().m_8055_(northBelow).m_247087_() || !this.m_9236_().m_8055_(southBelow).m_60795_() && !this.m_9236_().m_8055_(southBelow).m_247087_() || !this.m_9236_().m_8055_(eastBelow).m_60795_() && !this.m_9236_().m_8055_(eastBelow).m_247087_() || !this.m_9236_().m_8055_(westBelow).m_60795_() && !this.m_9236_().m_8055_(westBelow).m_247087_();
    }

    public static enum Variant implements StringRepresentable
    {
        GREEN(0, "green"),
        YELLOW(1, "yellow"),
        BROWN(2, "brown");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

